/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.ui.common.RememberedDecisionsManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectCheckbox;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarListener;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarCloseListener;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarEntry;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImage;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;

public class Browse
extends SkinView
implements SideBarCloseListener {
    protected static final String CFG_SHOWCLOSE = "contentnetwork.close.reminder";
    private SWTSkinObjectBrowser browserSkinObject;
    private SWTSkin skin;
    private SWTSkinObject soMain;
    private SideBarVitalityImage vitalityImage;
    private ContentNetwork contentNetwork;
    private static List<Long> listAlreadyCalledLoginRPC = new ArrayList<Long>();

    public SWTSkinObjectBrowser getBrowserSkinObject() {
        return this.browserSkinObject;
    }

    public Object skinObjectCreated(SWTSkinObject skinObject, Object params) {
        SideBarEntrySWT entry;
        SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        if (sidebar != null && (entry = sidebar.getEntryBySkinView(this)) != null) {
            entry.addListener(this);
        }
        return super.skinObjectCreated(skinObject, params);
    }

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        SideBarEntrySWT entry;
        this.soMain = skinObject;
        this.skin = skinObject.getSkin();
        Object creationParams = skinObject.getData("CreationParams");
        this.contentNetwork = creationParams instanceof ContentNetwork ? (ContentNetwork)creationParams : ConstantsVuze.getDefaultContentNetwork();
        long cnID = this.contentNetwork.getID();
        if (cnID != 1L && !listAlreadyCalledLoginRPC.contains(new Long(cnID))) {
            PlatformConfigMessenger.login(this.contentNetwork.getID(), 0L);
            listAlreadyCalledLoginRPC.add(new Long(cnID));
        }
        this.browserSkinObject = SWTSkinUtils.findBrowserSO(this.soMain);
        final SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        if (sidebar != null && (entry = sidebar.getEntryBySkinView(this)) != null) {
            this.vitalityImage = entry.addVitalityImage("image.sidebar.vitality.dots");
            this.vitalityImage.setVisible(false);
            sidebar.addListener(new SideBarListener(){
                long lastSelect = 0L;

                public void sidebarItemSelected(SideBarEntrySWT newSideBarEntry, SideBarEntrySWT oldSideBarEntry) {
                    if (entry == newSideBarEntry) {
                        if (entry == oldSideBarEntry) {
                            if (this.lastSelect < SystemTime.getOffsetTime(-1000L) && Browse.this.browserSkinObject != null) {
                                Browse.this.browserSkinObject.restart();
                            }
                        } else {
                            this.lastSelect = SystemTime.getCurrentTime();
                        }
                    }
                }
            });
        }
        this.browserSkinObject.addListener(new SWTSkinObjectListener(){

            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    Browse.this.browserSkinObject.removeListener(this);
                    Browse.this.browserSkinObject.addListener(new BrowserContext.loadingListener(){

                        public void browserLoadingChanged(boolean loading, String url) {
                            if (Browse.this.vitalityImage != null) {
                                Browse.this.vitalityImage.setVisible(loading);
                            }
                        }
                    });
                    Browse.this.browserSkinObject.getContext().setContentNetworkID(Browse.this.contentNetwork.getID());
                    Browse.this.browserSkinObject.setStartURL(ContentNetworkUtils.getUrl(Browse.this.contentNetwork, 6));
                }
                return null;
            }
        });
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        String menuID = "sidebar." + ContentNetworkUtils.getTarget(this.contentNetwork);
        MenuItem item = menuManager.addMenuItem(menuID, "Button.reload");
        item.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                Browse.this.browserSkinObject.refresh();
            }
        });
        if (Constants.isCVSVersion()) {
            MenuItem parent = menuManager.addMenuItem(menuID, "CVS Only");
            parent.setStyle(5);
            MenuItem menuItem = menuManager.addMenuItem(parent, "Button.reset");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    Browse.this.browserSkinObject.getContext().executeInBrowser("sendMessage('display','reset-url', {});");
                }
            });
            menuItem = menuManager.addMenuItem(parent, "Tux RPC Test");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    Browse.this.browserSkinObject.setURL("c:\\test\\BrowserMessaging.html");
                }
            });
            menuItem = menuManager.addMenuItem(parent, "URL..");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("", "!URL!");
                    entryWindow.prompt();
                    if (entryWindow.hasSubmittedInput()) {
                        Browse.this.browserSkinObject.setURL(entryWindow.getSubmittedInput());
                    }
                }
            });
            if (this.contentNetwork != ConstantsVuze.getDefaultContentNetwork()) {
                menuItem = menuManager.addMenuItem(parent, "Remove HD Network");
                menuItem.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        if (sidebar != null) {
                            SideBarEntrySWT entry = sidebar.getEntryBySkinView(Browse.this);
                            if (entry != null) {
                                entry.removeListener(Browse.this);
                            }
                            sidebar.closeEntry(ContentNetworkUtils.getTarget(Browse.this.contentNetwork));
                        }
                        Browse.this.contentNetwork.remove();
                    }
                });
                menuItem = menuManager.addMenuItem(parent, "Reset IP Flag && Close");
                menuItem.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        Browse.this.contentNetwork.setPersistentProperty("auth_shown", Boolean.FALSE);
                        if (sidebar != null) {
                            SideBarEntrySWT entry = sidebar.getEntryBySkinView(Browse.this);
                            if (entry != null) {
                                entry.removeListener(Browse.this);
                            }
                            sidebar.closeEntry(ContentNetworkUtils.getTarget(Browse.this.contentNetwork));
                        }
                    }
                });
            }
            menuItem = menuManager.addMenuItem(parent, "Source Ref: " + this.contentNetwork.getPersistentProperty("source_ref"));
            menuItem.setEnabled(false);
        }
        return null;
    }

    public void sidebarClosed(SideBarEntry entry) {
        boolean wasActive = false;
        Object prop = this.contentNetwork.getPersistentProperty("active");
        if (prop instanceof Boolean) {
            wasActive = (Boolean)prop;
        }
        this.contentNetwork.setPersistentProperty("active", Boolean.FALSE);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Shell shell = null;
                String url = ContentNetworkUtils.getUrl(Browse.this.contentNetwork, 34);
                if (url == null) {
                    return;
                }
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uiFunctions != null) {
                    shell = uiFunctions.getMainShell();
                }
                if (shell == null) {
                    return;
                }
                final Browser browser = new Browser((Composite)shell, Utils.getInitialBrowserStyle(0));
                browser.setVisible(false);
                browser.addProgressListener(new ProgressListener(){

                    public void completed(ProgressEvent event2) {
                        Utils.execSWTThreadLater(1000, new AERunnable(){

                            public void runSupport() {
                                browser.setUrl("about:blank");
                                browser.dispose();
                            }
                        });
                    }

                    public void changed(ProgressEvent event2) {
                    }
                });
                browser.setUrl(url);
            }
        });
        if (!wasActive) {
            return;
        }
        int decision = RememberedDecisionsManager.getRememberedDecision(CFG_SHOWCLOSE);
        if (decision != 1) {
            final SkinnedDialog closeDialog = new SkinnedDialog("skin3_close_notification", "close-notification.body");
            closeDialog.setTitle(MessageText.getString("v3.dialog.cnclose.title", new String[]{this.contentNetwork.getName()}));
            SWTSkin skin = closeDialog.getSkin();
            SWTSkinObjectButton soButton = (SWTSkinObjectButton)skin.getSkinObject("close");
            if (soButton != null) {
                soButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        closeDialog.close();
                    }
                });
            }
            closeDialog.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

                public void skinDialogClosed(SkinnedDialog dialog) {
                    SWTSkin skin = closeDialog.getSkin();
                    SWTSkinObjectCheckbox soCheck = (SWTSkinObjectCheckbox)skin.getSkinObject("noshowagain");
                    if (soCheck != null && soCheck.isChecked()) {
                        RememberedDecisionsManager.setRemembered(Browse.CFG_SHOWCLOSE, 1);
                    }
                }
            });
            closeDialog.open();
        }
    }
}

