/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.torrent.HasBeenOpenedListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.InitializerListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.Initializer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarItem;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarItemListener;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.views.skin.InfoBarUtil;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarVitalityImageSWT;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImage;
import org.gudy.azureus2.ui.swt.Utils;

public class SBC_LibraryView
extends SkinView {
    private static final String ID = "library-list";
    public static final int MODE_BIGTABLE = 0;
    public static final int MODE_SMALLTABLE = 1;
    public static final int TORRENTS_ALL = 0;
    public static final int TORRENTS_COMPLETE = 1;
    public static final int TORRENTS_INCOMPLETE = 2;
    public static final int TORRENTS_UNOPENED = 3;
    private static final String CFG_INFOBAR = "Library.infobar";
    public static List allViews = new ArrayList(1);
    private static final String[] modeViewIDs = new String[]{"library-big-area", "library-small-area"};
    private static final String[] modeIDs = new String[]{"library.table.big", "library.table.small"};
    private static final String ID_VITALITY_ACTIVE = "image.sidebar.vitality.dl";
    private static final String ID_VITALITY_ALERT = "image.sidebar.vitality.alert";
    private static final long DL_VITALITY_REFRESH_RATE = 15000L;
    private static final boolean DL_VITALITY_CONSTANT = true;
    private static int numSeeding = 0;
    private static int numDownloading = 0;
    private static int numComplete = 0;
    private static int numIncomplete = 0;
    private static int numErrorComplete = 0;
    private static String errorInCompleteTooltip;
    private static int numErrorInComplete;
    private static String errorCompleteTooltip;
    private static int numUnOpened;
    private int viewMode = -1;
    private SWTSkinButtonUtility btnSmallTable;
    private SWTSkinButtonUtility btnBigTable;
    private SWTSkinObject soListArea;
    private int torrentFilterMode = 0;
    private String torrentFilter;
    private ToolBarItem itemModeSmall;
    private ToolBarItem itemModeBig;
    private SWTSkinObject skinObject;
    private InfoBarUtil infoBarUtil;
    private SWTSkinObject soWait;
    private SWTSkinObject soWaitProgress;
    private SWTSkinObjectText soWaitTask;
    private int waitProgress = 0;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.skinObject = skinObject;
        this.soWait = null;
        try {
            this.soWait = this.getSkinObject("library-wait");
            this.soWaitProgress = this.getSkinObject("library-wait-progress");
            this.soWaitTask = (SWTSkinObjectText)this.getSkinObject("library-wait-task");
            if (this.soWaitProgress != null) {
                this.soWaitProgress.getControl().addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        Control c = (Control)e.widget;
                        Point size = c.getSize();
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, "#0000ff"));
                        int breakX = size.x * SBC_LibraryView.this.waitProgress / 100;
                        e.gc.fillRectangle(0, 0, breakX, size.y);
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, "#808080"));
                        e.gc.fillRectangle(breakX, 0, size.x - breakX, size.y);
                    }
                });
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        AzureusCore core = AzureusCoreFactory.getSingleton();
        if (!AzureusCoreFactory.isCoreRunning()) {
            Initializer initializer;
            if (this.soWait != null) {
                this.soWait.setVisible(true);
            }
            if ((initializer = Initializer.getLastInitializer()) != null) {
                initializer.addListener(new InitializerListener(){

                    public void reportPercent(final int percent) {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                if (SBC_LibraryView.this.soWaitProgress != null && !SBC_LibraryView.this.soWaitProgress.isDisposed()) {
                                    SBC_LibraryView.this.waitProgress = percent;
                                    SBC_LibraryView.this.soWaitProgress.getControl().redraw();
                                    SBC_LibraryView.this.soWaitProgress.getControl().update();
                                }
                            }
                        });
                        if (percent > 100) {
                            initializer.removeListener(this);
                        }
                    }

                    public void reportCurrentTask(String currentTask) {
                        if (SBC_LibraryView.this.soWaitTask != null && !SBC_LibraryView.this.soWaitTask.isDisposed()) {
                            SBC_LibraryView.this.soWaitTask.setText(currentTask);
                        }
                    }
                });
            }
        }
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (SBC_LibraryView.this.soWait != null) {
                            SBC_LibraryView.this.soWait.setVisible(false);
                        }
                    }
                });
            }
        });
        this.torrentFilter = skinObject.getSkinObjectID();
        if (this.torrentFilter.equalsIgnoreCase("LibraryDL")) {
            this.torrentFilterMode = 2;
        } else if (this.torrentFilter.equalsIgnoreCase("LibraryCD")) {
            this.torrentFilterMode = 1;
        } else if (this.torrentFilter.equalsIgnoreCase("LibraryUnopened")) {
            this.torrentFilterMode = 3;
        }
        this.soListArea = this.getSkinObject("library-list-area");
        this.soListArea.getControl().setData("TorrentFilterMode", (Object)new Long(this.torrentFilterMode));
        this.setViewMode(COConfigurationManager.getIntParameter(this.torrentFilter + ".viewmode"), false);
        SWTSkinObject so = this.getSkinObject("library-list-button-smalltable");
        if (so != null) {
            this.btnSmallTable = new SWTSkinButtonUtility(so);
            this.btnSmallTable.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    SBC_LibraryView.this.setViewMode(1, true);
                }
            });
        }
        if ((so = this.getSkinObject("library-list-button-bigtable")) != null) {
            this.btnBigTable = new SWTSkinButtonUtility(so);
            this.btnBigTable.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    SBC_LibraryView.this.setViewMode(0, true);
                }
            });
        }
        SkinViewManager.addListener(new SkinViewManager.SkinViewManagerListener(){

            public void skinViewAdded(SkinView skinview) {
                if (skinview instanceof ToolBarView) {
                    SBC_LibraryView.this.initToolBarView((ToolBarView)skinview);
                }
            }
        });
        ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
        if (tb != null) {
            this.initToolBarView(tb);
        }
        return null;
    }

    protected void initToolBarView(ToolBarView tb) {
        this.itemModeSmall = tb.getToolBarItem("modeSmall");
        if (this.itemModeSmall != null) {
            this.itemModeSmall.addListener(new ToolBarItemListener(){

                public void pressed(ToolBarItem toolBarItem) {
                    if (SBC_LibraryView.this.isVisible()) {
                        SBC_LibraryView.this.setViewMode(1, true);
                    }
                }

                public boolean held(ToolBarItem toolBarItem) {
                    return false;
                }
            });
        }
        this.itemModeBig = tb.getToolBarItem("modeBig");
        if (this.itemModeBig != null) {
            this.itemModeBig.addListener(new ToolBarItemListener(){

                public void pressed(ToolBarItem toolBarItem) {
                    if (SBC_LibraryView.this.isVisible()) {
                        SBC_LibraryView.this.setViewMode(0, true);
                    }
                }

                public boolean held(ToolBarItem toolBarItem) {
                    return false;
                }
            });
        }
    }

    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
        if (tb != null) {
            ToolBarItem itemModeBig;
            ToolBarItem itemModeSmall = tb.getToolBarItem("modeSmall");
            if (itemModeSmall != null) {
                itemModeSmall.setEnabled(true);
                itemModeSmall.getSkinButton().getSkinObject().switchSuffix(this.viewMode == 0 ? "" : "-down");
            }
            if ((itemModeBig = tb.getToolBarItem("modeBig")) != null) {
                itemModeBig.setEnabled(true);
                itemModeBig.getSkinButton().getSkinObject().switchSuffix(this.viewMode == 0 ? "-down" : "");
            }
        }
        return null;
    }

    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        return super.skinObjectHidden(skinObject, params);
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(int viewMode, boolean save) {
        SideBarEntrySWT entry;
        SWTSkinObject soOldViewArea;
        if (viewMode >= modeViewIDs.length || viewMode < 0 || viewMode == this.viewMode) {
            return;
        }
        if (this.itemModeSmall != null) {
            this.itemModeSmall.getSkinButton().getSkinObject().switchSuffix(viewMode == 0 ? "" : "-down");
        }
        if (this.itemModeBig != null) {
            this.itemModeBig.getSkinButton().getSkinObject().switchSuffix(viewMode == 0 ? "-down" : "");
        }
        int oldViewMode = this.viewMode;
        this.viewMode = viewMode;
        if (oldViewMode >= 0 && oldViewMode < modeViewIDs.length && (soOldViewArea = this.getSkinObject(modeViewIDs[oldViewMode])) != null) {
            soOldViewArea.setVisible(false);
        }
        SelectedContentManager.clearCurrentlySelectedContent();
        SWTSkinObject soViewArea = this.getSkinObject(modeViewIDs[viewMode]);
        if (soViewArea == null) {
            soViewArea = this.skin.createSkinObject(modeIDs[viewMode] + this.torrentFilterMode, modeIDs[viewMode], this.soListArea);
            this.skin.layout();
            soViewArea.setVisible(true);
            soViewArea.getControl().setLayoutData((Object)Utils.getFilledFormData());
        } else {
            soViewArea.setVisible(true);
        }
        if (save) {
            COConfigurationManager.setParameter(this.torrentFilter + ".viewmode", viewMode);
        }
        if (this.torrentFilterMode == 0 && viewMode == 0 && this.infoBarUtil == null) {
            this.infoBarUtil = new InfoBarUtil(this.skinObject, true, CFG_INFOBAR, "v3.library.infobar"){

                public boolean allowShow() {
                    return true;
                }
            };
        } else if (this.infoBarUtil != null && (this.torrentFilterMode != 0 || viewMode != 0)) {
            this.infoBarUtil.hide(true);
        }
        String entryID = null;
        if (this.torrentFilterMode == 0) {
            entryID = "Library";
        } else if (this.torrentFilterMode == 1) {
            entryID = "LibraryCD";
        } else if (this.torrentFilterMode == 2) {
            entryID = "LibraryDL";
        } else if (this.torrentFilterMode == 3) {
            entryID = "LibraryUnopened";
        }
        if (entryID != null && (entry = SideBar.getEntry(entryID)) != null) {
            entry.setLogID(entryID + "-" + viewMode);
        }
    }

    public static void setupViewTitle() {
        SideBarEntrySWT infoLibraryUn;
        ViewTitleInfo titleInfoDownloading = new ViewTitleInfo(){

            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0 && numIncomplete > 0) {
                    return numIncomplete + "";
                }
                if (propertyID == 1) {
                    return "There are " + numIncomplete + " incomplete torrents, " + numDownloading + " of which are currently downloading";
                }
                return null;
            }
        };
        SideBarEntrySWT infoDL = SideBar.getEntry("LibraryDL");
        if (infoDL != null) {
            SideBarVitalityImage vitalityImage = infoDL.addVitalityImage(ID_VITALITY_ACTIVE);
            vitalityImage.setVisible(false);
            vitalityImage = infoDL.addVitalityImage(ID_VITALITY_ALERT);
            vitalityImage.setVisible(false);
            infoDL.setTitleInfo(titleInfoDownloading);
        }
        ViewTitleInfo titleInfoSeeding = new ViewTitleInfo(){

            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    return null;
                }
                if (propertyID == 1) {
                    return "There are " + numComplete + " complete torrents, " + numSeeding + " of which are currently seeding";
                }
                return null;
            }
        };
        SideBarEntrySWT infoCD = SideBar.getEntry("LibraryCD");
        if (infoCD != null) {
            SideBarVitalityImage vitalityImage = infoCD.addVitalityImage(ID_VITALITY_ALERT);
            vitalityImage.setVisible(false);
            infoCD.setTitleInfo(titleInfoSeeding);
        }
        if ((infoLibraryUn = SideBar.getEntry("LibraryUnopened")) != null) {
            infoLibraryUn.setTitleInfo(new ViewTitleInfo(){

                public Object getTitleInfoProperty(int propertyID) {
                    if (propertyID == 0 && numUnOpened > 0) {
                        return "" + numUnOpened;
                    }
                    return null;
                }
            });
        }
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                SBC_LibraryView.setupViewTitleWithCore(core);
            }
        });
        PlatformTorrentUtils.addHasBeenOpenedListener(new HasBeenOpenedListener(){

            public void hasBeenOpenedChanged(DownloadManager dm, boolean opened) {
                SBC_LibraryView.recountUnopened();
                SBC_LibraryView.refreshAllLibraries();
            }
        });
    }

    protected static void setupViewTitleWithCore(AzureusCore core) {
        final GlobalManager gm = core.getGlobalManager();
        final DownloadManagerAdapter dmListener = new DownloadManagerAdapter(){

            public void stateChanged(DownloadManager dm, int state) {
                boolean isErrorState;
                if (PlatformTorrentUtils.getAdId(dm.getTorrent()) != null || PlatformTorrentUtils.isUpdateDM(dm)) {
                    return;
                }
                if (dm.getAssumedComplete()) {
                    boolean wasSeeding;
                    boolean isSeeding = dm.getState() == 60;
                    Boolean wasSeedingB = (Boolean)dm.getUserData("wasSeeding");
                    boolean bl = wasSeeding = wasSeedingB == null ? false : wasSeedingB;
                    if (isSeeding != wasSeeding) {
                        if (isSeeding) {
                            numSeeding++;
                        } else {
                            numSeeding--;
                        }
                        dm.setUserData("wasSeeding", new Boolean(isSeeding));
                    }
                } else {
                    boolean wasDownloading;
                    boolean isDownloading = dm.getState() == 50;
                    Boolean wasDownloadingB = (Boolean)dm.getUserData("wasDownloading");
                    boolean bl = wasDownloading = wasDownloadingB == null ? false : wasDownloadingB;
                    if (isDownloading != wasDownloading) {
                        if (isDownloading) {
                            numDownloading++;
                        } else {
                            numDownloading--;
                        }
                        dm.setUserData("wasDownloading", new Boolean(isDownloading));
                    }
                }
                boolean complete = dm.getAssumedComplete();
                Boolean wasErrorStateB = (Boolean)dm.getUserData("wasErrorState");
                boolean wasErrorState = wasErrorStateB == null ? false : wasErrorStateB;
                boolean bl = isErrorState = state == 100;
                if (isErrorState != wasErrorState) {
                    int rel;
                    int n = rel = isErrorState ? 1 : -1;
                    if (complete) {
                        numErrorComplete += rel;
                    } else {
                        numErrorInComplete += rel;
                    }
                    this.updateErrorTooltip();
                    dm.setUserData("wasErrorState", new Boolean(isErrorState));
                }
                SBC_LibraryView.refreshAllLibraries();
            }

            public void completionChanged(DownloadManager dm, boolean completed) {
                if (PlatformTorrentUtils.getAdId(dm.getTorrent()) != null || PlatformTorrentUtils.isUpdateDM(dm)) {
                    return;
                }
                if (completed) {
                    numComplete++;
                    numIncomplete--;
                    if (dm.getState() == 100) {
                        numErrorComplete++;
                        numErrorInComplete--;
                    }
                } else {
                    numIncomplete++;
                    numComplete--;
                    if (dm.getState() == 100) {
                        numErrorComplete--;
                        numErrorInComplete++;
                    }
                }
                SBC_LibraryView.recountUnopened();
                this.updateErrorTooltip();
                SBC_LibraryView.refreshAllLibraries();
            }

            protected void updateErrorTooltip() {
                if (numErrorComplete < 0) {
                    numErrorComplete = 0;
                }
                if (numErrorInComplete < 0) {
                    numErrorInComplete = 0;
                }
                if (numErrorComplete > 0 || numErrorInComplete > 0) {
                    String comp_error = null;
                    String incomp_error = null;
                    List downloads = gm.getDownloadManagers();
                    for (int i = 0; i < downloads.size(); ++i) {
                        DownloadManager download = (DownloadManager)downloads.get(i);
                        if (download.getState() != 100) continue;
                        if (download.getAssumedComplete()) {
                            if (comp_error == null) {
                                comp_error = download.getDisplayName() + ": " + download.getErrorDetails();
                                continue;
                            }
                            comp_error = comp_error + "...";
                            continue;
                        }
                        incomp_error = incomp_error == null ? download.getDisplayName() + ": " + download.getErrorDetails() : incomp_error + "...";
                    }
                    errorCompleteTooltip = comp_error;
                    errorInCompleteTooltip = incomp_error;
                }
            }
        };
        gm.addListener(new GlobalManagerAdapter(){

            public void downloadManagerRemoved(DownloadManager dm) {
                if (PlatformTorrentUtils.getAdId(dm.getTorrent()) != null || PlatformTorrentUtils.isUpdateDM(dm)) {
                    return;
                }
                SBC_LibraryView.recountUnopened();
                if (dm.getAssumedComplete()) {
                    numComplete--;
                    Boolean wasDownloadingB = (Boolean)dm.getUserData("wasDownloading");
                    if (wasDownloadingB != null && wasDownloadingB.booleanValue()) {
                        numDownloading--;
                    }
                } else {
                    numIncomplete--;
                    Boolean wasSeedingB = (Boolean)dm.getUserData("wasSeeding");
                    if (wasSeedingB != null && wasSeedingB.booleanValue()) {
                        numSeeding--;
                    }
                }
                SBC_LibraryView.refreshAllLibraries();
                dm.removeListener(dmListener);
            }

            public void downloadManagerAdded(DownloadManager dm) {
                if (PlatformTorrentUtils.getAdId(dm.getTorrent()) != null || PlatformTorrentUtils.isUpdateDM(dm)) {
                    return;
                }
                dm.addListener(dmListener, false);
                SBC_LibraryView.recountUnopened();
                if (dm.getAssumedComplete()) {
                    numComplete++;
                    if (dm.getState() == 60) {
                        numSeeding++;
                    }
                } else {
                    numIncomplete++;
                    if (dm.getState() == 50) {
                        dm.setUserData("wasDownloading", new Boolean(true));
                        numSeeding++;
                    } else {
                        dm.setUserData("wasDownloading", new Boolean(false));
                    }
                }
                SBC_LibraryView.refreshAllLibraries();
            }
        }, false);
        List downloadManagers = gm.getDownloadManagers();
        for (DownloadManager dm : downloadManagers) {
            if (PlatformTorrentUtils.getAdId(dm.getTorrent()) != null || PlatformTorrentUtils.isUpdateDM(dm)) continue;
            dm.addListener(dmListener, false);
            if (dm.getAssumedComplete()) {
                ++numComplete;
                if (dm.getState() == 60) {
                    dm.setUserData("wasSeeding", new Boolean(true));
                    ++numSeeding;
                    continue;
                }
                dm.setUserData("wasSeeding", new Boolean(false));
                continue;
            }
            ++numIncomplete;
            if (dm.getState() != 50) continue;
            ++numSeeding;
        }
        SBC_LibraryView.recountUnopened();
    }

    private static void recountUnopened() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        List dms = gm.getDownloadManagers();
        numUnOpened = 0;
        for (DownloadManager dm : dms) {
            if (PlatformTorrentUtils.getHasBeenOpened(dm) || !dm.getAssumedComplete()) continue;
            ++numUnOpened;
        }
    }

    protected static void refreshAllLibraries() {
        SideBarVitalityImage vitalityImage;
        int i;
        SideBarEntrySWT entry = SideBar.getEntry("LibraryDL");
        SideBarVitalityImage[] vitalityImages = entry.getVitalityImages();
        for (i = 0; i < vitalityImages.length; ++i) {
            vitalityImage = vitalityImages[i];
            if (vitalityImage.getImageID().equals(ID_VITALITY_ACTIVE)) {
                vitalityImage.setVisible(numDownloading > 0);
                SBC_LibraryView.refreshDLSpinner((SideBarVitalityImageSWT)vitalityImage);
                continue;
            }
            if (!vitalityImage.getImageID().equals(ID_VITALITY_ALERT)) continue;
            vitalityImage.setVisible(numErrorInComplete > 0);
            if (numErrorInComplete <= 0) continue;
            vitalityImage.setToolTip(errorInCompleteTooltip);
        }
        ViewTitleInfoManager.refreshTitleInfo(entry.getTitleInfo());
        entry = SideBar.getEntry("LibraryCD");
        vitalityImages = entry.getVitalityImages();
        for (i = 0; i < vitalityImages.length; ++i) {
            vitalityImage = vitalityImages[i];
            if (!vitalityImage.getImageID().equals(ID_VITALITY_ALERT)) continue;
            vitalityImage.setVisible(numErrorComplete > 0);
            if (numErrorComplete <= 0) continue;
            vitalityImage.setToolTip(errorCompleteTooltip);
        }
        entry = SideBar.getEntry("LibraryUnopened");
        ViewTitleInfoManager.refreshTitleInfo(entry.getTitleInfo());
    }

    public static void refreshDLSpinner(SideBarVitalityImageSWT vitalityImage) {
    }

    public static String getTableIdFromFilterMode(int torrentFilterMode, boolean big) {
        if (torrentFilterMode == 1) {
            return big ? "MySeeders.big" : "MySeeders";
        }
        if (torrentFilterMode == 2) {
            return big ? "MyTorrents.big" : "MyTorrents";
        }
        if (torrentFilterMode == 3) {
            return big ? "Unopened.big" : "Unopened";
        }
        if (torrentFilterMode == 0) {
            return "MyLibrary.big";
        }
        return null;
    }

    static {
        numErrorInComplete = 0;
        numUnOpened = 0;
    }
}

