/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectAdapter;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import org.gudy.azureus2.core3.util.Debug;

public abstract class SkinView
extends SWTSkinObjectAdapter {
    private boolean shownOnce = false;
    private boolean visible;
    protected SWTSkinObject soMain;
    protected SWTSkin skin;

    public SkinView() {
        if (this instanceof UIUpdatable) {
            UIUpdatable updateable = (UIUpdatable)((Object)this);
            try {
                UIFunctionsManager.getUIFunctions().getUIUpdater().addUpdater(updateable);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        this.setMainSkinObject(skinObject);
        this.visible = true;
        if (this.shownOnce) {
            return null;
        }
        this.shownOnce = true;
        try {
            return this.skinObjectInitialShow(skinObject, params);
        }
        catch (Exception e) {
            Debug.out(e);
            return null;
        }
    }

    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        this.visible = false;
        return super.skinObjectHidden(skinObject, params);
    }

    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        SkinViewManager.remove(this);
        if (this instanceof UIUpdatable) {
            UIUpdatable updateable = (UIUpdatable)((Object)this);
            try {
                UIFunctionsManager.getUIFunctions().getUIUpdater().removeUpdater(updateable);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        return null;
    }

    public abstract Object skinObjectInitialShow(SWTSkinObject var1, Object var2);

    public SWTSkinObject getMainSkinObject() {
        return this.soMain;
    }

    public final void setMainSkinObject(SWTSkinObject main) {
        if (this.soMain != null) {
            return;
        }
        this.soMain = main;
        if (this.soMain != null) {
            this.skin = this.soMain.getSkin();
        }
        SkinViewManager.add(this);
    }

    public final SWTSkin getSkin() {
        return this.skin;
    }

    public final SWTSkinObject getSkinObject(String viewID) {
        return this.skin.getSkinObject(viewID, this.soMain);
    }
}

