/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class SkinnedDialog {
    private final String shellSkinObjectID;
    private Shell shell;
    private SWTSkin skin;
    private List<SkinnedDialogClosedListener> closeListeners = new CopyOnWriteArrayList<SkinnedDialogClosedListener>();

    public SkinnedDialog(String skinFile, String shellSkinObjectID) {
        this(skinFile, shellSkinObjectID, 2160);
    }

    public SkinnedDialog(String skinFile, String shellSkinObjectID, int style) {
        this.shellSkinObjectID = shellSkinObjectID;
        Shell mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
        this.shell = ShellFactory.createShell(mainShell, style);
        Utils.setShellIcon(this.shell);
        this.skin = SWTSkinFactory.getNonPersistentInstance(SkinnedDialog.class.getClassLoader(), "com/aelitis/azureus/ui/skin/", skinFile + ".properties");
        this.skin.initialize(this.shell, shellSkinObjectID);
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    SkinnedDialog.this.shell.close();
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (SkinnedDialogClosedListener l : SkinnedDialog.this.closeListeners) {
                    try {
                        l.skinDialogClosed(SkinnedDialog.this);
                    }
                    catch (Exception e2) {
                        Debug.out(e2);
                    }
                }
            }
        });
        this.skin.layout();
        Utils.centerWindowRelativeTo(this.shell, (Control)mainShell);
    }

    public void open() {
        this.shell.open();
    }

    public SWTSkin getSkin() {
        return this.skin;
    }

    public void close() {
        this.shell.close();
    }

    public void addCloseListener(SkinnedDialogClosedListener l) {
        this.closeListeners.add(l);
    }

    public void setTitle(String string) {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.setText(string);
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public static interface SkinnedDialogClosedListener {
        public void skinDialogClosed(SkinnedDialog var1);
    }
}

