/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.devices.DeviceManagerUI;
import com.aelitis.azureus.ui.swt.devices.TranscodeChooser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarEnablerSelectedContent;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarItem;
import com.aelitis.azureus.ui.swt.views.skin.SBC_ActivityView;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.ui.swt.views.skin.VuzeShareUtils;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.util.PlayUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIPluginView;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.IconBarEnabler;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class ToolBarView
extends SkinView {
    private static toolbarButtonListener buttonListener;
    private Map<String, ToolBarItem> items = new LinkedHashMap<String, ToolBarItem>();
    Control lastControl = null;
    private boolean showText = true;
    private SWTSkinObject skinObject;
    private SWTSkinObject so2nd;
    private SWTSkinObject soGap;
    private boolean initComplete = false;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.skinObject = skinObject;
        buttonListener = new toolbarButtonListener();
        this.so2nd = skinObject.getSkin().getSkinObject("global-toolbar-2nd");
        this.soGap = skinObject.getSkin().getSkinObject("toolbar-gap");
        if (this.soGap != null) {
            Control cGap = this.soGap.getControl();
            FormData fd = (FormData)cGap.getLayoutData();
            if (fd.width == -1) {
                cGap.getParent().addListener(11, new Listener(){

                    public void handleEvent(Event event2) {
                        ToolBarView.this.resizeGap();
                    }
                });
            } else {
                this.soGap = null;
            }
        }
        ToolBarItem item = new ToolBarItem("download", "image.button.download", "v3.MainWindow.button.download"){

            public void triggerToolBarItem() {
                String viewID = SelectedContentManager.getCurrentySelectedViewID();
                if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                    return;
                }
                ISelectedContent[] sc = SelectedContentManager.getCurrentlySelectedContent();
                if (sc != null && sc.length == 1 && (sc[0].getHash() != null || sc[0].getDownloadInfo() != null)) {
                    TorrentListViewsUtils.downloadDataSource(sc[0], false, "toolbar");
                }
            }
        };
        this.addToolBarItem(item);
        item = new ToolBarItem("play", "image.button.play", "iconBar.play"){

            public void triggerToolBarItem() {
                String viewID = SelectedContentManager.getCurrentySelectedViewID();
                if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                    return;
                }
                ISelectedContent[] sc = SelectedContentManager.getCurrentlySelectedContent();
                if (sc != null) {
                    TorrentListViewsUtils.playOrStreamDataSource(sc[0], this.getSkinButton(), "toolbar");
                }
            }
        };
        this.addToolBarItem(item);
        this.addSeperator("toolbar.area.item.sep", this.soMain);
        this.lastControl = null;
        boolean first = true;
        if (!DeviceManagerUI.DISABLED) {
            item = new ToolBarItem("transcode", "image.button.transcode", "iconBar.transcode"){

                public void triggerToolBarItem() {
                    String viewID = SelectedContentManager.getCurrentySelectedViewID();
                    if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                        return;
                    }
                    final ISelectedContent[] contents = SelectedContentManager.getCurrentlySelectedContent();
                    if (contents.length == 0) {
                        return;
                    }
                    TranscodeChooser deviceChooser = new TranscodeChooser(){

                        public void closed() {
                            DeviceManager deviceManager = DeviceManagerFactory.getSingleton();
                            if (this.selectedTranscodeTarget != null && this.selectedProfile != null) {
                                for (int i = 0; i < contents.length; ++i) {
                                    DiskManagerFileInfo[] files;
                                    ISelectedContent selectedContent = contents[i];
                                    DownloadManager dm = selectedContent.getDownloadManager();
                                    if (dm == null) continue;
                                    for (DiskManagerFileInfo file : files = dm.getDiskManagerFileInfo()) {
                                        try {
                                            deviceManager.getTranscodeManager().getQueue().add(this.selectedTranscodeTarget, this.selectedProfile, (org.gudy.azureus2.plugins.disk.DiskManagerFileInfo)PluginCoreUtils.convert(file, false));
                                        }
                                        catch (TranscodeException e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                            }
                        }
                    };
                    deviceChooser.show();
                }
            };
            this.addToolBarItem(item, "toolbar.area.sitem.left", this.so2nd);
            this.addSeperator(this.so2nd);
            first = false;
        }
        item = new ToolBarItem("share", "image.button.share", "iconBar.share"){

            public void triggerToolBarItem() {
                String viewID = SelectedContentManager.getCurrentySelectedViewID();
                if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                    return;
                }
                ISelectedContent[] contents = SelectedContentManager.getCurrentlySelectedContent();
                if (contents.length > 0) {
                    VuzeShareUtils.getInstance().shareContent(contents[0], null, "ToolBar");
                }
            }
        };
        this.addToolBarItem(item, first ? "toolbar.area.sitem.left" : "toolbar.area.sitem", this.so2nd);
        this.addSeperator(this.so2nd);
        item = new ToolBarItem("run", "image.toolbar.run", "iconBar.run"){

            public void triggerToolBarItem() {
                String viewID = SelectedContentManager.getCurrentySelectedViewID();
                if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                    return;
                }
                boolean isIconBarEnabler = "IconBarEnabler".equals(viewID);
                ISelectedContent[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
                if (isIconBarEnabler && currentContent.length > 0 && currentContent[0] != null && currentContent[0] instanceof ToolBarEnablerSelectedContent) {
                    ToolBarEnablerSelectedContent ibeSelected = (ToolBarEnablerSelectedContent)currentContent[0];
                    IconBarEnabler enabler = ibeSelected.getIconBarEnabler();
                    if (enabler != null) {
                        enabler.itemActivated("start");
                    }
                } else {
                    Object[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    if (dms != null) {
                        TorrentUtil.runTorrents(dms);
                        for (int i = 0; i < dms.length; ++i) {
                            Object dm = dms[i];
                            PlatformTorrentUtils.setHasBeenOpened((DownloadManager)dm, true);
                        }
                    }
                }
            }
        };
        this.addToolBarItem(item, "toolbar.area.sitem", this.so2nd);
        this.addSeperator(this.so2nd);
        item = new ToolBarItem("up", "image.toolbar.up", "v3.iconBar.up"){

            public void triggerToolBarItem() {
                if (!AzureusCoreFactory.isCoreRunning()) {
                    return;
                }
                String viewID = SelectedContentManager.getCurrentySelectedViewID();
                if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                    return;
                }
                boolean isIconBarEnabler = "IconBarEnabler".equals(viewID);
                ISelectedContent[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
                if (isIconBarEnabler && currentContent.length > 0 && currentContent[0] != null && currentContent[0] instanceof ToolBarEnablerSelectedContent) {
                    ToolBarEnablerSelectedContent ibeSelected = (ToolBarEnablerSelectedContent)currentContent[0];
                    IconBarEnabler enabler = ibeSelected.getIconBarEnabler();
                    if (enabler != null) {
                        enabler.itemActivated("up");
                    }
                } else {
                    DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    if (dms != null) {
                        Arrays.sort(dms, new Comparator<DownloadManager>(){

                            @Override
                            public int compare(DownloadManager a, DownloadManager b) {
                                return a.getPosition() - b.getPosition();
                            }
                        });
                        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                        for (int i = 0; i < dms.length; ++i) {
                            DownloadManager dm = dms[i];
                            if (!gm.isMoveableUp(dm)) continue;
                            gm.moveUp(dm);
                        }
                    }
                }
            }

            public boolean triggerToolBarItemHold() {
                if (!AzureusCoreFactory.isCoreRunning()) {
                    return false;
                }
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                if (dms != null) {
                    gm.moveTop(dms);
                }
                return true;
            }
        };
        this.addToolBarItem(item, "toolbar.area.sitem", this.so2nd);
        this.addSeperator(this.so2nd);
        item = new ToolBarItem("down", "image.toolbar.down", "v3.iconBar.down"){

            public void triggerToolBarItem() {
                if (!AzureusCoreFactory.isCoreRunning()) {
                    return;
                }
                String viewID = SelectedContentManager.getCurrentySelectedViewID();
                if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                    return;
                }
                boolean isIconBarEnabler = "IconBarEnabler".equals(viewID);
                ISelectedContent[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
                if (isIconBarEnabler && currentContent.length > 0 && currentContent[0] != null && currentContent[0] instanceof ToolBarEnablerSelectedContent) {
                    ToolBarEnablerSelectedContent ibeSelected = (ToolBarEnablerSelectedContent)currentContent[0];
                    IconBarEnabler enabler = ibeSelected.getIconBarEnabler();
                    if (enabler != null) {
                        enabler.itemActivated("down");
                    }
                } else {
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    if (dms != null) {
                        Arrays.sort(dms, new Comparator<DownloadManager>(){

                            @Override
                            public int compare(DownloadManager a, DownloadManager b) {
                                return b.getPosition() - a.getPosition();
                            }
                        });
                        for (int i = 0; i < dms.length; ++i) {
                            DownloadManager dm = dms[i];
                            if (!gm.isMoveableDown(dm)) continue;
                            gm.moveDown(dm);
                        }
                    }
                }
            }

            public boolean triggerToolBarItemHold() {
                if (!AzureusCoreFactory.isCoreRunning()) {
                    return false;
                }
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                if (dms != null) {
                    gm.moveEnd(dms);
                }
                return true;
            }
        };
        this.addToolBarItem(item, "toolbar.area.sitem", this.so2nd);
        this.addSeperator(this.so2nd);
        item = new ToolBarItem("start", "image.toolbar.start", "iconBar.start"){

            public void triggerToolBarItem() {
                String viewID = SelectedContentManager.getCurrentySelectedViewID();
                if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                    return;
                }
                boolean isIconBarEnabler = "IconBarEnabler".equals(viewID);
                ISelectedContent[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
                if (isIconBarEnabler && currentContent.length > 0 && currentContent[0] != null && currentContent[0] instanceof ToolBarEnablerSelectedContent) {
                    ToolBarEnablerSelectedContent ibeSelected = (ToolBarEnablerSelectedContent)currentContent[0];
                    IconBarEnabler enabler = ibeSelected.getIconBarEnabler();
                    if (enabler != null) {
                        enabler.itemActivated("start");
                    }
                } else {
                    Object[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    if (dms != null) {
                        TorrentUtil.queueTorrents(dms, null);
                    }
                }
            }
        };
        this.addToolBarItem(item, "toolbar.area.sitem", this.so2nd);
        this.addSeperator(this.so2nd);
        item = new ToolBarItem("stop", "image.toolbar.stop", "iconBar.stop"){

            public void triggerToolBarItem() {
                String viewID = SelectedContentManager.getCurrentySelectedViewID();
                if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                    return;
                }
                boolean isIconBarEnabler = "IconBarEnabler".equals(viewID);
                ISelectedContent[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
                if (isIconBarEnabler && currentContent.length > 0 && currentContent[0] != null && currentContent[0] instanceof ToolBarEnablerSelectedContent) {
                    ToolBarEnablerSelectedContent ibeSelected = (ToolBarEnablerSelectedContent)currentContent[0];
                    IconBarEnabler enabler = ibeSelected.getIconBarEnabler();
                    if (enabler != null) {
                        enabler.itemActivated("stop");
                    }
                } else {
                    Object[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    if (dms != null) {
                        TorrentUtil.stopTorrents(dms, null);
                    }
                }
            }
        };
        this.addToolBarItem(item, "toolbar.area.sitem", this.so2nd);
        this.addSeperator(this.so2nd);
        item = new ToolBarItem("remove", "image.toolbar.remove", "iconBar.remove"){

            public void triggerToolBarItem() {
                String viewID = SelectedContentManager.getCurrentySelectedViewID();
                if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                    return;
                }
                boolean isActivityView = "Activity".equals(viewID);
                boolean isIconBarEnabler = "IconBarEnabler".equals(viewID);
                ISelectedContent[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
                if (isIconBarEnabler && currentContent.length > 0 && currentContent[0] != null && currentContent[0] instanceof ToolBarEnablerSelectedContent) {
                    ToolBarEnablerSelectedContent ibeSelected = (ToolBarEnablerSelectedContent)currentContent[0];
                    IconBarEnabler enabler = ibeSelected.getIconBarEnabler();
                    if (enabler != null) {
                        enabler.itemActivated("remove");
                    }
                } else if (isActivityView) {
                    SkinView view = SkinViewManager.getBySkinObjectID("Activity");
                    if (view instanceof SBC_ActivityView) {
                        SBC_ActivityView viewActivity = (SBC_ActivityView)view;
                        viewActivity.removeSelected();
                    }
                } else {
                    DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    TorrentListViewsUtils.removeDownloads(dms);
                }
            }
        };
        this.addToolBarItem(item, "toolbar.area.sitem.right", this.so2nd);
        this.addSeperator("toolbar.area.item.sep3", this.so2nd);
        this.addNonToolBar("toolbar.area.sitem.left2", this.so2nd);
        item = new ToolBarItem("modeBig", "image.toolbar.table_large", "v3.iconBar.view.big");
        this.addToolBarItem(item, "toolbar.area.vitem.left", this.so2nd);
        item.setEnabled(false);
        Control bigItem = item.getSkinButton().getSkinObject().getControl();
        SWTSkinObject soTitle = this.skin.getSkinObject("toolbar-item-title", item.getSkinButton().getSkinObject());
        if (soTitle instanceof SWTSkinObjectText) {
            ((SWTSkinObjectText)soTitle).setStyle(131072);
        }
        this.addSeperator(this.so2nd);
        item = new ToolBarItem("modeSmall", "image.toolbar.table_normal", "v3.iconBar.view.small");
        this.addToolBarItem(item, "toolbar.area.vitem.right", this.so2nd);
        item.setEnabled(false);
        Control smallItem = item.getSkinButton().getSkinObject().getControl();
        soTitle = this.skin.getSkinObject("toolbar-item-title", item.getSkinButton().getSkinObject());
        if (soTitle instanceof SWTSkinObjectText) {
            ((SWTSkinObjectText)soTitle).setStyle(16384);
        }
        this.resizeGap();
        SelectedContentManager.addCurrentlySelectedContentListener(new SelectedContentListener(){

            public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewID) {
                ToolBarView.this.updateCoreItems(currentContent, viewID);
                UIFunctionsManagerSWT.getUIFunctionsSWT().refreshTorrentMenu();
            }
        });
        try {
            if (!COConfigurationManager.getBooleanParameter("ToolBar.showText")) {
                this.flipShowText();
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        this.initComplete = true;
        return null;
    }

    protected void resizeGap() {
        if (this.soGap == null) {
            this.skinObject.getControl().getParent().layout();
            return;
        }
        Rectangle boundsLeft = this.skinObject.getControl().getBounds();
        Rectangle boundsRight = this.so2nd.getControl().getBounds();
        Rectangle clientArea = this.soGap.getControl().getParent().getClientArea();
        FormData fd = (FormData)this.soGap.getControl().getLayoutData();
        fd.width = clientArea.width - (boundsLeft.x + boundsLeft.width) - boundsRight.width;
        if (fd.width < 0) {
            fd.width = 0;
        } else if (fd.width > 50) {
            fd.width -= 30;
        } else if (fd.width > 20) {
            fd.width = 20;
        }
        this.soGap.getControl().getParent().layout();
    }

    protected void updateCoreItems(ISelectedContent[] currentContent, String viewID) {
        TableColumn tc;
        DownloadManager dm;
        ISelectedContent content;
        String itemID;
        int i;
        DownloadManager[] dms;
        SideBarEntrySWT entry;
        SideBar sidebar;
        boolean hasRealDM;
        ToolBarItem item;
        String[] itemsNeedingSelection = new String[]{};
        String[] itemsNeedingRealDMSelection = new String[]{"remove", "up", "down", "top", "bottom", "transcode"};
        String[] itemsRequiring1SelectionWithHash = new String[]{"details", "comment"};
        String[] itemsRequiring1DMSelection = new String[]{};
        boolean isActivityView = "Activity".equals(viewID);
        boolean isIconBarEnabler = "IconBarEnabler".equals(viewID);
        int numSelection = currentContent.length;
        boolean hasSelection = numSelection > 0;
        boolean has1Selection = numSelection == 1;
        boolean has1SelectionWithHash = has1Selection && currentContent[0].getHash() != null;
        for (int i2 = 0; i2 < itemsNeedingSelection.length; ++i2) {
            String itemID2 = itemsNeedingSelection[i2];
            item = this.getToolBarItem(itemID2);
            if (item == null) continue;
            item.setEnabled(hasSelection);
        }
        TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
        boolean bl = hasRealDM = tv != null;
        if (!hasRealDM && (sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class)) != null && (entry = sidebar.getCurrentEntry()) != null) {
            if (entry.datasource instanceof DownloadManager) {
                hasRealDM = true;
            } else if (entry.iview instanceof UIPluginView && ((UIPluginView)((Object)entry.iview)).getDataSource() instanceof DownloadManager) {
                hasRealDM = true;
            }
        }
        boolean isDMSelection = (dms = SelectedContentManager.getDMSFromSelectedContent()) != null && dms.length > 0;
        for (i = 0; i < itemsNeedingRealDMSelection.length; ++i) {
            itemID = itemsNeedingRealDMSelection[i];
            item = this.getToolBarItem(itemID);
            if (item == null) continue;
            item.setEnabled(hasSelection && isDMSelection && hasRealDM);
        }
        for (i = 0; i < itemsRequiring1SelectionWithHash.length; ++i) {
            itemID = itemsRequiring1SelectionWithHash[i];
            item = this.getToolBarItem(itemID);
            if (item == null) continue;
            item.setEnabled(has1SelectionWithHash);
        }
        for (i = 0; i < itemsRequiring1DMSelection.length; ++i) {
            itemID = itemsRequiring1DMSelection[i];
            item = this.getToolBarItem(itemID);
            if (item == null) continue;
            item.setEnabled(has1Selection && isDMSelection);
        }
        boolean canStart = false;
        boolean canStop = false;
        if (isIconBarEnabler && currentContent.length > 0 && currentContent[0] != null && currentContent[0] instanceof ToolBarEnablerSelectedContent) {
            ToolBarEnablerSelectedContent ibeSelected = (ToolBarEnablerSelectedContent)currentContent[0];
            IconBarEnabler enabler = ibeSelected.getIconBarEnabler();
            if (enabler != null) {
                String[] TBKEYS;
                for (String item_key : TBKEYS = new String[]{"download", "play", "share", "run", "up", "down", "start", "stop", "remove"}) {
                    item = this.getToolBarItem(item_key);
                    if (item == null) continue;
                    boolean enabled = enabler.isEnabled(item_key);
                    item.setEnabled(enabled);
                    if (!enabled) continue;
                    if (item_key.equals("start")) {
                        canStart = true;
                        continue;
                    }
                    if (!item_key.equals("stop")) continue;
                    canStop = true;
                }
            }
        } else if (isActivityView) {
            item = this.getToolBarItem("up");
            if (item != null) {
                item.setEnabled(false);
            }
            if ((item = this.getToolBarItem("down")) != null) {
                item.setEnabled(false);
            }
            if ((item = this.getToolBarItem("remove")) != null) {
                SkinView view = SkinViewManager.getBySkinObjectID("Activity");
                if (view instanceof SBC_ActivityView) {
                    SBC_ActivityView viewActivity = (SBC_ActivityView)view;
                    if (viewActivity.isVisible()) {
                        item.setEnabled(viewActivity.getNumSelected() > 0);
                    } else {
                        item.setEnabled(false);
                    }
                } else {
                    item.setEnabled(false);
                }
            }
        } else if (currentContent.length > 0 && hasRealDM) {
            for (int i3 = 0; i3 < currentContent.length; ++i3) {
                content = currentContent[i3];
                dm = content.getDownloadManager();
                if (!canStart && ManagerUtils.isStartable(dm)) {
                    canStart = true;
                }
                if (canStop || !ManagerUtils.isStopable(dm)) continue;
                canStop = true;
            }
        }
        if ((item = this.getToolBarItem("share")) != null) {
            boolean canShare = has1SelectionWithHash && VuzeShareUtils.getInstance().canShare(currentContent[0]);
            item.setEnabled(canShare);
        }
        if ((item = this.getToolBarItem("run")) != null) {
            boolean canRun = has1Selection;
            if (canRun) {
                content = currentContent[0];
                dm = content.getDownloadManager();
                if (dm == null) {
                    canRun = false;
                } else {
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent == null) {
                        canRun = false;
                    } else if (!dm.getAssumedComplete() && torrent.isSimpleTorrent()) {
                        canRun = false;
                    } else if (PlatformTorrentUtils.useEMP(torrent) && PlatformTorrentUtils.embeddedPlayerAvail() && PlayUtils.canProgressiveOrIsComplete(torrent)) {
                        canRun = false;
                    } else if (PlatformTorrentUtils.getAdId(torrent) != null) {
                        canRun = false;
                    }
                }
            }
            item.setEnabled(canRun);
        }
        if ((item = this.getToolBarItem("start")) != null) {
            item.setEnabled(canStart);
        }
        if ((item = this.getToolBarItem("stop")) != null) {
            item.setEnabled(canStop);
        }
        if ((item = this.getToolBarItem("play")) != null) {
            item.setEnabled(has1Selection && PlayUtils.canPlayDS(currentContent[0]));
        }
        if ((item = this.getToolBarItem("download")) != null) {
            boolean enabled = has1Selection && currentContent[0].getDownloadManager() == null && (currentContent[0].getHash() != null || currentContent[0].getDownloadInfo() != null);
            item.setEnabled(enabled);
        }
        if (tv != null && (tc = tv.getTableColumn("#")) != null && !tc.isVisible()) {
            item = this.getToolBarItem("up");
            if (item != null) {
                item.setEnabled(false);
            }
            if ((item = this.getToolBarItem("down")) != null) {
                item.setEnabled(false);
            }
        }
    }

    protected void activateViaSideBar(ToolBarItem toolBarItem) {
        SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        if (sidebar != null) {
            SideBarEntrySWT entry = sidebar.getCurrentEntry();
            if (entry.iview != null) {
                entry.iview.itemActivated(toolBarItem.getId());
            }
        }
    }

    public ToolBarItem getToolBarItem(String itemID) {
        return this.items.get(itemID);
    }

    public ToolBarItem[] getAllToolBarItems() {
        return this.items.values().toArray(new ToolBarItem[0]);
    }

    public void refreshCoreToolBarItems() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                ToolBarView.this._refreshCoreToolBarItems();
            }
        });
    }

    public void _refreshCoreToolBarItems() {
        ISelectedContent[] sc = SelectedContentManager.getCurrentlySelectedContent();
        String sv = SelectedContentManager.getCurrentySelectedViewID();
        if (sv != null) {
            this.updateCoreItems(sc, sv);
        } else {
            SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
            if (sidebar != null) {
                SideBarEntrySWT entry = sidebar.getCurrentEntry();
                IconBarEnabler enabler = entry.getIconBarEnabler();
                if (enabler == null && entry.iview != null) {
                    enabler = entry.iview;
                }
                ToolBarItem[] allToolBarItems = this.getAllToolBarItems();
                for (int i = 0; i < allToolBarItems.length; ++i) {
                    ToolBarItem toolBarItem = allToolBarItems[i];
                    toolBarItem.setEnabled(enabler.isEnabled(toolBarItem.getId()));
                }
            }
        }
    }

    private boolean triggerIViewToolBar(String id) {
        SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        if (sidebar != null) {
            SideBarEntrySWT entry = sidebar.getCurrentEntry();
            IconBarEnabler enabler = entry.getIconBarEnabler();
            if (enabler == null && entry.iview != null) {
                enabler = entry.iview;
            }
            enabler.itemActivated(id);
            return true;
        }
        return false;
    }

    public void addToolBarItem(ToolBarItem item) {
        this.addToolBarItem(item, "toolbar.area.item", this.soMain);
    }

    public void addToolBarItem(ToolBarItem item, String templateID, SWTSkinObject soMain) {
        SWTSkinObject so = this.skin.createSkinObject("toolbar:" + item.getId(), templateID, soMain);
        if (so != null) {
            so.setTooltipID(item.getTooltipID());
            if (this.lastControl != null) {
                FormData fd = (FormData)so.getControl().getLayoutData();
                fd.left = new FormAttachment(this.lastControl);
            }
            so.setData("toolbaritem", item);
            SWTSkinButtonUtility btn = new SWTSkinButtonUtility(so, "toolbar-item-image");
            btn.setImage(item.getImageID());
            btn.addSelectionListener(buttonListener);
            item.setSkinButton(btn);
            SWTSkinObject soTitle = this.skin.getSkinObject("toolbar-item-title", so);
            if (soTitle instanceof SWTSkinObjectText) {
                ((SWTSkinObjectText)soTitle).setTextID(item.getTextID());
            }
            if (this.initComplete) {
                Utils.relayout((Control)so.getControl().getParent());
            }
            this.lastControl = item.getSkinButton().getSkinObject().getControl();
            this.items.put(item.getId(), item);
        }
    }

    private void addSeperator(SWTSkinObject soMain) {
        this.addSeperator("toolbar.area.sitem.sep", soMain);
    }

    private void addSeperator(String id, SWTSkinObject soMain) {
        SWTSkinObject so = this.skin.createSkinObject("toolbar_sep" + Math.random(), id, soMain);
        if (so != null) {
            if (this.lastControl != null) {
                FormData fd = (FormData)so.getControl().getLayoutData();
                fd.left = new FormAttachment(this.lastControl, fd.left == null ? 0 : fd.left.offset);
            }
            this.lastControl = so.getControl();
        }
    }

    private void addNonToolBar(String skinid, SWTSkinObject soMain) {
        SWTSkinObject so = this.skin.createSkinObject("toolbar_d" + Math.random(), skinid, soMain);
        if (so != null) {
            if (this.lastControl != null) {
                FormData fd = (FormData)so.getControl().getLayoutData();
                fd.left = new FormAttachment(this.lastControl, fd.left == null ? 0 : fd.left.offset);
            }
            this.lastControl = so.getControl();
        }
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
        ToolBarItem[] allToolBarItems = this.getAllToolBarItems();
        for (int i = 0; i < allToolBarItems.length; ++i) {
            ToolBarItem tbi = allToolBarItems[i];
            SWTSkinObject so = tbi.getSkinButton().getSkinObject();
            SWTSkinObject soTitle = this.skin.getSkinObject("toolbar-item-title", so);
            soTitle.setVisible(showText);
        }
    }

    public boolean getShowText() {
        return this.showText;
    }

    public void flipShowText() {
        ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
        if (tb == null) {
            SkinViewManager.addListener(new SkinViewManager.SkinViewManagerListener(){

                public void skinViewAdded(SkinView skinview) {
                    if (skinview instanceof ToolBarView) {
                        SkinViewManager.RemoveListener(this);
                        ToolBarView.this.flipShowText();
                    }
                }
            });
            return;
        }
        try {
            FormData fd;
            Control control;
            boolean showText = !tb.getShowText();
            COConfigurationManager.setParameter("ToolBar.showText", showText);
            tb.setShowText(showText);
            SWTSkinObject skinObject = this.skin.getSkinObject("search-text");
            if (skinObject != null) {
                control = skinObject.getControl();
                fd = (FormData)control.getLayoutData();
                fd.top.offset = showText ? 6 : 5;
                int n = fd.bottom.offset = showText ? -3 : -2;
            }
            if ((skinObject = this.skin.getSkinObject("topgap")) != null) {
                control = skinObject.getControl();
                fd = (FormData)control.getLayoutData();
                int n = fd.height = showText ? 6 : 2;
            }
            if ((skinObject = this.skin.getSkinObject("tabbar")) != null) {
                control = skinObject.getControl();
                fd = (FormData)control.getLayoutData();
                fd.height = showText ? 50 : 32;
                skinObject.switchSuffix(showText ? "" : "-small", 4, true);
                Shell shell = control.getShell();
                shell.layout(true, true);
                shell.redraw();
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    private static class toolbarButtonListener
    extends SWTSkinButtonUtility.ButtonListenerAdapter {
        private toolbarButtonListener() {
        }

        public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            item.triggerToolBarItem();
        }

        public boolean held(SWTSkinButtonUtility buttonUtility) {
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            buttonUtility.getSkinObject().switchSuffix("", 0, false, true);
            boolean triggerToolBarItemHold = item.triggerToolBarItemHold();
            return triggerToolBarItemHold;
        }

        public void disabledStateChanged(SWTSkinButtonUtility buttonUtility, boolean disabled) {
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            item.setEnabled(!disabled);
        }
    }
}

