/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.shells.LightBoxBrowserWindow;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectImage;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.utils.SWTLoginUtils;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.ILoginInfoListener;
import com.aelitis.azureus.util.LoginInfoManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;

public class UserAreaUtils {
    private SWTSkin skin;
    private UIFunctionsSWT uiFunctions = null;
    private boolean firstLoginStateSync = true;
    private SWTSkinObjectImage soImage;

    public UserAreaUtils(SWTSkin skin, UIFunctionsSWT uiFunctions) {
        this.skin = skin;
        this.uiFunctions = uiFunctions;
        this.updateLoginLabels(null);
        this.hookListeners();
    }

    private void hookListeners() {
        SWTSkinObject skinObject = this.skin.getSkinObject("user-info-image");
        if (skinObject != null) {
            final Control control = skinObject.getControl();
            final Menu menu = new Menu((Decorations)control.getShell(), 8);
            this.fillUserInfoMenu(menu);
            menu.addListener(22, new Listener(){

                public void handleEvent(Event event2) {
                    MenuItem[] menuItems = menu.getItems();
                    for (int i = 0; i < menuItems.length; ++i) {
                        menuItems[i].dispose();
                    }
                    UserAreaUtils.this.fillUserInfoMenu(menu);
                }
            });
            SWTSkinButtonUtility btnGo = new SWTSkinButtonUtility(skinObject);
            btnGo.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    Point point = control.getShell().toDisplay(control.getParent().getLocation());
                    point.y += control.getSize().y / 2 + 10;
                    menu.setLocation(point);
                    menu.setVisible(true);
                }
            });
        }
        if ((skinObject = this.skin.getSkinObject("user-info-name")) != null) {
            SWTSkinButtonUtility btnGo = new SWTSkinButtonUtility(skinObject);
            btnGo.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    if (LoginInfoManager.getInstance().isLoggedIn()) {
                        if (null != UserAreaUtils.this.uiFunctions) {
                            String url = ConstantsVuze.getDefaultContentNetwork().getServiceURL(25);
                            UserAreaUtils.this.uiFunctions.viewURL(url, "browse", "curuser-name");
                        }
                    } else {
                        SWTLoginUtils.openLoginWindow();
                    }
                }
            });
        }
        if ((skinObject = this.skin.getSkinObject("user-info-profile-image")) instanceof SWTSkinObjectImage) {
            this.soImage = (SWTSkinObjectImage)skinObject;
        }
        LoginInfoManager.getInstance().addListener(new ILoginInfoListener(){

            public void loginUpdate(LoginInfoManager.LoginInfo info, boolean isNewLoginID) {
                UserAreaUtils.this.synchLoginStates(info, isNewLoginID);
            }

            public void avatarURLUpdated(String newAvatarURL) {
                UserAreaUtils.this.soImage.setImageUrl(newAvatarURL);
            }
        });
    }

    private void synchLoginStates(LoginInfoManager.LoginInfo info, boolean isNewLoginID) {
        this.updateLoginLabels(info);
        if (this.firstLoginStateSync) {
            this.firstLoginStateSync = false;
            return;
        }
        if (isNewLoginID) {
            if (null == info.userName) {
                this.resetBrowserPage("browse");
                this.resetBrowserPage("publish");
            } else {
                this.refreshBrowserPage("browse");
                this.refreshBrowserPage("publish");
            }
        }
    }

    private void updateLoginLabels(LoginInfoManager.LoginInfo info) {
        SWTSkinObject skinObjectName;
        if (info != null && null != info.userName) {
            skinObjectName = this.skin.getSkinObject("user-info-name");
            if (skinObjectName instanceof SWTSkinObjectText) {
                if (null != info.displayName) {
                    ((SWTSkinObjectText)skinObjectName).setText(info.displayName);
                } else {
                    ((SWTSkinObjectText)skinObjectName).setText(info.userName);
                }
            }
        } else {
            skinObjectName = this.skin.getSkinObject("user-info-name");
            if (skinObjectName instanceof SWTSkinObjectText) {
                ((SWTSkinObjectText)skinObjectName).setTextID("v3.MainWindow.text.log.in");
            }
        }
        SWTSkinObject skinObject = this.skin.getSkinObject("user-info");
        skinObject.relayout();
    }

    private void resetBrowserPage(String targetViewID) {
        SWTSkinObject skinObject = this.skin.getSkinObject(targetViewID);
        if (skinObject instanceof SWTSkinObjectBrowser) {
            ((SWTSkinObjectBrowser)skinObject).restart();
        }
    }

    private void refreshBrowserPage(final String targetViewID) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SWTSkinObject skinObject = UserAreaUtils.this.skin.getSkinObject(targetViewID);
                if (skinObject instanceof SWTSkinObjectBrowser) {
                    ((SWTSkinObjectBrowser)skinObject).getBrowser().refresh();
                }
            }
        });
    }

    private void fillUserInfoMenu(Menu menu) {
        if (LoginInfoManager.getInstance().isLoggedIn()) {
            MenuItem item = new MenuItem(menu, 8);
            item.setText(MessageText.getString("v3.MainWindow.text.my.account"));
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (null != UserAreaUtils.this.uiFunctions) {
                        String url = ContentNetworkUtils.getUrl(ConstantsVuze.getDefaultContentNetwork(), 26);
                        if (url == null) {
                            return;
                        }
                        UserAreaUtils.this.uiFunctions.viewURL(url, "browse", "curuser-account-menu");
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            item = new MenuItem(menu, 8);
            item.setText(MessageText.getString("v3.MainWindow.text.my.profile"));
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (LoginInfoManager.getInstance().isLoggedIn()) {
                        if (null != UserAreaUtils.this.uiFunctions) {
                            String url = ContentNetworkUtils.getUrl(ConstantsVuze.getDefaultContentNetwork(), 25);
                            UserAreaUtils.this.uiFunctions.viewURL(url, "browse", "curuser-profile-menu");
                        }
                    } else {
                        SWTLoginUtils.openLoginWindow();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            item = new MenuItem(menu, 2);
            item = new MenuItem(menu, 8);
            item.setText(MessageText.getString("v3.MainWindow.text.log.out"));
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    String url = ContentNetworkUtils.getUrl(ConstantsVuze.getDefaultContentNetwork(), 23);
                    SideBarEntrySWT entry = SideBar.getEntry("browse");
                    if (entry != null && entry.isInTree()) {
                        SWTSkinObjectBrowser soBrowser = SWTSkinUtils.findBrowserSO(entry.getSkinObject());
                        if (soBrowser != null) {
                            soBrowser.setURL(url);
                        } else {
                            UserAreaUtils.this.uiFunctions.viewURL(url, "browse", "curuser-profile-menu");
                        }
                    }
                }
            });
        } else {
            LoginInfoManager.LoginInfo info = LoginInfoManager.getInstance().getUserInfo();
            MenuItem item = new MenuItem(menu, 8);
            item.setText(MessageText.getString("v3.MainWindow.text.my.account"));
            item.setEnabled(false);
            item = new MenuItem(menu, 8);
            item.setText(MessageText.getString("v3.MainWindow.text.my.profile"));
            item.setEnabled(false);
            if (info.isRegistrationStillOpen) {
                item = new MenuItem(menu, 2);
                item = new MenuItem(menu, 8);
                item.setText(MessageText.getString("v3.MainWindow.text.get.started"));
                item.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (null != UserAreaUtils.this.uiFunctions) {
                            String url = ContentNetworkUtils.getUrl(ConstantsVuze.getDefaultContentNetwork(), 24);
                            if (url == null) {
                                return;
                            }
                            new LightBoxBrowserWindow(url, "vuzePage", 460, 577);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
            }
        }
    }
}

