/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin.sidebar;

import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarVitalityImageSWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImage;

public class SideBarToolTips
implements Listener,
UIUpdatable {
    Shell toolTipShell = null;
    Shell mainShell = null;
    Label toolTipLabel = null;
    private final Tree tree;
    private final SideBar sidebar;
    private SideBarEntrySWT sidebarEntry;
    private Point lastMouseHoverPos;

    public SideBarToolTips(SideBar sidebar, Tree tree) {
        this.sidebar = sidebar;
        this.tree = tree;
        this.mainShell = tree.getShell();
        tree.addListener(12, (Listener)this);
        tree.addListener(1, (Listener)this);
        tree.addListener(5, (Listener)this);
        tree.addListener(32, (Listener)this);
        this.mainShell.addListener(27, (Listener)this);
        tree.addListener(27, (Listener)this);
    }

    public void handleEvent(Event event2) {
        switch (event2.type) {
            case 32: {
                this.handleHover(new Point(event2.x, event2.y));
                break;
            }
            case 12: {
                if (this.mainShell != null && !this.mainShell.isDisposed()) {
                    this.mainShell.removeListener(27, (Listener)this);
                }
            }
            default: {
                if (this.toolTipShell == null) break;
                this.toolTipShell.dispose();
                this.toolTipShell = null;
                this.toolTipLabel = null;
            }
        }
    }

    private void handleHover(Point mousePos) {
        Rectangle displayRect;
        if (this.toolTipShell != null && !this.toolTipShell.isDisposed()) {
            this.toolTipShell.dispose();
        }
        if (this.tree.getItemCount() == 0) {
            return;
        }
        int indent = this.tree.getItem((int)0).getBounds().x;
        TreeItem treeItem = this.tree.getItem(new Point(indent, mousePos.y));
        if (treeItem == null) {
            return;
        }
        String id = (String)treeItem.getData("Plugin.viewID");
        this.sidebarEntry = SideBar.getEntry(id);
        String sToolTip = this.getToolTip(mousePos);
        if (sToolTip == null) {
            return;
        }
        this.lastMouseHoverPos = mousePos;
        Display d = this.tree.getDisplay();
        if (d == null) {
            return;
        }
        this.toolTipShell = new Shell(this.tree.getShell(), 16384);
        this.toolTipShell.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                UIUpdaterSWT.getInstance().removeUpdater(SideBarToolTips.this);
            }
        });
        FillLayout f = new FillLayout();
        try {
            f.marginWidth = 3;
            f.marginHeight = 1;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        this.toolTipShell.setLayout((Layout)f);
        this.toolTipShell.setBackground(d.getSystemColor(29));
        this.toolTipLabel = new Label((Composite)this.toolTipShell, 64);
        this.toolTipLabel.setForeground(d.getSystemColor(28));
        this.toolTipLabel.setBackground(d.getSystemColor(29));
        this.toolTipLabel.setText(sToolTip.replaceAll("&", "&&"));
        Point size = this.toolTipLabel.computeSize(-1, -1);
        if (size.x > 600) {
            size = this.toolTipLabel.computeSize(600, -1, true);
        }
        size.x += this.toolTipShell.getBorderWidth() * 2 + 2;
        size.y += this.toolTipShell.getBorderWidth() * 2;
        try {
            size.x += this.toolTipShell.getBorderWidth() * 2 + f.marginWidth * 2;
            size.y += this.toolTipShell.getBorderWidth() * 2 + f.marginHeight * 2;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        Point pt = this.tree.toDisplay(mousePos.x, mousePos.y);
        try {
            displayRect = this.tree.getMonitor().getClientArea();
        }
        catch (NoSuchMethodError e) {
            displayRect = this.tree.getDisplay().getClientArea();
        }
        if (pt.x + size.x > displayRect.x + displayRect.width) {
            pt.x = displayRect.x + displayRect.width - size.x;
        }
        pt.y = pt.y + size.y > displayRect.y + displayRect.height ? (pt.y -= size.y + 2) : (pt.y += 21);
        if (pt.y < displayRect.y) {
            pt.y = displayRect.y;
        }
        this.toolTipShell.setBounds(pt.x, pt.y, size.x, size.y);
        this.toolTipShell.setVisible(true);
        UIUpdaterSWT.getInstance().addUpdater(this);
    }

    private String getToolTip(Point mousePos) {
        SideBarVitalityImage[] vitalityImages = this.sidebarEntry.getVitalityImages();
        for (int i = 0; i < vitalityImages.length; ++i) {
            Rectangle hitArea;
            SideBarVitalityImageSWT vitalityImage = (SideBarVitalityImageSWT)vitalityImages[i];
            String indicatorToolTip = vitalityImage.getToolTip();
            if (indicatorToolTip == null || !vitalityImage.isVisible() || (hitArea = vitalityImage.getHitArea()) == null || !hitArea.contains(mousePos)) continue;
            return indicatorToolTip;
        }
        if (this.sidebarEntry.titleInfo != null) {
            return (String)this.sidebarEntry.titleInfo.getTitleInfoProperty(1);
        }
        return null;
    }

    public String getUpdateUIName() {
        return "SideBarToolTips";
    }

    public void updateUI() {
        if (this.toolTipLabel == null || this.toolTipLabel.isDisposed()) {
            return;
        }
        if (this.sidebarEntry == null || this.sidebarEntry.titleInfo == null) {
            return;
        }
        String sToolTip = this.getToolTip(this.lastMouseHoverPos);
        if (sToolTip == null) {
            return;
        }
        this.toolTipLabel.setText(sToolTip.replaceAll("&", "&&"));
    }
}

