/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin.widgets;

import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.views.skin.BuddiesViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;

public class FriendsList {
    private Composite content;
    private ScrolledComposite scrollable;
    private Canvas canvas;
    private List friendsWidgets = new ArrayList();
    private Color widgetBackgroundColor;
    private Color borderColor;
    private boolean isEmailDisplayOnly = false;
    private BuddiesViewer buddiesViewer;
    private Image default_prompt_image = null;
    private String default_prompt_text = null;
    private Rectangle textBounds;

    public FriendsList(Composite parent) {
        this.content = new Composite(parent, 0);
        FillLayout fLayout = new FillLayout();
        fLayout.marginHeight = 4;
        fLayout.marginWidth = 4;
        this.content.setLayout((Layout)fLayout);
        this.content.setBackgroundMode(1);
        this.scrollable = new ScrolledComposite(this.content, 512);
        this.scrollable.setExpandHorizontal(true);
        this.scrollable.setExpandVertical(true);
        this.scrollable.setBackgroundMode(1);
        this.canvas = new Canvas((Composite)this.scrollable, 0x20000000);
        this.borderColor = SWTSkinFactory.getInstance().getSkinProperties().getColor("color.widget.border");
        this.widgetBackgroundColor = parent.getDisplay().getSystemColor(25);
        this.scrollable.setContent((Control)this.canvas);
        this.init();
    }

    private void init() {
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                FriendsList.this.textBounds = FriendsList.this.canvas.getClientArea();
                try {
                    e.gc.setAntialias(1);
                    e.gc.setTextAntialias(1);
                    e.gc.setInterpolation(2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Rectangle bounds = FriendsList.this.canvas.getBounds();
                --bounds.width;
                --bounds.height;
                e.gc.fillRectangle(bounds);
                if (FriendsList.this.borderColor != null) {
                    e.gc.setForeground(FriendsList.this.borderColor);
                    e.gc.drawRectangle(bounds);
                }
                if (FriendsList.this.friendsWidgets.size() < 1) {
                    ((FriendsList)FriendsList.this).textBounds.x += 8;
                    ((FriendsList)FriendsList.this).textBounds.width -= 16;
                    if (null != FriendsList.this.default_prompt_text && FriendsList.this.default_prompt_text.length() > 0) {
                        GCStringPrinter.printString(e.gc, FriendsList.this.default_prompt_text, FriendsList.this.textBounds, false, false, 0x1000040);
                    }
                }
            }
        });
        this.canvas.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle r = FriendsList.this.scrollable.getClientArea();
                FriendsList.this.scrollable.setMinSize(FriendsList.this.canvas.computeSize(r.width, -1));
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.canvas.setBackground(this.widgetBackgroundColor);
        GridLayout gLayout = new GridLayout();
        gLayout.marginWidth = 1;
        gLayout.marginHeight = 1;
        gLayout.verticalSpacing = 0;
        gLayout.horizontalSpacing = 0;
        this.canvas.setLayout((Layout)gLayout);
        this.content.layout(true, true);
    }

    public void addFriend(final VuzeBuddy buddy) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (null == FriendsList.this.findWidget(buddy)) {
                    FriendWidget widget = new FriendWidget((Composite)FriendsList.this.canvas, buddy);
                    Rectangle r = FriendsList.this.scrollable.getClientArea();
                    FriendsList.this.friendsWidgets.add(widget);
                    GridData gData = new GridData(768);
                    gData.heightHint = 22;
                    widget.getControl().setLayoutData((Object)gData);
                    FriendsList.this.canvas.layout(true, true);
                    FriendsList.this.scrollable.setMinSize(FriendsList.this.canvas.computeSize(r.width, -1));
                    FriendsList.this.content.layout(true, true);
                    FriendsList.this.canvas.redraw();
                }
            }
        });
    }

    public void removeFriend(final VuzeBuddy buddy) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                FriendWidget widget = FriendsList.this.findWidget(buddy);
                if (null != widget) {
                    FriendsList.this.friendsWidgets.remove(widget);
                    widget.dispose(false);
                    FriendsList.this.canvas.layout(true);
                    Rectangle r = FriendsList.this.scrollable.getClientArea();
                    FriendsList.this.scrollable.setMinSize(FriendsList.this.canvas.computeSize(r.width, -1));
                    FriendsList.this.canvas.redraw();
                }
            }
        });
    }

    public void clear() {
        for (FriendWidget widget : this.friendsWidgets) {
            widget.dispose(false);
        }
        this.friendsWidgets.clear();
        Rectangle r = this.scrollable.getClientArea();
        this.scrollable.setMinSize(this.canvas.computeSize(r.width, -1));
    }

    public FriendWidget findWidget(VuzeBuddy buddy) {
        if (null != buddy) {
            for (FriendWidget widget : this.friendsWidgets) {
                if (null == widget.getBuddy() || !widget.getBuddy().getLoginID().equals(buddy.getLoginID())) continue;
                return widget;
            }
        }
        return null;
    }

    public Control getControl() {
        return this.content;
    }

    public boolean isEmailDisplayOnly() {
        return this.isEmailDisplayOnly;
    }

    public void setEmailDisplayOnly(boolean isEmailDisplayOnly) {
        this.isEmailDisplayOnly = isEmailDisplayOnly;
    }

    public BuddiesViewer getBuddiesViewer() {
        return this.buddiesViewer;
    }

    public void setBuddiesViewer(BuddiesViewer buddiesViewer) {
        this.buddiesViewer = buddiesViewer;
    }

    public int getContentCount() {
        return this.friendsWidgets.size();
    }

    public List getFriends() {
        ArrayList<VuzeBuddy> vuzeBuddies = new ArrayList<VuzeBuddy>();
        for (FriendWidget widget : this.friendsWidgets) {
            vuzeBuddies.add(widget.getBuddy());
        }
        return vuzeBuddies;
    }

    public Image getDefault_prompt_image() {
        return this.default_prompt_image;
    }

    public void setDefault_prompt_image(Image default_prompt_image) {
        this.default_prompt_image = default_prompt_image;
    }

    public String getDefault_prompt_text() {
        return this.default_prompt_text;
    }

    public void setDefault_prompt_text(String default_prompt_text) {
        this.default_prompt_text = default_prompt_text;
    }

    private class FriendWidget {
        private Composite parent;
        private Canvas friendCanvas;
        private VuzeBuddy buddy;
        private Rectangle closeButtonBounds;
        private Rectangle textAreaBounds;
        private Color normalColor = null;
        private Color borderColor = null;
        private boolean isActive = false;
        private boolean closeIsActive = false;
        private int alpha = 255;
        private Font boldFont = null;
        private Font normalFont = null;

        private FriendWidget(Composite parent, VuzeBuddy buddy) {
            this.parent = parent;
            this.buddy = buddy;
            final ImageLoader imageLoader = ImageLoader.getInstance();
            this.closeButtonBounds = imageLoader.getImage("button_skin_close").getBounds();
            imageLoader.releaseImage("button_skin_close");
            this.normalColor = SWTSkinFactory.getInstance().getSkinProperties().getColor("color.table.bg");
            this.borderColor = SWTSkinFactory.getInstance().getSkinProperties().getColor("color.widget.border");
            this.friendCanvas = new Canvas(parent, 0x20000000);
            this.friendCanvas.setBackgroundMode(1);
            this.friendCanvas.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle bounds = FriendWidget.this.friendCanvas.getBounds();
                    ((FriendWidget)FriendWidget.this).closeButtonBounds.x = bounds.width - ((FriendWidget)FriendWidget.this).closeButtonBounds.width - 6;
                    ((FriendWidget)FriendWidget.this).closeButtonBounds.y = bounds.height / 2 - ((FriendWidget)FriendWidget.this).closeButtonBounds.height / 2;
                    FriendWidget.this.textAreaBounds = new Rectangle(6, 0, ((FriendWidget)FriendWidget.this).closeButtonBounds.x - 6, bounds.height);
                }
            });
            this.friendCanvas.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    if (!FriendsList.this.isEmailDisplayOnly()) {
                        FriendWidget.this.isActive = true;
                        FriendWidget.this.friendCanvas.redraw();
                    }
                }

                public void mouseExit(MouseEvent e) {
                    if (!FriendsList.this.isEmailDisplayOnly()) {
                        FriendWidget.this.isActive = false;
                        FriendWidget.this.friendCanvas.redraw();
                    }
                }

                public void mouseHover(MouseEvent e) {
                    super.mouseHover(e);
                }
            });
            this.friendCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (!FriendsList.this.isEmailDisplayOnly() && FriendWidget.this.closeButtonBounds.contains(e.x, e.y) && FriendWidget.this.closeIsActive) {
                        FriendsList.this.getBuddiesViewer().removeFromShare(FriendWidget.this.buddy);
                    }
                }
            });
            this.friendCanvas.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (!FriendsList.this.isEmailDisplayOnly()) {
                        if (FriendWidget.this.closeButtonBounds.contains(e.x, e.y)) {
                            if (!FriendWidget.this.closeIsActive) {
                                FriendWidget.this.closeIsActive = true;
                                FriendWidget.this.friendCanvas.redraw();
                            }
                        } else if (FriendWidget.this.closeIsActive) {
                            FriendWidget.this.closeIsActive = false;
                            FriendWidget.this.friendCanvas.redraw();
                        }
                    }
                }
            });
            this.friendCanvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (null == FriendWidget.this.boldFont) {
                        FriendWidget.this.normalFont = e.gc.getFont();
                        FontData[] fData = e.gc.getFont().getFontData();
                        for (int i = 0; i < fData.length; ++i) {
                            fData[i].setStyle(1);
                        }
                        FriendWidget.this.boldFont = new Font((Device)e.display, fData);
                        FriendWidget.this.friendCanvas.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                if (null != FriendWidget.this.boldFont && !FriendWidget.this.boldFont.isDisposed()) {
                                    FriendWidget.this.boldFont.dispose();
                                }
                            }
                        });
                    }
                    Rectangle innerBounds = FriendWidget.this.friendCanvas.getClientArea();
                    if (FriendWidget.this.normalColor != null) {
                        e.gc.setBackground(FriendWidget.this.normalColor);
                    }
                    e.gc.fillRectangle(innerBounds);
                    if (FriendWidget.this.borderColor != null) {
                        e.gc.setForeground(FriendWidget.this.borderColor);
                        e.gc.drawLine(0, innerBounds.height - 1, innerBounds.width, innerBounds.height - 1);
                    }
                    VuzeBuddy vbuddy = FriendWidget.this.buddy;
                    Rectangle displayNameBounds = new Rectangle(((FriendWidget)FriendWidget.this).textAreaBounds.x, ((FriendWidget)FriendWidget.this).textAreaBounds.y, ((FriendWidget)FriendWidget.this).textAreaBounds.width, ((FriendWidget)FriendWidget.this).textAreaBounds.height);
                    if (null != vbuddy.getDisplayName() && vbuddy.getDisplayName().length() > 0) {
                        e.gc.setFont(FriendWidget.this.boldFont);
                        Point extent = e.gc.textExtent(vbuddy.getDisplayName() + " ");
                        displayNameBounds.width = extent.x;
                        GCStringPrinter.printString(e.gc, vbuddy.getDisplayName() + " ", displayNameBounds, false, true, 16384);
                        displayNameBounds.x = extent.x + 6;
                        displayNameBounds.width = ((FriendWidget)FriendWidget.this).textAreaBounds.width - extent.x;
                        e.gc.setFont(FriendWidget.this.normalFont);
                        if (null != vbuddy.getLoginID() && vbuddy.getLoginID().length() > 0) {
                            GCStringPrinter.printString(e.gc, "(" + vbuddy.getLoginID() + ")", displayNameBounds, false, true, 16384);
                        }
                    } else if (null != vbuddy.getLoginID() && vbuddy.getLoginID().length() > 0) {
                        GCStringPrinter.printString(e.gc, vbuddy.getLoginID(), displayNameBounds, false, true, 16384);
                    }
                    if (!FriendsList.this.isEmailDisplayOnly()) {
                        String id = FriendWidget.this.closeIsActive ? "button_skin_close-over" : "button_skin_close";
                        Image img = imageLoader.getImage(id);
                        e.gc.drawImage(img, ((FriendWidget)FriendWidget.this).closeButtonBounds.x, ((FriendWidget)FriendWidget.this).closeButtonBounds.y);
                        imageLoader.releaseImage(id);
                    }
                }
            });
        }

        public VuzeBuddy getBuddy() {
            return this.buddy;
        }

        public void setBuddy(VuzeBuddy buddy) {
            this.buddy = buddy;
        }

        public void dispose(boolean animated) {
            if (null != this.friendCanvas && !this.friendCanvas.isDisposed()) {
                if (animated) {
                    this.parent.getDisplay().asyncExec((Runnable)new AERunnable(){

                        public void runSupport() {
                            while (FriendWidget.this.alpha > 20 && !FriendWidget.this.friendCanvas.isDisposed()) {
                                FriendWidget.this.alpha -= 40;
                                FriendWidget.this.friendCanvas.redraw();
                                FriendWidget.this.friendCanvas.update();
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (!FriendWidget.this.friendCanvas.isDisposed()) {
                                FriendWidget.this.friendCanvas.dispose();
                                FriendWidget.this.parent.layout(true);
                            }
                        }
                    });
                } else if (!this.friendCanvas.isDisposed()) {
                    this.friendCanvas.dispose();
                    this.parent.layout(true);
                }
            }
        }

        public Control getControl() {
            return this.friendCanvas;
        }
    }
}

