/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.content.AzureusPlatformContentDirectory;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.peer.cache.CacheDiscovery;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.DownloadUtils;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.NavigationHelper;
import java.net.URL;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeAddedListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class InitialisationFunctions {
    private static final String EXTENSION_PREFIX = "azid";

    public static void earlyInitialisation(AzureusCore core) {
        DownloadUtils.initialise();
        DownloadManagerEnhancer dme = DownloadManagerEnhancer.initialise(core);
        InitialisationFunctions.registerTrackerURLExtensions();
        AzureusPlatformContentDirectory.register();
        CacheDiscovery.initialise(dme);
        ContentNetworkManagerFactory.preInitialise();
        MetaSearchManagerFactory.preInitialise();
        SubscriptionManagerFactory.preInitialise();
        DeviceManagerFactory.preInitialise();
        NavigationHelper.initialise();
        RelatedContentManager.preInitialise(core);
        AZ3Functions.setProvider(new AZ3Functions.provider(){

            public void subscribeToRSS(String name, URL url, int interval, boolean is_public, String creator_ref) throws Exception {
                Subscription subs = SubscriptionManagerFactory.getSingleton().createSingletonRSS(name, url, interval);
                if (subs.isPublic() != is_public) {
                    subs.setPublic(is_public);
                }
                if (creator_ref != null) {
                    subs.setCreatorRef(creator_ref);
                }
            }

            public boolean canShowCDP(org.gudy.azureus2.core3.download.DownloadManager dm) {
                return TorrentListViewsUtils.canViewDetails(dm);
            }

            public void showCDP(org.gudy.azureus2.core3.download.DownloadManager dm, String ref) {
                TorrentListViewsUtils.viewDetails(dm, ref);
            }

            public String getCDPURL(org.gudy.azureus2.core3.download.DownloadManager dm) {
                return TorrentListViewsUtils.getDetailsURL(dm);
            }
        });
    }

    public static void lateInitialisation(AzureusCore core) {
        ExternalStimulusHandler.initialise(core);
        PluginInitializer.getDefaultInterface().getUtilities().createDelayedTask(new Runnable(){

            public void run() {
                MetaSearchManagerFactory.getSingleton();
                SubscriptionManagerFactory.getSingleton();
                try {
                    RelatedContentManager.getSingleton();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }).queue();
    }

    protected static void registerTrackerURLExtensions() {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        DownloadManager dm = pi.getDownloadManager();
        dm.addDownloadWillBeAddedListener(new DownloadWillBeAddedListener(){

            public void initialised(Download download) {
                InitialisationFunctions.register(download);
            }
        });
        dm.addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                InitialisationFunctions.register(download);
            }

            public void downloadRemoved(Download download) {
            }
        });
    }

    protected static void register(final Download download) {
        DownloadManagerStateAttributeListener dmsal = new DownloadManagerStateAttributeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void attributeEventOccurred(org.gudy.azureus2.core3.download.DownloadManager dm, String attribute_name, int event_type) {
                try {
                    Torrent t = download.getTorrent();
                    if (t == null) {
                        return;
                    }
                    if (!PlatformTorrentUtils.isContent(t, true)) {
                        return;
                    }
                    DownloadUtils.addTrackerExtension(download, InitialisationFunctions.EXTENSION_PREFIX, ConstantsVuze.AZID);
                    download.setFlag(32L, true);
                }
                finally {
                    dm.getDownloadState().removeListener(this, "trackerclientextensions", 2);
                }
            }
        };
        PluginCoreUtils.unwrap(download).getDownloadState().addListener(dmsal, "trackerclientextensions", 2);
    }
}

