/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.crypto.VuzeCryptoException;
import com.aelitis.azureus.core.crypto.VuzeCryptoManager;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ILoginInfoListener;
import com.aelitis.azureus.util.MapUtils;
import java.util.Iterator;
import java.util.Map;

public class LoginInfoManager {
    private static final String NAME_NOT_SET_VALUE = "no.user.name.has.been.set";
    private static LoginInfoManager INSTANCE;
    private String userName = "no.user.name.has.been.set";
    private String displayName = null;
    private String pk = null;
    private boolean isRegistrationStillOpen = false;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private String avatarURL;

    private LoginInfoManager() {
    }

    public static LoginInfoManager getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new LoginInfoManager();
        }
        return INSTANCE;
    }

    public void addListener(ILoginInfoListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            if (this.isLoggedIn()) {
                listener.loginUpdate(new LoginInfo(), true);
                if (this.avatarURL != null) {
                    listener.avatarURLUpdated(this.avatarURL);
                }
            }
        }
    }

    public void removeListener(ILoginInfoListener listener) {
        this.listeners.remove(listener);
    }

    public LoginInfo getUserInfo() {
        return new LoginInfo();
    }

    public void setUserInfo(String userName, String displayName, String pk, String avatarURL) {
        boolean changed = false;
        boolean isNewLoginID = false;
        if (!("" + userName).equals("" + this.userName)) {
            this.userName = userName;
            changed = true;
            isNewLoginID = true;
        }
        if (!("" + displayName).equals("" + this.displayName)) {
            this.displayName = displayName;
            changed = true;
        }
        if (!("" + pk).equals("" + this.pk)) {
            this.pk = pk;
            changed = true;
        }
        if (!("" + avatarURL).equals("" + this.avatarURL)) {
            this.setAvatarURL(avatarURL);
            changed = true;
        }
        if (changed) {
            this.notifyListeners(isNewLoginID);
        }
    }

    public void setAvatarURL(String avatarURL) {
        if (avatarURL == null) {
            return;
        }
        if (avatarURL.equals(this.avatarURL)) {
            return;
        }
        this.avatarURL = avatarURL;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ILoginInfoListener)iterator.next()).avatarURLUpdated(avatarURL);
        }
    }

    public boolean isLoggedIn() {
        return this.userName != null && !this.userName.equals(NAME_NOT_SET_VALUE);
    }

    private void notifyListeners(boolean isNewLoginID) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ILoginInfoListener)iterator.next()).loginUpdate(new LoginInfo(), isNewLoginID);
        }
    }

    public void setUserInfo(Map mapUserInfo) {
        try {
            this.setUserInfo(MapUtils.getMapString(mapUserInfo, "login-id", null), MapUtils.getMapString(mapUserInfo, "display-name", null), VuzeCryptoManager.getSingleton().getPublicKey(""), MapUtils.getMapString(mapUserInfo, "avatar.url", null));
        }
        catch (VuzeCryptoException vuzeCryptoException) {
            // empty catch block
        }
    }

    public void logout() {
        this.userName = null;
        this.displayName = null;
        this.avatarURL = null;
        this.pk = null;
        this.notifyListeners(false);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ILoginInfoListener)iterator.next()).avatarURLUpdated(this.avatarURL);
        }
    }

    public class LoginInfo {
        public final String userName;
        public final String displayName;
        public final boolean isRegistrationStillOpen;
        public final String pk;
        public final String avatarUrl;

        public LoginInfo() {
            this.userName = LoginInfoManager.this.userName;
            this.displayName = LoginInfoManager.this.displayName == null ? LoginInfoManager.this.userName : LoginInfoManager.this.displayName;
            this.isRegistrationStillOpen = LoginInfoManager.this.isRegistrationStillOpen;
            this.pk = LoginInfoManager.this.pk;
            this.avatarUrl = LoginInfoManager.this.avatarURL;
        }

        public String getProfileAHREF(String referer) {
            StringBuffer buf = new StringBuffer();
            buf.append("<A HREF=\"");
            buf.append(ConstantsVuze.getDefaultContentNetwork().getProfileService(this.userName, referer));
            buf.append("\" TITLE=\"");
            buf.append(this.displayName);
            if (!this.displayName.equals(this.userName)) {
                buf.append(" (");
                buf.append(this.userName);
                buf.append(")");
            }
            buf.append("\">");
            buf.append(this.displayName);
            buf.append("</A>");
            return buf.toString();
        }
    }
}

