/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class NavigationHelper {
    public static final int COMMAND_SWITCH_TO_TAB = 1;
    public static final int COMMAND_CONDITION_CHECK = 2;
    public static final int COMMAND_BUDDY_SYNC = 3;
    public static final String COMMAND_CHECK_BUDDY_MANAGER = "buddy-manager";
    public static final String COMMAND_CHECK_BUDDY_MANAGER_ENABLED = "enabled";
    private static CopyOnWriteList listeners = new CopyOnWriteList();
    private static List command_queue;

    protected static void initialise() {
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            public void process(VuzeFile[] files, int expected_types) {
                for (int i = 0; i < files.length; ++i) {
                    VuzeFile vf = files[i];
                    VuzeFileComponent[] comps = vf.getComponents();
                    for (int j = 0; j < comps.length; ++j) {
                        VuzeFileComponent comp2 = comps[j];
                        if (comp2.getType() != 2 && comp2.getType() != 4) continue;
                        try {
                            List commands = (List)comp2.getContent().get("commands");
                            for (int k = 0; k < commands.size(); ++k) {
                                String[] args;
                                Map command = (Map)commands.get(k);
                                int command_type = ((Long)command.get("type")).intValue();
                                List l_args = (List)command.get("args");
                                if (l_args == null) {
                                    args = new String[]{};
                                } else {
                                    args = new String[l_args.size()];
                                    for (int l = 0; l < args.length; ++l) {
                                        args[l] = new String((byte[])l_args.get(l), "UTF-8");
                                    }
                                }
                                NavigationHelper.addCommand(command_type, args);
                            }
                            comp2.setProcessed();
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addCommand(int type, String[] args) {
        CopyOnWriteList copyOnWriteList = listeners;
        synchronized (copyOnWriteList) {
            if (listeners.size() == 0) {
                if (command_queue == null) {
                    command_queue = new ArrayList();
                }
                command_queue.add(new Object[]{new Integer(type), args});
            }
        }
        for (navigationListener l : listeners) {
            try {
                l.processCommand(type, args);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(navigationListener l) {
        List queue;
        CopyOnWriteList copyOnWriteList = listeners;
        synchronized (copyOnWriteList) {
            listeners.add(l);
            queue = command_queue;
            command_queue = null;
        }
        if (queue != null) {
            for (int i = 0; i < queue.size(); ++i) {
                Object[] entry = (Object[])queue.get(i);
                int type = (Integer)entry[0];
                String[] args = (String[])entry[1];
                try {
                    l.processCommand(type, args);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            VuzeFile vf = VuzeFileHandler.getSingleton().create();
            HashMap content = new HashMap();
            ArrayList commands = new ArrayList();
            content.put("commands", commands);
            HashMap<String, Serializable> command1 = new HashMap<String, Serializable>();
            commands.add(command1);
            ArrayList l_args1 = new ArrayList();
            command1.put("type", new Long(1L));
            command1.put("args", l_args1);
            HashMap<String, Serializable> command2 = new HashMap<String, Serializable>();
            commands.add(command2);
            ArrayList l_args2 = new ArrayList();
            command2.put("type", new Long(1L));
            command2.put("args", l_args2);
            HashMap<String, Serializable> command3 = new HashMap<String, Serializable>();
            commands.add(command3);
            ArrayList<String> l_args3 = new ArrayList<String>();
            l_args3.add(COMMAND_CHECK_BUDDY_MANAGER);
            l_args3.add(COMMAND_CHECK_BUDDY_MANAGER_ENABLED);
            command3.put("type", new Long(2L));
            command3.put("args", l_args3);
            vf.addComponent(2, content);
            vf.write(new File("C:\\temp\\v3ui.vuze"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static interface navigationListener {
        public void processCommand(int var1, String[] var2);
    }
}

