/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkListener;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManager;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.util.ConstantsVuze;
import java.util.Iterator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class UrlFilter {
    private static UrlFilter instance = null;
    private String default_site_host = (String)ConstantsVuze.getDefaultContentNetwork().getProperty(1);
    private String DEFAULT_RPC_WHITELIST = "https?://" + this.default_site_host.replaceAll("\\.", "\\\\.") + ":?[0-9]*/" + ".*";
    private CopyOnWriteList<String> listUrlBlacklist = new CopyOnWriteList();
    private CopyOnWriteList<String> listUrlWhitelist = new CopyOnWriteList();
    private AEMonitor mon = new AEMonitor("UrlFilter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UrlFilter getInstance() {
        Class<UrlFilter> clazz = UrlFilter.class;
        synchronized (UrlFilter.class) {
            if (instance == null) {
                instance = new UrlFilter();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public UrlFilter() {
        this.listUrlWhitelist.add(this.DEFAULT_RPC_WHITELIST);
        ContentNetworkManager cmn = ContentNetworkManagerFactory.getSingleton();
        ContentNetwork[] contentNetworks = cmn.getContentNetworks();
        cmn.addListener(new ContentNetworkListener(){

            public void networkRemoved(ContentNetwork network) {
            }

            public void networkChanged(ContentNetwork network) {
            }

            public void networkAdded(ContentNetwork network) {
                UrlFilter.this.addNetworkFilters(network);
            }

            public void networkAddFailed(long network_id, Throwable error) {
            }
        });
        for (ContentNetwork cn : contentNetworks) {
            this.addNetworkFilters(cn);
        }
    }

    protected void addNetworkFilters(ContentNetwork network) {
        int[] whitelist_services;
        if (network == null) {
            return;
        }
        for (int service : whitelist_services = new int[]{15, 5, 4, 3}) {
            if (!network.isServiceSupported(service)) continue;
            this.addUrlWhitelist(network.getServiceURL(service) + ".*");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUrlWhitelist(String string) {
        this.mon.enter();
        try {
            if (!this.listUrlWhitelist.contains(string)) {
                PlatformMessenger.debug("add whitelist of " + string);
                this.listUrlWhitelist.add(string);
            } else {
                PlatformMessenger.debug("whitelist already exists: " + string);
            }
        }
        finally {
            this.mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUrlBlacklist(String string) {
        this.mon.enter();
        try {
            if (!this.listUrlBlacklist.contains(string)) {
                PlatformMessenger.debug("add blacklist of " + string);
                this.listUrlBlacklist.add(string);
            }
        }
        finally {
            this.mon.exit();
        }
    }

    public String[] getUrlWhitelist() {
        return this.listUrlWhitelist.toArray((String[])new String[0]);
    }

    public boolean isWhitelisted(String url) {
        Iterator<String> it = this.listUrlWhitelist.iterator();
        while (it.hasNext()) {
            if (!url.matches(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean urlCanRPC(String url) {
        return this.urlCanRPC(url, false);
    }

    public boolean urlCanRPC(String url, boolean showDebug) {
        if (url == null) {
            Debug.out("URL null and should be blocked");
            return false;
        }
        if (Constants.isCVSVersion() && url.startsWith("file://")) {
            return true;
        }
        if (this.isWhitelisted(url)) {
            return true;
        }
        if (showDebug) {
            Debug.out("urlCanRPC: URL '" + url + "' " + " does not match one of the " + this.listUrlWhitelist.size() + " whitelist entries");
        }
        return false;
    }

    public boolean urlIsBlocked(String url) {
        if (url == null) {
            Debug.out("URL null and should be blocked");
            return true;
        }
        for (String blackListed : this.listUrlBlacklist) {
            if (!url.matches(blackListed)) continue;
            Debug.out("URL '" + url + "' " + " is blocked by " + blackListed);
            return true;
        }
        return false;
    }
}

