/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProvider;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProviderInstance;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.router.DHTRouterFactory;
import com.aelitis.azureus.core.dht.router.DHTRouterFactoryObserver;
import com.aelitis.azureus.core.dht.router.DHTRouterObserver;
import com.aelitis.azureus.vivaldi.ver2.IDWrapper;
import com.aelitis.azureus.vivaldi.ver2.InitialPosition;
import com.aelitis.azureus.vivaldi.ver2.LocalPosition;
import com.aelitis.azureus.vivaldi.ver2.RemotePosition;
import com.aelitis.azureus.vivaldi.ver2.StableLocalPosition;
import com.aelitis.azureus.vivaldi.ver2.SyrahPosition;
import com.aelitis.azureus.vivaldi.ver2.TransientTuple;
import com.aelitis.azureus.vivaldi.ver2.stats.SerializationController;
import com.aelitis.azureus.vivaldi.ver2.stats.V1Serializer;
import edu.harvard.syrah.nc.Coordinate;
import edu.harvard.syrah.nc.VivaldiClient;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VivaldiV2PositionProvider
implements DHTNetworkPositionProvider,
DHTRouterFactoryObserver,
DHTRouterObserver {
    public static final int NUM_DIMS = 5;
    public static final int TRANSIENT_TIME = 45000;
    public static final long MIN_NC_UPDATE_INTERVAL = 10000L;
    private static final boolean LOGGING_ENABLED = false;
    private static boolean initialised = false;
    private static volatile DHTNetworkPositionProviderInstance provider = null;
    private final VivaldiClient<IDWrapper> vc;
    private final InitialPosition ip;
    protected final SortedSet<IDWrapper> transient_ids;
    protected final LinkedList<TransientTuple> transient_list;
    protected final SerializationController serializer;
    protected final SortedSet<IDWrapper> router_entries;
    protected DHTRouter router = null;
    protected long last_nc_update = 0L;
    private boolean started_up = false;

    public static synchronized void initialise() {
        if (!initialised) {
            initialised = true;
            provider = DHTNetworkPositionManager.registerProvider(new VivaldiV2PositionProvider());
            VivaldiV2PositionProvider.doLog("Vivaldi V2 position provider created");
        }
    }

    protected VivaldiV2PositionProvider() {
        DHTRouterFactory.addObserver(this);
        this.vc = new VivaldiClient(5);
        this.ip = new InitialPosition();
        this.transient_ids = new TreeSet<IDWrapper>();
        this.transient_list = new LinkedList();
        this.serializer = new SerializationController();
        this.router_entries = new TreeSet<IDWrapper>();
        Timer timer = new Timer("VivaldiV2PositionProvider:ping");
        timer.addPeriodicEvent(10000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                VivaldiV2PositionProvider.this.ping();
            }
        });
    }

    protected void resetPingClock(long curr_time) {
        this.last_nc_update = curr_time;
    }

    protected void ping() {
        IDWrapper id;
        long curr_time = System.currentTimeMillis();
        if (curr_time > this.last_nc_update + 10000L && this.router != null && (id = this.vc.getNeighborToPing(curr_time)) != null) {
            byte[] raw_id = id.getRawId();
            this.router.requestPing(raw_id);
        }
    }

    @Override
    public byte getPositionType() {
        return 5;
    }

    @Override
    public DHTNetworkPosition create(byte[] ID, boolean is_local) {
        if (is_local) {
            VivaldiV2PositionProvider.doLog("Returning position for local peer");
            return new LocalPosition(this);
        }
        this.purgeTransient(System.currentTimeMillis());
        return this.ip;
    }

    @Override
    public DHTNetworkPosition deserialisePosition(DataInputStream is) throws IOException {
        return new RemotePosition(is);
    }

    @Override
    public void serialiseStats(DataOutputStream os) throws IOException {
        if (!this.serializer.contains((byte)1)) {
            this.serializer.addSerializer(V1Serializer.getInstance());
        }
        this.serializer.toSerialized((byte)1, os, this.vc);
    }

    @Override
    public void routerCreated(DHTRouter _router) {
        VivaldiV2PositionProvider.doLog("Vivaldi notified of created router");
        _router.addObserver(this);
        this.router = _router;
    }

    @Override
    public synchronized void added(DHTRouterContact contact) {
        this.purgeTransient(System.currentTimeMillis());
        IDWrapper id = new IDWrapper(contact.getID());
        if (!this.router_entries.contains(id)) {
            this.router_entries.add(id);
        }
        if (this.transient_ids.remove(id)) {
            TransientTuple tt = null;
            Iterator i = this.transient_list.iterator();
            while (i.hasNext()) {
                tt = (TransientTuple)i.next();
                if (!tt.id.equals(id)) continue;
                i.remove();
                break;
            }
            long curr_time = System.currentTimeMillis();
            long tt_age = curr_time - tt.create_time + tt.last_pos.getAge();
            if (this.vc.processSample(id, tt.last_pos.getCoords(), tt.last_pos.getError(), tt.last_rtt, tt_age, curr_time, true)) {
                this.resetPingClock(curr_time);
            }
        } else if (this.vc.getHosts().contains(id)) {
            // empty if block
        }
    }

    @Override
    public synchronized void removed(DHTRouterContact contact) {
        this.purgeTransient(System.currentTimeMillis());
        IDWrapper id = new IDWrapper(contact.getID());
        if (this.router_entries.remove(id)) {
            // empty if block
        }
        if (!this.vc.removeHost(id) && this.transient_ids.remove(id)) {
            Iterator i = this.transient_list.iterator();
            while (i.hasNext()) {
                TransientTuple tt = (TransientTuple)i.next();
                if (!tt.id.equals(id)) continue;
                i.remove();
                break;
            }
        }
    }

    @Override
    public void locationChanged(DHTRouterContact contact) {
        this.purgeTransient(System.currentTimeMillis());
    }

    @Override
    public void nowAlive(DHTRouterContact contact) {
        this.purgeTransient(System.currentTimeMillis());
    }

    @Override
    public void nowFailing(DHTRouterContact contact) {
        this.purgeTransient(System.currentTimeMillis());
    }

    @Override
    public void destroyed(DHTRouter router) {
        VivaldiV2PositionProvider.doLog("Vivaldi notified of destroyed router");
        router.removeObserver(this);
        this.vc.reset();
        this.router_entries.clear();
        this.transient_ids.clear();
        this.transient_list.clear();
    }

    @Override
    public DHTNetworkPosition getLocalPosition() {
        if (this.started_up) {
            return new StableLocalPosition(this);
        }
        return null;
    }

    protected Coordinate getCoords() {
        return this.vc.getSystemCoords();
    }

    protected Coordinate getStableCoords() {
        return this.vc.getApplicationCoords();
    }

    protected float getError() {
        return (float)this.vc.getSystemError();
    }

    protected long getAge() {
        long age = this.vc.getAge(System.currentTimeMillis());
        return age;
    }

    protected InitialPosition getInitialPosition() {
        return this.ip;
    }

    protected VivaldiClient<IDWrapper> getVivaldiClient() {
        return this.vc;
    }

    protected synchronized void update(LocalPosition local_pos, IDWrapper id, SyrahPosition sp, float sample_rtt) {
        if (sp == local_pos) {
            VivaldiV2PositionProvider.doLog("update invoked on LocalPosition with itself, ID = " + id);
            return;
        }
        if (sp == this.ip) {
            VivaldiV2PositionProvider.doLog("update invoked with the InitialPosition singleton, ID = " + id);
            return;
        }
        long curr_time = System.currentTimeMillis();
        if (this.vc.getHosts().contains(id)) {
            if (this.vc.processSample(id, sp.getCoords(), sp.getError(), sample_rtt, sp.getAge(), curr_time, false)) {
                this.resetPingClock(curr_time);
            }
            VivaldiV2PositionProvider.doLog("update called on host, ID = " + id);
            return;
        }
        if (this.router_entries.contains(id)) {
            if (this.transient_ids.remove(id)) {
                Iterator i = this.transient_list.iterator();
                while (i.hasNext()) {
                    TransientTuple tt = (TransientTuple)i.next();
                    if (!tt.id.equals(id)) continue;
                    i.remove();
                    break;
                }
            }
            if (this.vc.processSample(id, sp.getCoords(), sp.getError(), sample_rtt, sp.getAge(), curr_time, true)) {
                this.resetPingClock(curr_time);
            }
            VivaldiV2PositionProvider.doLog("update called on host already in router, ID = " + id);
            return;
        }
        long new_remove_time = curr_time + 45000L;
        if (!this.transient_ids.contains(id)) {
            this.transient_ids.add(id);
            this.transient_list.addLast(new TransientTuple(new_remove_time, id, sp, sample_rtt, curr_time));
            VivaldiV2PositionProvider.doLog("added transient " + id + " " + this.getStats());
            return;
        }
        VivaldiV2PositionProvider.doLog("updating transient " + id + " " + this.getStats());
        TransientTuple tt = null;
        Iterator i = this.transient_list.iterator();
        while (i.hasNext()) {
            tt = (TransientTuple)i.next();
            if (!tt.id.equals(id)) continue;
            i.remove();
            break;
        }
        tt.remove_time = new_remove_time;
        tt.last_pos = sp;
        tt.last_rtt = sample_rtt;
        this.transient_list.addLast(tt);
    }

    protected synchronized void purgeTransient(long curr_time) {
        Iterator i = this.transient_list.iterator();
        while (i.hasNext()) {
            TransientTuple tt = (TransientTuple)i.next();
            if (tt.remove_time > curr_time) {
                return;
            }
            i.remove();
            this.transient_ids.remove(tt.id);
            VivaldiV2PositionProvider.doLog("removed transient " + tt.id + " " + this.getStats());
        }
    }

    protected String getStats() {
        return "[h:" + this.vc.getHosts().size() + ", t:" + this.transient_list.size() + " re:" + this.router_entries.size() + "]";
    }

    protected static void doLog(String str) {
    }

    @Override
    public void startUp(DataInputStream is) {
        this.started_up = true;
        try {
            this.vc.startUp(is);
        }
        catch (IOException e) {
            VivaldiV2PositionProvider.doLog("startUp failed:" + e.toString());
        }
    }

    @Override
    public void shutDown(DataOutputStream os) {
        try {
            this.vc.shutDown(os);
        }
        catch (IOException e) {
            VivaldiV2PositionProvider.doLog("shutDown failed:" + e.toString());
        }
    }
}

