/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2.stats;

import com.aelitis.azureus.vivaldi.ver2.stats.VivaldiStatistics;
import edu.harvard.syrah.nc.Coordinate;
import edu.harvard.syrah.nc.VivaldiClient;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V1Statistics
implements VivaldiStatistics {
    public Coordinate sys_coord;
    public Coordinate app_coord;
    public float error;
    public float dist_to_nearest_neighbor;
    public float age_difference;
    public float valid_link_count;
    public float gravity;
    public float relative_rank_loss;
    public float norm_app_latency_penalty;
    public float relative_app_latency_penalty;
    public float sys_re50;
    public float sys_re95;
    public float app_re50;
    public float app_re95;
    public float sys_dd;
    public float app_dd;
    public float neighbors_used_per_update;
    public float running_relative_diff;
    public float running_sys_update_frequency;
    public float running_app_update_frequency;
    public boolean keepStatistics;
    protected static final NumberFormat nf = NumberFormat.getInstance();
    protected static final int NFDigits = 3;
    static boolean haveSetFormat = false;

    @Override
    public boolean isValid() {
        if (this.sys_coord == null || this.app_coord == null || this.error < 0.0f || this.dist_to_nearest_neighbor < 0.0f) {
            return false;
        }
        return !this.keepStatistics || !(this.sys_re50 > this.sys_re95 || this.app_re50 > this.app_re95 || this.running_sys_update_frequency > this.running_app_update_frequency || this.age_difference < 0.0f) && !(this.valid_link_count < 0.0f);
    }

    void checkFormat() {
        if (!haveSetFormat) {
            if (nf.getMaximumFractionDigits() > 3) {
                nf.setMaximumFractionDigits(3);
            }
            if (nf.getMinimumFractionDigits() > 3) {
                nf.setMinimumFractionDigits(3);
            }
            nf.setGroupingUsed(false);
        }
        haveSetFormat = true;
    }

    public String toString() {
        this.checkFormat();
        String basic = new String("sc " + this.sys_coord + " ac " + this.app_coord + " er " + nf.format(this.error) + " nn " + nf.format(this.dist_to_nearest_neighbor));
        if (this.keepStatistics) {
            String complete = new String(" rrl " + nf.format(this.relative_rank_loss) + " narl " + nf.format(this.norm_app_latency_penalty) + " ralp " + nf.format(this.relative_app_latency_penalty) + " age " + nf.format(this.age_difference) + " gr " + nf.format(this.gravity) + " vl " + nf.format(this.valid_link_count) + " sys_re50 " + nf.format(this.sys_re50) + " sys_re95 " + nf.format(this.sys_re95) + " app_re50 " + nf.format(this.app_re50) + " app_re95 " + nf.format(this.app_re95) + " sys_dd " + nf.format(this.sys_dd) + " app_dd " + nf.format(this.app_dd) + " ne " + nf.format(this.neighbors_used_per_update) + " rd " + nf.format(this.running_relative_diff) + " sf " + nf.format(this.running_sys_update_frequency) + " af " + nf.format(this.running_app_update_frequency));
            return new String(basic + complete);
        }
        return basic;
    }

    public V1Statistics(DataInputStream is) {
        try {
            if (1 == is.readByte()) {
                int num_dimensions = is.readInt();
                this.sys_coord = new Coordinate(num_dimensions, is);
                this.app_coord = new Coordinate(num_dimensions, is);
                this.error = is.readFloat();
                this.dist_to_nearest_neighbor = is.readFloat();
                this.keepStatistics = is.readBoolean();
                if (this.keepStatistics) {
                    this.relative_rank_loss = is.readFloat();
                    this.norm_app_latency_penalty = is.readFloat();
                    this.relative_app_latency_penalty = is.readFloat();
                    this.age_difference = is.readFloat();
                    this.valid_link_count = is.readFloat();
                    this.gravity = is.readFloat();
                    this.sys_re50 = is.readFloat();
                    this.sys_re95 = is.readFloat();
                    this.app_re50 = is.readFloat();
                    this.app_re95 = is.readFloat();
                    this.sys_dd = is.readFloat();
                    this.app_dd = is.readFloat();
                    this.neighbors_used_per_update = is.readFloat();
                    this.running_relative_diff = is.readFloat();
                    this.running_sys_update_frequency = is.readFloat();
                    this.running_app_update_frequency = is.readFloat();
                }
            }
        }
        catch (IOException ex) {
            this.error = -1.0f;
        }
    }

    public static void toSerialized(DataOutputStream os, VivaldiClient<?> vc) throws IOException {
        os.writeByte(1);
        os.writeInt(vc.getSystemCoords().getNumDimensions());
        vc.getSystemCoords().toSerialized(os);
        vc.getApplicationCoords().toSerialized(os);
        Hashtable<String, Double> stats = vc.getStatistics();
        os.writeFloat(new Float(stats.get("er")).floatValue());
        os.writeFloat(new Float(stats.get("nn")).floatValue());
        if (VivaldiClient.keepStatistics) {
            os.writeBoolean(true);
            os.writeFloat(new Float(stats.get("rrl")).floatValue());
            os.writeFloat(new Float(stats.get("narl")).floatValue());
            os.writeFloat(new Float(stats.get("ralp")).floatValue());
            os.writeFloat(new Float(stats.get("age")).floatValue());
            os.writeFloat(new Float(stats.get("vl")).floatValue());
            os.writeFloat(new Float(stats.get("gr")).floatValue());
            os.writeFloat(new Float(stats.get("sys_re50")).floatValue());
            os.writeFloat(new Float(stats.get("sys_re95")).floatValue());
            os.writeFloat(new Float(stats.get("app_re50")).floatValue());
            os.writeFloat(new Float(stats.get("app_re95")).floatValue());
            os.writeFloat(new Float(stats.get("sys_dd")).floatValue());
            os.writeFloat(new Float(stats.get("app_dd")).floatValue());
            os.writeFloat(new Float(stats.get("ne")).floatValue());
            os.writeFloat(new Float(stats.get("rd")).floatValue());
            os.writeFloat(new Float(stats.get("sf")).floatValue());
            os.writeFloat(new Float(stats.get("af")).floatValue());
        } else {
            os.writeBoolean(false);
        }
    }

    @Override
    public byte getSerializedVersion() {
        return 1;
    }

    public long getDBValuesStored() {
        return 0L;
    }

    public long getDBKeysBlocked() {
        return 0L;
    }

    public long getRouterNodes() {
        return 0L;
    }

    public long getRouterLeaves() {
        return 0L;
    }

    public long getRouterContacts() {
        return 0L;
    }

    public long getRouterUptime() {
        return 0L;
    }

    public int getRouterCount() {
        return 0;
    }

    public long getTotalBytesReceived() {
        return 0L;
    }

    public long getTotalBytesSent() {
        return 0L;
    }

    public long getTotalPacketsReceived() {
        return 0L;
    }

    public long getTotalPacketsSent() {
        return 0L;
    }

    public long getTotalPingsReceived() {
        return 0L;
    }

    public long getTotalFindNodesReceived() {
        return 0L;
    }

    public long getTotalFindValuesReceived() {
        return 0L;
    }

    public long getTotalStoresReceived() {
        return 0L;
    }

    public long getTotalKeyBlocksReceived() {
        return 0L;
    }

    public long getIncomingRequests() {
        return 0L;
    }

    public long getAverageBytesReceived() {
        return 0L;
    }

    public long getAverageBytesSent() {
        return 0L;
    }

    public long getAveragePacketsReceived() {
        return 0L;
    }

    public long getAveragePacketsSent() {
        return 0L;
    }

    public String getVersion() {
        return new String("");
    }

    public String getString() {
        return new String("foo");
    }
}

