/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.magneturi.impl;

import com.aelitis.azureus.core.util.png.PNG;
import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.net.magneturi.MagnetURIHandlerListener;
import com.aelitis.net.magneturi.MagnetURIHandlerProgressListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;

public class MagnetURIHandlerImpl
extends MagnetURIHandler {
    private static final LogIDs LOGID = LogIDs.NET;
    private static MagnetURIHandlerImpl singleton;
    private static AEMonitor class_mon;
    private static final int DOWNLOAD_TIMEOUT = 180000;
    protected static final String NL = "\r\n";
    private static final boolean DEBUG = false;
    private int port;
    private List listeners = new ArrayList();
    private Map info_map = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MagnetURIHandler getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new MagnetURIHandlerImpl();
            }
            MagnetURIHandlerImpl magnetURIHandlerImpl = singleton;
            return magnetURIHandlerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected MagnetURIHandlerImpl() {
        ServerSocket socket = null;
        for (int i = 45100; i <= 45199; ++i) {
            try {
                socket = new ServerSocket(i, 50, InetAddress.getByName("127.0.0.1"));
                this.port = i;
                break;
            }
            catch (Throwable e) {
                continue;
            }
        }
        if (socket == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 3, "MagnetURI: no free sockets, giving up"));
            }
        } else {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "MagnetURI: bound on " + socket.getLocalPort()));
            }
            final ServerSocket f_socket = socket;
            AEThread t = new AEThread("MagnetURIHandler"){

                public void runSupport() {
                    int errors = 0;
                    int ok = 0;
                    while (true) {
                        try {
                            while (true) {
                                final Socket sck = f_socket.accept();
                                ++ok;
                                errors = 0;
                                AEThread t = new AEThread("MagnetURIHandler:processor"){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void runSupport() {
                                        boolean close_socket = true;
                                        try {
                                            String address = sck.getInetAddress().getHostAddress();
                                            if (address.equals("localhost") || address.equals("127.0.0.1")) {
                                                BufferedReader br = new BufferedReader(new InputStreamReader(sck.getInputStream(), "UTF8"));
                                                String line = br.readLine();
                                                if (line != null) {
                                                    if (line.toUpperCase().startsWith("GET ")) {
                                                        Logger.log(new LogEvent(LOGID, "MagnetURIHandler: processing '" + line + "'"));
                                                        line = line.substring(4);
                                                        int pos = line.lastIndexOf(32);
                                                        line = line.substring(0, pos);
                                                        close_socket = MagnetURIHandlerImpl.this.process(line, br, sck.getOutputStream());
                                                    } else {
                                                        Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: invalid command - '" + line + "'"));
                                                    }
                                                } else {
                                                    Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: connect from '" + address + "': no data read"));
                                                }
                                            } else {
                                                Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: connect from invalid address '" + address + "'"));
                                            }
                                        }
                                        catch (Throwable e) {
                                            if (!(e instanceof IOException) && !(e instanceof SocketException)) {
                                                Debug.printStackTrace(e);
                                            }
                                        }
                                        finally {
                                            try {
                                                if (close_socket) {
                                                    sck.close();
                                                }
                                            }
                                            catch (Throwable e) {}
                                        }
                                    }
                                };
                                t.setDaemon(true);
                                t.start();
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            if (++errors <= 100 || !Logger.isEnabled()) continue;
                            Logger.log(new LogEvent(LOGID, "MagnetURIHandler: bailing out, too many socket errors"));
                            continue;
                        }
                        break;
                    }
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    protected boolean process(String get, BufferedReader is, OutputStream os) throws IOException {
        String urn;
        HashMap<String, String> original_params = new HashMap<String, String>();
        HashMap<String, String> lc_params = new HashMap<String, String>();
        ArrayList<String> source_params = new ArrayList<String>();
        int pos = get.indexOf(63);
        if (pos != -1) {
            StringTokenizer tok = new StringTokenizer(get.substring(pos + 1), "&");
            while (tok.hasMoreTokens()) {
                String lhs;
                String arg = tok.nextToken();
                pos = arg.indexOf(61);
                if (pos == -1) {
                    lhs = arg.trim();
                    original_params.put(lhs, "");
                    lc_params.put(lhs.toLowerCase(MessageText.LOCALE_ENGLISH), "");
                    continue;
                }
                try {
                    lhs = arg.substring(0, pos).trim();
                    String lc_lhs = lhs.toLowerCase(MessageText.LOCALE_ENGLISH);
                    String rhs = URLDecoder.decode(arg.substring(pos + 1).trim(), "UTF8");
                    original_params.put(lhs, rhs);
                    lc_params.put(lc_lhs, rhs);
                    if (!lc_lhs.equals("xsource")) continue;
                    source_params.add(rhs);
                }
                catch (UnsupportedEncodingException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (get.startsWith("/magnet10/badge.img")) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                byte[] data = ((MagnetURIHandlerListener)this.listeners.get(i)).badge();
                if (data == null) continue;
                this.writeReply(os, "image/gif", data);
                return true;
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/magnet10/canHandle.img?")) {
            urn = (String)lc_params.get("xt");
            if (urn != null && urn.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:btih:")) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    byte[] data = ((MagnetURIHandlerListener)this.listeners.get(i)).badge();
                    if (data == null) continue;
                    this.writeReply(os, "image/gif", data);
                    return true;
                }
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/azversion")) {
            this.writeReply(os, "text/plain", "4.2.0.8");
            return true;
        }
        if (get.startsWith("/magnet10/options.js?") || get.startsWith("/magnet10/default.js?")) {
            String resp = "";
            resp = resp + this.getJS("magnetOptionsPreamble");
            resp = resp + this.getJSS("<a href=\\\"http://127.0.0.1:\"+(45100+magnetCurrentSlot)+\"/select/?\"+magnetQueryString+\"\\\" target=\\\"_blank\\\">");
            resp = resp + this.getJSS("<img src=\\\"http://127.0.0.1:\"+(45100+magnetCurrentSlot)+\"/magnet10/badge.img\\\">");
            resp = resp + this.getJSS("Download with Azureus");
            resp = resp + this.getJSS("</a>");
            resp = resp + this.getJS("magnetOptionsPostamble");
            resp = resp + "magnetOptionsPollSuccesses++";
            this.writeReply(os, "application/x-javascript", resp);
            return true;
        }
        if (get.startsWith("/magnet10/pause")) {
            try {
                Thread.sleep(250L);
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/select/")) {
            String fail_reason = "";
            boolean ok = false;
            String urn2 = (String)lc_params.get("xt");
            if (urn2 == null) {
                fail_reason = "xt missing";
            } else {
                String lc_urn = urn2.toLowerCase(MessageText.LOCALE_ENGLISH);
                try {
                    URL url = lc_urn.startsWith("http:") || lc_urn.startsWith("https:") ? new URL(urn2) : new URL("magnet:?xt=" + urn2);
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        if (!((MagnetURIHandlerListener)this.listeners.get(i)).download(url)) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        fail_reason = "No listeners accepted the operation";
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    fail_reason = Debug.getNestedExceptionMessage(e);
                }
            }
            if (ok) {
                if ("image".equalsIgnoreCase((String)lc_params.get("result"))) {
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        byte[] data = ((MagnetURIHandlerListener)this.listeners.get(i)).badge();
                        if (data == null) continue;
                        this.writeReply(os, "image/gif", data);
                        return true;
                    }
                }
                this.writeReply(os, "text/plain", "Download initiated");
            } else {
                this.writeReply(os, "text/plain", "Download initiation failed: " + fail_reason);
            }
        } else {
            String name;
            if (get.startsWith("/download/")) {
                urn = (String)lc_params.get("xt");
                if (urn == null || !urn.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:sha1:") && !urn.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:btih:")) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: invalid command - '" + get + "'"));
                    }
                    return true;
                }
                final PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
                try {
                    pw.print("HTTP/1.0 200 OK\r\n");
                    pw.flush();
                    String base_32 = urn.substring(9);
                    ArrayList<InetSocketAddress> sources = new ArrayList<InetSocketAddress>();
                    for (int i = 0; i < source_params.size(); ++i) {
                        String source = (String)source_params.get(i);
                        int p = source.indexOf(58);
                        if (p == -1) continue;
                        try {
                            InetSocketAddress sa = new InetSocketAddress(source.substring(0, p), Integer.parseInt(source.substring(p + 1)));
                            sources.add(sa);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    InetSocketAddress[] s = new InetSocketAddress[sources.size()];
                    sources.toArray(s);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "MagnetURIHandler: download of '" + base_32 + "' starts (initial sources=" + s.length + ")"));
                    }
                    byte[] sha1 = Base32.decode(base_32);
                    byte[] data = null;
                    for (int i = 0; i < this.listeners.size() && (data = ((MagnetURIHandlerListener)this.listeners.get(i)).download(new MagnetURIHandlerProgressListener(){

                        public void reportSize(long size) {
                            pw.print("X-Report: " + MagnetURIHandlerImpl.this.getMessageText("torrent_size", String.valueOf(size)) + MagnetURIHandlerImpl.NL);
                            pw.flush();
                        }

                        public void reportActivity(String str) {
                            pw.print("X-Report: " + str + MagnetURIHandlerImpl.NL);
                            pw.flush();
                        }

                        public void reportCompleteness(int percent) {
                            pw.print("X-Report: " + MagnetURIHandlerImpl.this.getMessageText("percent", String.valueOf(percent)) + MagnetURIHandlerImpl.NL);
                            pw.flush();
                        }
                    }, sha1, s, 180000L)) == null; ++i) {
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "MagnetURIHandler: download of '" + base_32 + "' completes, data " + (data == null ? "not found" : "found, length = " + data.length)));
                    }
                    if (data == null) {
                        pw.print("X-Report: error: " + this.getMessageText("no_sources") + NL);
                        pw.flush();
                        return !lc_params.containsKey("pause_on_error");
                    }
                    pw.print("Content-Length: " + data.length + NL + NL);
                    pw.flush();
                    os.write(data);
                    os.flush();
                }
                catch (Throwable e) {
                    pw.print("X-Report: error: " + this.getMessageText("error", Debug.getNestedExceptionMessage(e)) + NL);
                    pw.flush();
                    return !lc_params.containsKey("pause_on_error");
                }
            }
            if (get.startsWith("/getinfo?")) {
                name = (String)lc_params.get("name");
                if (name != null) {
                    Integer info = (Integer)this.info_map.get(name);
                    int value = Integer.MIN_VALUE;
                    if (info != null) {
                        value = info;
                    } else {
                        for (int i = 0; i < this.listeners.size() && value == Integer.MIN_VALUE; ++i) {
                            HashMap<String, String> paramsCopy = new HashMap<String, String>();
                            paramsCopy.putAll(original_params);
                            value = ((MagnetURIHandlerListener)this.listeners.get(i)).get(name, paramsCopy);
                        }
                    }
                    if (value == Integer.MIN_VALUE) {
                        String def_str = (String)lc_params.get("default");
                        if (def_str != null) {
                            try {
                                value = Integer.parseInt(def_str);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    } else {
                        String max_str = (String)lc_params.get("max");
                        if (max_str != null) {
                            try {
                                int max = Integer.parseInt(max_str);
                                if (value > max) {
                                    value = max;
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                    if (value != Integer.MIN_VALUE) {
                        if (value < 0) {
                            value = 0;
                        }
                        if (value > 0x100000) {
                            value = 0x100000;
                        }
                        int width = value;
                        int height = 1;
                        String div_mod = (String)lc_params.get("divmod");
                        if (div_mod != null) {
                            int n = Integer.parseInt(div_mod);
                            width = value / n + 1;
                            height = value % n + 1;
                        } else {
                            String div = (String)lc_params.get("div");
                            if (div != null) {
                                width = value / Integer.parseInt(div);
                            } else {
                                String mod = (String)lc_params.get("mod");
                                if (mod != null) {
                                    width = value % Integer.parseInt(mod);
                                }
                            }
                        }
                        String img_type = (String)lc_params.get("img_type");
                        if (img_type != null && img_type.equals("png")) {
                            byte[] data = PNG.getPNGBytesForSize(width, height);
                            this.writeReply(os, "image/png", data);
                        } else {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            this.writeImage(baos, width, height);
                            byte[] data = baos.toByteArray();
                            this.writeReply(os, "image/bmp", data);
                        }
                        return true;
                    }
                }
                this.writeNotFound(os);
                return true;
            }
            if (get.startsWith("/setinfo?")) {
                name = (String)lc_params.get("name");
                if (name != null) {
                    boolean result = false;
                    for (int i = 0; i < this.listeners.size() && !result; ++i) {
                        HashMap<String, String> paramsCopy = new HashMap<String, String>();
                        paramsCopy.putAll(original_params);
                        result = ((MagnetURIHandlerListener)this.listeners.get(i)).set(name, paramsCopy);
                    }
                    int width = result ? 20 : 10;
                    int height = result ? 20 : 10;
                    String img_type = (String)lc_params.get("img_type");
                    if (img_type != null && img_type.equals("png")) {
                        byte[] data = PNG.getPNGBytesForSize(width, height);
                        this.writeReply(os, "image/png", data);
                    } else {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        this.writeImage(baos, width, height);
                        byte[] data = baos.toByteArray();
                        this.writeReply(os, "image/bmp", data);
                    }
                    return true;
                }
            } else if (get.equals("/browserheaders.js")) {
                String header;
                String headers_str = "";
                while ((header = is.readLine()) != null && (header = header.trim()).length() != 0) {
                    headers_str = headers_str + (headers_str.length() == 0 ? "" : "\n") + header;
                }
                String script = "var headers = \"" + new String(Base64.encode(headers_str.getBytes("UTF-8"))) + "\";";
                this.writeReply(os, "application/x-javascript", script);
            }
        }
        return true;
    }

    private void writeImage(OutputStream os, int width, int height) {
        int rowWidth = width / 8;
        if (rowWidth % 4 != 0) {
            rowWidth = (rowWidth / 4 + 1) * 4;
        }
        int imageSize = rowWidth * height;
        int fileSize = 54 + imageSize;
        try {
            os.write(new byte[]{66, 77});
            this.write4Bytes(os, fileSize);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, 54L);
            this.write4Bytes(os, 40L);
            this.write4Bytes(os, width);
            this.write4Bytes(os, height);
            this.write4Bytes(os, 65537L);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, imageSize);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, 0L);
            byte[] data = new byte[imageSize];
            os.write(data);
        }
        catch (IOException e) {
            Debug.out(e);
        }
    }

    private void write4Bytes(OutputStream os, long l) {
        try {
            os.write((int)(l & 0xFFL));
            os.write((int)(l >> 8 & 0xFFL));
            os.write((int)(l >> 16 & 0xFFL));
            os.write((int)(l >> 24 & 0xFFL));
        }
        catch (IOException e) {
            Debug.out(e);
        }
    }

    protected String getMessageText(String resource) {
        return MessageText.getString("MagnetURLHandler.report." + resource);
    }

    protected String getMessageText(String resource, String param) {
        return MessageText.getString("MagnetURLHandler.report." + resource, new String[]{param});
    }

    protected String getJS(String s) {
        return "document.write(" + s + ");" + NL;
    }

    protected String getJSS(String s) {
        return "document.write(\"" + s + "\");" + NL;
    }

    protected void writeReply(OutputStream os, String content_type, String content) throws IOException {
        this.writeReply(os, content_type, content.getBytes());
    }

    protected void writeReply(OutputStream os, String content_type, byte[] content) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.1 200 OK\r\n");
        pw.print("Cache-Control: no-cache\r\n");
        pw.print("Pragma: no-cache\r\n");
        pw.print("Content-Type: " + content_type + NL);
        pw.print("Content-Length: " + content.length + NL + NL);
        pw.flush();
        os.write(content);
    }

    protected void writeNotFound(OutputStream os) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.0 404 Not Found\r\n\r\n");
        pw.flush();
    }

    public int getPort() {
        return this.port;
    }

    public void addInfo(String name, int info) {
        this.info_map.put(name, new Integer(info));
        Logger.log(new LogEvent(LOGID, 0, "MagnetURIHandler: global info registered: " + name + " -> " + info));
    }

    public void addListener(MagnetURIHandlerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(MagnetURIHandlerListener l) {
        this.listeners.remove(l);
    }

    public static void main(String[] args) {
        new MagnetURIHandlerImpl();
        try {
            Thread.sleep(1000000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        class_mon = new AEMonitor("MagnetURLHandler:class");
    }
}

