/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.syrah.nc;

import edu.harvard.syrah.nc.Coordinate;
import edu.harvard.syrah.nc.VivaldiClient;

public class Vec {
    protected static final int CLASS_HASH = Vec.class.hashCode();
    protected final double[] direction;
    protected final int num_dims;

    public static Vec scale(Vec lhs, double k) {
        Vec scaled = new Vec(lhs);
        scaled.scale(k);
        return scaled;
    }

    public static Vec makeRandom(int num_dims, double axisLength) {
        Vec v = new Vec(num_dims);
        for (int i = 0; i < num_dims; ++i) {
            double length = VivaldiClient.random.nextDouble() * axisLength;
            if ((!VivaldiClient.USE_HEIGHT || i < num_dims - 1) && VivaldiClient.random.nextBoolean()) {
                length *= -1.0;
            }
            v.direction[i] = length;
        }
        return v;
    }

    public Vec(int _num_dims) {
        this.direction = new double[_num_dims];
        if (VivaldiClient.USE_HEIGHT) {
            --_num_dims;
        }
        this.num_dims = _num_dims;
    }

    public Vec(Vec v) {
        this(v.direction, true);
    }

    public Vec(double[] init_dir, boolean make_copy) {
        if (make_copy) {
            int num_dims = init_dir.length;
            this.direction = new double[num_dims];
            System.arraycopy(init_dir, 0, this.direction, 0, num_dims);
        } else {
            this.direction = init_dir;
        }
        int _num_dims = init_dir.length;
        if (VivaldiClient.USE_HEIGHT) {
            --_num_dims;
        }
        this.num_dims = _num_dims;
    }

    public int getNumDimensions() {
        return this.direction.length;
    }

    public double[] getComponents() {
        double[] dir_copy = new double[this.direction.length];
        System.arraycopy(this.direction, 0, dir_copy, 0, this.direction.length);
        return dir_copy;
    }

    public void add(Vec v) {
        for (int i = 0; i < this.direction.length; ++i) {
            int n = i;
            this.direction[n] = this.direction[n] + v.direction[i];
        }
    }

    public void subtract(Vec v) {
        for (int i = 0; i < this.direction.length; ++i) {
            int n = i;
            this.direction[n] = this.direction[n] - v.direction[i];
        }
    }

    public void scale(double k) {
        int i = 0;
        while (i < this.direction.length) {
            int n = i++;
            this.direction[n] = this.direction[n] * k;
        }
    }

    public boolean isUnit() {
        return this.getLength() == 1.0;
    }

    public double getLength() {
        double sum = this.getPlanarLength();
        if (VivaldiClient.USE_HEIGHT) {
            sum += this.direction[this.direction.length - 1];
        }
        return sum;
    }

    double getPlanarLength() {
        double sum = 0.0;
        for (int i = 0; i < this.num_dims; ++i) {
            sum += this.direction[i] * this.direction[i];
        }
        return Math.sqrt(sum);
    }

    public void makeUnit() {
        double length = this.getLength();
        if (length != 1.0) {
            this.scale(1.0 / length);
        }
    }

    public Coordinate asCoordinateFromZero(boolean make_copy) {
        return new Coordinate(this.direction, make_copy);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vec) {
            Vec v = (Vec)obj;
            int num_dims = this.direction.length;
            for (int i = 0; i < num_dims; ++i) {
                if (this.direction[i] == v.direction[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int num_dims = this.direction.length;
        int hc = CLASS_HASH;
        for (int i = 0; i < num_dims; ++i) {
            hc ^= new Double(this.direction[i]).hashCode();
        }
        return hc;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(1024);
        sbuf.append("[");
        int num_dims = this.direction.length;
        int i = 0;
        while (true) {
            if (i == num_dims - 1 && VivaldiClient.USE_HEIGHT) {
                sbuf.append('h');
            }
            sbuf.append(VivaldiClient.nf.format(this.direction[i]));
            if (++i >= num_dims) break;
            sbuf.append(",");
        }
        sbuf.append("]");
        return sbuf.toString();
    }
}

