/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectParser;
import org.bouncycastle.asn1.BERNull;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;

public class ASN1StreamParser {
    InputStream _in;
    private int _limit;
    private boolean _eofFound;

    public ASN1StreamParser(InputStream in) {
        this(in, Integer.MAX_VALUE);
    }

    public ASN1StreamParser(InputStream in, int limit) {
        this._in = in;
        this._limit = limit;
    }

    public ASN1StreamParser(byte[] encoding) {
        this(new ByteArrayInputStream(encoding), encoding.length);
    }

    InputStream getParentStream() {
        return this._in;
    }

    private int readLength() throws IOException {
        int length = this._in.read();
        if (length < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            length = 0;
            for (int i = 0; i < size; ++i) {
                int next = this._in.read();
                if (next < 0) {
                    throw new EOFException("EOF found reading length");
                }
                length = (length << 8) + next;
            }
            if (length < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (length >= this._limit) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return length;
    }

    public DEREncodable readObject() throws IOException {
        int length;
        int baseTagNo;
        int tag = this._in.read();
        if (tag == -1) {
            if (this._eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this._eofFound = true;
            return null;
        }
        this.set00Check(false);
        int tagNo = baseTagNo = tag & 0xFFFFFFDF;
        if ((tag & 0x80) != 0 && (tagNo = tag & 0x1F) == 31) {
            tagNo = 0;
            int b = this._in.read();
            while (b >= 0 && (b & 0x80) != 0) {
                tagNo |= b & 0x7F;
                tagNo <<= 7;
                b = this._in.read();
            }
            if (b < 0) {
                this._eofFound = true;
                throw new EOFException("EOF encountered inside tag value.");
            }
            tagNo |= b & 0x7F;
        }
        if ((length = this.readLength()) < 0) {
            IndefiniteLengthInputStream indIn = new IndefiniteLengthInputStream(this._in);
            switch (baseTagNo) {
                case 5: {
                    while (indIn.read() >= 0) {
                    }
                    return BERNull.INSTANCE;
                }
                case 4: {
                    return new BEROctetStringParser(new ASN1ObjectParser(tag, tagNo, indIn));
                }
                case 16: {
                    return new BERSequenceParser(new ASN1ObjectParser(tag, tagNo, indIn));
                }
                case 17: {
                    return new BERSetParser(new ASN1ObjectParser(tag, tagNo, indIn));
                }
            }
            return new BERTaggedObjectParser(tag, tagNo, indIn);
        }
        DefiniteLengthInputStream defIn = new DefiniteLengthInputStream(this._in, length);
        switch (baseTagNo) {
            case 2: {
                return new DERInteger(defIn.toByteArray());
            }
            case 5: {
                defIn.toByteArray();
                return DERNull.INSTANCE;
            }
            case 6: {
                return new DERObjectIdentifier(defIn.toByteArray());
            }
            case 4: {
                return new DEROctetString(defIn.toByteArray());
            }
            case 16: {
                return new DERSequence(this.loadVector(defIn, length)).parser();
            }
            case 17: {
                return new DERSet(this.loadVector(defIn, length)).parser();
            }
        }
        return new BERTaggedObjectParser(tag, tagNo, defIn);
    }

    private void set00Check(boolean enabled) {
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(enabled);
        }
    }

    private ASN1EncodableVector loadVector(InputStream in, int length) throws IOException {
        DERObject obj;
        ASN1InputStream aIn = new ASN1InputStream(in, length);
        ASN1EncodableVector v = new ASN1EncodableVector();
        while ((obj = aIn.readObject()) != null) {
            v.add(obj);
        }
        return v;
    }
}

