/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.cl;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerFactory;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;

public class Main {
    public static void main(String[] args) {
        if (!Main.parseParameters(args)) {
            Main.usage();
        }
        String torrentFile = args[args.length - 2];
        String path = args[args.length - 1];
        DownloadManager manager = DownloadManagerFactory.create(null, null, torrentFile, path, null, 0, false, false, null, null);
        manager.initialize();
        while (true) {
            StringBuffer buf = new StringBuffer();
            int state = manager.getState();
            switch (state) {
                case 0: {
                    buf.append("Waiting");
                    break;
                }
                case 20: {
                    buf.append("Allocating");
                    break;
                }
                case 30: {
                    buf.append("Checking");
                    break;
                }
                case 40: {
                    buf.append("Ready");
                    manager.startDownload();
                    break;
                }
                case 50: {
                    buf.append("Downloading");
                    break;
                }
                case 60: {
                    buf.append("Seeding");
                    break;
                }
                case 70: {
                    buf.append("Stopped");
                    break;
                }
                case 100: {
                    buf.append("Error : " + manager.getErrorDetails());
                }
            }
            buf.append(" C:");
            DownloadManagerStats stats = manager.getStats();
            int completed = stats.getCompleted();
            buf.append(completed / 10);
            buf.append('.');
            buf.append(completed % 10);
            buf.append('%');
            buf.append(" S:");
            buf.append(manager.getNbSeeds());
            buf.append(" P:");
            buf.append(manager.getNbPeers());
            buf.append(" D:");
            buf.append(DisplayFormatters.formatDownloaded(stats));
            buf.append(" U:");
            buf.append(DisplayFormatters.formatByteCountToKiBEtc(stats.getTotalDataBytesSent()));
            buf.append(" DS:");
            buf.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(stats.getDataReceiveRate()));
            buf.append(" US:");
            buf.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(stats.getDataSendRate()));
            buf.append(" T:");
            buf.append(manager.getTrackerStatus());
            while (buf.length() < 80) {
                buf.append(' ');
            }
            System.out.print("\r".concat(buf.toString()));
            if (state == 100) {
                return;
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
            }
        }
    }

    private static boolean parseParameters(String[] args) {
        if (args.length < 2) {
            return false;
        }
        if (args.length == 2) {
            return true;
        }
        if (args.length % 2 != 0) {
            return false;
        }
        try {
            for (int i = 0; i < args.length - 2; i += 2) {
                String param = args[i];
                String value = args[i + 1];
                if (param.equals("--maxUploads")) {
                    COConfigurationManager.setParameter("Max Uploads", Integer.parseInt(value));
                    continue;
                }
                if (param.equals("--maxSpeed")) {
                    COConfigurationManager.setParameter("Max Upload Speed KBs", Integer.parseInt(value));
                    continue;
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void usage() {
        System.out.println("Usage : java org.gudy.azureus2.cl.Main [parameters] \"file.torrent\" \"save path\"");
        System.out.println("--maxUploads :\t\t Max number of simultaneous uploads");
        System.out.println("--maxSpeed :\t\t Max upload speed in KBytes/sec");
        SESecurityManager.exitVM(0);
    }
}

