/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.category.impl;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryListener;
import org.gudy.azureus2.core3.category.impl.CategoryManagerImpl;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;

public class CategoryImpl
implements Category,
Comparable {
    private String sName;
    private int type;
    private List managers = new ArrayList();
    private int upload_speed;
    private int download_speed;
    private LimitedRateGroup upload_limiter = new LimitedRateGroup(){

        public String getName() {
            return "cat_up: " + CategoryImpl.this.sName;
        }

        public int getRateLimitBytesPerSecond() {
            return CategoryImpl.this.upload_speed;
        }
    };
    private LimitedRateGroup download_limiter = new LimitedRateGroup(){

        public String getName() {
            return "cat_down: " + CategoryImpl.this.sName;
        }

        public int getRateLimitBytesPerSecond() {
            return CategoryImpl.this.download_speed;
        }
    };
    private static final int LDT_CATEGORY_DMADDED = 1;
    private static final int LDT_CATEGORY_DMREMOVED = 2;
    private ListenerManager category_listeners = ListenerManager.createManager("CatListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            CategoryListener target = (CategoryListener)_listener;
            if (type == 1) {
                target.downloadManagerAdded(CategoryImpl.this, (DownloadManager)value);
            } else if (type == 2) {
                target.downloadManagerRemoved(CategoryImpl.this, (DownloadManager)value);
            }
        }
    });

    public CategoryImpl(String sName, int maxup, int maxdown) {
        this.sName = sName;
        this.type = 0;
        this.upload_speed = maxup;
        this.download_speed = maxdown;
    }

    public CategoryImpl(String sName, int type) {
        this.sName = sName;
        this.type = type;
    }

    public void addCategoryListener(CategoryListener l) {
        this.category_listeners.addListener(l);
    }

    public void removeCategoryListener(CategoryListener l) {
        this.category_listeners.removeListener(l);
    }

    public String getName() {
        return this.sName;
    }

    public int getType() {
        return this.type;
    }

    public List getDownloadManagers(List all_dms) {
        if (this.type == 0) {
            return this.managers;
        }
        if (this.type == 1) {
            return all_dms;
        }
        ArrayList<DownloadManager> result = new ArrayList<DownloadManager>();
        for (int i = 0; i < all_dms.size(); ++i) {
            DownloadManager dm = (DownloadManager)all_dms.get(i);
            Category cat = dm.getDownloadState().getCategory();
            if (cat != null && cat.getType() != 2) continue;
            result.add(dm);
        }
        return result;
    }

    public void addManager(DownloadManagerState manager_state) {
        if (manager_state.getCategory() != this) {
            manager_state.setCategory(this);
            return;
        }
        DownloadManager manager = manager_state.getDownloadManager();
        if (manager == null) {
            return;
        }
        if (!this.managers.contains(manager)) {
            this.managers.add(manager);
            manager.addRateLimiter(this.upload_limiter, true);
            manager.addRateLimiter(this.download_limiter, false);
            this.category_listeners.dispatch(1, manager);
        }
    }

    public void removeManager(DownloadManagerState manager_state) {
        if (manager_state.getCategory() == this) {
            manager_state.setCategory(null);
            return;
        }
        DownloadManager manager = manager_state.getDownloadManager();
        if (manager == null) {
            return;
        }
        if (this.managers.contains(manager) || this.type != 0) {
            this.managers.remove(manager);
            manager.removeRateLimiter(this.upload_limiter, true);
            manager.removeRateLimiter(this.download_limiter, false);
            this.category_listeners.dispatch(2, manager);
        }
    }

    public void setDownloadSpeed(int speed) {
        if (this.download_speed != speed) {
            this.download_speed = speed;
            CategoryManagerImpl.getInstance().saveCategories();
        }
    }

    public int getDownloadSpeed() {
        return this.download_speed;
    }

    public void setUploadSpeed(int speed) {
        if (this.upload_speed != speed) {
            this.upload_speed = speed;
            CategoryManagerImpl.getInstance().saveCategories();
        }
    }

    public int getUploadSpeed() {
        return this.upload_speed;
    }

    public int compareTo(Object b) {
        boolean bTypeIsUser;
        boolean aTypeIsUser = this.type == 0;
        boolean bl = bTypeIsUser = ((Category)b).getType() == 0;
        if (aTypeIsUser == bTypeIsUser) {
            return this.sName.compareToIgnoreCase(((Category)b).getName());
        }
        if (aTypeIsUser) {
            return 1;
        }
        return -1;
    }
}

