/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import java.util.Arrays;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.util.Debug;

public class DiskManagerFileInfoSetImpl
implements DiskManagerFileInfoSet {
    final DiskManagerFileInfoImpl[] files;
    final DiskManagerHelper diskManager;

    public DiskManagerFileInfoSetImpl(DiskManagerFileInfoImpl[] files, DiskManagerHelper dm) {
        this.files = files;
        this.diskManager = dm;
    }

    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    public int nbFiles() {
        return this.files.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(boolean[] toChange, boolean setPriority) {
        if (toChange.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        DownloadManagerState dmState = this.diskManager.getDownloadState();
        try {
            dmState.suppressStateSave(true);
            for (int i = 0; i < this.files.length; ++i) {
                if (!toChange[i]) continue;
                this.files[i].setPriority(setPriority);
            }
        }
        finally {
            dmState.suppressStateSave(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkipped(boolean[] toChange, boolean setSkipped) {
        if (toChange.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        DownloadManagerState dmState = this.diskManager.getDownloadState();
        try {
            dmState.suppressStateSave(true);
            if (!setSkipped && !Arrays.equals(toChange, this.setStorageTypes(toChange, 1))) {
                return;
            }
            for (int i = 0; i < this.files.length; ++i) {
                if (!toChange[i]) continue;
                this.files[i].skipped = setSkipped;
                this.diskManager.skippedFileSetChanged(this.files[i]);
            }
            if (!setSkipped) {
                DiskManagerUtil.doFileExistenceChecks(this, toChange, this.diskManager.getDownloadState().getDownloadManager(), true);
            }
        }
        finally {
            dmState.suppressStateSave(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] setStorageTypes(boolean[] toChange, int newStroageType) {
        if (toChange.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        if (this.files.length == 0) {
            return new boolean[0];
        }
        String[] types = this.diskManager.getStorageTypes();
        boolean[] modified = new boolean[this.files.length];
        DownloadManagerState dm_state = this.diskManager.getDownloadState();
        if (newStroageType == 2) {
            Debug.out("Download must be stopped for linear -> compact conversion");
            return modified;
        }
        try {
            dm_state.suppressStateSave(true);
            for (int i = 0; i < this.files.length; ++i) {
                int old_type;
                if (!toChange[i]) continue;
                int n = old_type = types[i].equals("L") ? 1 : 2;
                if (newStroageType == old_type) {
                    modified[i] = true;
                    continue;
                }
                DiskManagerFileInfoImpl file = this.files[i];
                try {
                    file.getCacheFile().setStorageType(newStroageType == 1 ? 1 : 2);
                    modified[i] = true;
                    types[i] = file.getCacheFile().getStorageType() == 1 ? "L" : "C";
                }
                catch (Throwable e) {
                    try {
                        Debug.printStackTrace(e);
                        this.diskManager.setFailed(file, "Failed to change storage type for '" + file.getFile(true) + "': " + Debug.getNestedExceptionMessage(e));
                        types[i] = file.getCacheFile().getStorageType() == 1 ? "L" : "C";
                    }
                    catch (Throwable throwable) {
                        types[i] = file.getCacheFile().getStorageType() == 1 ? "L" : "C";
                        throw throwable;
                    }
                    break;
                }
                continue;
            }
            dm_state.setListAttribute("storetypes", types);
            DiskManagerUtil.doFileExistenceChecks(this, toChange, dm_state.getDownloadManager(), true);
        }
        finally {
            dm_state.suppressStateSave(false);
            dm_state.save();
        }
        return modified;
    }
}

