/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.util.CaseSensitiveFileMap;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerActivationListener;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPieceListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.DownloadManagerTrackerListener;
import org.gudy.azureus2.core3.download.ForceRecheckListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerController;
import org.gudy.azureus2.core3.download.impl.DownloadManagerDefaultPaths;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandler;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStateImpl;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStatsImpl;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;

public class DownloadManagerImpl
extends LogRelation
implements DownloadManager {
    private static final long SCRAPE_DELAY_ERROR_TORRENTS = 0x6DDD00L;
    private static final long SCRAPE_DELAY_STOPPED_TORRENTS = 3600000L;
    private static final long SCRAPE_INITDELAY_ERROR_TORRENTS = 600000L;
    private static final long SCRAPE_INITDELAY_STOPPED_TORRENTS = 180000L;
    private static int upload_when_busy_min_secs;
    private static final String CFG_MOVE_COMPLETED_TOP = "Newly Seeding Torrents Get First Priority";
    private static final int LDT_STATECHANGED = 1;
    private static final int LDT_DOWNLOADCOMPLETE = 2;
    private static final int LDT_COMPLETIONCHANGED = 3;
    private static final int LDT_POSITIONCHANGED = 4;
    private static final int LDT_FILEPRIORITYCHANGED = 5;
    private AEMonitor listeners_mon = new AEMonitor("DM:DownloadManager:L");
    private static ListenerManager listeners_aggregator;
    private ListenerManager listeners = ListenerManager.createManager("DM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object listener, int type, Object value) {
            listeners_aggregator.dispatch(listener, type, value);
        }
    });
    private static final int LDT_TL_ANNOUNCERESULT = 1;
    private static final int LDT_TL_SCRAPERESULT = 2;
    private ListenerManager tracker_listeners = ListenerManager.createManager("DM:TrackerListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            DownloadManagerTrackerListener listener = (DownloadManagerTrackerListener)_listener;
            if (type == 1) {
                listener.announceResult((TRTrackerAnnouncerResponse)value);
            } else if (type == 2) {
                listener.scrapeResult((TRTrackerScraperResponse)value);
            }
        }
    });
    private static final int LDT_PE_PEER_ADDED = 1;
    private static final int LDT_PE_PEER_REMOVED = 2;
    private static final int LDT_PE_PM_ADDED = 5;
    private static final int LDT_PE_PM_REMOVED = 6;
    private static ListenerManager peer_listeners_aggregator;
    private ListenerManager peer_listeners = ListenerManager.createManager("DM:PeerListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object listener, int type, Object value) {
            peer_listeners_aggregator.dispatch(listener, type, value);
        }
    });
    private AEMonitor peer_listeners_mon = new AEMonitor("DM:DownloadManager:PeerL");
    private List current_peers = new ArrayList();
    private static final int LDT_PE_PIECE_ADDED = 3;
    private static final int LDT_PE_PIECE_REMOVED = 4;
    private static ListenerManager piece_listeners_aggregator;
    private ListenerManager piece_listeners = ListenerManager.createManager("DM:PieceListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object listener, int type, Object value) {
            piece_listeners_aggregator.dispatch(listener, type, value);
        }
    });
    private AEMonitor piece_listeners_mon = new AEMonitor("DM:DownloadManager:PeiceL");
    private List current_pieces = new ArrayList();
    private DownloadManagerController controller;
    private DownloadManagerStatsImpl stats;
    protected AEMonitor this_mon = new AEMonitor("DM:DownloadManager");
    private boolean persistent;
    private boolean assumedComplete;
    private int last_informed_state = -1;
    private boolean latest_informed_force_start;
    private GlobalManager globalManager;
    private String torrentFileName;
    private boolean open_for_seeding;
    private String display_name = "";
    private String internal_name = "";
    private File torrent_save_location;
    private int position = -1;
    private Object[] read_torrent_state;
    private DownloadManagerState download_manager_state;
    private TOTorrent torrent;
    private String torrent_comment;
    private String torrent_created_by;
    private TRTrackerAnnouncer tracker_client;
    private TRTrackerAnnouncerListener tracker_client_listener = new TRTrackerAnnouncerListener(){

        public void receivedTrackerResponse(TRTrackerAnnouncerResponse response) {
            PEPeerManager pm = DownloadManagerImpl.this.controller.getPeerManager();
            if (pm != null) {
                pm.processTrackerResponse(response);
            }
            DownloadManagerImpl.this.tracker_listeners.dispatch(1, response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void urlChanged(final TRTrackerAnnouncer announcer, final URL old_url, URL new_url, boolean explicit) {
            if (explicit) {
                if (DownloadManagerImpl.this.torrent.getPrivate()) {
                    ArrayList peers;
                    try {
                        DownloadManagerImpl.this.peer_listeners_mon.enter();
                        peers = new ArrayList(DownloadManagerImpl.this.current_peers);
                    }
                    finally {
                        DownloadManagerImpl.this.peer_listeners_mon.exit();
                    }
                    new AEThread("DM:torrentChangeFlusher", true){

                        public void runSupport() {
                            for (int i = 0; i < peers.size(); ++i) {
                                PEPeer peer = (PEPeer)peers.get(i);
                                peer.getManager().removePeer(peer, "Private torrent: tracker changed");
                            }
                            try {
                                TRTrackerAnnouncer an = TRTrackerAnnouncerFactory.create(DownloadManagerImpl.this.torrent, true);
                                an.cloneFrom(announcer);
                                an.setTrackerUrl(old_url);
                                an.stop(false);
                                an.destroy();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }.start();
                }
                DownloadManagerImpl.this.requestTrackerAnnounce(true);
            }
        }

        public void urlRefresh() {
            DownloadManagerImpl.this.requestTrackerAnnounce(true);
        }
    };
    private TRTrackerAnnouncerListener stopping_tracker_client_listener = new TRTrackerAnnouncerListener(){

        public void receivedTrackerResponse(TRTrackerAnnouncerResponse response) {
            if (DownloadManagerImpl.this.tracker_client == null) {
                response.setPeers(new TRTrackerAnnouncerResponsePeer[0]);
            }
            DownloadManagerImpl.this.tracker_listeners.dispatch(1, response);
        }

        public void urlChanged(TRTrackerAnnouncer announcer, URL old_url, URL new_url, boolean explicit) {
        }

        public void urlRefresh() {
        }
    };
    private CopyOnWriteList activation_listeners = new CopyOnWriteList();
    private long scrape_random_seed = SystemTime.getCurrentTime();
    private Map data;
    private boolean data_already_allocated = false;
    private long creation_time = SystemTime.getCurrentTime();
    private int iSeedingRank;
    private boolean az_messaging_enabled = true;
    private boolean dl_identity_obtained;
    private byte[] dl_identity;
    private int dl_identity_hashcode;
    private int max_uploads = 2;
    private int max_connections;
    private int max_connections_when_seeding;
    private boolean max_connections_when_seeding_enabled;
    private int max_seed_connections;
    private int max_uploads_when_seeding = 2;
    private boolean max_uploads_when_seeding_enabled;
    private int max_upload_when_busy_bps;
    private int current_upload_when_busy_bps;
    private long last_upload_when_busy_update;
    private long last_upload_when_busy_dec_time;
    private int crypto_level = 0;
    private volatile boolean destroyed;
    private File cached_save_location;
    private File cached_save_location_result;

    public DownloadManagerImpl(GlobalManager _gm, byte[] _torrent_hash, String _torrentFileName, String _torrent_save_dir, String _torrent_save_file, int _initialState, boolean _persistent, boolean _recovered, boolean _open_for_seeding, boolean _has_ever_been_started, List _file_priorities, DownloadManagerInitialisationAdapter _initialisation_adapter) {
        if (_initialState != 0 && _initialState != 70 && _initialState != 75) {
            Debug.out("DownloadManagerImpl: Illegal start state, " + _initialState);
        }
        this.persistent = _persistent;
        this.globalManager = _gm;
        this.open_for_seeding = _open_for_seeding;
        if (_file_priorities != null) {
            this.setData("file_priorities", _file_priorities);
        }
        this.stats = new DownloadManagerStatsImpl(this);
        this.controller = new DownloadManagerController(this);
        this.torrentFileName = _torrentFileName;
        while (_torrent_save_dir.endsWith(File.separator)) {
            _torrent_save_dir = _torrent_save_dir.substring(0, _torrent_save_dir.length() - 1);
        }
        this.readTorrent(_torrent_save_dir, _torrent_save_file, _torrent_hash, this.persistent && !_recovered, _open_for_seeding, _has_ever_been_started, _initialState);
        if (this.torrent != null && _initialisation_adapter != null) {
            try {
                _initialisation_adapter.initialised(this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTorrent(String torrent_save_dir, String torrent_save_file, byte[] torrent_hash, boolean new_torrent, boolean for_seeding, boolean has_ever_been_started, int initial_state) {
        try {
            this.display_name = this.torrentFileName;
            this.internal_name = "";
            this.torrent_comment = "";
            this.torrent_created_by = "";
            try {
                this.download_manager_state = DownloadManagerStateImpl.getDownloadState(this, this.torrentFileName, torrent_hash, initial_state == 70 || initial_state == 75);
                this.readParameters();
                DownloadManagerStateAttributeListener attr_listener = new DownloadManagerStateAttributeListener(){

                    public void attributeEventOccurred(DownloadManager dm, String attribute_name, int event_type) {
                        if (attribute_name.equals("filelinks")) {
                            DownloadManagerImpl.this.setFileLinks();
                        } else if (attribute_name.equals("parameters")) {
                            DownloadManagerImpl.this.readParameters();
                        }
                    }
                };
                this.download_manager_state.addListener(attr_listener, "filelinks", 1);
                this.download_manager_state.addListener(attr_listener, "parameters", 1);
                this.torrent = this.download_manager_state.getTorrent();
                this.setFileLinks();
                if (!this.dl_identity_obtained) {
                    this.dl_identity = torrent_hash == null ? this.torrent.getHash() : torrent_hash;
                    this.dl_identity_hashcode = new String(this.dl_identity).hashCode();
                }
                if (!Arrays.equals(this.dl_identity, this.torrent.getHash())) {
                    this.torrent = null;
                    this.torrent_save_location = new File(torrent_save_dir, this.torrentFileName);
                    throw new NoStackException("Download identity changed - please remove and re-add the download");
                }
                this.read_torrent_state = null;
                LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(this.torrent);
                this.display_name = FileUtil.convertOSSpecificChars(locale_decoder.decodeString(this.torrent.getName()), false);
                this.internal_name = ByteFormatter.nicePrint(this.torrent.getHash(), true);
                File save_dir_file = new File(torrent_save_dir);
                if (torrent_save_file == null) {
                    try {
                        if (save_dir_file.exists()) {
                            save_dir_file = save_dir_file.getCanonicalFile();
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    if (this.torrent.isSimpleTorrent()) {
                        if (save_dir_file.exists()) {
                            if (save_dir_file.isDirectory()) {
                                torrent_save_file = this.display_name;
                            } else {
                                torrent_save_dir = save_dir_file.getParent().toString();
                                torrent_save_file = save_dir_file.getName();
                            }
                        } else {
                            if (save_dir_file.getParent() == null) {
                                throw new NoStackException("Data location '" + torrent_save_dir + "' is invalid");
                            }
                            torrent_save_dir = save_dir_file.getParent().toString();
                            torrent_save_file = save_dir_file.getName();
                        }
                    } else {
                        if (save_dir_file.exists()) {
                            if (!save_dir_file.isDirectory()) {
                                throw new NoStackException("'" + torrent_save_dir + "' is not a directory");
                            }
                            if (save_dir_file.getName().equals(this.display_name)) {
                                torrent_save_dir = save_dir_file.getParent().toString();
                            }
                        }
                        torrent_save_file = this.display_name;
                    }
                }
                this.torrent_save_location = new File(torrent_save_dir, torrent_save_file);
                File linked_target = this.getSaveLocation();
                if (!linked_target.exists() && !new_torrent && !Constants.isWindows && has_ever_been_started) {
                    throw new NoStackException(MessageText.getString("DownloadManager.error.datamissing") + " " + Debug.secretFileName(linked_target.toString()));
                }
                if (new_torrent) {
                    this.download_manager_state.setLongParameter("stats.download.added.time", SystemTime.getCurrentTime());
                    boolean low_noise = TorrentUtils.getFlag(this.torrent, 1);
                    if (low_noise) {
                        this.download_manager_state.setFlag(16L, true);
                    }
                    this.download_manager_state.setTrackerResponseCache(new HashMap());
                    if (for_seeding) {
                        DiskManagerFactory.setTorrentResumeDataNearlyComplete(this.download_manager_state);
                        this.download_manager_state.setFlag(8L, true);
                    } else {
                        this.download_manager_state.clearResumeData();
                    }
                } else {
                    long add_time = this.download_manager_state.getLongParameter("stats.download.added.time");
                    if (add_time == 0L) {
                        try {
                            add_time = new File(this.torrentFileName).lastModified();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (add_time == 0L) {
                            add_time = SystemTime.getCurrentTime();
                        }
                        this.download_manager_state.setLongParameter("stats.download.added.time", add_time);
                    }
                }
                this.torrent_comment = StringInterner.intern(locale_decoder.decodeString(this.torrent.getComment()));
                if (this.torrent_comment == null) {
                    this.torrent_comment = "";
                }
                this.torrent_created_by = locale_decoder.decodeString(this.torrent.getCreatedBy());
                if (this.torrent_created_by == null) {
                    this.torrent_created_by = "";
                }
                if (this.download_manager_state.isResumeDataComplete() || for_seeding) {
                    this.stats.setDownloadCompleted(1000);
                    this.setAssumedComplete(true);
                } else {
                    this.setAssumedComplete(false);
                }
            }
            catch (TOTorrentException e) {
                this.setFailed(TorrentUtils.exceptionToText(e));
            }
            catch (UnsupportedEncodingException e) {
                Debug.printStackTrace(e);
                this.setFailed(MessageText.getString("DownloadManager.error.unsupportedencoding"));
            }
            catch (NoStackException e) {
                Debug.outNoStack(e.getMessage());
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                this.setFailed(e);
            }
            finally {
                this.dl_identity_obtained = true;
            }
            if (this.download_manager_state == null) {
                this.read_torrent_state = new Object[]{torrent_save_dir, torrent_save_file, torrent_hash, new Boolean(new_torrent), new Boolean(for_seeding), new Boolean(has_ever_been_started), new Integer(initial_state)};
                this.download_manager_state = DownloadManagerStateImpl.getDownloadState(this);
                this.torrent_save_location = torrent_save_file == null ? new File(torrent_save_dir) : new File(torrent_save_dir, torrent_save_file);
            } else {
                if (torrent_save_file == null) {
                    this.torrent_save_location = new File(torrent_save_dir);
                }
                if (this.download_manager_state.getNetworks().length == 0 && this.torrent != null) {
                    String[] networks = AENetworkClassifier.getNetworks(this.torrent, this.display_name);
                    this.download_manager_state.setNetworks(networks);
                }
            }
        }
        finally {
            if (this.torrent_save_location != null) {
                try {
                    this.torrent_save_location = this.torrent_save_location.getCanonicalFile();
                }
                catch (Throwable e) {
                    this.torrent_save_location = this.torrent_save_location.getAbsoluteFile();
                }
                this.getSaveLocation();
            }
            this.controller.setInitialState(initial_state);
        }
    }

    protected void readTorrent() {
        if (this.read_torrent_state == null) {
            return;
        }
        this.readTorrent((String)this.read_torrent_state[0], (String)this.read_torrent_state[1], (byte[])this.read_torrent_state[2], (Boolean)this.read_torrent_state[3], (Boolean)this.read_torrent_state[4], (Boolean)this.read_torrent_state[5], (Integer)this.read_torrent_state[6]);
    }

    protected void readParameters() {
        this.max_connections = this.getDownloadState().getIntParameter("max.peers");
        this.max_connections_when_seeding_enabled = this.getDownloadState().getBooleanParameter("max.peers.when.seeding.enabled");
        this.max_connections_when_seeding = this.getDownloadState().getIntParameter("max.peers.when.seeding");
        this.max_seed_connections = this.getDownloadState().getIntParameter("max.seeds");
        this.max_uploads = this.getDownloadState().getIntParameter("max.uploads");
        this.max_uploads_when_seeding_enabled = this.getDownloadState().getBooleanParameter("max.uploads.when.seeding.enabled");
        this.max_uploads_when_seeding = this.getDownloadState().getIntParameter("max.uploads.when.seeding");
        this.max_upload_when_busy_bps = this.getDownloadState().getIntParameter("max.upload.when.busy") * 1024;
        this.max_uploads = Math.max(this.max_uploads, 2);
        this.max_uploads_when_seeding = Math.max(this.max_uploads_when_seeding, 2);
    }

    protected int getMaxConnections() {
        return this.max_connections;
    }

    protected int getMaxConnectionsWhenSeeding() {
        return this.max_connections_when_seeding;
    }

    protected boolean isMaxConnectionsWhenSeedingEnabled() {
        return this.max_connections_when_seeding_enabled;
    }

    protected int getMaxSeedConnections() {
        return this.max_seed_connections;
    }

    protected boolean isMaxUploadsWhenSeedingEnabled() {
        return this.max_uploads_when_seeding_enabled;
    }

    protected int getMaxUploadsWhenSeeding() {
        return this.max_uploads_when_seeding;
    }

    public int getMaxUploads() {
        return this.max_uploads;
    }

    public void setMaxUploads(int max) {
        this.download_manager_state.setIntParameter("max.uploads", max);
    }

    public int getEffectiveMaxUploads() {
        if (this.isMaxUploadsWhenSeedingEnabled() && this.getState() == 60) {
            return this.getMaxUploadsWhenSeeding();
        }
        return this.max_uploads;
    }

    public int getEffectiveUploadRateLimitBytesPerSecond() {
        int local_max_bps;
        int rate = local_max_bps = this.stats.getUploadRateLimitBytesPerSecond();
        if (this.max_upload_when_busy_bps != 0) {
            long now = SystemTime.getCurrentTime();
            if (now < this.last_upload_when_busy_update || now - this.last_upload_when_busy_update > 5000L) {
                this.last_upload_when_busy_update = now;
                String key = TransferSpeedValidator.getActiveUploadParameter(this.globalManager);
                int global_limit_bps = COConfigurationManager.getIntParameter(key) * 1024;
                if (global_limit_bps > 0 && this.max_upload_when_busy_bps < global_limit_bps) {
                    local_max_bps = local_max_bps == 0 ? global_limit_bps : local_max_bps;
                    GlobalManagerStats gm_stats = this.globalManager.getStats();
                    int actual = gm_stats.getDataSendRateNoLAN() + gm_stats.getProtocolSendRateNoLAN();
                    int move_by = (local_max_bps - this.max_upload_when_busy_bps) / 10;
                    if (move_by < 1024) {
                        move_by = 1024;
                    }
                    if (global_limit_bps - actual <= 2048) {
                        if (this.current_upload_when_busy_bps == 0) {
                            this.current_upload_when_busy_bps = local_max_bps;
                        }
                        int prev_upload_when_busy_bps = this.current_upload_when_busy_bps;
                        this.current_upload_when_busy_bps -= move_by;
                        if (this.current_upload_when_busy_bps < this.max_upload_when_busy_bps) {
                            this.current_upload_when_busy_bps = this.max_upload_when_busy_bps;
                        }
                        if (this.current_upload_when_busy_bps < prev_upload_when_busy_bps) {
                            this.last_upload_when_busy_dec_time = now;
                        }
                    } else if (this.current_upload_when_busy_bps != 0 && (upload_when_busy_min_secs == 0 || now < this.last_upload_when_busy_dec_time || now - this.last_upload_when_busy_dec_time >= (long)(upload_when_busy_min_secs * 1000))) {
                        this.current_upload_when_busy_bps += move_by;
                        if (this.current_upload_when_busy_bps >= local_max_bps) {
                            this.current_upload_when_busy_bps = 0;
                        }
                    }
                    if (this.current_upload_when_busy_bps > 0) {
                        rate = this.current_upload_when_busy_bps;
                    }
                } else {
                    this.current_upload_when_busy_bps = 0;
                }
            } else if (this.current_upload_when_busy_bps > 0) {
                rate = this.current_upload_when_busy_bps;
            }
        }
        return rate;
    }

    protected void setFileLinks() {
        this.cached_save_location = null;
        DiskManagerFactory.setFileLinks(this, this.download_manager_state.getFileLinks());
        this.controller.fileInfoChanged();
    }

    protected void clearFileLinks() {
        this.download_manager_state.clearFileLinks();
    }

    protected void updateFileLinks(File old_save_path, File new_save_path) {
        try {
            old_save_path = old_save_path.getCanonicalFile();
        }
        catch (IOException ioe) {
            old_save_path = old_save_path.getAbsoluteFile();
        }
        try {
            new_save_path = new_save_path.getCanonicalFile();
        }
        catch (IOException ioe) {
            new_save_path = new_save_path.getAbsoluteFile();
        }
        String old_path = old_save_path.getPath();
        String new_path = new_save_path.getPath();
        CaseSensitiveFileMap links = this.download_manager_state.getFileLinks();
        Iterator it = links.keySetIterator();
        while (it.hasNext()) {
            File from = (File)it.next();
            File to = links.get(from);
            String from_s = from == null ? null : from.getAbsolutePath();
            String to_s = to == null ? null : to.getAbsolutePath();
            try {
                this.updateFileLink(old_path, new_path, from_s, to_s);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void updateFileLink(String old_path, String new_path, String from_loc, String to_loc) {
        if (to_loc == null) {
            return;
        }
        if (this.torrent.isSimpleTorrent()) {
            if (!old_path.equals(from_loc)) {
                throw new RuntimeException("assert failure: old_path=" + old_path + ", from_loc=" + from_loc);
            }
            this.download_manager_state.setFileLink(new File(old_path), null);
            this.download_manager_state.setFileLink(new File(new_path), new File(new_path));
            return;
        }
        String from_loc_to_use = FileUtil.translateMoveFilePath(old_path, new_path, from_loc);
        if (from_loc_to_use == null) {
            return;
        }
        String to_loc_to_use = FileUtil.translateMoveFilePath(old_path, new_path, to_loc);
        if (to_loc_to_use == null) {
            to_loc_to_use = to_loc;
        }
        this.download_manager_state.setFileLink(new File(from_loc), null);
        this.download_manager_state.setFileLink(new File(from_loc_to_use), new File(to_loc_to_use));
    }

    public boolean filesExist() {
        return this.filesExist(true);
    }

    public boolean filesExist(boolean expected_to_be_allocated) {
        return this.controller.filesExist(expected_to_be_allocated);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public String getDisplayName() {
        String result;
        DownloadManagerState dms = this.getDownloadState();
        if (dms != null && (result = dms.getDisplayName()) != null) {
            return result;
        }
        return this.display_name;
    }

    public String getInternalName() {
        return this.internal_name;
    }

    public String getErrorDetails() {
        return this.controller.getErrorDetail();
    }

    public long getSize() {
        if (this.torrent != null) {
            return this.torrent.getSize();
        }
        return 0L;
    }

    protected void setFailed() {
        this.setFailed((String)null);
    }

    protected void setFailed(Throwable e) {
        this.setFailed(Debug.getNestedExceptionMessage(e));
    }

    protected void setFailed(String str) {
        this.controller.setFailed(str);
    }

    protected void setTorrentInvalid(String str) {
        this.setFailed(str);
        this.torrent = null;
    }

    public void saveResumeData() {
        if (this.getState() == 50) {
            try {
                this.getDiskManager().saveResumeData(true);
            }
            catch (Exception e) {
                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
            }
        }
        if (!this.assumedComplete) {
            this.download_manager_state.save();
        }
    }

    public void saveDownload() {
        DiskManager disk_manager = this.controller.getDiskManager();
        if (disk_manager != null) {
            disk_manager.saveState();
        }
        this.download_manager_state.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (this.torrent == null) {
            this.readTorrent();
        }
        if (this.torrent == null) {
            this.setFailed();
            return;
        }
        if (this.assumedComplete && !this.filesExist(true)) {
            return;
        }
        this.download_manager_state.setActive(true);
        try {
            try {
                this.this_mon.enter();
                if (this.tracker_client != null) {
                    Debug.out("DownloadManager: initialize called with tracker client still available");
                    this.tracker_client.destroy();
                }
                this.tracker_client = TRTrackerAnnouncerFactory.create(this.torrent, this.download_manager_state.getNetworks());
                this.tracker_client.setTrackerResponseCache(this.download_manager_state.getTrackerResponseCache());
                this.tracker_client.addListener(this.tracker_client_listener);
            }
            finally {
                this.this_mon.exit();
            }
            try {
                this.controller.initializeDiskManager(this.open_for_seeding);
            }
            finally {
                this.open_for_seeding = false;
            }
        }
        catch (TRTrackerAnnouncerException e) {
            this.setFailed(e);
        }
    }

    public void setStateWaiting() {
        this.controller.setStateWaiting();
    }

    public void setStateFinishing() {
        this.controller.setStateFinishing();
    }

    public void setStateQueued() {
        this.controller.setStateQueued();
    }

    public int getState() {
        return this.controller.getState();
    }

    public int getSubState() {
        return this.controller.getSubState();
    }

    public boolean canForceRecheck() {
        if (this.getTorrent() == null) {
            return false;
        }
        return this.controller.canForceRecheck();
    }

    public void forceRecheck() {
        this.controller.forceRecheck(null);
    }

    public void forceRecheck(ForceRecheckListener l) {
        this.controller.forceRecheck(l);
    }

    public void setPieceCheckingEnabled(boolean enabled) {
        this.controller.setPieceCheckingEnabled(enabled);
    }

    public void resetFile(DiskManagerFileInfo file) {
        int state = this.getState();
        if (state == 70 || state == 100) {
            DiskManagerFactory.clearResumeData(this, file);
        } else {
            Debug.out("Download not stopped");
        }
    }

    public void recheckFile(DiskManagerFileInfo file) {
        int state = this.getState();
        if (state == 70 || state == 100) {
            DiskManagerFactory.recheckFile(this, file);
        } else {
            Debug.out("Download not stopped");
        }
    }

    public void startDownload() {
        this.controller.startDownload(this.getTrackerClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt(int state_after_stopping, boolean remove_torrent, boolean remove_data) {
        try {
            this.download_manager_state.setLongAttribute("timestopped", SystemTime.getCurrentTime());
            this.controller.stopIt(state_after_stopping, remove_torrent, remove_data);
        }
        finally {
            this.download_manager_state.setActive(false);
        }
    }

    public boolean pause() {
        return this.globalManager.pauseDownload(this);
    }

    public boolean isPaused() {
        return this.globalManager.isPaused(this);
    }

    public void resume() {
        this.globalManager.resumeDownload(this);
    }

    public boolean getAssumedComplete() {
        return this.assumedComplete;
    }

    public boolean requestAssumedCompleteMode() {
        boolean bCompleteNoDND = this.controller.isDownloadComplete(false);
        this.setAssumedComplete(bCompleteNoDND);
        return bCompleteNoDND;
    }

    protected void setAssumedComplete(boolean _assumedComplete) {
        long completedOn;
        if (_assumedComplete && (completedOn = this.download_manager_state.getLongParameter("stats.download.completed.time")) <= 0L) {
            this.download_manager_state.setLongParameter("stats.download.completed.time", SystemTime.getCurrentTime());
        }
        if (this.assumedComplete == _assumedComplete) {
            return;
        }
        this.assumedComplete = _assumedComplete;
        if (!this.assumedComplete) {
            this.controller.setStateDownloading();
        }
        if (this.position != -1) {
            DownloadManager[] dms = new DownloadManager[]{this};
            this.position = this.globalManager.getDownloadManagers().size() + 1;
            if (COConfigurationManager.getBooleanParameter(CFG_MOVE_COMPLETED_TOP)) {
                this.globalManager.moveTop(dms);
            } else {
                this.globalManager.moveEnd(dms);
            }
            this.globalManager.fixUpDownloadManagerPositions();
        }
        this.listeners.dispatch(3, new Object[]{this, new Boolean(_assumedComplete)});
    }

    public int getNbSeeds() {
        PEPeerManager peerManager = this.controller.getPeerManager();
        if (peerManager != null) {
            return peerManager.getNbSeeds();
        }
        return 0;
    }

    public int getNbPeers() {
        PEPeerManager peerManager = this.controller.getPeerManager();
        if (peerManager != null) {
            return peerManager.getNbPeers();
        }
        return 0;
    }

    public String getTrackerStatus() {
        TRTrackerScraperResponse response;
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            return tc.getStatusString();
        }
        if (this.torrent != null && (response = this.getTrackerScrapeResponse()) != null) {
            return response.getStatusString();
        }
        return "";
    }

    public TRTrackerAnnouncer getTrackerClient() {
        return this.tracker_client;
    }

    public void setAnnounceResult(DownloadAnnounceResult result) {
        TRTrackerAnnouncer cl = this.getTrackerClient();
        if (cl == null) {
            return;
        }
        cl.setAnnounceResult(result);
    }

    public void setScrapeResult(DownloadScrapeResult result) {
        if (this.torrent != null && result != null) {
            TRTrackerScraper scraper = this.globalManager.getTrackerScraper();
            TRTrackerScraperResponse current_resp = this.getTrackerScrapeResponse();
            URL target_url = current_resp != null ? current_resp.getURL() : this.torrent.getAnnounceURL();
            scraper.setScrape(this.torrent, target_url, result);
        }
    }

    public int getNbPieces() {
        if (this.torrent == null) {
            return 0;
        }
        return this.torrent.getNumberOfPieces();
    }

    public int getTrackerTime() {
        TRTrackerScraperResponse response;
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            return tc.getTimeUntilNextUpdate();
        }
        if (this.torrent != null && (response = this.getTrackerScrapeResponse()) != null) {
            if (response.getStatus() == 3) {
                return -1;
            }
            return (int)((response.getNextScrapeStartTime() - SystemTime.getCurrentTime()) / 1000L);
        }
        return 60;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public File getSaveLocation() {
        File save_location = this.torrent_save_location;
        if (save_location == this.cached_save_location) {
            return this.cached_save_location_result;
        }
        File res = this.download_manager_state.getFileLink(save_location);
        if (res == null || res.equals(save_location)) {
            res = save_location;
        } else {
            try {
                res = res.getCanonicalFile();
            }
            catch (Throwable e) {
                res = res.getAbsoluteFile();
            }
        }
        this.cached_save_location = save_location;
        this.cached_save_location_result = res;
        return res;
    }

    public File getAbsoluteSaveLocation() {
        return this.torrent_save_location;
    }

    public void setTorrentSaveDir(String new_dir) {
        this.setTorrentSaveDir(new_dir, this.getAbsoluteSaveLocation().getName());
    }

    public void setTorrentSaveDir(String new_dir, String dl_name) {
        File new_location = new File(new_dir, dl_name);
        File old_location = this.torrent_save_location;
        if (new_location.equals(old_location)) {
            return;
        }
        this.updateFileLinks(old_location, new_location);
        this.torrent_save_location = new_location;
        try {
            this.torrent_save_location = this.torrent_save_location.getCanonicalFile();
        }
        catch (Throwable e) {
            this.torrent_save_location = this.torrent_save_location.getAbsoluteFile();
        }
        Logger.log(new LogEvent(this, LogIDs.CORE, "Torrent save directory changing from \"" + old_location.getPath() + "\" to \"" + new_location.getPath()));
        this.controller.fileInfoChanged();
    }

    public String getPieceLength() {
        if (this.torrent != null) {
            return DisplayFormatters.formatByteCountToKiBEtc(this.torrent.getPieceLength());
        }
        return "";
    }

    public String getTorrentFileName() {
        return this.torrentFileName;
    }

    public void setTorrentFileName(String string) {
        this.torrentFileName = string;
    }

    public void setTrackerScrapeResponse(TRTrackerScraperResponse response) {
        Object[] res = this.getActiveScrapeResponse();
        URL active_url = (URL)res[1];
        if (active_url != null && this.torrent != null) {
            this.torrent.setAnnounceURL(active_url);
        }
        if (response != null) {
            int state = this.getState();
            if (state == 100 || state == 70) {
                long minNextScrape = response.getStatus() == 0 ? SystemTime.getCurrentTime() + (state == 100 ? 600000L : 180000L) : SystemTime.getCurrentTime() + (state == 100 ? 0x6DDD00L : 3600000L);
                if (response.getNextScrapeStartTime() < minNextScrape) {
                    response.setNextScrapeStartTime(minNextScrape);
                }
            } else if (!response.isValid() && response.getStatus() == 0) {
                int sr = this.getStats().getShareRatio();
                long minNextScrape = SystemTime.getCurrentTime() + (long)((sr > 10000 ? 10000 : sr + 1000) * 60);
                if (response.getNextScrapeStartTime() < minNextScrape) {
                    response.setNextScrapeStartTime(minNextScrape);
                }
            }
            this.tracker_listeners.dispatch(2, response);
        }
    }

    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        Object[] res = this.getActiveScrapeResponse();
        return (TRTrackerScraperResponse)res[0];
    }

    protected Object[] getActiveScrapeResponse() {
        TRTrackerScraperResponse response = null;
        URL active_url = null;
        TRTrackerScraper scraper = this.globalManager.getTrackerScraper();
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            response = scraper.scrape(tc);
        }
        if (response == null && this.torrent != null) {
            TOTorrentAnnounceURLSet[] sets;
            TRTrackerScraperResponse non_null_response = null;
            try {
                sets = this.torrent.getAnnounceURLGroup().getAnnounceURLSets();
            }
            catch (Exception e) {
                return new Object[]{scraper.scrape(this.torrent), active_url};
            }
            if (sets.length == 0) {
                response = scraper.scrape(this.torrent);
            } else {
                Random scrape_random = new Random(this.scrape_random_seed);
                block2: for (int i = 0; response == null && i < sets.length; ++i) {
                    URL url;
                    int j;
                    TOTorrentAnnounceURLSet set = sets[i];
                    URL[] urls = set.getAnnounceURLs();
                    ArrayList<URL> rand_urls = new ArrayList<URL>();
                    for (j = 0; j < urls.length; ++j) {
                        url = urls[j];
                        int pos = (int)(scrape_random.nextDouble() * (double)(rand_urls.size() + 1));
                        rand_urls.add(pos, url);
                    }
                    for (j = 0; response == null && j < rand_urls.size(); ++j) {
                        url = (URL)rand_urls.get(j);
                        response = scraper.scrape(this.torrent, url);
                        if (response == null) continue;
                        int status = response.getStatus();
                        if (status == 2) {
                            active_url = url;
                            continue block2;
                        }
                        if (status == 0 || status == 3) continue block2;
                        if (response.isValid() && status != 1) continue;
                        if (non_null_response == null) {
                            non_null_response = response;
                        }
                        response = null;
                    }
                }
                if (response == null) {
                    response = non_null_response;
                }
            }
        }
        return new Object[]{response, active_url};
    }

    public void requestTrackerAnnounce(boolean force) {
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            tc.update(force);
        }
    }

    public void requestTrackerScrape(boolean force) {
        if (this.torrent != null) {
            TRTrackerScraper scraper = this.globalManager.getTrackerScraper();
            scraper.scrape(this.torrent, force);
        }
    }

    protected void setTrackerRefreshDelayOverrides(int percent) {
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            tc.setRefreshDelayOverrides(percent);
        }
    }

    protected boolean activateRequest(int count) {
        for (DownloadManagerActivationListener listener : this.activation_listeners) {
            try {
                if (!listener.activateRequest(count)) continue;
                return true;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    public int getActivationCount() {
        return this.controller.getActivationCount();
    }

    public String getTorrentComment() {
        return this.torrent_comment;
    }

    public String getTorrentCreatedBy() {
        return this.torrent_created_by;
    }

    public long getTorrentCreationDate() {
        if (this.torrent == null) {
            return 0L;
        }
        return this.torrent.getCreationDate();
    }

    public GlobalManager getGlobalManager() {
        return this.globalManager;
    }

    public DiskManager getDiskManager() {
        return this.controller.getDiskManager();
    }

    public DiskManagerFileInfoSet getDiskManagerFileInfoSet() {
        return this.controller.getDiskManagerFileInfoSet();
    }

    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        return this.controller.getDiskManagerFileInfo();
    }

    public PEPeerManager getPeerManager() {
        return this.controller.getPeerManager();
    }

    public boolean isDownloadComplete(boolean bIncludeDND) {
        if (!bIncludeDND) {
            return this.assumedComplete;
        }
        return this.controller.isDownloadComplete(bIncludeDND);
    }

    public void addListener(DownloadManagerListener listener) {
        this.addListener(listener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadManagerListener listener, boolean triggerStateChange) {
        if (listener == null) {
            Debug.out("Warning: null listener");
            return;
        }
        try {
            this.listeners_mon.enter();
            this.listeners.addListener(listener);
            if (triggerStateChange) {
                listener.stateChanged(this, this.getState());
            }
        }
        catch (Throwable t) {
            Debug.out("adding listener", t);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadManagerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.removeListener(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informStateChanged() {
        try {
            this.listeners_mon.enter();
            int new_state = this.controller.getState();
            boolean new_force_start = this.controller.isForceStart();
            if (new_state != this.last_informed_state || new_force_start != this.latest_informed_force_start) {
                this.last_informed_state = new_state;
                this.latest_informed_force_start = new_force_start;
                this.listeners.dispatch(1, new Object[]{this, new Integer(new_state)});
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informDownloadEnded() {
        try {
            this.listeners_mon.enter();
            this.listeners.dispatch(2, new Object[]{this});
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void informPrioritiesChange(List files) {
        this.controller.filePrioritiesChanged(files);
        try {
            this.listeners_mon.enter();
            for (int i = 0; i < files.size(); ++i) {
                this.listeners.dispatch(5, new Object[]{this, (DiskManagerFileInfo)files.get(i)});
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        this.requestAssumedCompleteMode();
    }

    protected void informPriorityChange(DiskManagerFileInfo file) {
        this.informPrioritiesChange(Collections.singletonList(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informPositionChanged(int new_position) {
        try {
            this.listeners_mon.enter();
            int old_position = this.position;
            if (new_position != old_position) {
                this.position = new_position;
                this.listeners.dispatch(4, new Object[]{this, new Integer(old_position), new Integer(new_position)});
                if (this.getState() == 60 || this.getState() == 50) {
                    PeerControlSchedulerFactory.updateScheduleOrdering();
                }
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void addPeerListener(DownloadManagerPeerListener listener) {
        this.addPeerListener(listener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerListener(DownloadManagerPeerListener listener, boolean bDispatchForExisting) {
        try {
            this.peer_listeners_mon.enter();
            this.peer_listeners.addListener(listener);
            if (!bDispatchForExisting) {
                return;
            }
            for (int i = 0; i < this.current_peers.size(); ++i) {
                this.peer_listeners.dispatch(listener, 1, this.current_peers.get(i));
            }
            PEPeerManager temp = this.controller.getPeerManager();
            if (temp != null) {
                this.peer_listeners.dispatch(listener, 5, temp);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public void removePeerListener(DownloadManagerPeerListener listener) {
        this.peer_listeners.removeListener(listener);
    }

    public void addPieceListener(DownloadManagerPieceListener listener) {
        this.addPieceListener(listener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPieceListener(DownloadManagerPieceListener listener, boolean bDispatchForExisting) {
        try {
            this.piece_listeners_mon.enter();
            this.piece_listeners.addListener(listener);
            if (!bDispatchForExisting) {
                return;
            }
            for (int i = 0; i < this.current_pieces.size(); ++i) {
                this.piece_listeners.dispatch(listener, 3, this.current_pieces.get(i));
            }
        }
        finally {
            this.piece_listeners_mon.exit();
        }
    }

    public void removePieceListener(DownloadManagerPieceListener listener) {
        this.piece_listeners.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeer(PEPeer peer) {
        try {
            this.peer_listeners_mon.enter();
            this.current_peers.add(peer);
            this.peer_listeners.dispatch(1, peer);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeer(PEPeer peer) {
        TRTrackerAnnouncer announcer;
        try {
            this.peer_listeners_mon.enter();
            this.current_peers.remove(peer);
            this.peer_listeners.dispatch(2, peer);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
        if ((peer.isSeed() || peer.isRelativeSeed()) && this.isDownloadComplete(false) && (announcer = this.tracker_client) != null) {
            announcer.removeFromTrackerResponseCache(peer.getIp(), peer.getTCPListenPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PEPeer[] getCurrentPeers() {
        try {
            this.peer_listeners_mon.enter();
            PEPeer[] pEPeerArray = this.current_peers.toArray(new PEPeer[this.current_peers.size()]);
            return pEPeerArray;
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPiece(PEPiece piece) {
        try {
            this.piece_listeners_mon.enter();
            this.current_pieces.add(piece);
            this.piece_listeners.dispatch(3, piece);
        }
        finally {
            this.piece_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePiece(PEPiece piece) {
        try {
            this.piece_listeners_mon.enter();
            this.current_pieces.remove(piece);
            this.piece_listeners.dispatch(4, piece);
        }
        finally {
            this.piece_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PEPiece[] getCurrentPieces() {
        try {
            this.piece_listeners_mon.enter();
            PEPiece[] pEPieceArray = this.current_pieces.toArray(new PEPiece[this.current_pieces.size()]);
            return pEPieceArray;
        }
        finally {
            this.piece_listeners_mon.exit();
        }
    }

    protected void informWillBeStarted(PEPeerManager pm) {
        List l = this.peer_listeners.getListenersCopy();
        for (int i = 0; i < l.size(); ++i) {
            try {
                ((DownloadManagerPeerListener)l.get(i)).peerManagerWillBeAdded(pm);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informStarted(PEPeerManager pm) {
        try {
            this.peer_listeners_mon.enter();
            this.peer_listeners.dispatch(5, pm);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            tc.update(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informStopped(PEPeerManager pm, boolean for_queue) {
        if (pm != null) {
            try {
                this.peer_listeners_mon.enter();
                this.peer_listeners.dispatch(6, pm);
            }
            finally {
                this.peer_listeners_mon.exit();
            }
        }
        try {
            this.this_mon.enter();
            if (this.tracker_client != null) {
                this.tracker_client.addListener(this.stopping_tracker_client_listener);
                this.tracker_client.removeListener(this.tracker_client_listener);
                this.download_manager_state.setTrackerResponseCache(this.tracker_client.getTrackerResponseCache());
                this.tracker_client.getLastResponse().setPeers(new TRTrackerAnnouncerResponsePeer[0]);
                this.tracker_client.stop(for_queue && this.isDownloadComplete(false));
                this.tracker_client.destroy();
                this.tracker_client = null;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public DownloadManagerStats getStats() {
        return this.stats;
    }

    public boolean isForceStart() {
        return this.controller.isForceStart();
    }

    public void setForceStart(boolean forceStart) {
        this.controller.setForceStart(forceStart);
    }

    protected void downloadEnded(boolean never_downloaded) {
        DiskManager dm;
        TRTrackerAnnouncer tc;
        if (!never_downloaded) {
            if (this.isForceStart()) {
                this.setForceStart(false);
            }
            this.setAssumedComplete(true);
            this.informDownloadEnded();
        }
        if ((tc = this.tracker_client) != null && (dm = this.getDiskManager()) != null && dm.getRemaining() == 0L) {
            tc.complete(never_downloaded);
        }
    }

    public void addDiskListener(DownloadManagerDiskListener listener) {
        this.controller.addDiskListener(listener);
    }

    public void removeDiskListener(DownloadManagerDiskListener listener) {
        this.controller.removeDiskListener(listener);
    }

    public void addActivationListener(DownloadManagerActivationListener listener) {
        this.activation_listeners.add(listener);
    }

    public void removeActivationListener(DownloadManagerActivationListener listener) {
        this.activation_listeners.remove(listener);
    }

    public int getHealthStatus() {
        int state = this.getState();
        PEPeerManager peerManager = this.controller.getPeerManager();
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null && peerManager != null && (state == 50 || state == 60)) {
            boolean isSeed;
            int nbSeeds = this.getNbSeeds();
            int nbPeers = this.getNbPeers();
            int nbRemotes = peerManager.getNbRemoteConnectionsExcludingUDP();
            TRTrackerAnnouncerResponse announce_response = tc.getLastResponse();
            int trackerStatus = announce_response.getStatus();
            boolean bl = isSeed = state == 60;
            if (nbSeeds + nbPeers == 0) {
                if (isSeed) {
                    return 2;
                }
                return 5;
            }
            if (!(isSeed || trackerStatus != 0 && trackerStatus != 1)) {
                return 2;
            }
            if (nbRemotes == 0) {
                TRTrackerScraperResponse scrape_response = this.getTrackerScrapeResponse();
                if (scrape_response != null && scrape_response.isValid() && nbSeeds == scrape_response.getSeeds() && nbPeers == scrape_response.getPeers()) {
                    return 4;
                }
                return 3;
            }
            return 4;
        }
        if (state == 100) {
            return 6;
        }
        return 1;
    }

    public int getNATStatus() {
        int state = this.getState();
        PEPeerManager peerManager = this.controller.getPeerManager();
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null && peerManager != null && (state == 50 || state == 60)) {
            if (peerManager.getNbRemoteConnectionsExcludingUDP() > 0) {
                return 1;
            }
            long last_good_time = peerManager.getLastRemoteConnectionTime();
            if (last_good_time > 0L) {
                if (SystemTime.getCurrentTime() - last_good_time < 1800000L) {
                    return 1;
                }
                return 2;
            }
            TRTrackerAnnouncerResponse announce_response = tc.getLastResponse();
            int trackerStatus = announce_response.getStatus();
            if (trackerStatus == 0 || trackerStatus == 1) {
                return 0;
            }
            if (SystemTime.getCurrentTime() - peerManager.getTimeStarted() < 180000L) {
                return 0;
            }
            TRTrackerScraperResponse scrape_response = this.getTrackerScrapeResponse();
            if (scrape_response != null && scrape_response.isValid() && peerManager.getNbSeeds() == scrape_response.getSeeds() && peerManager.getNbPeers() == scrape_response.getPeers()) {
                return 0;
            }
            return 3;
        }
        return 0;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int new_position) {
        this.informPositionChanged(new_position);
    }

    public void addTrackerListener(DownloadManagerTrackerListener listener) {
        this.tracker_listeners.addListener(listener);
    }

    public void removeTrackerListener(DownloadManagerTrackerListener listener) {
        this.tracker_listeners.removeListener(listener);
    }

    protected void deleteDataFiles() {
        DiskManagerFactory.deleteDataFiles(this.torrent, this.torrent_save_location.getParent(), this.torrent_save_location.getName());
        this.getDownloadState().setFlag(4L, true);
    }

    protected void deleteTorrentFile() {
        if (this.torrentFileName != null) {
            TorrentUtils.delete(new File(this.torrentFileName));
        }
    }

    public DownloadManagerState getDownloadState() {
        return this.download_manager_state;
    }

    public Object getData(String key) {
        return this.getUserData(key);
    }

    public void setData(String key, Object value) {
        this.setUserData(key, value);
    }

    public Object getUserData(Object key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserData(Object key, Object value) {
        try {
            this.peer_listeners_mon.enter();
            if (this.data == null) {
                this.data = new LightHashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                }
            } else {
                this.data.put(key, value);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public boolean isDataAlreadyAllocated() {
        return this.data_already_allocated;
    }

    public void setDataAlreadyAllocated(boolean already_allocated) {
        this.data_already_allocated = already_allocated;
    }

    public void setSeedingRank(int rank) {
        this.iSeedingRank = rank;
    }

    public int getSeedingRank() {
        return this.iSeedingRank;
    }

    public long getCreationTime() {
        return this.creation_time;
    }

    public void setCreationTime(long t) {
        this.creation_time = t;
    }

    public boolean isExtendedMessagingEnabled() {
        return this.az_messaging_enabled;
    }

    public void setAZMessagingEnabled(boolean enable) {
        this.az_messaging_enabled = enable;
    }

    public void setCryptoLevel(int level) {
        this.crypto_level = level;
    }

    public int getCryptoLevel() {
        return this.crypto_level;
    }

    public void moveDataFiles(File new_parent_dir) throws DownloadManagerException {
        this.moveDataFiles(new_parent_dir, null);
    }

    public void renameDownload(String new_name) throws DownloadManagerException {
        this.moveDataFiles(null, new_name);
    }

    public void moveDataFiles(final File destination, final String new_name) throws DownloadManagerException {
        if (destination == null && new_name == null) {
            throw new NullPointerException("destination and new name are both null");
        }
        if (!this.canMoveDataFiles()) {
            throw new DownloadManagerException("canMoveDataFiles is false!");
        }
        SaveLocationChange slc = new SaveLocationChange();
        slc.download_location = destination;
        slc.download_name = new_name;
        File current_location = this.getSaveLocation();
        if (slc.normaliseDownloadLocation(current_location).equals(current_location)) {
            return;
        }
        try {
            FileUtil.runAsTask(new AzureusCoreOperationTask(){

                public void run(AzureusCoreOperation operation) {
                    try {
                        DownloadManagerImpl.this.moveDataFilesSupport(destination, new_name);
                    }
                    catch (DownloadManagerException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DownloadManagerException) {
                throw (DownloadManagerException)cause;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveDataFilesSupport(File new_parent_dir, String new_filename) throws DownloadManagerException {
        boolean is_paused = this.pause();
        try {
            this.moveDataFilesSupport0(new_parent_dir, new_filename);
        }
        finally {
            if (is_paused) {
                this.resume();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveDataFilesSupport0(File new_parent_dir, String new_filename) throws DownloadManagerException {
        if (!this.canMoveDataFiles()) {
            throw new DownloadManagerException("canMoveDataFiles is false!");
        }
        if (new_filename != null) {
            new_filename = FileUtil.convertOSSpecificChars(new_filename, false);
        }
        File old_file = this.getSaveLocation();
        try {
            old_file = old_file.getCanonicalFile();
            if (new_parent_dir != null) {
                new_parent_dir = new_parent_dir.getCanonicalFile();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new DownloadManagerException("Failed to get canonical paths", e);
        }
        File current_save_location = old_file;
        File new_save_location = new File(new_parent_dir == null ? old_file.getParentFile() : new_parent_dir, new_filename == null ? old_file.getName() : new_filename);
        if (current_save_location.equals(new_save_location)) {
            return;
        }
        DiskManager dm = this.getDiskManager();
        if (dm == null || dm.getFiles() == null) {
            if (!old_file.exists()) {
                FileUtil.mkdirs(new_save_location.getParentFile());
                this.setTorrentSaveDir(new_save_location.getParent().toString(), new_save_location.getName());
                return;
            }
            try {
                new_save_location = new_save_location.getCanonicalFile();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            if (old_file.equals(new_save_location)) return;
            if (this.torrent.isSimpleTorrent()) {
                if (!this.controller.getDiskManagerFileInfo()[0].setLinkAtomic(new_save_location)) throw new DownloadManagerException("rename operation failed");
                this.setTorrentSaveDir(new_save_location.getParentFile().toString(), new_save_location.getName());
                return;
            }
            if (FileUtil.isAncestorOf(old_file, new_save_location)) {
                Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{old_file.toString(), "Target is sub-directory of files"});
                throw new DownloadManagerException("rename operation failed");
            }
            final HashSet<File> files_to_move = new HashSet<File>();
            files_to_move.add(null);
            DiskManagerFileInfo[] info_files = this.controller.getDiskManagerFileInfo();
            for (int i = 0; i < info_files.length; ++i) {
                File f = info_files[i].getFile(true);
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException ioe) {
                    f = f.getAbsoluteFile();
                }
                boolean added_entry = files_to_move.add(f);
                while (added_entry) {
                    f = f.getParentFile();
                    added_entry = files_to_move.add(f);
                }
            }
            FileFilter ff = new FileFilter(){

                public boolean accept(File f) {
                    return files_to_move.contains(f);
                }
            };
            if (!FileUtil.renameFile(old_file, new_save_location, false, ff)) throw new DownloadManagerException("rename operation failed");
            this.setTorrentSaveDir(new_save_location.getParentFile().toString(), new_save_location.getName());
            return;
        }
        dm.moveDataFiles(new_save_location.getParentFile(), new_save_location.getName());
    }

    public void moveTorrentFile(File new_parent_dir) throws DownloadManagerException {
        this.moveTorrentFile(new_parent_dir, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTorrentFile(File new_parent_dir, String new_name) throws DownloadManagerException {
        SaveLocationChange slc = new SaveLocationChange();
        slc.torrent_location = new_parent_dir;
        slc.torrent_name = new_name;
        File torrent_file_now = new File(this.getTorrentFileName());
        if (!slc.isDifferentTorrentLocation(torrent_file_now)) {
            return;
        }
        boolean is_paused = this.pause();
        try {
            this.moveTorrentFile0(new_parent_dir, new_name);
        }
        finally {
            if (is_paused) {
                this.resume();
            }
        }
    }

    private void moveTorrentFile0(File new_parent_dir, String new_name) throws DownloadManagerException {
        if (!this.canMoveDataFiles()) {
            throw new DownloadManagerException("Cannot move torrent file");
        }
        this.setTorrentFile(new_parent_dir, new_name);
    }

    public void setTorrentFile(File new_parent_dir, String new_name) throws DownloadManagerException {
        File old_file = new File(this.getTorrentFileName());
        if (!old_file.exists()) {
            Debug.out("torrent file doesn't exist!");
            return;
        }
        if (new_parent_dir == null) {
            new_parent_dir = old_file.getParentFile();
        }
        if (new_name == null) {
            new_name = old_file.getName();
        }
        File new_file = new File(new_parent_dir, new_name);
        try {
            old_file = old_file.getCanonicalFile();
            new_file = new_file.getCanonicalFile();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new DownloadManagerException("Failed to get canonical paths", e);
        }
        if (new_file.equals(old_file)) {
            return;
        }
        if (!TorrentUtils.move(old_file, new_file)) {
            throw new DownloadManagerException("rename operation failed");
        }
        this.setTorrentFileName(new_file.toString());
    }

    public boolean isInDefaultSaveDir() {
        return DownloadManagerDefaultPaths.isInDefaultDownloadDir(this);
    }

    public boolean seedPieceRecheck() {
        PEPeerManager pm = this.controller.getPeerManager();
        if (pm != null) {
            return pm.seedPieceRecheck();
        }
        return false;
    }

    public void addRateLimiter(LimitedRateGroup group, boolean upload) {
        this.controller.addRateLimiter(group, upload);
    }

    public void removeRateLimiter(LimitedRateGroup group, boolean upload) {
        this.controller.removeRateLimiter(group, upload);
    }

    public boolean isTrackerError() {
        TRTrackerAnnouncerResponse resp;
        TRTrackerAnnouncer announcer = this.getTrackerClient();
        return announcer != null ? (resp = announcer.getLastResponse()) != null && resp.getStatus() == 1 : (resp = this.getTrackerScrapeResponse()) != null && resp.getStatus() == 1;
    }

    public boolean isUnauthorisedOnTracker() {
        TRTrackerAnnouncer announcer = this.getTrackerClient();
        String status_str = null;
        if (announcer != null) {
            TRTrackerAnnouncerResponse resp = announcer.getLastResponse();
            if (resp != null && resp.getStatus() == 1) {
                status_str = resp.getStatusString();
            }
        } else {
            TRTrackerScraperResponse resp = this.getTrackerScrapeResponse();
            if (resp != null && resp.getStatus() == 1) {
                status_str = resp.getStatusString();
            }
        }
        return status_str != null && ((status_str = status_str.toLowerCase()).contains("not authorised") || status_str.contains("not authorized"));
    }

    private byte[] getIdentity() {
        return this.dl_identity;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DownloadManagerImpl) {
            DownloadManagerImpl other = (DownloadManagerImpl)obj;
            byte[] id1 = this.getIdentity();
            byte[] id2 = other.getIdentity();
            if (id1 == null || id2 == null) {
                return false;
            }
            return Arrays.equals(id1, id2);
        }
        return false;
    }

    public int hashCode() {
        return this.dl_identity_hashcode;
    }

    public String getRelationText() {
        return "TorrentDLM: '" + this.getDisplayName() + "'";
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.tracker_client};
    }

    public String toString() {
        String hash = "<unknown>";
        try {
            hash = ByteFormatter.encodeString(this.torrent.getHash());
        }
        catch (Throwable e) {
            // empty catch block
        }
        String status = DisplayFormatters.formatDownloadStatus(this);
        if (status.length() > 10) {
            status = status.substring(0, 10);
        }
        return "DownloadManagerImpl#" + this.getPosition() + (this.getAssumedComplete() ? "s" : "d") + "@" + Integer.toHexString(this.hashCode()) + "/" + status + "/" + hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter writer) {
        writer.println(this.toString());
        PEPeerManager pm = this.getPeerManager();
        try {
            TRTrackerScraperResponse scrape;
            writer.indent();
            writer.println("Save Dir: " + Debug.secretFileName(this.getSaveLocation().toString()));
            if (this.current_peers.size() > 0) {
                writer.println("# Peers: " + this.current_peers.size());
            }
            if (this.current_pieces.size() > 0) {
                writer.println("# Pieces: " + this.current_pieces.size());
            }
            writer.println("Listeners: DownloadManager=" + this.listeners.size() + "; Disk=" + this.controller.getDiskListenerCount() + "; Peer=" + this.peer_listeners.size() + "; Tracker=" + this.tracker_listeners.size());
            writer.println("SR: " + this.iSeedingRank);
            String sFlags = "";
            if (this.open_for_seeding) {
                sFlags = sFlags + "Opened for Seeding; ";
            }
            if (this.data_already_allocated) {
                sFlags = sFlags + "Data Already Allocated; ";
            }
            if (this.assumedComplete) {
                sFlags = sFlags + "onlySeeding; ";
            }
            if (this.persistent) {
                sFlags = sFlags + "persistent; ";
            }
            if (sFlags.length() > 0) {
                writer.println("Flags: " + sFlags);
            }
            this.stats.generateEvidence(writer);
            this.download_manager_state.generateEvidence(writer);
            if (pm != null) {
                pm.generateEvidence(writer);
            }
            this.controller.generateEvidence(writer);
            TRTrackerAnnouncer announcer = this.tracker_client;
            if (announcer != null) {
                announcer.generateEvidence(writer);
            }
            if ((scrape = this.getTrackerScrapeResponse()) == null) {
                writer.println("Scrape: null");
            } else {
                writer.println("Scrape: " + scrape.getString());
            }
        }
        finally {
            writer.exdent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(boolean is_duplicate) {
        this.destroyed = true;
        if (is_duplicate) {
            this.controller.destroy();
        } else {
            try {
                if (!this.getSaveLocation().exists()) {
                    return;
                }
                DiskManager dm = this.getDiskManager();
                if (dm != null) {
                    dm.downloadRemoved();
                    return;
                }
                SaveLocationChange move_details = DownloadManagerMoveHandler.onRemoval(this);
                if (move_details == null) {
                    return;
                }
                boolean can_move_torrent = move_details.hasTorrentChange();
                try {
                    if (move_details.hasDownloadChange()) {
                        this.moveDataFiles(move_details.download_location, move_details.download_name);
                    }
                }
                catch (Exception e) {
                    can_move_torrent = false;
                    Logger.log(new LogAlert((Object)this, true, "Problem moving files to removed download directory", (Throwable)e));
                }
                if (can_move_torrent) {
                    try {
                        this.moveTorrentFile(move_details.torrent_location, move_details.torrent_name);
                    }
                    catch (Exception e) {
                        Logger.log(new LogAlert((Object)this, true, "Problem moving torrent to removed download directory", (Throwable)e));
                    }
                }
            }
            finally {
                this.clearFileLinks();
                this.controller.destroy();
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public int[] getStorageType(DiskManagerFileInfo[] info) {
        String[] types = DiskManagerImpl.getStorageTypes(this);
        int[] result = new int[info.length];
        for (int i = 0; i < info.length; ++i) {
            boolean is_linear = types[info[i].getIndex()].equals("L");
            result[i] = is_linear ? 1 : 2;
        }
        return result;
    }

    public boolean canMoveDataFiles() {
        return this.isPersistent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String name) throws DownloadManagerException {
        boolean paused = this.pause();
        try {
            this.renameDownload(name);
            this.getDownloadState().setAttribute("displayname", name);
            this.renameTorrentSafe(name);
        }
        finally {
            if (paused) {
                this.resume();
            }
        }
    }

    public void renameTorrent(String name) throws DownloadManagerException {
        this.moveTorrentFile(null, name);
    }

    private void renameTorrentSafe(String name) throws DownloadManagerException {
        String torrent_name;
        String torrent_parent = new File(this.getTorrentFileName()).getParent();
        File new_path = new File(torrent_parent, (torrent_name = name) + ".torrent");
        if (new_path.exists()) {
            new_path = null;
        }
        for (int i = 1; i < 10 && new_path == null; ++i) {
            new_path = new File(torrent_parent, torrent_name + "(" + i + ").torrent");
            if (!new_path.exists()) continue;
            new_path = null;
        }
        if (new_path == null) {
            throw new DownloadManagerException("cannot rename torrent file - file already exists");
        }
        this.renameTorrent(new_path.getName());
    }

    static {
        COConfigurationManager.addAndFireParameterListener("max.uploads.when.busy.inc.min.secs", new ParameterListener(){

            public void parameterChanged(String name) {
                upload_when_busy_min_secs = COConfigurationManager.getIntParameter(name);
            }
        });
        listeners_aggregator = ListenerManager.createAsyncManager("DM:ListenAggregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object _listener, int type, Object _value) {
                DownloadManagerListener listener = (DownloadManagerListener)_listener;
                Object[] value = (Object[])_value;
                DownloadManagerImpl dm = (DownloadManagerImpl)value[0];
                if (type == 1) {
                    listener.stateChanged(dm, (Integer)value[1]);
                } else if (type == 2) {
                    listener.downloadComplete(dm);
                } else if (type == 3) {
                    listener.completionChanged(dm, (Boolean)value[1]);
                } else if (type == 5) {
                    listener.filePriorityChanged(dm, (DiskManagerFileInfo)value[1]);
                } else if (type == 4) {
                    listener.positionChanged(dm, (Integer)value[1], (Integer)value[2]);
                }
            }
        });
        peer_listeners_aggregator = ListenerManager.createAsyncManager("DM:PeerListenAggregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object _listener, int type, Object value) {
                DownloadManagerPeerListener listener = (DownloadManagerPeerListener)_listener;
                if (type == 1) {
                    listener.peerAdded((PEPeer)value);
                } else if (type == 2) {
                    listener.peerRemoved((PEPeer)value);
                } else if (type == 5) {
                    listener.peerManagerAdded((PEPeerManager)value);
                } else if (type == 6) {
                    listener.peerManagerRemoved((PEPeerManager)value);
                }
            }
        });
        piece_listeners_aggregator = ListenerManager.createAsyncManager("DM:PieceListenAggregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object _listener, int type, Object value) {
                DownloadManagerPieceListener listener = (DownloadManagerPieceListener)_listener;
                if (type == 3) {
                    listener.pieceAdded((PEPiece)value);
                } else if (type == 4) {
                    listener.pieceRemoved((PEPiece)value);
                }
            }
        });
    }

    protected static class NoStackException
    extends Exception {
        protected NoStackException(String str) {
            super(str);
        }
    }
}

