/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UnresolvableHostManager;

public class IPAddressRangeManager {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected ArrayList entries = new ArrayList();
    protected long total_span;
    protected boolean rebuild_required;
    protected long last_rebuild_time;
    protected IpRange[] mergedRanges = new IpRange[0];
    protected AEMonitor this_mon = new AEMonitor("IPAddressRangeManager");

    protected IPAddressRangeManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRange(IpRange range) {
        try {
            this.this_mon.enter();
            this.entries.add(range);
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRange(IpRange range) {
        try {
            this.this_mon.enter();
            this.entries.remove(range);
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object isInRange(String ip) {
        if (this.entries.size() == 0) {
            return null;
        }
        try {
            Object res;
            this.this_mon.enter();
            long address_long = this.addressToInt(ip);
            if (address_long < 0L) {
                address_long += 0x100000000L;
            }
            Object object = res = this.isInRange(address_long);
            return object;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object isInRange(InetAddress ip) {
        if (this.entries.size() == 0) {
            return null;
        }
        try {
            Object res;
            this.this_mon.enter();
            long address_long = this.addressToInt(ip);
            if (address_long < 0L) {
                address_long += 0x100000000L;
            }
            Object object = res = this.isInRange(address_long);
            return object;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object isInRange(long address_long) {
        try {
            IpRange e;
            this.this_mon.enter();
            this.checkRebuild();
            if (this.mergedRanges.length == 0) {
                Object var3_2 = null;
                return var3_2;
            }
            int bottom = 0;
            int top = this.mergedRanges.length - 1;
            int current = -1;
            while (top >= 0 && bottom < this.mergedRanges.length && bottom <= top) {
                current = (bottom + top) / 2;
                e = this.mergedRanges[current];
                long this_start = e.getStartIpLong();
                long this_end = e.getMergedEndLong();
                if (address_long == this_start) break;
                if (address_long > this_start) {
                    if (address_long <= this_end) break;
                    bottom = current + 1;
                    continue;
                }
                if (address_long == this_end || address_long >= this_start) break;
                top = current - 1;
            }
            if (top >= 0 && bottom < this.mergedRanges.length && bottom <= top) {
                e = this.mergedRanges[current];
                if (address_long <= e.getEndIpLong()) {
                    IpRange this_start = e;
                    return this_start;
                }
                IpRange[] merged = e.getMergedEntries();
                if (merged == null) {
                    Debug.out("IPAddressRangeManager: inconsistent merged details - no entries");
                    Object var8_12 = null;
                    return var8_12;
                }
                for (int i = 0; i < merged.length; ++i) {
                    IpRange me = merged[i];
                    if (me.getStartIpLong() > address_long || me.getEndIpLong() < address_long) continue;
                    IpRange ipRange = me;
                    return ipRange;
                }
                Debug.out("IPAddressRangeManager: inconsistent merged details - entry not found");
            }
            Object var6_6 = null;
            return var6_6;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int addressToInt(String address) {
        try {
            return PRHelpers.addressToInt(address);
        }
        catch (UnknownHostException e) {
            return UnresolvableHostManager.getPseudoAddress(address);
        }
    }

    protected int addressToInt(InetAddress address) {
        return PRHelpers.addressToInt(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRebuild() {
        try {
            long now;
            long secs_since_last_build;
            this.this_mon.enter();
            if (this.rebuild_required && (secs_since_last_build = ((now = SystemTime.getCurrentTime()) - this.last_rebuild_time) / 1000L) > (long)(this.entries.size() / 2000)) {
                this.last_rebuild_time = now;
                this.rebuild_required = false;
                this.rebuild();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void rebuild() {
        int i;
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "IPAddressRangeManager: rebuilding " + this.entries.size() + " entries starts"));
        }
        IpRange[] ents = new IpRange[this.entries.size()];
        this.entries.toArray(ents);
        for (int i2 = 0; i2 < ents.length; ++i2) {
            ents[i2].resetMergeInfo();
        }
        Arrays.sort(ents, new Comparator(){

            public int compare(Object o1, Object o2) {
                IpRange e1 = (IpRange)o1;
                IpRange e2 = (IpRange)o2;
                long diff = e1.getStartIpLong() - e2.getStartIpLong();
                if (diff == 0L) {
                    diff = e2.getEndIpLong() - e1.getEndIpLong();
                }
                return IPAddressRangeManager.this.signum(diff);
            }

            public boolean equals(Object obj) {
                return false;
            }
        });
        ArrayList<IpRange> me = new ArrayList<IpRange>(ents.length);
        block1: for (i = 0; i < ents.length; ++i) {
            IpRange entry = ents[i];
            if (entry.getMerged()) continue;
            me.add(entry);
            int pos = i + 1;
            while (pos < ents.length) {
                IpRange e2;
                long end_pos = entry.getMergedEndLong();
                if ((e2 = ents[pos++]).getMerged()) continue;
                if (end_pos < e2.getStartIpLong()) continue block1;
                e2.setMerged();
                if (e2.getEndIpLong() <= end_pos) continue;
                entry.setMergedEnd(e2.getEndIpLong());
                entry.addMergedEntry(e2);
            }
        }
        this.mergedRanges = new IpRange[me.size()];
        me.toArray(this.mergedRanges);
        this.total_span = 0L;
        for (i = 0; i < this.mergedRanges.length; ++i) {
            IpRange e = this.mergedRanges[i];
            long span = e.getMergedEndLong() - e.getStartIpLong() + 1L;
            this.total_span += span;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "IPAddressRangeManager: rebuilding " + this.entries.size() + " entries ends"));
        }
    }

    protected int signum(long diff) {
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return 0;
    }

    protected long getTotalSpan() {
        this.checkRebuild();
        return this.total_span;
    }

    public static void main(String[] args) {
        IPAddressRangeManager manager = new IPAddressRangeManager();
        Random r = new Random();
        for (int i = 0; i < 1000000; ++i) {
            int ip1 = r.nextInt(0xFFFFFFF);
            int ip2 = ip1 + r.nextInt(255);
            String start = PRHelpers.intToAddress(ip1);
            String end = PRHelpers.intToAddress(ip2);
            manager.addRange(new IpRangeImpl("test_" + i, start, end, true));
        }
        int num = 0;
        int hits = 0;
        while (true) {
            if (num % 1000 == 0) {
                System.out.println(num + "/" + hits);
            }
            ++num;
            int ip = r.nextInt();
            Object res = manager.isInRange(ip);
            if (res == null) continue;
            ++hits;
        }
    }

    public ArrayList getEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllEntries() {
        try {
            this.this_mon.enter();
            this.entries.clear();
            IpFilterManagerFactory.getSingleton().deleteAllDescriptions();
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }
}

