/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.peers.PeerDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface PEPeerManager {
    public DiskManager getDiskManager();

    public PiecePicker getPiecePicker();

    public PEPeerManagerAdapter getAdapter();

    public void start();

    public void stopAll();

    public byte[] getHash();

    public String getDisplayName();

    public PeerIdentityDataID getPeerIdentityDataID();

    public byte[] getPeerId();

    public int[] getAvailability();

    public int getAvailability(int var1);

    public float getAvgAvail();

    public float getMinAvailability();

    public long getAvailWentBadTime();

    public boolean hasDownloadablePiece();

    public PEPiece[] getPieces();

    public PEPiece getPiece(int var1);

    public PEPeerManagerStats getStats();

    public void processTrackerResponse(TRTrackerAnnouncerResponse var1);

    public int getNbPeers();

    public int getNbSeeds();

    public int getPieceLength(int var1);

    public long getRemaining();

    public long getHiddenBytes();

    public long getETA();

    public String getElapsedTime();

    public long getTimeStarted();

    public long getTimeStartedSeeding();

    public void addListener(PEPeerManagerListener var1);

    public void removeListener(PEPeerManagerListener var1);

    public void addPiece(PEPiece var1, int var2);

    public boolean needsMD5CheckOnCompletion(int var1);

    public boolean isSeeding();

    public boolean isSuperSeedMode();

    public boolean canToggleSuperSeedMode();

    public void setSuperSeedMode(boolean var1);

    public boolean seedPieceRecheck();

    public int getNbRemoteConnectionsExcludingUDP();

    public long getLastRemoteConnectionTime();

    public int getMaxNewConnectionsAllowed();

    public boolean hasPotentialConnections();

    public void dataBytesReceived(PEPeer var1, int var2);

    public void dataBytesSent(PEPeer var1, int var2);

    public void protocolBytesSent(PEPeer var1, int var2);

    public void protocolBytesReceived(PEPeer var1, int var2);

    public void discarded(PEPeer var1, int var2);

    public PEPeerStats createPeerStats(PEPeer var1);

    public List<PEPeer> getPeers();

    public List<PEPeer> getPeers(String var1);

    public PeerDescriptor[] getPendingPeers();

    public PeerDescriptor[] getPendingPeers(String var1);

    public void addPeer(PEPeer var1);

    public void addPeer(String var1, int var2, int var3, boolean var4, Map var5);

    public void removePeer(PEPeer var1);

    public void removePeer(PEPeer var1, String var2);

    public void peerAdded(PEPeer var1);

    public void peerRemoved(PEPeer var1);

    public DiskManagerReadRequest createDiskManagerRequest(int var1, int var2, int var3);

    public void requestCanceled(DiskManagerReadRequest var1);

    public boolean requestExists(String var1, int var2, int var3, int var4);

    public boolean validatePieceReply(PEPeerTransport var1, int var2, int var3, DirectByteBuffer var4);

    public void writeBlock(int var1, int var2, DirectByteBuffer var3, PEPeer var4, boolean var5);

    public boolean isWritten(int var1, int var2);

    public boolean isInEndGameMode();

    public void peerConnectionClosed(PEPeerTransport var1, boolean var2, boolean var3);

    public PeerExchangerItem createPeerExchangeConnection(PEPeerTransport var1);

    public void peerVerifiedAsSelf(PEPeerTransport var1);

    public LimitedRateGroup getUploadLimitedRateGroup();

    public LimitedRateGroup getDownloadLimitedRateGroup();

    public int getUploadRateLimitBytesPerSecond();

    public int getDownloadRateLimitBytesPerSecond();

    public Object getData(String var1);

    public void setData(String var1, Object var2);

    public int getAverageCompletionInThousandNotation();

    public PEPeerTransport getTransportFromIdentity(byte[] var1);

    public PEPeerTransport getTransportFromAddress(String var1);

    public boolean getPreferUDP();

    public void setPreferUDP(boolean var1);

    public void addRateLimiter(LimitedRateGroup var1, boolean var2);

    public void removeRateLimiter(LimitedRateGroup var1, boolean var2);

    public boolean isPeerSourceEnabled(String var1);

    public int getPartitionID();

    public void generateEvidence(IndentWriter var1);
}

