/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.transfer.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class OverallStatsImpl
extends GlobalManagerAdapter
implements OverallStats {
    private static final long TEN_YEARS = 315360000L;
    private static final long STATS_PERIOD = 60000L;
    private AzureusCore core;
    private long totalDownloaded;
    private long totalUploaded;
    private long totalUptime;
    private long lastDownloaded;
    private long lastUploaded;
    private long lastUptime;
    private long totalProtocolUploaded;
    private long totalDataUploaded;
    private long totalProtocolDownloaded;
    private long totalDataDownloaded;
    private long lastProtocolUploaded;
    private long lastDataUploaded;
    private long lastProtocolDownloaded;
    private long lastDataDownloaded;
    private long session_start_time = SystemTime.getCurrentTime();
    protected AEMonitor this_mon = new AEMonitor("OverallStats");
    private int tick_count;

    private Map load(String filename) {
        return FileUtil.readResilientConfigFile(filename);
    }

    private Map load() {
        return this.load("azureus.statistics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String filename, Map map) {
        try {
            this.this_mon.enter();
            FileUtil.writeResilientConfigFile(filename, map);
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void save(Map map) {
        this.save("azureus.statistics", map);
    }

    private void validateAndLoadValues(Map statisticsMap) {
        this.lastUptime = SystemTime.getCurrentTime() / 1000L;
        Map overallMap = (Map)statisticsMap.get("all");
        this.totalDownloaded = this.getLong(overallMap, "downloaded");
        this.totalUploaded = this.getLong(overallMap, "uploaded");
        this.totalUptime = this.getLong(overallMap, "uptime");
        this.totalProtocolUploaded = this.getLong(overallMap, "p_uploaded");
        this.totalDataUploaded = this.getLong(overallMap, "d_uploaded");
        this.totalProtocolDownloaded = this.getLong(overallMap, "p_downloaded");
        this.totalDataDownloaded = this.getLong(overallMap, "d_downloaded");
    }

    protected long getLong(Map map, String name) {
        if (map == null) {
            return 0L;
        }
        Object obj = map.get(name);
        if (!(obj instanceof Long)) {
            return 0L;
        }
        return (Long)obj;
    }

    public OverallStatsImpl(AzureusCore _core) {
        this.core = _core;
        Map stats = this.load();
        this.validateAndLoadValues(stats);
        HashSet<String> types = new HashSet<String>();
        types.add("xfer.upload.protocol.bytes.total");
        types.add("xfer.upload.data.bytes.total");
        types.add("xfer.download.protocol.bytes.total");
        types.add("xfer.download.data.bytes.total");
        AzureusCoreStats.registerProvider(types, new AzureusCoreStatsProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void updateStats(Set types, Map values) {
                try {
                    GlobalManagerStats stats = OverallStatsImpl.this.core.getGlobalManager().getStats();
                    OverallStatsImpl.this.this_mon.enter();
                    if (types.contains("xfer.upload.protocol.bytes.total")) {
                        values.put("xfer.upload.protocol.bytes.total", new Long(OverallStatsImpl.this.totalProtocolUploaded + (stats.getTotalProtocolBytesSent() - OverallStatsImpl.this.lastProtocolUploaded)));
                    }
                    if (types.contains("xfer.upload.data.bytes.total")) {
                        values.put("xfer.upload.data.bytes.total", new Long(OverallStatsImpl.this.totalDataUploaded + (stats.getTotalDataBytesSent() - OverallStatsImpl.this.lastDataUploaded)));
                    }
                    if (types.contains("xfer.download.protocol.bytes.total")) {
                        values.put("xfer.download.protocol.bytes.total", new Long(OverallStatsImpl.this.totalProtocolDownloaded + (stats.getTotalProtocolBytesReceived() - OverallStatsImpl.this.lastProtocolDownloaded)));
                    }
                    if (types.contains("xfer.download.data.bytes.total")) {
                        values.put("xfer.download.data.bytes.total", new Long(OverallStatsImpl.this.totalDataDownloaded + (stats.getTotalDataBytesReceived() - OverallStatsImpl.this.lastDataDownloaded)));
                    }
                }
                finally {
                    OverallStatsImpl.this.this_mon.exit();
                }
            }
        });
        this.core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                if (component instanceof GlobalManager) {
                    GlobalManager gm = (GlobalManager)component;
                    gm.addListener(OverallStatsImpl.this, false);
                    SimpleTimer.addPeriodicEvent("OverallStats", 60000L, new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            OverallStatsImpl.this.updateStats(false);
                        }
                    });
                }
            }
        });
    }

    public int getAverageDownloadSpeed() {
        if (this.totalUptime > 1L) {
            return (int)(this.totalDownloaded / this.totalUptime);
        }
        return 0;
    }

    public int getAverageUploadSpeed() {
        if (this.totalUptime > 1L) {
            return (int)(this.totalUploaded / this.totalUptime);
        }
        return 0;
    }

    public long getDownloadedBytes() {
        return this.totalDownloaded;
    }

    public long getUploadedBytes() {
        return this.totalUploaded;
    }

    public long getTotalUpTime() {
        return this.totalUptime;
    }

    public long getSessionUpTime() {
        return (SystemTime.getCurrentTime() - this.session_start_time) / 1000L;
    }

    public void destroyInitiated() {
        this.updateStats(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStats(boolean force) {
        try {
            long delta;
            this.this_mon.enter();
            long current_time = SystemTime.getCurrentTime() / 1000L;
            if (current_time < this.lastUptime) {
                this.lastUptime = current_time;
                return;
            }
            GlobalManagerStats stats = this.core.getGlobalManager().getStats();
            long current_total_d_received = stats.getTotalDataBytesReceived();
            long current_total_p_received = stats.getTotalProtocolBytesReceived();
            long current_total_d_sent = stats.getTotalDataBytesSent();
            long current_total_p_sent = stats.getTotalProtocolBytesSent();
            long current_total_received = current_total_d_received + current_total_p_received;
            long current_total_sent = current_total_d_sent + current_total_p_sent;
            this.totalDownloaded += current_total_received - this.lastDownloaded;
            this.lastDownloaded = current_total_received;
            if (this.totalDownloaded < 0L) {
                this.totalDownloaded = 0L;
            }
            this.totalUploaded += current_total_sent - this.lastUploaded;
            this.lastUploaded = current_total_sent;
            if (this.totalUploaded < 0L) {
                this.totalUploaded = 0L;
            }
            this.totalDataDownloaded += current_total_d_received - this.lastDataDownloaded;
            this.lastDataDownloaded = current_total_d_received;
            if (this.totalDataDownloaded < 0L) {
                this.totalDataDownloaded = 0L;
            }
            this.totalProtocolDownloaded += current_total_p_received - this.lastProtocolDownloaded;
            this.lastProtocolDownloaded = current_total_p_received;
            if (this.totalProtocolDownloaded < 0L) {
                this.totalProtocolDownloaded = 0L;
            }
            this.totalDataUploaded += current_total_d_sent - this.lastDataUploaded;
            this.lastDataUploaded = current_total_d_sent;
            if (this.totalDataUploaded < 0L) {
                this.totalDataUploaded = 0L;
            }
            this.totalProtocolUploaded += current_total_p_sent - this.lastProtocolUploaded;
            this.lastProtocolUploaded = current_total_p_sent;
            if (this.totalProtocolUploaded < 0L) {
                this.totalProtocolUploaded = 0L;
            }
            if ((delta = current_time - this.lastUptime) > 100L || delta < 0L) {
                this.lastUptime = current_time;
                return;
            }
            if (this.totalUptime > 315360000L) {
                this.totalUptime = 0L;
            }
            if (this.totalUptime < 0L) {
                this.totalUptime = 0L;
            }
            this.totalUptime += delta;
            this.lastUptime = current_time;
            ++this.tick_count;
            HashMap<String, Long> overallMap = new HashMap<String, Long>();
            overallMap.put("downloaded", new Long(this.totalDownloaded));
            overallMap.put("uploaded", new Long(this.totalUploaded));
            overallMap.put("uptime", new Long(this.totalUptime));
            overallMap.put("p_uploaded", new Long(this.totalProtocolUploaded));
            overallMap.put("d_uploaded", new Long(this.totalDataUploaded));
            overallMap.put("p_downloaded", new Long(this.totalProtocolDownloaded));
            overallMap.put("d_downloaded", new Long(this.totalDataDownloaded));
            HashMap<String, HashMap<String, Long>> map = new HashMap<String, HashMap<String, Long>>();
            map.put("all", overallMap);
            this.save(map);
        }
        finally {
            this.this_mon.exit();
        }
    }
}

