/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentImpl;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;

public class TOTorrentXMLSerialiser
extends XUXmlWriter {
    protected TOTorrentImpl torrent;

    protected TOTorrentXMLSerialiser(TOTorrentImpl _torrent) {
        this.torrent = _torrent;
    }

    protected void serialiseToFile(File file) throws TOTorrentException {
        this.resetIndent();
        try {
            this.setOutputStream(new FileOutputStream(file));
            this.writeRoot();
        }
        catch (IOException e) {
            throw new TOTorrentException("TOTorrentXMLSerialiser: file write fails: " + e.toString(), 5);
        }
        finally {
            try {
                this.closeOutputStream();
            }
            catch (Throwable e) {
                throw new TOTorrentException("TOTorrentXMLSerialiser: file close fails: " + e.toString(), 5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRoot() throws TOTorrentException {
        this.writeLineRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writeLineRaw("<tor:TORRENT");
        this.writeLineRaw("\txmlns:tor=\"http://azureus.sourceforge.net/files\"");
        this.writeLineRaw("\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        this.writeLineRaw("\txsi:schemaLocation=\"http://azureus.sourceforge.net/files http://azureus.sourceforge.net/files/torrent.xsd\">");
        try {
            byte[] created_by;
            long creation_date;
            byte[] comment;
            this.indent();
            this.writeTag("ANNOUNCE_URL", this.torrent.getAnnounceURL().toString());
            TOTorrentAnnounceURLSet[] sets = this.torrent.getAnnounceURLGroup().getAnnounceURLSets();
            if (sets.length > 0) {
                this.writeLineRaw("<ANNOUNCE_LIST>");
                try {
                    this.indent();
                    for (int i = 0; i < sets.length; ++i) {
                        TOTorrentAnnounceURLSet set = sets[i];
                        URL[] urls = set.getAnnounceURLs();
                        this.writeLineRaw("<ANNOUNCE_ENTRY>");
                        try {
                            this.indent();
                            for (int j = 0; j < urls.length; ++j) {
                                this.writeTag("ANNOUNCE_URL", urls[j].toString());
                            }
                        }
                        finally {
                            this.exdent();
                        }
                        this.writeLineRaw("</ANNOUNCE_ENTRY>");
                    }
                }
                finally {
                    this.exdent();
                }
                this.writeLineRaw("</ANNOUNCE_LIST>");
            }
            if ((comment = this.torrent.getComment()) != null) {
                this.writeLocalisableTag("COMMENT", comment);
            }
            if ((creation_date = this.torrent.getCreationDate()) != 0L) {
                this.writeTag("CREATION_DATE", creation_date);
            }
            if ((created_by = this.torrent.getCreatedBy()) != null) {
                this.writeLocalisableTag("CREATED_BY", created_by);
            }
            this.writeTag("TORRENT_HASH", this.torrent.getHash());
            byte[] hash_override = this.torrent.getHashOverride();
            if (hash_override != null) {
                this.writeTag("TORRENT_HASH_OVERRIDE", hash_override);
            }
            this.writeInfo();
            Map additional_properties = this.torrent.getAdditionalProperties();
            for (String key : additional_properties.keySet()) {
                this.writeGenericMapEntry(key, additional_properties.get(key));
            }
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</tor:TORRENT>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInfo() throws TOTorrentException {
        this.writeLineRaw("<INFO>");
        try {
            this.indent();
            this.writeLocalisableTag("NAME", this.torrent.getName());
            this.writeTag("PIECE_LENGTH", this.torrent.getPieceLength());
            TOTorrentFileImpl[] files = (TOTorrentFileImpl[])this.torrent.getFiles();
            if (this.torrent.isSimpleTorrent()) {
                this.writeTag("LENGTH", files[0].getLength());
            } else {
                this.writeLineRaw("<FILES>");
                try {
                    this.indent();
                    for (int i = 0; i < files.length; ++i) {
                        this.writeLineRaw("<FILE>");
                        try {
                            this.indent();
                            TOTorrentFileImpl file = files[i];
                            this.writeTag("LENGTH", file.getLength());
                            this.writeLineRaw("<PATH>");
                            try {
                                this.indent();
                                byte[][] path_comps = file.getPathComponents();
                                for (int j = 0; j < path_comps.length; ++j) {
                                    this.writeLocalisableTag("COMPONENT", path_comps[j]);
                                }
                            }
                            finally {
                                this.exdent();
                            }
                            this.writeLineRaw("</PATH>");
                            Map additional_properties = file.getAdditionalProperties();
                            for (String key : additional_properties.keySet()) {
                                this.writeGenericMapEntry(key, additional_properties.get(key));
                            }
                        }
                        finally {
                            this.exdent();
                        }
                        this.writeLineRaw("</FILE>");
                    }
                }
                finally {
                    this.exdent();
                }
                this.writeLineRaw("</FILES>");
            }
            this.writeLineRaw("<PIECES>");
            try {
                this.indent();
                byte[][] pieces = this.torrent.getPieces();
                for (int i = 0; i < pieces.length; ++i) {
                    this.writeGeneric(pieces[i]);
                }
            }
            finally {
                this.exdent();
            }
            this.writeLineRaw("</PIECES>");
            Map additional_properties = this.torrent.getAdditionalInfoProperties();
            for (String key : additional_properties.keySet()) {
                this.writeGenericMapEntry(key, additional_properties.get(key));
            }
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</INFO>");
    }
}

