/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrentdownloader.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.util.protocol.magnet.MagnetConnection;

public class TorrentDownloaderImpl
extends AEThread
implements TorrentDownloader {
    private String original_url;
    private String url_str;
    private String referrer;
    private Map request_properties;
    private String file_str;
    private URL url;
    private HttpURLConnection con;
    private String error = "Ok";
    private String status = "";
    private TorrentDownloaderCallBackInterface iface;
    private int state = -1;
    private int percentDone = 0;
    private int readTotal = 0;
    private boolean cancel = false;
    private String filename;
    private String directoryname;
    private File file = null;
    private byte[] buf = new byte[1020];
    private int bufBytes = 0;
    private boolean deleteFileOnCancel = true;
    private boolean ignoreReponseCode = false;
    private AEMonitor this_mon = new AEMonitor("TorrentDownloader");
    private int errCode;

    public TorrentDownloaderImpl() {
        super("Torrent Downloader");
        this.setDaemon(true);
    }

    public void init(TorrentDownloaderCallBackInterface _iface, String _url, String _referrer, Map _request_properties, String _file) {
        this.iface = _iface;
        this.original_url = _url;
        _url = _url.replace('\\', '/');
        _url = _url.replaceAll(" ", "%20");
        this.setName("TorrentDownloader: " + _url);
        this.url_str = _url;
        this.referrer = _referrer;
        this.request_properties = _request_properties;
        this.file_str = _file;
    }

    public void notifyListener() {
        if (this.iface != null) {
            this.iface.TorrentDownloaderEvent(this.state, this);
        } else if (this.state == 4) {
            System.err.println(this.error);
        }
    }

    private void cleanUpFile() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(int errCode, String err) {
        try {
            this.this_mon.enter();
            this.state = 4;
            this.setError(errCode, err);
            this.cleanUpFile();
            this.notifyListener();
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSupport() {
        block71: {
            block68: {
                try {
                    new URL(this.url_str);
                }
                catch (Throwable t) {
                    if (this.url_str.length() != 40) break block68;
                    try {
                        byte[] infohash = ByteFormatter.decodeString(this.url_str.toUpperCase());
                        this.url_str = "magnet:?xt=urn:btih:" + Base32.encode(infohash);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            try {
                this.url = AddressUtils.adjustURL(new URL(this.url_str));
                String protocol = this.url.getProtocol().toLowerCase();
                if (protocol.equals("magnet") || protocol.equals("dht")) {
                    this.url = AddressUtils.adjustURL(new URL(this.url_str + "&pause_on_error=true"));
                }
                for (int i = 0; i < 2; ++i) {
                    try {
                        if (protocol.equals("https")) {
                            HttpsURLConnection ssl_con = (HttpsURLConnection)this.url.openConnection();
                            ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                public boolean verify(String host, SSLSession session) {
                                    return true;
                                }
                            });
                            this.con = ssl_con;
                        } else {
                            this.con = (HttpURLConnection)this.url.openConnection();
                        }
                        this.con.setRequestProperty("User-Agent", "Azureus 4.2.0.8");
                        if (this.referrer != null && this.referrer.length() > 0) {
                            this.con.setRequestProperty("Referer", this.referrer);
                        }
                        if (this.request_properties != null) {
                            for (Map.Entry entry : this.request_properties.entrySet()) {
                                String key = (String)entry.getKey();
                                String value = (String)entry.getValue();
                                if (key.equalsIgnoreCase("Accept-Encoding")) continue;
                                this.con.setRequestProperty(key, value);
                            }
                        }
                        this.con.connect();
                        break;
                    }
                    catch (SSLException e) {
                        if (i == 0 && SESecurityManager.installServerCertificates(this.url) != null) continue;
                        throw e;
                    }
                    catch (IOException e) {
                        if (i != 0) continue;
                        URL retry_url = UrlUtils.getIPV4Fallback(this.url);
                        if (retry_url != null) {
                            this.url = retry_url;
                            continue;
                        }
                        throw e;
                    }
                }
                int response = this.con.getResponseCode();
                if (!this.ignoreReponseCode && response != 202 && response != 200) {
                    this.error(response, Integer.toString(response) + ": " + this.con.getResponseMessage());
                    return;
                }
                this.filename = this.con.getHeaderField("Content-Disposition");
                if (this.filename != null && this.filename.toLowerCase().matches(".*attachment.*")) {
                    while (this.filename.toLowerCase().charAt(0) != 'a') {
                        this.filename = this.filename.substring(1);
                    }
                }
                if (this.filename == null || !this.filename.toLowerCase().startsWith("attachment") || this.filename.indexOf(61) == -1) {
                    String tmp = this.url.getFile();
                    if (tmp.length() == 0 || tmp.equals("/")) {
                        this.filename = this.url.getHost();
                    } else if (tmp.startsWith("?")) {
                        int p2;
                        String query = tmp.toUpperCase();
                        int pos = query.indexOf("XT=URN:SHA1:");
                        if (pos == -1) {
                            pos = query.indexOf("XT=URN:BTIH:");
                        }
                        this.filename = pos != -1 ? ((p2 = query.indexOf("&", pos += 12)) == -1 ? query.substring(pos) : query.substring(pos, p2)) : "Torrent" + (long)(Math.random() * 9.223372036854776E18);
                        this.filename = this.filename + ".tmp";
                    } else {
                        int param_pos;
                        if (tmp.lastIndexOf(47) != -1) {
                            tmp = tmp.substring(tmp.lastIndexOf(47) + 1);
                        }
                        if ((param_pos = tmp.indexOf(63)) != -1) {
                            tmp = tmp.substring(0, param_pos);
                        }
                        this.filename = URLDecoder.decode(tmp, "UTF8");
                    }
                } else {
                    this.filename = this.filename.substring(this.filename.indexOf(61) + 1);
                    if (this.filename.startsWith("\"") && this.filename.endsWith("\"")) {
                        this.filename = this.filename.substring(1, this.filename.lastIndexOf(34));
                    }
                    this.filename = URLDecoder.decode(this.filename, "UTF8");
                    File temp = new File(this.filename);
                    this.filename = temp.getName();
                }
                this.filename = FileUtil.convertOSSpecificChars(this.filename, false);
                this.directoryname = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
                boolean useTorrentSave = COConfigurationManager.getBooleanParameter("Save Torrent Files");
                if (this.file_str != null) {
                    File temp = new File(this.file_str);
                    if (!useTorrentSave || this.directoryname.length() == 0) {
                        this.directoryname = temp.isDirectory() ? temp.getCanonicalPath() : temp.getCanonicalFile().getParent();
                    }
                    if (!temp.isDirectory()) {
                        this.filename = temp.getName();
                    }
                }
                this.state = 0;
                this.notifyListener();
            }
            catch (MalformedURLException e) {
                this.error(0, "Exception while parsing URL '" + this.url + "':" + e.getMessage());
            }
            catch (UnknownHostException e) {
                this.error(0, "Exception while initializing download of '" + this.url + "': Unknown Host '" + e.getMessage() + "'");
            }
            catch (IOException ioe) {
                this.error(0, "I/O Exception while initializing download of '" + this.url + "':" + ioe.toString());
            }
            catch (Throwable e) {
                this.error(0, "Exception while initializing download of '" + this.url + "':" + e.toString());
            }
            if (this.state == 4) {
                return;
            }
            try {
                InputStream in;
                block69: {
                    final boolean[] status_reader_run = new boolean[]{true};
                    this.state = 1;
                    this.notifyListener();
                    this.state = 2;
                    this.notifyListener();
                    AEThread status_reader = new AEThread("TorrentDownloader:statusreader"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runSupport() {
                            boolean changed_status = false;
                            try {
                                while (true) {
                                    block9: {
                                        Thread.sleep(250L);
                                        try {
                                            TorrentDownloaderImpl.this.this_mon.enter();
                                            if (status_reader_run[0]) break block9;
                                            break;
                                        }
                                        finally {
                                            TorrentDownloaderImpl.this.this_mon.exit();
                                        }
                                    }
                                    String s = TorrentDownloaderImpl.this.con.getResponseMessage();
                                    if (s.equals(TorrentDownloaderImpl.this.getStatus())) continue;
                                    if (!s.toLowerCase().startsWith("error:")) {
                                        TorrentDownloaderImpl.this.setStatus(s);
                                    } else {
                                        TorrentDownloaderImpl.this.error(TorrentDownloaderImpl.this.con.getResponseCode(), s.substring(6));
                                    }
                                    changed_status = true;
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            if (changed_status) {
                                TorrentDownloaderImpl.this.setStatus("");
                            }
                        }
                    };
                    status_reader.setDaemon(true);
                    status_reader.start();
                    try {
                        in = this.con.getInputStream();
                    }
                    catch (FileNotFoundException e) {
                        if (this.ignoreReponseCode) {
                            in = this.con.getErrorStream();
                            break block69;
                        }
                        throw e;
                    }
                    finally {
                        try {
                            this.this_mon.enter();
                            status_reader_run[0] = false;
                        }
                        finally {
                            this.this_mon.exit();
                        }
                    }
                }
                if (this.state == 4) break block71;
                this.file = new File(this.directoryname, this.filename);
                boolean useTempFile = false;
                try {
                    this.file.createNewFile();
                    useTempFile = !this.file.exists();
                }
                catch (Throwable t) {
                    useTempFile = true;
                }
                if (useTempFile) {
                    this.file = File.createTempFile("AZU", ".torrent", new File(this.directoryname));
                    this.file.createNewFile();
                }
                FileOutputStream fileout = new FileOutputStream(this.file, false);
                this.bufBytes = 0;
                int size = this.con.getContentLength();
                this.percentDone = -1;
                while (!this.cancel) {
                    try {
                        this.bufBytes = in.read(this.buf);
                        this.readTotal += this.bufBytes;
                        if (size != 0) {
                            this.percentDone = 100 * this.readTotal / size;
                        }
                        this.notifyListener();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (this.bufBytes > 0) {
                        fileout.write(this.buf, 0, this.bufBytes);
                    }
                    if (this.bufBytes > 0) continue;
                }
                in.close();
                fileout.flush();
                fileout.close();
                if (this.cancel) {
                    this.state = 6;
                    if (this.deleteFileOnCancel) {
                        this.cleanUpFile();
                    }
                } else {
                    if (this.readTotal <= 0) {
                        this.error(0, "No data contained in '" + this.url.toString() + "'");
                        return;
                    }
                    try {
                        TOTorrent torrent;
                        String name;
                        File new_file;
                        if (!this.filename.toLowerCase().endsWith(".torrent") && this.file.renameTo(new_file = new File(this.directoryname, name = TorrentUtils.getLocalisedName(torrent = TorrentUtils.readFromFile(this.file, false)) + ".torrent"))) {
                            this.filename = name;
                            this.file = new_file;
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    TorrentUtils.setObtainedFrom(this.file, this.original_url);
                    this.state = 3;
                }
                this.notifyListener();
            }
            catch (Exception e) {
                if (!this.cancel) {
                    Debug.out("'" + this.directoryname + "' '" + this.filename + "'", e);
                }
                this.error(0, "Exception while downloading '" + this.url.toString() + "':" + e.getMessage());
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TorrentDownloaderImpl) {
            TorrentDownloaderImpl other = (TorrentDownloaderImpl)obj;
            if (other.getURL().equals(this.url.toString())) {
                File this_file;
                File other_file = other.getFile();
                if (other_file == (this_file = this.file)) {
                    return true;
                }
                if (other_file == null || this_file == null) {
                    return false;
                }
                return other_file.getAbsolutePath().equals(this_file.getAbsolutePath());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String getError() {
        return this.error;
    }

    public void setError(int errCode, String err) {
        this.error = err;
        this.errCode = errCode;
    }

    public int getErrorCode() {
        return this.errCode;
    }

    protected void setStatus(String str) {
        this.status = str;
        this.notifyListener();
    }

    public String getStatus() {
        return this.status;
    }

    public File getFile() {
        if (!this.isAlive() || this.file == null) {
            this.file = new File(this.directoryname, this.filename);
        }
        return this.file;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public int getDownloadState() {
        return this.state;
    }

    public void setDownloadState(int state) {
        this.state = state;
    }

    public String getURL() {
        return this.url.toString();
    }

    public void cancel() {
        this.cancel = true;
        if (this.con instanceof MagnetConnection) {
            this.con.disconnect();
        }
    }

    public void setDownloadPath(String path, String file) {
        if (!this.isAlive()) {
            if (path != null) {
                this.directoryname = path;
            }
            if (file != null) {
                this.filename = file;
            }
        }
    }

    public int getTotalRead() {
        return this.readTotal;
    }

    public byte[] getLastReadBytes() {
        if (this.bufBytes <= 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[this.bufBytes];
        System.arraycopy(this.buf, 0, bytes, 0, this.bufBytes);
        return bytes;
    }

    public int getLastReadCount() {
        return this.bufBytes;
    }

    public void setDeleteFileOnCancel(boolean deleteFileOnCancel) {
        this.deleteFileOnCancel = deleteFileOnCancel;
    }

    public boolean getDeleteFileOnCancel() {
        return this.deleteFileOnCancel;
    }

    public boolean isIgnoreReponseCode() {
        return this.ignoreReponseCode;
    }

    public void setIgnoreReponseCode(boolean ignoreReponseCode) {
        this.ignoreReponseCode = ignoreReponseCode;
    }
}

