/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerFactoryImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketTracker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPTrackerCodecs;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class TRTrackerBTAnnouncerImpl
extends TRTrackerAnnouncerImpl {
    private static final int OVERRIDE_PERIOD = 10000;
    protected static Timer tracker_timer = new Timer("Tracker Timer", 32);
    public static String UDP_REALM = "UDP Tracker";
    private static int userMinInterval = 0;
    private static int userMaxNumwant = 100;
    private static boolean udpAnnounceEnabled = true;
    private static AEMonitor class_mon;
    private static Map tracker_report_map;
    private TOTorrent torrent;
    private TimerEvent current_timer_event;
    private TimerEventPerformer timer_event_action;
    protected int tracker_state = 1;
    private String tracker_status_str = "";
    private TRTrackerAnnouncerResponseImpl last_response = null;
    private long last_update_time_secs;
    private long current_time_to_wait_secs;
    private boolean manual_control;
    private long min_interval = 0L;
    private int failure_added_time = 0;
    private long failure_time_last_updated = 0L;
    private boolean stopped;
    private boolean stopped_for_queue;
    private boolean completed;
    private boolean complete_reported = false;
    private boolean update_in_progress = false;
    private long rd_last_override = 0L;
    private int rd_override_percentage = 100;
    private long min_interval_override = 0L;
    private List trackerUrlLists;
    private URL lastUsedUrl;
    private URL lastAZTrackerCheckedURL;
    private HashWrapper torrent_hash;
    private String last_tracker_message;
    private String info_hash = "info_hash=";
    private byte[] tracker_peer_id;
    private String tracker_peer_id_str = "&peer_id=";
    private byte[] data_peer_id;
    private String key_id = "";
    private static final int key_id_length = 8;
    private int key_udp;
    private int announceCount;
    private int announceFailCount;
    private byte autoUDPprobeEvery = 1;
    private String tracker_id = "";
    private String ip_override;
    private String[] peer_networks;
    private TRTrackerAnnouncerDataProvider announce_data_provider;
    protected AEMonitor this_mon = new AEMonitor("TRTrackerBTAnnouncer");
    private boolean az_tracker;
    private boolean destroyed;
    static final String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static String createKeyID() {
        String key_id = "";
        for (int i = 0; i < 8; ++i) {
            int pos = (int)(Math.random() * (double)chars.length());
            key_id = key_id + chars.charAt(pos);
        }
        return key_id;
    }

    public TRTrackerBTAnnouncerImpl(TOTorrent _torrent, String[] _peer_networks, boolean _manual) throws TRTrackerAnnouncerException {
        super(_torrent);
        this.torrent = _torrent;
        this.peer_networks = _peer_networks;
        this.manual_control = _manual;
        this.constructTrackerUrlLists(true);
        try {
            this.tracker_peer_id = ClientIDManagerImpl.getSingleton().generatePeerID(this.torrent, true);
            this.data_peer_id = COConfigurationManager.getBooleanParameter("Tracker Separate Peer IDs") ? ClientIDManagerImpl.getSingleton().generatePeerID(this.torrent, false) : this.tracker_peer_id;
        }
        catch (ClientIDException e) {
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Peer ID generation fails", e);
        }
        this.key_id = TRTrackerBTAnnouncerImpl.createKeyID();
        this.key_udp = (int)(Math.random() * 4.294967295E9);
        try {
            this.torrent_hash = _torrent.getHashWrapper();
            this.info_hash = this.info_hash + URLEncoder.encode(new String(this.torrent_hash.getBytes(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
            this.tracker_peer_id_str = this.tracker_peer_id_str + URLEncoder.encode(new String(this.tracker_peer_id, "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            Logger.log(new LogEvent((Object)this.torrent, LOGID, "URL encode fails", (Throwable)e));
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: URL encode fails");
        }
        catch (TOTorrentException e) {
            Logger.log(new LogEvent((Object)this.torrent, LOGID, "Torrent hash retrieval fails", (Throwable)e));
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: URL encode fails");
        }
        this.timer_event_action = new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void perform(TimerEvent this_event) {
                if (TRTrackerBTAnnouncerImpl.access$300(TRTrackerBTAnnouncerImpl.this)) {
                    TRTrackerBTAnnouncerImpl.this.requestUpdateSupport();
                    return;
                }
                secs_to_wait = TRTrackerBTAnnouncerImpl.this.getErrorRetryInterval();
                try {
                    secs_to_wait = TRTrackerBTAnnouncerImpl.this.requestUpdateSupport();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(TRTrackerBTAnnouncerImpl.access$400(TRTrackerBTAnnouncerImpl.this), TRTrackerAnnouncerImpl.LOGID, "Next tracker announce (unadjusted) will be in " + secs_to_wait + "s"));
                    }
                    var5_3 = null;
                }
                catch (Throwable var4_9) {
                    var5_4 = null;
                    TRTrackerBTAnnouncerImpl.access$502(TRTrackerBTAnnouncerImpl.this, secs_to_wait);
                    if (TRTrackerBTAnnouncerImpl.this.tracker_state != 4) {
                        block17: {
                            block18: {
                                block19: {
                                    try {
                                        TRTrackerBTAnnouncerImpl.this.this_mon.enter();
                                        if (this_event.isCancelled()) break block17;
                                        secs_to_wait = TRTrackerBTAnnouncerImpl.this.getAdjustedSecsToWait();
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent(TRTrackerBTAnnouncerImpl.access$400(TRTrackerBTAnnouncerImpl.this), TRTrackerAnnouncerImpl.LOGID, "Next tracker announce (adjusted) will be in " + secs_to_wait + "s"));
                                        }
                                        target_time = SystemTime.getCurrentTime() + secs_to_wait * 1000L;
                                        if (TRTrackerBTAnnouncerImpl.access$600(TRTrackerBTAnnouncerImpl.this) == null || TRTrackerBTAnnouncerImpl.access$600(TRTrackerBTAnnouncerImpl.this).isCancelled()) break block18;
                                        if (TRTrackerBTAnnouncerImpl.access$600(TRTrackerBTAnnouncerImpl.this) == this_event || TRTrackerBTAnnouncerImpl.access$600(TRTrackerBTAnnouncerImpl.this).getWhen() >= target_time) break block19;
                                        TRTrackerBTAnnouncerImpl.this.this_mon.exit();
                                        return;
                                    }
lbl29:
                                    // 2 sources

                                    catch (Throwable var8_8) {
                                        TRTrackerBTAnnouncerImpl.this.this_mon.exit();
                                        throw var8_8;
                                    }
                                }
                                ** try [egrp 2[TRYBLOCK] [3 : 275->312)] { 
lbl34:
                                // 1 sources

                                TRTrackerBTAnnouncerImpl.access$600(TRTrackerBTAnnouncerImpl.this).cancel();
                            }
                            if (!TRTrackerBTAnnouncerImpl.access$700(TRTrackerBTAnnouncerImpl.this)) {
                                TRTrackerBTAnnouncerImpl.access$602(TRTrackerBTAnnouncerImpl.this, TRTrackerBTAnnouncerImpl.tracker_timer.addEvent(target_time, this));
                            }
                        }
                        TRTrackerBTAnnouncerImpl.this.this_mon.exit();
                    }
                    throw var4_9;
                }
                TRTrackerBTAnnouncerImpl.access$502(TRTrackerBTAnnouncerImpl.this, secs_to_wait);
                if (TRTrackerBTAnnouncerImpl.this.tracker_state != 4) {
                    try {
                        TRTrackerBTAnnouncerImpl.this.this_mon.enter();
                        if (this_event.isCancelled()) {
                        }
                        secs_to_wait = TRTrackerBTAnnouncerImpl.this.getAdjustedSecsToWait();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(TRTrackerBTAnnouncerImpl.access$400(TRTrackerBTAnnouncerImpl.this), TRTrackerAnnouncerImpl.LOGID, "Next tracker announce (adjusted) will be in " + secs_to_wait + "s"));
                        }
                        target_time = SystemTime.getCurrentTime() + secs_to_wait * 1000L;
                        if (TRTrackerBTAnnouncerImpl.access$600(TRTrackerBTAnnouncerImpl.this) != null && !TRTrackerBTAnnouncerImpl.access$600(TRTrackerBTAnnouncerImpl.this).isCancelled()) {
                            if (TRTrackerBTAnnouncerImpl.access$600(TRTrackerBTAnnouncerImpl.this) != this_event && TRTrackerBTAnnouncerImpl.access$600(TRTrackerBTAnnouncerImpl.this).getWhen() < target_time) {
                                return;
                            }
                            TRTrackerBTAnnouncerImpl.access$600(TRTrackerBTAnnouncerImpl.this).cancel();
                        }
                        if (TRTrackerBTAnnouncerImpl.access$700(TRTrackerBTAnnouncerImpl.this)) ** GOTO lbl66
                        TRTrackerBTAnnouncerImpl.access$602(TRTrackerBTAnnouncerImpl.this, TRTrackerBTAnnouncerImpl.tracker_timer.addEvent(target_time, this));
                    }
                    finally {
                        TRTrackerBTAnnouncerImpl.this.this_mon.exit();
                    }
                }
            }
        };
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer Created using url : " + this.trackerURLListToString()));
        }
    }

    public void cloneFrom(TRTrackerAnnouncer _other) {
        if (_other instanceof TRTrackerBTAnnouncerImpl) {
            TRTrackerBTAnnouncerImpl other = (TRTrackerBTAnnouncerImpl)_other;
            this.data_peer_id = other.data_peer_id;
            this.tracker_peer_id = other.tracker_peer_id;
            this.tracker_peer_id_str = other.tracker_peer_id_str;
            this.tracker_id = other.tracker_id;
            this.key_id = other.key_id;
            this.key_udp = other.key_udp;
            this.announce_data_provider = other.announce_data_provider;
        } else {
            Debug.out("Incompatible type");
        }
    }

    protected long getAdjustedSecsToWait() {
        long secs_to_wait = this.current_time_to_wait_secs;
        if (this.last_response != null && this.last_response.getStatus() != 2) {
            if (this.last_response.getStatus() == 1) {
                if (this.failure_added_time < 900) {
                    this.failure_added_time = 900;
                }
                secs_to_wait = this.getErrorRetryInterval();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: tracker reported error, adjusting to error retry interval"));
                }
            } else {
                secs_to_wait = this.getErrorRetryInterval();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: tracker seems to be offline, adjusting to error retry interval"));
                }
            }
        } else {
            if (this.rd_override_percentage == 0) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: override, perc = 0"));
                }
                return 60L;
            }
            if (this.rd_override_percentage != 100) {
                secs_to_wait = secs_to_wait * (long)this.rd_override_percentage / 100L;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: override, perc = " + this.rd_override_percentage));
                }
            }
            if (secs_to_wait < 60L) {
                secs_to_wait = 60L;
            }
            if (this.min_interval != 0L && secs_to_wait < this.min_interval) {
                float percentage = (float)this.min_interval / (float)this.current_time_to_wait_secs;
                int added_secs = (int)((float)(this.min_interval - secs_to_wait) * percentage);
                secs_to_wait += (long)added_secs;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: min_interval=" + this.min_interval + ", interval=" + this.current_time_to_wait_secs + ", orig=" + this.current_time_to_wait_secs + ", new=" + secs_to_wait + ", added=" + added_secs + ", perc=" + percentage));
                }
            }
        }
        return secs_to_wait;
    }

    public int getStatus() {
        return this.tracker_state;
    }

    public String getStatusString() {
        return this.tracker_status_str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefreshDelayOverrides(int percentage) {
        boolean override_allowed;
        if (percentage > 100) {
            percentage = 100;
        } else if (percentage < 50) {
            percentage = 50;
        }
        long now = SystemTime.getCurrentTime();
        boolean bl = override_allowed = this.rd_last_override > 0L && now - this.rd_last_override > 10000L;
        if (now < this.rd_last_override) {
            override_allowed = true;
        }
        if (override_allowed && this.rd_override_percentage != percentage) {
            try {
                this.this_mon.enter();
                this.rd_last_override = now;
                this.rd_override_percentage = percentage;
                if (this.current_timer_event != null && !this.current_timer_event.isCancelled()) {
                    long start = this.current_timer_event.getCreatedTime();
                    long expiry = this.current_timer_event.getWhen();
                    long secs_to_wait = this.getAdjustedSecsToWait();
                    long target_time = start + secs_to_wait * 1000L;
                    if (target_time != expiry) {
                        this.current_timer_event.cancel();
                        if (!this.destroyed) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "Changed next tracker announce to " + secs_to_wait + "s via " + Debug.getStackTrace(true, false, 0, 3)));
                            }
                            this.current_timer_event = tracker_timer.addEvent(start, target_time, this.timer_event_action);
                        }
                    }
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimeUntilNextUpdate() {
        try {
            int rem;
            this.this_mon.enter();
            if (this.current_timer_event == null) {
                int n = this.getErrorRetryInterval();
                return n;
            }
            int n = rem = (int)((this.current_timer_event.getWhen() - SystemTime.getCurrentTime()) / 1000L);
            return n;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public int getLastUpdateTime() {
        return (int)this.last_update_time_secs;
    }

    public void update(boolean force) {
        long effective_min;
        long now = SystemTime.getCurrentTime() / 1000L;
        if (now < this.last_update_time_secs) {
            force = true;
        }
        long l = effective_min = this.min_interval_override > 0L ? this.min_interval_override : 60L;
        if (this.manual_control || force || now - this.last_update_time_secs >= effective_min) {
            this.requestUpdate();
        }
    }

    public void complete(boolean already_reported) {
        this.complete_reported = this.complete_reported || already_reported;
        this.completed = true;
        this.requestUpdate();
    }

    public void stop(boolean for_queue) {
        this.stopped = true;
        this.stopped_for_queue = for_queue;
        this.requestUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestUpdate() {
        try {
            this.this_mon.enter();
            if (this.current_timer_event != null) {
                this.current_timer_event.cancel();
            }
            this.rd_last_override = SystemTime.getCurrentTime();
            if (!this.destroyed) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Forcing tracker announce now via " + Debug.getStackTrace(true, false, 0, 3)));
                }
                this.current_timer_event = tracker_timer.addEvent(SystemTime.getCurrentTime(), this.timer_event_action);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long requestUpdateSupport() {
        boolean clear_progress = true;
        try {
            try {
                this.this_mon.enter();
                if (this.update_in_progress || this.announce_data_provider == null) {
                    clear_progress = false;
                    long l = this.getErrorRetryInterval();
                    return l;
                }
                this.update_in_progress = true;
            }
            finally {
                this.this_mon.exit();
            }
            this.last_update_time_secs = SystemTime.getCurrentTime() / 1000L;
            this.tracker_status_str = MessageText.getString("PeerManager.status.checking") + "...";
            TRTrackerAnnouncerResponseImpl response = null;
            if (this.stopped) {
                if (this.tracker_state == 1 && !this.manual_control) {
                    this.tracker_state = 4;
                } else if (this.tracker_state != 4) {
                    response = this.stopSupport();
                    this.tracker_state = response.getStatus() == 2 ? 4 : 4;
                }
            } else if (this.tracker_state == 1) {
                response = this.startSupport();
                if (response.getStatus() == 2) {
                    this.tracker_state = 2;
                }
            } else if (this.completed) {
                if (!this.complete_reported) {
                    response = this.completeSupport();
                    if (response.getStatus() != 0) {
                        this.complete_reported = true;
                        this.tracker_state = 3;
                    }
                } else {
                    this.tracker_state = 3;
                    response = this.updateSupport();
                }
            } else {
                response = this.updateSupport();
            }
            if (response != null) {
                int rs = response.getStatus();
                if (rs == 0) {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.offline");
                } else if (rs == 1) {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.error");
                    this.tracker_state = 1;
                } else if (this.announce_data_provider.isPeerSourceEnabled("Tracker")) {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.ok");
                } else {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.ps_disabled");
                    response.setPeers(new TRTrackerAnnouncerResponsePeerImpl[0]);
                }
                String reason = response.getAdditionalInfo();
                if (reason != null) {
                    this.tracker_status_str = this.tracker_status_str + " (" + reason + ")";
                }
                this.last_response = response;
                this.listeners.dispatch(1, response);
                long l = response.getTimeToWait();
                return l;
            }
            this.tracker_status_str = "";
            long l = this.getErrorRetryInterval();
            return l;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            long l = this.getErrorRetryInterval();
            return l;
        }
        finally {
            try {
                this.this_mon.enter();
                if (clear_progress) {
                    this.update_in_progress = false;
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected TRTrackerAnnouncerResponseImpl startSupport() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending a start Request"));
        }
        return this.update("started");
    }

    protected TRTrackerAnnouncerResponseImpl completeSupport() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending a completed Request"));
        }
        return this.update("completed");
    }

    protected TRTrackerAnnouncerResponseImpl stopSupport() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending a stopped Request"));
        }
        return this.update("stopped");
    }

    protected TRTrackerAnnouncerResponseImpl updateSupport() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending an update Request"));
        }
        return this.update("");
    }

    private TRTrackerAnnouncerResponseImpl update(String evt) {
        TRTrackerAnnouncerResponseImpl resp = this.update2(evt);
        TRTrackerAnnouncerResponsePeer[] peers = resp.getPeers();
        if (peers != null) {
            ArrayList<TRTrackerAnnouncerResponsePeer> p = new ArrayList<TRTrackerAnnouncerResponsePeer>();
            for (int i = 0; i < peers.length; ++i) {
                TRTrackerAnnouncerResponsePeer peer = peers[i];
                if (this.peer_networks == null) {
                    p.add(peer);
                    continue;
                }
                String peer_address = peer.getAddress();
                String peer_network = AENetworkClassifier.categoriseAddress(peer_address);
                boolean added = false;
                for (int j = 0; j < this.peer_networks.length; ++j) {
                    if (this.peer_networks[j] != peer_network) continue;
                    p.add(peer);
                    added = true;
                    break;
                }
                if (added || !Logger.isEnabled()) continue;
                Logger.log(new LogEvent((Object)this.torrent, LOGID, 1, "Tracker Announcer dropped peer '" + peer_address + "' as incompatible " + "with network selection"));
            }
            peers = new TRTrackerAnnouncerResponsePeer[p.size()];
            p.toArray(peers);
            resp.setPeers(peers);
        }
        return resp;
    }

    private TRTrackerAnnouncerResponseImpl update2(String evt) {
        int num_want;
        TRTrackerAnnouncerResponsePeer[] cached_peers;
        TRTrackerAnnouncerResponseImpl last_failure_resp = null;
        String skip_host = null;
        block5: for (int i = 0; i < this.trackerUrlLists.size(); ++i) {
            List urls = (List)this.trackerUrlLists.get(i);
            for (int j = 0; j < urls.size(); ++j) {
                URL original_url = (URL)urls.get(j);
                if (skip_host != null && skip_host.equals(original_url.getHost())) {
                    if (!Logger.isEnabled()) continue;
                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 1, "Tracker Announcer is ignoring '" + original_url + "' as already received overloaded response from this host"));
                    continue;
                }
                this.lastUsedUrl = original_url;
                if (this.lastUsedUrl != this.lastAZTrackerCheckedURL) {
                    this.az_tracker = TRTrackerUtils.isAZTracker(this.lastUsedUrl);
                }
                URL request_url = null;
                try {
                    request_url = this.constructUrl(evt, original_url);
                    URL[] tracker_url = new URL[]{original_url};
                    byte[] result_bytes = this.updateOld(tracker_url, request_url);
                    this.lastUsedUrl = tracker_url[0];
                    TRTrackerAnnouncerResponseImpl resp = this.decodeTrackerResponse(this.lastUsedUrl, result_bytes);
                    int resp_status = resp.getStatus();
                    if (resp_status == 2) {
                        try {
                            if (!original_url.toString().equals(this.lastUsedUrl.toString())) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(this.torrent, LOGID, "announce url permanently redirected: old = " + original_url + ", new = " + this.lastUsedUrl));
                                }
                                TorrentUtils.replaceAnnounceURL(this.torrent, original_url, this.lastUsedUrl);
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        urls.remove(j);
                        urls.add(0, this.lastUsedUrl);
                        this.trackerUrlLists.remove(i);
                        this.trackerUrlLists.add(0, urls);
                        this.informURLChange(original_url, this.lastUsedUrl, false);
                        return resp;
                    }
                    if (resp_status == 1) {
                        last_failure_resp = resp;
                        String reason = resp.getAdditionalInfo();
                        if (reason != null && (reason.indexOf("too many seeds") != -1 || reason.indexOf("too many peers") != -1)) {
                            skip_host = original_url.getHost();
                        }
                    } else {
                        ++this.announceFailCount;
                        last_failure_resp = resp;
                    }
                }
                catch (MalformedURLException e) {
                    ++this.announceFailCount;
                    Debug.printStackTrace(e);
                    last_failure_resp = new TRTrackerAnnouncerResponseImpl(original_url, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), "malformed URL '" + (request_url == null ? "<null>" : request_url.toString()) + "'");
                }
                catch (Throwable e) {
                    ++this.announceFailCount;
                    last_failure_resp = new TRTrackerAnnouncerResponseImpl(original_url, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), e.getMessage() == null ? e.toString() : e.getMessage());
                }
                if (this.destroyed) break block5;
            }
        }
        if (last_failure_resp == null) {
            last_failure_resp = new TRTrackerAnnouncerResponseImpl(null, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), "Reason Unknown");
        }
        if ((cached_peers = this.getPeersFromCache(num_want = this.calculateNumWant() * 4)).length > 0) {
            last_failure_resp.setPeers(cached_peers);
        }
        return last_failure_resp;
    }

    private byte[] updateOld(URL[] tracker_url, URL reqUrl) throws Exception {
        try {
            TorrentUtils.setTLSTorrentHash(this.torrent_hash);
            for (int i = 0; i < 2; ++i) {
                String protocol;
                String failure_reason;
                block29: {
                    failure_reason = null;
                    protocol = reqUrl.getProtocol();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is Requesting: " + reqUrl));
                    }
                    ByteArrayOutputStream message = new ByteArrayOutputStream();
                    URL udpAnnounceURL = null;
                    boolean udp_probe = false;
                    if (protocol.equalsIgnoreCase("udp") && udpAnnounceEnabled) {
                        udpAnnounceURL = reqUrl;
                    } else if (protocol.equalsIgnoreCase("http") && !this.az_tracker && this.announceCount % this.autoUDPprobeEvery == 0 && udpAnnounceEnabled && (!this.stopped && this.announceCount != 0 && (this.announceCount >= this.trackerUrlLists.size() || this.announceFailCount != this.announceCount) || TRTrackerUtils.isUDPProbeOK(reqUrl))) {
                        udpAnnounceURL = new URL(reqUrl.toString().replaceFirst("^http", "udp"));
                        udp_probe = true;
                    }
                    if (udpAnnounceURL != null) {
                        failure_reason = this.announceUDP(reqUrl, message, udp_probe);
                        if ((failure_reason != null || message.size() == 0) && udp_probe) {
                            udpAnnounceURL = null;
                            if (this.autoUDPprobeEvery < 16) {
                                this.autoUDPprobeEvery = (byte)(this.autoUDPprobeEvery << 1);
                            } else {
                                TRTrackerUtils.setUDPProbeResult(reqUrl, false);
                            }
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "redirection of http announce [" + tracker_url[0] + "] to udp failed, will retry in " + this.autoUDPprobeEvery + " announces"));
                            }
                        } else if (failure_reason == null && udp_probe) {
                            TRTrackerUtils.setUDPProbeResult(reqUrl, true);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "redirection of http announce [" + tracker_url[0] + "] to udp successful"));
                            }
                            this.autoUDPprobeEvery = 1;
                        }
                    }
                    ++this.announceCount;
                    if (udpAnnounceURL == null) {
                        failure_reason = this.announceHTTP(tracker_url, reqUrl, message);
                    }
                    if (message.size() <= 0) break block29;
                    byte[] byArray = message.toByteArray();
                    return byArray;
                }
                try {
                    if (failure_reason == null) {
                        failure_reason = "No data received from tracker";
                    }
                }
                catch (SSLException e) {
                    if (i == 0) {
                        if (SESecurityManager.installServerCertificates(reqUrl) != null) continue;
                        failure_reason = this.exceptionToString(e);
                    } else {
                        failure_reason = this.exceptionToString(e);
                    }
                }
                catch (IOException e) {
                    URL retry_url;
                    if (i == 0 && protocol.toLowerCase().startsWith("http") && (retry_url = UrlUtils.getIPV4Fallback(reqUrl)) != null) {
                        reqUrl = retry_url;
                        continue;
                    }
                    failure_reason = this.exceptionToString(e);
                }
                catch (Exception e) {
                    failure_reason = this.exceptionToString(e);
                }
                if (failure_reason != null && failure_reason.indexOf("401") != -1) {
                    failure_reason = "Tracker authentication failed";
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Exception while processing the Tracker Request for " + reqUrl + ": " + failure_reason));
                }
                throw new Exception(failure_reason);
            }
            throw new Exception("Internal Error: should never get here");
        }
        finally {
            TorrentUtils.setTLSTorrentHash(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String announceHTTP(URL[] tracker_url, URL original_reqUrl, ByteArrayOutputStream message) throws IOException {
        HttpURLConnection con;
        TRTrackerUtils.checkForBlacklistedURLs(original_reqUrl);
        URL reqUrl = TRTrackerUtils.adjustURLForHosting(original_reqUrl);
        reqUrl = AddressUtils.adjustURL(reqUrl);
        if (reqUrl != original_reqUrl && Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "    HTTP: url adjusted to " + reqUrl));
        }
        String failure_reason = null;
        Properties http_properties = new Properties();
        http_properties.put("URL", reqUrl);
        try {
            ClientIDManagerImpl.getSingleton().generateHTTPProperties(http_properties);
        }
        catch (ClientIDException e) {
            throw new IOException(e.getMessage());
        }
        reqUrl = (URL)http_properties.get("URL");
        if (reqUrl.getProtocol().equalsIgnoreCase("https")) {
            HttpsURLConnection ssl_con = (HttpsURLConnection)reqUrl.openConnection();
            ssl_con.setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String host, SSLSession session) {
                    return true;
                }
            });
            con = ssl_con;
        } else {
            con = (HttpURLConnection)reqUrl.openConnection();
        }
        String user_agent = (String)http_properties.get("User-Agent");
        if (user_agent != null) {
            con.setRequestProperty("User-Agent", user_agent);
        }
        con.setRequestProperty("Connection", "close");
        con.addRequestProperty("Accept-Encoding", "gzip");
        try {
            con.connect();
            InputStream is = null;
            try {
                String encoding;
                boolean gzip;
                String marker;
                int pos;
                is = con.getInputStream();
                String resulting_url_str = con.getURL().toString();
                if (!reqUrl.toString().equals(resulting_url_str) && (pos = resulting_url_str.indexOf(marker = "permredirect=1")) != -1) {
                    --pos;
                    try {
                        URL redirect_url;
                        tracker_url[0] = redirect_url = new URL(resulting_url_str.substring(0, pos));
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                boolean bl = gzip = (encoding = con.getHeaderField("content-encoding")) != null && encoding.equalsIgnoreCase("gzip");
                if (gzip) {
                    is = new GZIPInputStream(is);
                }
                int content_length = -1;
                byte[] data = new byte[1024];
                int num_read = 0;
                while (content_length <= 0 || num_read < content_length) {
                    try {
                        int len = is.read(data);
                        if (len > 0) {
                            message.write(data, 0, len);
                            if ((num_read += len) <= 131072) continue;
                            message.reset();
                            throw new Exception("Tracker response invalid (too large)");
                        }
                        if (len != 0) break;
                        Thread.sleep(20L);
                    }
                    catch (Exception e) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent((Object)this.torrent, LOGID, "Exception while Requesting Tracker", (Throwable)e));
                            Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Message Received was : " + message));
                        }
                        failure_reason = this.exceptionToString(e);
                        break;
                    }
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer [" + this.lastUsedUrl + "] has received : " + message));
                }
            }
            catch (Exception e) {
                failure_reason = this.exceptionToString(e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                    is = null;
                }
            }
        }
        finally {
            con.disconnect();
        }
        return failure_reason;
    }

    protected String announceUDP(URL original_reqUrl, ByteArrayOutputStream message, boolean is_probe) throws IOException {
        long timeout = is_probe ? 10000L : 30000L;
        URL reqUrl = TRTrackerUtils.adjustURLForHosting(original_reqUrl);
        if (reqUrl != original_reqUrl && Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "    UDP: url adjusted to " + reqUrl));
        }
        String failure_reason = null;
        PasswordAuthentication auth = null;
        try {
            if (!is_probe && UrlUtils.queryHasParameter(reqUrl.getQuery(), "auth", false)) {
                auth = SESecurityManager.getPasswordAuthentication(UDP_REALM, reqUrl);
            }
            PRUDPPacketHandler handler = PRUDPPacketHandlerFactory.getHandler(UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber());
            InetSocketAddress destination = new InetSocketAddress(reqUrl.getHost(), reqUrl.getPort() == -1 ? 80 : reqUrl.getPort());
            for (int retry_loop = 0; retry_loop < 1; ++retry_loop) {
                try {
                    PRUDPPacketRequestConnect connect_request = new PRUDPPacketRequestConnect();
                    PRUDPPacket reply = handler.sendAndReceive(auth, connect_request, destination, timeout);
                    if (reply.getAction() == 0) {
                        int ip;
                        String ip_str;
                        int event2;
                        String event_str;
                        int p_pos;
                        String url_str;
                        PRUDPPacketRequest request2;
                        PRUDPPacketRequest announce_request;
                        PRUDPPacketReplyConnect connect_reply = (PRUDPPacketReplyConnect)reply;
                        long my_connection = connect_reply.getConnectionId();
                        if (PRUDPPacketTracker.VERSION == 1) {
                            request2 = announce_request = new PRUDPPacketRequestAnnounce(my_connection);
                            url_str = reqUrl.toString();
                            p_pos = url_str.indexOf("?");
                            url_str = url_str.substring(p_pos + 1);
                            event_str = this.getURLParam(url_str, "event");
                            event2 = 0;
                            if (event_str != null) {
                                if (event_str.equals("started")) {
                                    event2 = 2;
                                } else if (event_str.equals("stopped")) {
                                    event2 = 3;
                                } else if (event_str.equals("completed")) {
                                    event2 = 1;
                                }
                            }
                            ip_str = this.getURLParam(url_str, "ip");
                            ip = 0;
                            if (ip_str != null) {
                                ip = PRHelpers.addressToInt(ip_str);
                            }
                            ((PRUDPPacketRequestAnnounce)announce_request).setDetails(this.torrent_hash.getBytes(), this.tracker_peer_id, this.getLongURLParam(url_str, "downloaded"), event2, ip, (int)this.getLongURLParam(url_str, "numwant"), this.getLongURLParam(url_str, "left"), (short)this.getLongURLParam(url_str, "port"), this.getLongURLParam(url_str, "uploaded"));
                        } else {
                            request2 = announce_request = new PRUDPPacketRequestAnnounce2(my_connection);
                            url_str = reqUrl.toString();
                            p_pos = url_str.indexOf("?");
                            url_str = url_str.substring(p_pos + 1);
                            event_str = this.getURLParam(url_str, "event");
                            event2 = 0;
                            if (event_str != null) {
                                if (event_str.equals("started")) {
                                    event2 = 2;
                                } else if (event_str.equals("stopped")) {
                                    event2 = 3;
                                } else if (event_str.equals("completed")) {
                                    event2 = 1;
                                }
                            }
                            ip_str = this.getURLParam(url_str, "ip");
                            ip = 0;
                            if (ip_str != null) {
                                ip = PRHelpers.addressToInt(ip_str);
                            }
                            ((PRUDPPacketRequestAnnounce2)announce_request).setDetails(this.torrent_hash.getBytes(), this.tracker_peer_id, this.getLongURLParam(url_str, "downloaded"), event2, ip, this.key_udp, (int)this.getLongURLParam(url_str, "numwant"), this.getLongURLParam(url_str, "left"), (short)this.getLongURLParam(url_str, "port"), this.getLongURLParam(url_str, "uploaded"));
                        }
                        reply = handler.sendAndReceive(auth, request2, destination);
                        if (reply.getAction() == 1) {
                            short[] ports;
                            HashMap<String, Serializable> map;
                            PRUDPPacketReply announce_reply;
                            if (auth != null) {
                                SESecurityManager.setPasswordAuthenticationOutcome(UDP_REALM, reqUrl, true);
                            }
                            if (PRUDPPacketTracker.VERSION == 1) {
                                announce_reply = (PRUDPPacketReplyAnnounce)reply;
                                map = new HashMap<String, Serializable>();
                                map.put("interval", new Long(((PRUDPPacketReplyAnnounce)announce_reply).getInterval()));
                                int[] addresses = ((PRUDPPacketReplyAnnounce)announce_reply).getAddresses();
                                ports = ((PRUDPPacketReplyAnnounce)announce_reply).getPorts();
                                ArrayList peers = new ArrayList();
                                map.put("peers", peers);
                                for (int i = 0; i < addresses.length; ++i) {
                                    HashMap<String, Object> peer = new HashMap<String, Object>();
                                    peers.add(peer);
                                    peer.put("ip", PRHelpers.intToAddress(addresses[i]).getBytes());
                                    peer.put("port", new Long(ports[i]));
                                }
                                byte[] data = BEncoder.encode(map);
                                message.write(data);
                                return null;
                            }
                            announce_reply = (PRUDPPacketReplyAnnounce2)reply;
                            map = new HashMap();
                            map.put("interval", new Long(((PRUDPPacketReplyAnnounce2)announce_reply).getInterval()));
                            int[] addresses = ((PRUDPPacketReplyAnnounce2)announce_reply).getAddresses();
                            ports = ((PRUDPPacketReplyAnnounce2)announce_reply).getPorts();
                            map.put("complete", new Long(((PRUDPPacketReplyAnnounce2)announce_reply).getSeeders()));
                            map.put("incomplete", new Long(((PRUDPPacketReplyAnnounce2)announce_reply).getLeechers()));
                            ArrayList peers = new ArrayList();
                            map.put("peers", peers);
                            for (int i = 0; i < addresses.length; ++i) {
                                HashMap<String, Object> peer = new HashMap<String, Object>();
                                peers.add(peer);
                                peer.put("ip", PRHelpers.intToAddress(addresses[i]).getBytes());
                                peer.put("port", new Long(ports[i]));
                            }
                            byte[] data = BEncoder.encode(map);
                            message.write(data);
                            return null;
                        }
                        failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                        continue;
                    }
                    failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                    continue;
                }
                catch (PRUDPPacketHandlerException e) {
                    if (e.getMessage() != null && e.getMessage().indexOf("timed out") != -1) continue;
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            failure_reason = this.exceptionToString(e);
        }
        if (auth != null) {
            SESecurityManager.setPasswordAuthenticationOutcome(UDP_REALM, reqUrl, false);
        }
        return failure_reason;
    }

    protected long getLongURLParam(String url, String param) {
        String val = this.getURLParam(url, param);
        if (val == null) {
            return 0L;
        }
        return Long.parseLong(val);
    }

    protected String getURLParam(String url, String param) {
        int p1 = url.indexOf(param + "=");
        if (p1 == -1) {
            return null;
        }
        int p2 = url.indexOf("&", p1);
        if (p2 == -1) {
            return url.substring(p1 + param.length() + 1);
        }
        return url.substring(p1 + param.length() + 1, p2);
    }

    protected String exceptionToString(Throwable e) {
        String str;
        String class_name = e.getClass().getName();
        int pos = class_name.lastIndexOf(46);
        if (pos != -1) {
            class_name = class_name.substring(pos + 1);
        }
        if ((str = class_name + ":" + e.getMessage()).indexOf("timed out") != -1) {
            str = "timeout";
        }
        return str;
    }

    public URL constructUrl(String evt, URL _url) throws Exception {
        String ext;
        boolean stopped;
        String url = _url.toString();
        StringBuffer request2 = new StringBuffer(url);
        if (url.indexOf(63) != -1) {
            request2.append('&');
        } else {
            request2.append('?');
        }
        request2.append(this.info_hash);
        request2.append(this.tracker_peer_id_str);
        String port_details = this.announce_data_provider.getCryptoLevel() == 1 ? TRTrackerUtils.getPortsForURLFullCrypto() : TRTrackerUtils.getPortsForURL();
        request2.append(port_details);
        request2.append("&uploaded=").append(this.announce_data_provider.getTotalSent());
        request2.append("&downloaded=").append(this.announce_data_provider.getTotalReceived());
        request2.append("&left=").append(this.announce_data_provider.getRemaining());
        request2.append("&corrupt=").append(this.announce_data_provider.getFailedHashCheck());
        if (this.tracker_id.length() > 0) {
            request2.append("&trackerid=").append(this.tracker_id);
        }
        if (evt.length() != 0) {
            request2.append("&event=").append(evt);
        }
        if (stopped = evt.equals("stopped")) {
            request2.append("&numwant=0");
            if (this.stopped_for_queue) {
                request2.append("&azq=1");
            }
        } else {
            int numwant = Math.min(this.calculateNumWant(), userMaxNumwant);
            request2.append("&numwant=").append(numwant);
        }
        request2.append("&no_peer_id=1");
        request2.append("&compact=1");
        String explicit_ips = COConfigurationManager.getStringParameter("Override Ip", "");
        String ip = null;
        String tracker_network = AENetworkClassifier.categoriseAddress(_url.getHost());
        boolean network_ok = false;
        boolean normal_network_ok = false;
        if (this.peer_networks == null) {
            network_ok = true;
            normal_network_ok = true;
        } else {
            for (int i = 0; i < this.peer_networks.length; ++i) {
                if (this.peer_networks[i] == "Public") {
                    normal_network_ok = true;
                }
                if (this.peer_networks[i] != tracker_network) continue;
                network_ok = true;
            }
        }
        if (!network_ok) {
            throw new Exception("Network not enabled for url '" + _url + "'");
        }
        String normal_explicit = null;
        if (explicit_ips.length() > 0) {
            StringTokenizer tok = new StringTokenizer(explicit_ips, ";");
            while (tok.hasMoreTokens()) {
                String this_address = tok.nextToken().trim();
                if (this_address.length() <= 0) continue;
                String cat = AENetworkClassifier.categoriseAddress(this_address);
                if (cat == "Public") {
                    normal_explicit = this_address;
                }
                if (tracker_network != cat) continue;
                ip = this_address;
                break;
            }
        }
        if (ip == null) {
            if (normal_network_ok && normal_explicit != null) {
                ip = normal_explicit;
            } else if (this.ip_override != null) {
                ip = this.ip_override;
            }
        }
        if (ip != null) {
            block32: {
                if (tracker_network == "Public") {
                    try {
                        ip = PRHelpers.DNSToIPAddress(ip);
                    }
                    catch (UnknownHostException e) {
                        if (!Logger.isEnabled()) break block32;
                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "IP Override host resolution of '" + ip + "' fails, using unresolved address"));
                    }
                }
            }
            request2.append("&ip=").append(ip);
        }
        if (COConfigurationManager.getBooleanParameter("Tracker Key Enable Client", true)) {
            request2.append("&key=").append(this.key_id);
        }
        if ((ext = this.announce_data_provider.getExtensions()) != null) {
            while (ext.startsWith("&")) {
                ext = ext.substring(1);
            }
            request2.append("&");
            request2.append(ext);
        }
        request2.append("&azver=3");
        if (this.az_tracker && !stopped) {
            DHTNetworkPosition best_position;
            String as;
            int up = this.announce_data_provider.getUploadSpeedKBSec(evt.equals("started"));
            if (up > 0) {
                request2.append("&azup=" + up);
            }
            if ((as = NetworkAdmin.getSingleton().getCurrentASN().getAS()).length() > 0) {
                request2.append("&azas=" + URLEncoder.encode(as, "UTF8"));
            }
            if ((best_position = DHTNetworkPositionManager.getBestLocalPosition()) != null) {
                try {
                    byte[] bytes = DHTNetworkPositionManager.serialisePosition(best_position);
                    request2.append("&aznp=" + Base32.encode(bytes));
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        return new URL(request2.toString());
    }

    protected int calculateNumWant() {
        if (!this.announce_data_provider.isPeerSourceEnabled("Tracker")) {
            return 0;
        }
        int MAX_PEERS = 100;
        int maxAllowed = this.announce_data_provider.getMaxNewConnectionsAllowed();
        if (maxAllowed < 0 || maxAllowed > MAX_PEERS) {
            maxAllowed = MAX_PEERS;
        }
        return maxAllowed;
    }

    public byte[] getPeerId() {
        return this.data_peer_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnnounceDataProvider(TRTrackerAnnouncerDataProvider _provider) {
        try {
            this.this_mon.enter();
            this.announce_data_provider = _provider;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public URL getTrackerUrl() {
        return this.lastUsedUrl;
    }

    public void setTrackerUrl(URL new_url) {
        try {
            new_url = new URL(new_url.toString().replaceAll(" ", ""));
            ArrayList<URL> list = new ArrayList<URL>(1);
            list.add(new_url);
            this.trackerUrlLists.clear();
            this.trackerUrlLists.add(list);
            this.informURLChange(this.lastUsedUrl, new_url, true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void resetTrackerUrl(boolean shuffle) {
        String old_list = this.trackerURLListToString();
        this.constructTrackerUrlLists(shuffle);
        if (this.trackerUrlLists.size() == 0) {
            return;
        }
        if (!old_list.equals(this.trackerURLListToString())) {
            URL first_url = (URL)((List)this.trackerUrlLists.get(0)).get(0);
            this.informURLChange(this.lastUsedUrl, first_url, true);
        }
    }

    public void refreshListeners() {
        this.informURLRefresh();
    }

    public void setIPOverride(String override) {
        this.ip_override = override;
    }

    public void clearIPOverride() {
        this.ip_override = null;
    }

    private void constructTrackerUrlLists(boolean shuffle) {
        try {
            this.trackerUrlLists = new ArrayList(1);
            TOTorrentAnnounceURLSet[] announce_sets = this.torrent.getAnnounceURLGroup().getAnnounceURLSets();
            if (announce_sets.length == 0) {
                URL url = this.torrent.getAnnounceURL();
                ArrayList<URL> list = new ArrayList<URL>();
                list.add(url);
                this.trackerUrlLists.add(list);
            } else {
                for (int i = 0; i < announce_sets.length; ++i) {
                    URL[] urls = announce_sets[i].getAnnounceURLs();
                    ArrayList<URL> random_urls = new ArrayList<URL>();
                    for (int j = 0; j < urls.length; ++j) {
                        URL url = urls[j];
                        int pos = shuffle ? (int)(Math.random() * (double)(random_urls.size() + 1)) : j;
                        random_urls.add(pos, url);
                    }
                    this.trackerUrlLists.add(random_urls);
                }
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    protected String trackerURLListToString() {
        String trackerUrlListString = "[";
        for (int i = 0; i < this.trackerUrlLists.size(); ++i) {
            List group = (List)this.trackerUrlLists.get(i);
            trackerUrlListString = trackerUrlListString + (i == 0 ? "" : ",") + "[";
            for (int j = 0; j < group.size(); ++j) {
                URL u = (URL)group.get(j);
                trackerUrlListString = trackerUrlListString + (j == 0 ? "" : ",") + u.toString();
            }
            trackerUrlListString = trackerUrlListString + "]";
        }
        trackerUrlListString = trackerUrlListString + "]";
        return trackerUrlListString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerAnnouncerResponseImpl decodeTrackerResponse(URL url, byte[] data) {
        String failure_reason;
        if (data == null) {
            failure_reason = "no response";
        } else {
            try {
                try {
                    byte[] v6peers;
                    int entry_size;
                    int i;
                    int peers_length;
                    ArrayList meta_peers;
                    boolean this_is_az_tracker;
                    byte[] trackerid;
                    long time_to_wait;
                    Map metaData;
                    block98: {
                        metaData = BDecoder.decode(data);
                        Object o = metaData.get("az_ps");
                        if (o instanceof List) {
                            List peer_sources = (List)o;
                            ArrayList<String> x = new ArrayList<String>();
                            for (int i2 = 0; i2 < peer_sources.size(); ++i2) {
                                Object o1 = peer_sources.get(i2);
                                if (!(o1 instanceof byte[])) continue;
                                x.add(new String((byte[])o1));
                            }
                            String[] y = new String[x.size()];
                            x.toArray(y);
                            this.announce_data_provider.setPeerSources(y);
                        }
                        try {
                            String warning_message;
                            byte[] b_warning_message = (byte[])metaData.get("warning message");
                            if (b_warning_message == null || !COConfigurationManager.getBooleanParameter("Tracker Client Show Warnings") || (warning_message = new String(b_warning_message)).equals(this.last_tracker_message)) break block98;
                            this.last_tracker_message = warning_message;
                            boolean log_it = false;
                            try {
                                class_mon.enter();
                                String last_warning_message = (String)tracker_report_map.get(url.getHost());
                                if (last_warning_message == null || !warning_message.equals(last_warning_message)) {
                                    log_it = true;
                                    tracker_report_map.put(url.getHost(), warning_message);
                                }
                            }
                            finally {
                                class_mon.exit();
                            }
                            if (log_it) {
                                Logger.logTextResource(new LogAlert((Object)this.torrent, false, 1, "TrackerClient.announce.warningmessage"), new String[]{this.announce_data_provider.getName(), warning_message});
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    try {
                        time_to_wait = (Long)metaData.get("interval");
                        Long raw_min_interval = (Long)metaData.get("min interval");
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "Received from announce: 'interval' = " + time_to_wait + "; 'min interval' = " + raw_min_interval));
                        }
                        if (time_to_wait < 0L || time_to_wait > 0xFFFFFFFFL) {
                            time_to_wait = 0xFFFFFFFFL;
                        }
                        if (raw_min_interval != null) {
                            this.min_interval = raw_min_interval;
                            if (this.min_interval < 1L) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "Tracker being silly and returning a 'min interval' of less than 1 second (" + this.min_interval + ")"));
                                }
                                this.min_interval = 0L;
                            } else if (this.min_interval > time_to_wait) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "Tracker being silly and returning a 'min interval' (" + this.min_interval + ") greater than recommended announce 'interval'" + " (" + time_to_wait + ")"));
                                }
                                this.min_interval = 0L;
                            }
                        }
                        if (userMinInterval != 0) {
                            time_to_wait = Math.max((long)userMinInterval, time_to_wait);
                            this.min_interval = Math.max(this.min_interval, (long)userMinInterval);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "Overriding with user settings: 'interval' = " + time_to_wait + "; 'min interval' = " + this.min_interval));
                            }
                        }
                        if (time_to_wait > 30L) {
                            time_to_wait -= 10L;
                        }
                    }
                    catch (Exception e) {
                        byte[] failure_reason_bytes = (byte[])metaData.get("failure reason");
                        if (failure_reason_bytes == null) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 1, "Problems with Tracker, will retry in " + this.getErrorRetryInterval() + "ms"));
                            }
                            return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), "Unknown cause");
                        }
                        String failure_reason2 = new String(failure_reason_bytes, "UTF8");
                        return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash, 1, (long)this.getErrorRetryInterval(), failure_reason2);
                    }
                    Long incomplete_l = (Long)metaData.get("incomplete");
                    Long complete_l = (Long)metaData.get("complete");
                    if ((incomplete_l != null || complete_l != null) && Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE SCRAPE1: seeds=" + complete_l + " peers=" + incomplete_l));
                    }
                    if ((trackerid = (byte[])metaData.get("tracker id")) != null) {
                        this.tracker_id = new String(trackerid);
                    }
                    byte[] crypto_flags = (byte[])metaData.get("crypto_flags");
                    ArrayList<TRTrackerAnnouncerResponsePeerImpl> valid_meta_peers = new ArrayList<TRTrackerAnnouncerResponsePeerImpl>();
                    Object meta_peers_peek = metaData.get("peers");
                    Long az_compact_l = (Long)metaData.get("azcompact");
                    long az_compact = az_compact_l == null ? 0L : az_compact_l;
                    boolean bl = this_is_az_tracker = az_compact == 2L;
                    if (this.az_tracker != this_is_az_tracker || this.lastUsedUrl != this.lastAZTrackerCheckedURL) {
                        this.lastAZTrackerCheckedURL = this.lastUsedUrl;
                        this.az_tracker = this_is_az_tracker;
                        TRTrackerUtils.setAZTracker(url, this.az_tracker);
                    }
                    if (az_compact == 2L) {
                        meta_peers = (List)meta_peers_peek;
                        peers_length = meta_peers.size();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE CompactPeers2: num=" + peers_length));
                        }
                        if (peers_length > 1) {
                            long total_rtt = 0L;
                            int rtt_count = 0;
                            for (int i3 = 0; i3 < peers_length; ++i3) {
                                Map peer = (Map)meta_peers.get(i3);
                                Long l_rtt = (Long)peer.get("r");
                                if (l_rtt == null) continue;
                                long rtt = l_rtt;
                                if (rtt <= 0L) {
                                    peer.remove("r");
                                } else {
                                    total_rtt += rtt;
                                }
                                ++rtt_count;
                            }
                            final int average_rtt = (int)(rtt_count == 0 ? 0L : total_rtt / (long)rtt_count);
                            Collections.sort(meta_peers, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    boolean biased_2;
                                    Map map1 = (Map)o1;
                                    Map map2 = (Map)o2;
                                    Long l_rtt1 = (Long)map1.get("r");
                                    Long l_rtt2 = (Long)map2.get("r");
                                    boolean biased_1 = map1.containsKey("b");
                                    if (biased_1 == (biased_2 = map2.containsKey("b"))) {
                                        int rtt1 = l_rtt1 == null ? average_rtt : l_rtt1.intValue();
                                        int rtt2 = l_rtt2 == null ? average_rtt : l_rtt2.intValue();
                                        return rtt1 - rtt2;
                                    }
                                    if (biased_1) {
                                        return -1;
                                    }
                                    return 1;
                                }
                            });
                            int biased_pos = peers_length;
                            int non_biased_pos = peers_length;
                            for (int i4 = 0; i4 < peers_length; ++i4) {
                                Map peer = (Map)meta_peers.get(i4);
                                if (peer.containsKey("b")) {
                                    if (i4 != 0) continue;
                                    biased_pos = i4;
                                    continue;
                                }
                                non_biased_pos = i4;
                                break;
                            }
                            ArrayList new_peers = new ArrayList(peers_length);
                            int non_biased_start = non_biased_pos;
                            boolean last_biased = true;
                            while (biased_pos < non_biased_start || non_biased_pos < peers_length) {
                                if (biased_pos < non_biased_start) {
                                    if (non_biased_pos < peers_length) {
                                        boolean use_biased;
                                        Map biased = (Map)meta_peers.get(biased_pos);
                                        Map non_biased = (Map)meta_peers.get(non_biased_pos);
                                        if (!last_biased) {
                                            use_biased = true;
                                        } else {
                                            Long l_rtt_biased = (Long)biased.get("r");
                                            Long l_rtt_non_biased = (Long)non_biased.get("r");
                                            int biased_rtt = l_rtt_biased == null ? average_rtt : l_rtt_biased.intValue();
                                            int non_biased_rtt = l_rtt_non_biased == null ? average_rtt : l_rtt_non_biased.intValue();
                                            boolean bl2 = use_biased = non_biased_rtt >= biased_rtt;
                                        }
                                        if (use_biased) {
                                            new_peers.add(biased);
                                            ++biased_pos;
                                        } else {
                                            new_peers.add(non_biased);
                                            ++non_biased_pos;
                                        }
                                        last_biased = use_biased;
                                        continue;
                                    }
                                    new_peers.add(meta_peers.get(biased_pos++));
                                    continue;
                                }
                                new_peers.add(meta_peers.get(non_biased_pos++));
                            }
                            meta_peers = new_peers;
                        }
                        for (i = 0; i < peers_length; ++i) {
                            Map peer = (Map)meta_peers.get(i);
                            try {
                                Long l_azver;
                                String ip;
                                byte[] ip_bytes = (byte[])peer.get("i");
                                if (ip_bytes.length == 4) {
                                    int ip1 = 0xFF & ip_bytes[0];
                                    int ip2 = 0xFF & ip_bytes[1];
                                    int ip3 = 0xFF & ip_bytes[2];
                                    int ip4 = 0xFF & ip_bytes[3];
                                    ip = ip1 + "." + ip2 + "." + ip3 + "." + ip4;
                                } else {
                                    StringBuffer sb = new StringBuffer(39);
                                    for (int j = 0; j < 16; j += 2) {
                                        sb.append(Integer.toHexString(ip_bytes[j] << 8 & 0xFF00 | ip_bytes[j + 1] & 0xFF));
                                        if (j >= 14) continue;
                                        sb.append(":");
                                    }
                                    ip = sb.toString();
                                }
                                byte[] tcp_bytes = (byte[])peer.get("t");
                                int tcp_port = ((tcp_bytes[0] & 0xFF) << 8) + (tcp_bytes[1] & 0xFF);
                                byte[] peer_peer_id = this.getAnonymousPeerId(ip, tcp_port);
                                int udp_port = 0;
                                byte[] udp_bytes = (byte[])peer.get("u");
                                if (udp_bytes != null) {
                                    udp_port = udp_bytes.length == 0 ? tcp_port : ((udp_bytes[0] & 0xFF) << 8) + (udp_bytes[1] & 0xFF);
                                }
                                int http_port = 0;
                                byte[] http_bytes = (byte[])peer.get("h");
                                if (http_bytes != null) {
                                    http_port = ((http_bytes[0] & 0xFF) << 8) + (http_bytes[1] & 0xFF);
                                }
                                short protocol = 1;
                                byte[] protocol_bytes = (byte[])peer.get("c");
                                if (protocol_bytes != null) {
                                    protocol = (protocol_bytes[0] & 1) == 0 ? (short)1 : 2;
                                }
                                byte az_ver = (l_azver = (Long)peer.get("v")) == null ? (byte)1 : l_azver.byteValue();
                                Long l_up_speed = (Long)peer.get("s");
                                boolean biased = peer.containsKey("b");
                                if (biased) {
                                    PeerClassifier.setAzureusIP(ip);
                                }
                                TRTrackerAnnouncerResponsePeerImpl new_peer = new TRTrackerAnnouncerResponsePeerImpl("Tracker", peer_peer_id, ip, tcp_port, udp_port, http_port, protocol, az_ver, l_up_speed == null ? (short)0 : l_up_speed.shortValue());
                                if (Logger.isEnabled()) {
                                    String extra = "";
                                    Long l_rtt = (Long)peer.get("r");
                                    if (l_rtt != null) {
                                        extra = ",rtt=" + l_rtt;
                                    }
                                    if (biased) {
                                        extra = extra + ",biased";
                                    }
                                    Logger.log(new LogEvent(this.torrent, LOGID, "AZ2-COMPACT PEER: " + new_peer.getString() + extra));
                                }
                                valid_meta_peers.add(new_peer);
                                continue;
                            }
                            catch (Throwable e) {
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid az2 peer received: " + peer));
                            }
                        }
                    } else if (meta_peers_peek instanceof List) {
                        meta_peers = (List)meta_peers_peek;
                        peers_length = meta_peers.size();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE old style non-compact: num=" + peers_length));
                        }
                        if (crypto_flags != null && peers_length != crypto_flags.length) {
                            crypto_flags = null;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid crypto_flags returned: length mismatch"));
                            }
                        }
                        for (i = 0; i < peers_length; ++i) {
                            Map peer = (Map)meta_peers.get(i);
                            Object s_peerid = peer.get("peer id");
                            Object s_ip = peer.get("ip");
                            Object s_port = peer.get("port");
                            if (s_ip == null || s_port == null) continue;
                            String ip = new String((byte[])s_ip, "UTF8");
                            int peer_port = ((Long)s_port).intValue();
                            if (peer_port > 65535) {
                                peer_port -= 65536;
                            }
                            if (peer_port < 0) {
                                peer_port += 65536;
                            }
                            if (peer_port < 0 || peer_port > 65535) {
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid peer port given: " + ip + ": " + peer_port));
                                continue;
                            }
                            byte[] peer_peer_id = s_peerid == null ? this.getAnonymousPeerId(ip, peer_port) : (byte[])s_peerid;
                            short protocol = crypto_flags == null ? (short)1 : (crypto_flags[i] == 0 ? (short)1 : 2);
                            int udp_port = 0;
                            int http_port = 0;
                            TRTrackerAnnouncerResponsePeerImpl new_peer = new TRTrackerAnnouncerResponsePeerImpl("Tracker", peer_peer_id, ip, peer_port, udp_port, http_port, protocol, 1, 0);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "NON-COMPACT PEER: " + new_peer.getString()));
                            }
                            valid_meta_peers.add(new_peer);
                        }
                    } else if (meta_peers_peek instanceof byte[]) {
                        meta_peers = (ArrayList)((byte[])meta_peers_peek);
                        int n = entry_size = az_compact == 1L ? 9 : 6;
                        if (crypto_flags != null && ((Object)meta_peers).length / entry_size != crypto_flags.length) {
                            crypto_flags = null;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid crypto_flags returned: length mismatch"));
                            }
                        }
                        int peer_number = 0;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE CompactPeers: num=" + ((Object)meta_peers).length / entry_size));
                        }
                        for (int i5 = 0; i5 < ((Object)meta_peers).length; i5 += entry_size) {
                            int protocol;
                            int udp_port;
                            ++peer_number;
                            int ip1 = 0xFF & meta_peers[i5];
                            int ip2 = 0xFF & meta_peers[i5 + 1];
                            int ip3 = 0xFF & meta_peers[i5 + 2];
                            int ip4 = 0xFF & meta_peers[i5 + 3];
                            int po1 = 0xFF & meta_peers[i5 + 4];
                            int po2 = 0xFF & meta_peers[i5 + 5];
                            String ip = "" + ip1 + "." + ip2 + "." + ip3 + "." + ip4;
                            int tcp_port = po1 * 256 + po2;
                            if (tcp_port < 0 || tcp_port > 65535) {
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid compact peer port given: " + ip + ": " + tcp_port));
                                continue;
                            }
                            byte[] peer_peer_id = this.getAnonymousPeerId(ip, tcp_port);
                            if (az_compact == 1L) {
                                int upo1 = 0xFF & meta_peers[i5 + 6];
                                int upo2 = 0xFF & meta_peers[i5 + 7];
                                udp_port = upo1 * 256 + upo2;
                                ArrayList flags = meta_peers[i5 + 8];
                                protocol = (flags & 1) == 0 ? 1 : 2;
                            } else {
                                protocol = crypto_flags == null ? 1 : (crypto_flags[peer_number - 1] == 0 ? 1 : 2);
                                udp_port = 0;
                            }
                            int http_port = 0;
                            TRTrackerAnnouncerResponsePeerImpl peer = new TRTrackerAnnouncerResponsePeerImpl("Tracker", peer_peer_id, ip, tcp_port, udp_port, http_port, (short)protocol, 1, 0);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "COMPACT PEER: " + peer.getString()));
                            }
                            valid_meta_peers.add(peer);
                        }
                    } else if (meta_peers_peek instanceof Map ? ((Map)meta_peers_peek).size() != 0 : !metaData.containsKey("peers6")) {
                        throw new IOException("peers missing from response");
                    }
                    if ((v6peers = (byte[])metaData.get("peers6")) != null) {
                        entry_size = 18;
                        byte[] rawAddr = new byte[16];
                        for (int i6 = 0; i6 < v6peers.length; i6 += 18) {
                            System.arraycopy(v6peers, i6, rawAddr, 0, 16);
                            String ip = InetAddress.getByAddress(rawAddr).getHostAddress();
                            int po1 = 0xFF & v6peers[i6 + 16];
                            int po2 = 0xFF & v6peers[i6 + 17];
                            int tcp_port = po1 * 256 + po2;
                            if (tcp_port < 0 || tcp_port > 65535) {
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid compactv6 peer port given: " + ip + ": " + tcp_port));
                                continue;
                            }
                            byte[] peer_peer_id = this.getAnonymousPeerId(ip, tcp_port);
                            short protocol = 1;
                            TRTrackerAnnouncerResponsePeerImpl peer = new TRTrackerAnnouncerResponsePeerImpl("Tracker", peer_peer_id, ip, tcp_port, 0, 0, protocol, 1, 0);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "COMPACTv6 PEER: " + peer.getString()));
                            }
                            valid_meta_peers.add(peer);
                        }
                    }
                    TRTrackerAnnouncerResponsePeer[] peers = new TRTrackerAnnouncerResponsePeerImpl[valid_meta_peers.size()];
                    valid_meta_peers.toArray(peers);
                    this.addToTrackerCache((TRTrackerAnnouncerResponsePeerImpl[])peers);
                    TRTrackerAnnouncerResponseImpl resp = new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash, 2, time_to_wait, peers);
                    this.failure_added_time = 0;
                    Map extensions = (Map)metaData.get("extensions");
                    resp.setExtensions(extensions);
                    if (extensions != null) {
                        Object override;
                        if (complete_l == null) {
                            complete_l = (Long)extensions.get("complete");
                        }
                        if (incomplete_l == null) {
                            incomplete_l = (Long)extensions.get("incomplete");
                        }
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE SCRAPE2: seeds=" + complete_l + " peers=" + incomplete_l));
                        }
                        if ((override = extensions.get("min interval override")) != null && override instanceof Long) {
                            this.min_interval_override = (Long)override;
                        }
                    }
                    if (complete_l != null || incomplete_l != null) {
                        int incomplete;
                        int complete = complete_l == null ? 0 : complete_l.intValue();
                        int n = incomplete = incomplete_l == null ? 0 : incomplete_l.intValue();
                        if (complete < 0 || incomplete < 0) {
                            resp.setFailurReason(MessageText.getString("Tracker.announce.ignorePeerSeed", new String[]{(complete < 0 ? MessageText.getString("MyTorrentsView.seeds") + " == " + complete + ". " : "") + (incomplete < 0 ? MessageText.getString("MyTorrentsView.peers") + " == " + incomplete + ". " : "")}));
                        } else {
                            TRTrackerScraperResponse scrapeResponse;
                            resp.setScrapeResult(complete, incomplete);
                            TRTrackerScraper scraper = TRTrackerScraperFactory.getSingleton();
                            if (scraper != null && (scrapeResponse = scraper.scrape(this)) != null) {
                                long lNextScrapeTime = scrapeResponse.getNextScrapeStartTime();
                                long lNewNextScrapeTime = TRTrackerScraperResponseImpl.calcScrapeIntervalSecs(0, complete) * 1000;
                                scrapeResponse.setScrapeStartTime(SystemTime.getCurrentTime());
                                if (lNextScrapeTime < lNewNextScrapeTime) {
                                    scrapeResponse.setNextScrapeStartTime(lNewNextScrapeTime);
                                }
                                scrapeResponse.setSeedsPeers(complete, incomplete);
                            }
                        }
                    }
                    return resp;
                }
                catch (IOException e) {
                    String trace_data = data.length <= 150 ? new String(data) : new String(data, 0, 150) + "...";
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "TRTrackerAnnouncer::invalid reply: " + trace_data));
                    }
                    failure_reason = "invalid reply: " + trace_data;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                failure_reason = "error: " + e.getMessage();
            }
        }
        return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), failure_reason);
    }

    protected void informURLChange(URL old_url, URL new_url, boolean explicit) {
        this.listeners.dispatch(2, new Object[]{old_url, new_url, new Boolean(explicit)});
    }

    protected void informURLRefresh() {
        this.listeners.dispatch(3, null);
    }

    public TRTrackerAnnouncerResponse getLastResponse() {
        if (this.last_response == null) {
            return new TRTrackerAnnouncerResponseImpl(null, this.torrent_hash, 0, 60L, "Initialising");
        }
        return this.last_response;
    }

    public boolean isManual() {
        return this.manual_control;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed = true;
        TRTrackerAnnouncerFactoryImpl.destroy(this);
        try {
            this.this_mon.enter();
            if (this.current_timer_event != null && this.current_timer_event.getWhen() - SystemTime.getCurrentTime() > 10000L) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Canceling announce trigger"));
                }
                this.current_timer_event.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int getErrorRetryInterval() {
        boolean is_seed;
        long currentTime = SystemTime.getCurrentTime() / 1000L;
        long diff = currentTime - this.failure_time_last_updated;
        if (diff < (long)this.failure_added_time && diff >= 0L) {
            return this.failure_added_time;
        }
        this.failure_time_last_updated = currentTime;
        this.failure_added_time = this.failure_added_time == 0 ? 10 : (this.failure_added_time < 30 ? (this.failure_added_time += 10) : (this.failure_added_time < 60 ? (this.failure_added_time += 15) : (this.failure_added_time < 120 ? (this.failure_added_time += 30) : (this.failure_added_time < 600 ? (this.failure_added_time += 60) : (this.failure_added_time += 120 + new Random().nextInt(60))))));
        boolean bl = this.announce_data_provider == null ? false : (is_seed = this.announce_data_provider.getRemaining() == 0L);
        if (is_seed) {
            this.failure_added_time *= 2;
        }
        if (!is_seed && this.failure_added_time > 1800) {
            this.failure_added_time = 1800;
        } else if (is_seed && this.failure_added_time > 3600) {
            this.failure_added_time = 3600;
        }
        return this.failure_added_time;
    }

    public void setAnnounceResult(DownloadAnnounceResult result) {
        TRTrackerAnnouncerResponseImpl response;
        String status;
        if (result.getResponseType() == 2) {
            status = MessageText.getString("PeerManager.status.error");
            String reason = result.getError();
            if (reason != null) {
                status = status + " (" + reason + ")";
            }
            response = new TRTrackerAnnouncerResponseImpl(result.getURL(), this.torrent_hash, 0, result.getTimeToWait(), reason);
        } else {
            DownloadAnnounceResultPeer[] ext_peers = result.getPeers();
            ArrayList<TRTrackerAnnouncerResponsePeerImpl> l_peers = new ArrayList<TRTrackerAnnouncerResponsePeerImpl>(ext_peers.length);
            boolean ps_enabled = this.announce_data_provider != null && this.announce_data_provider.isPeerSourceEnabled("Tracker");
            for (int i = 0; i < ext_peers.length; ++i) {
                DownloadAnnounceResultPeer ext_peer = ext_peers[i];
                String ps = ext_peer.getSource();
                if (!ps_enabled && ps.equals("Tracker")) continue;
                int http_port = 0;
                byte az_version = 1;
                TRTrackerAnnouncerResponsePeerImpl p = new TRTrackerAnnouncerResponsePeerImpl(ext_peer.getSource(), ext_peer.getPeerID(), ext_peer.getAddress(), ext_peer.getPort(), ext_peer.getUDPPort(), http_port, ext_peer.getProtocol(), az_version, 0);
                l_peers.add(p);
                if (!Logger.isEnabled()) continue;
                Logger.log(new LogEvent(this.torrent, LOGID, "EXTERNAL PEER: " + p.getString()));
            }
            TRTrackerAnnouncerResponsePeer[] peers = new TRTrackerAnnouncerResponsePeerImpl[l_peers.size()];
            l_peers.toArray(peers);
            this.addToTrackerCache((TRTrackerAnnouncerResponsePeerImpl[])peers);
            if (ps_enabled || peers.length > 0 || ext_peers.length == 0) {
                status = MessageText.getString("PeerManager.status.ok");
            } else {
                status = MessageText.getString("PeerManager.status.ps_disabled");
                peers = new TRTrackerAnnouncerResponsePeerImpl[]{};
            }
            response = new TRTrackerAnnouncerResponseImpl(result.getURL(), this.torrent_hash, 2, result.getTimeToWait(), peers);
        }
        if (this.last_response == null || this.last_response.getStatus() != 2) {
            this.tracker_status_str = status + " (" + result.getURL() + ")";
        }
        this.listeners.dispatch(1, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter writer) {
        writer.println("BT announce:");
        try {
            writer.indent();
            writer.println("state: " + this.tracker_state + ", in_progress=" + this.update_in_progress);
            writer.println("current: " + (this.lastUsedUrl == null ? "null" : this.lastUsedUrl.toString()));
            writer.println("last: " + (this.last_response == null ? "null" : this.last_response.getString()));
            writer.println("last_update_secs: " + this.last_update_time_secs);
            writer.println("secs_to_wait: " + this.current_time_to_wait_secs + (this.manual_control ? " - manual" : ""));
            writer.println("min_interval: " + this.min_interval);
            writer.println("min_interval_override: " + this.min_interval_override);
            writer.println("rd: last_override=" + this.rd_last_override + ",percentage=" + this.rd_override_percentage);
            writer.println("event: " + (this.current_timer_event == null ? "null" : this.current_timer_event.getString()));
            writer.println("stopped: " + this.stopped + ", for_q=" + this.stopped_for_queue);
            writer.println("complete: " + this.completed + ", reported=" + this.complete_reported);
        }
        finally {
            writer.exdent();
        }
    }

    static /* synthetic */ boolean access$300(TRTrackerBTAnnouncerImpl x0) {
        return x0.manual_control;
    }

    static /* synthetic */ TOTorrent access$400(TRTrackerBTAnnouncerImpl x0) {
        return x0.torrent;
    }

    static /* synthetic */ long access$502(TRTrackerBTAnnouncerImpl x0, long x1) {
        x0.current_time_to_wait_secs = x1;
        return x0.current_time_to_wait_secs;
    }

    static /* synthetic */ TimerEvent access$600(TRTrackerBTAnnouncerImpl x0) {
        return x0.current_timer_event;
    }

    static /* synthetic */ boolean access$700(TRTrackerBTAnnouncerImpl x0) {
        return x0.destroyed;
    }

    static /* synthetic */ TimerEvent access$602(TRTrackerBTAnnouncerImpl x0, TimerEvent x1) {
        x0.current_timer_event = x1;
        return x0.current_timer_event;
    }

    static {
        PRUDPTrackerCodecs.registerCodecs();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Tracker Client Min Announce Interval", "Tracker Client Numwant Limit", "Server Enable UDP"}, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                userMinInterval = COConfigurationManager.getIntParameter("Tracker Client Min Announce Interval");
                userMaxNumwant = COConfigurationManager.getIntParameter("Tracker Client Numwant Limit");
                udpAnnounceEnabled = COConfigurationManager.getBooleanParameter("Server Enable UDP");
            }
        });
        class_mon = new AEMonitor("TRTrackerBTAnnouncer:class");
        tracker_report_map = new HashMap();
    }
}

