/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking.TRBlockingServerProcessor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class TRBlockingServer
extends TRTrackerServerTCP {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private ServerSocket server_socket;
    private volatile boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRBlockingServer(String _name, int _port, InetAddress _bind_ip, boolean _ssl, boolean _apply_ip_filter, boolean _start_up_ready) throws TRTrackerServerException {
        block16: {
            super(_name, _port, _ssl, _apply_ip_filter, _start_up_ready);
            boolean ok = false;
            try {
                InetAddress bind_ip = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
                String tr_bind_ip = COConfigurationManager.getStringParameter("Bind IP for Tracker", "");
                if (tr_bind_ip.length() >= 7) {
                    try {
                        bind_ip = InetAddress.getByName(tr_bind_ip);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (_ssl) {
                    if (_port == 0) {
                        throw new TRTrackerServerException("port of 0 not currently supported for SSL");
                    }
                    try {
                        SSLServerSocketFactory factory = SESecurityManager.getSSLServerSocketFactory();
                        if (factory == null) {
                            throw new TRTrackerServerException("TRTrackerServer: failed to get SSL factory");
                        }
                        SSLServerSocket ssl_server_socket = bind_ip == null ? (SSLServerSocket)factory.createServerSocket(this.getPort(), 128) : (SSLServerSocket)factory.createServerSocket(this.getPort(), 128, bind_ip);
                        String[] cipherSuites = ssl_server_socket.getSupportedCipherSuites();
                        ssl_server_socket.setEnabledCipherSuites(cipherSuites);
                        ssl_server_socket.setNeedClientAuth(false);
                        ssl_server_socket.setReuseAddress(true);
                        this.server_socket = ssl_server_socket;
                        AEThread accept_thread = new AEThread("TRTrackerServer:accept.loop(ssl)"){

                            public void runSupport() {
                                TRBlockingServer.this.acceptLoop(TRBlockingServer.this.server_socket);
                            }
                        };
                        accept_thread.setDaemon(true);
                        accept_thread.start();
                        Logger.log(new LogEvent(LOGID, "TRTrackerServer: SSL listener established on port " + this.getPort()));
                        ok = true;
                        break block16;
                    }
                    catch (Throwable e) {
                        Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.getPort()});
                        Logger.log(new LogEvent(LOGID, "TRTrackerServer: SSL listener failed on port " + this.getPort(), e));
                        if (e instanceof TRTrackerServerException) {
                            throw (TRTrackerServerException)e;
                        }
                        throw new TRTrackerServerException("TRTrackerServer: accept fails: " + e.toString());
                    }
                }
                try {
                    int port = this.getPort();
                    ServerSocket ss = _bind_ip != null ? new ServerSocket(port, 1024, _bind_ip) : (bind_ip == null ? new ServerSocket(port, 1024) : new ServerSocket(port, 1024, bind_ip));
                    if (port == 0) {
                        this.setPort(ss.getLocalPort());
                    }
                    ss.setReuseAddress(true);
                    this.server_socket = ss;
                    AEThread accept_thread = new AEThread("TRTrackerServer:accept.loop"){

                        public void runSupport() {
                            TRBlockingServer.this.acceptLoop(TRBlockingServer.this.server_socket);
                        }
                    };
                    accept_thread.setDaemon(true);
                    accept_thread.start();
                    Logger.log(new LogEvent(LOGID, "TRTrackerServer: listener established on port " + this.getPort()));
                    ok = true;
                }
                catch (Throwable e) {
                    Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.getPort()});
                    throw new TRTrackerServerException("TRTrackerServer: accept fails", e);
                }
            }
            finally {
                if (!ok) {
                    this.destroySupport();
                }
            }
        }
    }

    protected void acceptLoop(ServerSocket ss) {
        long successfull_accepts = 0L;
        long failed_accepts = 0L;
        while (!this.closed) {
            try {
                Socket socket = ss.accept();
                ++successfull_accepts;
                String ip = socket.getInetAddress().getHostAddress();
                if (!this.isIPFilterEnabled() || !this.ip_filter.isInRange(ip, "Tracker", null)) {
                    this.runProcessor(new TRBlockingServerProcessor(this, socket));
                    continue;
                }
                socket.close();
            }
            catch (Throwable e) {
                if (this.closed) continue;
                Logger.log(new LogEvent(LOGID, "TRTrackerServer: listener failed on port " + this.getPort(), e));
                if (++failed_accepts <= 100L || successfull_accepts != 0L) continue;
                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + this.getPort(), "TCP"});
                break;
            }
        }
    }

    protected void closeSupport() {
        this.closed = true;
        try {
            this.server_socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.destroySupport();
    }
}

