/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServer;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class TRNonBlockingServerProcessor
extends TRTrackerServerProcessorTCP {
    private static final int READ_BUFFER_INITIAL = 1024;
    private static final int READ_BUFFER_INCREMENT = 1024;
    private static final int READ_BUFFER_LIMIT = 32768;
    private SocketChannel socket_channel;
    private long start_time;
    private ByteBuffer read_buffer;
    private String request_header;
    private ByteBuffer write_buffer;

    protected TRNonBlockingServerProcessor(TRTrackerServerTCP _server, SocketChannel _socket) {
        super(_server);
        this.socket_channel = _socket;
        this.start_time = SystemTime.getCurrentTime();
        this.read_buffer = ByteBuffer.allocate(1024);
    }

    protected int processRead() {
        byte[] data;
        if (this.read_buffer.remaining() == 0) {
            int capacity = this.read_buffer.capacity();
            if (capacity == 32768) {
                return -1;
            }
            this.read_buffer.position(0);
            data = new byte[capacity];
            this.read_buffer.get(data);
            this.read_buffer = ByteBuffer.allocate(capacity + 1024);
            this.read_buffer.put(data);
        }
        try {
            int len = this.socket_channel.read(this.read_buffer);
            if (len < 0) {
                return -1;
            }
            if (len == 0) {
                return 2;
            }
            data = this.read_buffer.array();
            for (int i = this.read_buffer.position() - 4; i >= 0; --i) {
                if (data[i] != 13 || data[i + 1] != 10 || data[i + 2] != 13 || data[i + 3] != 10) continue;
                this.request_header = new String(data, 0, this.read_buffer.position());
                this.getServer().runProcessor(this);
                return 0;
            }
            return 1;
        }
        catch (IOException e) {
            return -1;
        }
    }

    protected int processWrite() {
        if (this.write_buffer == null) {
            return -1;
        }
        if (!this.write_buffer.hasRemaining()) {
            return 0;
        }
        try {
            int written = this.socket_channel.write(this.write_buffer);
            if (written == 0) {
                return 2;
            }
            if (this.write_buffer.hasRemaining()) {
                return 1;
            }
            return 0;
        }
        catch (IOException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSupport() {
        boolean async = false;
        try {
            String url = this.request_header.substring(4).trim();
            int pos = url.indexOf(" ");
            url = url.substring(0, pos);
            final AESemaphore[] went_async = new AESemaphore[]{null};
            final ByteArrayOutputStream[] async_stream = new ByteArrayOutputStream[]{null};
            AsyncController async_control = new AsyncController(){

                public void setAsyncStart() {
                    went_async[0] = new AESemaphore("async");
                }

                public void setAsyncComplete() {
                    went_async[0].reserve();
                    TRNonBlockingServerProcessor.this.asyncProcessComplete(async_stream[0]);
                }
            };
            try {
                ByteArrayOutputStream response = this.process(this.request_header, this.request_header.toLowerCase(), url, (InetSocketAddress)this.socket_channel.socket().getRemoteSocketAddress(), TRTrackerServerImpl.restrict_non_blocking_requests, new ByteArrayInputStream(new byte[0]), async_control);
                if (response == null) {
                    async = true;
                } else if (went_async[0] != null) {
                    async_stream[0] = response;
                    async = true;
                } else {
                    this.write_buffer = ByteBuffer.wrap(response.toByteArray());
                }
            }
            finally {
                if (went_async[0] != null) {
                    went_async[0].release();
                }
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (!async) {
                ((TRNonBlockingServer)this.getServer()).readyToWrite(this);
            }
        }
    }

    protected abstract ByteArrayOutputStream process(String var1, String var2, String var3, InetSocketAddress var4, boolean var5, InputStream var6, AsyncController var7) throws IOException;

    protected void asyncProcessComplete(ByteArrayOutputStream response) {
        this.write_buffer = ByteBuffer.wrap(response.toByteArray());
        ((TRNonBlockingServer)this.getServer()).readyToWrite(this);
    }

    protected SocketChannel getSocketChannel() {
        return this.socket_channel;
    }

    protected long getStartTime() {
        return this.start_time;
    }

    public void interruptTask() {
    }

    protected void failed() {
    }

    protected void completed() {
    }

    protected void closed() {
    }
}

