/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.util.Java15Utils;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;

public class AEDiagnostics {
    public static final boolean ALWAYS_PASS_HASH_CHECKS = false;
    public static final boolean USE_DUMMY_FILE_DATA = false;
    public static final boolean CHECK_DUMMY_FILE_DATA = false;
    public static final boolean DEBUG_MONITOR_SEM_USAGE = false;
    public static final boolean DEBUG_THREADS = true;
    public static final boolean TRACE_DIRECT_BYTE_BUFFERS = false;
    public static final boolean TRACE_DBB_POOL_USAGE = false;
    public static final boolean PRINT_DBB_POOL_USAGE = false;
    public static final boolean TRACE_TCP_TRANSPORT_STATS = false;
    public static final boolean TRACE_CONNECTION_DROPS = false;
    private static final int MAX_FILE_SIZE;
    private static final String CONFIG_KEY = "diagnostics.tidy_close";
    private static File debug_dir;
    private static File debug_save_dir;
    private static boolean started_up;
    private static boolean startup_complete;
    private static boolean enable_pending_writes;
    private static Map<String, AEDiagnosticsLogger> loggers;
    protected static boolean loggers_enabled;
    private static List evidence_generators;
    private static boolean load_15_tried;
    private static final String[][] bad_dlls;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void startup(boolean _enable_pending) {
        if (started_up) {
            return;
        }
        started_up = true;
        enable_pending_writes = _enable_pending;
        try {
            boolean transitoryStartup = System.getProperty("transitory.startup", "0").equals("1");
            if (transitoryStartup) {
                load_15_tried = true;
                loggers_enabled = false;
                return;
            }
            debug_dir = FileUtil.getUserFile("logs");
            debug_save_dir = new File(debug_dir, "save");
            loggers_enabled = COConfigurationManager.getBooleanParameter("Logger.DebugFiles.Enabled");
            boolean was_tidy = COConfigurationManager.getBooleanParameter(CONFIG_KEY);
            new AEThread2("asyncify", true){

                public void run() {
                    SimpleTimer.addEvent("AEDiagnostics:logCleaner", SystemTime.getCurrentTime() + 60000L + (long)((int)(Math.random() * 15000.0)), new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            AEDiagnostics.cleanOldLogs();
                        }
                    });
                }
            }.start();
            if (debug_dir.exists()) {
                long now = SystemTime.getCurrentTime();
                debug_save_dir.mkdir();
                File[] files = debug_dir.listFiles();
                if (files != null) {
                    boolean file_copied = false;
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file.isDirectory() || was_tidy) continue;
                        file_copied = true;
                        FileUtil.copyFile(file, new File(debug_save_dir, now + "_" + file.getName()));
                    }
                    if (file_copied) {
                        Logger.logTextResource(new LogAlert(false, 1, "diagnostics.log_found"), new String[]{debug_save_dir.toString()});
                    }
                }
            } else {
                debug_dir.mkdir();
            }
        }
        catch (Throwable e) {
            if (!(e instanceof NoClassDefFoundError)) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            startup_complete = true;
            AEDiagnostics.load15Stuff();
        }
    }

    protected static void load15Stuff() {
        if (load_15_tried) {
            return;
        }
        load_15_tried = true;
        try {
            Method m;
            Java15Utils.Java15UtilsProvider provider2;
            Class<?> c = Class.forName("com.aelitis.azureus.jdk15.Java15Initialiser");
            if (c != null && (provider2 = (Java15Utils.Java15UtilsProvider)(m = c.getDeclaredMethod("getUtilsProvider", new Class[0])).invoke(null, new Object[0])) != null) {
                Java15Utils.setProvider(provider2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void dumpThreads() {
        Java15Utils.dumpThreads();
    }

    protected static void cleanOldLogs() {
        try {
            long now = SystemTime.getCurrentTime();
            File[] files = debug_save_dir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    long last_modified;
                    File file = files[i];
                    if (file.isDirectory() || now - (last_modified = file.lastModified()) <= 864000000L) continue;
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isStartupComplete() {
        return startup_complete;
    }

    public static File getLogDir() {
        AEDiagnostics.startup(false);
        return debug_dir;
    }

    public static synchronized void flushPendingLogs() {
        for (AEDiagnosticsLogger logger : loggers.values()) {
            logger.writePending();
        }
        enable_pending_writes = false;
    }

    public static synchronized AEDiagnosticsLogger getLogger(String name) {
        AEDiagnosticsLogger logger = loggers.get(name);
        if (logger == null) {
            AEDiagnostics.startup(false);
            logger = new AEDiagnosticsLogger(debug_dir, name, MAX_FILE_SIZE, !enable_pending_writes);
            loggers.put(name, logger);
        }
        return logger;
    }

    public static void logWithStack(String logger_name, String str) {
        AEDiagnostics.log(logger_name, str + ": " + Debug.getCompressedStackTrace());
    }

    public static void log(String logger_name, String str) {
        AEDiagnostics.getLogger(logger_name).log(str);
    }

    public static void markDirty() {
        try {
            COConfigurationManager.setParameter(CONFIG_KEY, false);
            COConfigurationManager.save();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static boolean isDirty() {
        return !COConfigurationManager.getBooleanParameter(CONFIG_KEY);
    }

    public static void markClean() {
        try {
            COConfigurationManager.setParameter(CONFIG_KEY, true);
            COConfigurationManager.save();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void checkDumpsAndNatives() {
        try {
            File app_dir;
            PlatformManager p_man = PlatformManagerFactory.getPlatformManager();
            if (p_man.getPlatformType() == 1 && p_man.hasCapability(PlatformManagerCapabilities.TestNativeAvailability)) {
                for (int i = 0; i < bad_dlls.length; ++i) {
                    String dll = bad_dlls[i][0];
                    String load = bad_dlls[i][1];
                    if (load.equalsIgnoreCase("n") || COConfigurationManager.getBooleanParameter("platform.win32.dll_found." + dll, false)) continue;
                    try {
                        if (!p_man.testNativeAvailability(dll + ".dll")) continue;
                        COConfigurationManager.setParameter("platform.win32.dll_found." + dll, true);
                        String detail = MessageText.getString("platform.win32.baddll." + dll);
                        Logger.logTextResource(new LogAlert(true, 1, "platform.win32.baddll.info"), new String[]{dll + ".dll", detail});
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            if ((app_dir = new File(SystemProperties.getApplicationPath())).canRead()) {
                long last_done;
                File[] files = app_dir.listFiles();
                File most_recent_dump = null;
                long most_recent_time = 0L;
                long now = SystemTime.getCurrentTime();
                long one_week_ago = now - 604800000L;
                for (int i = 0; i < files.length; ++i) {
                    long last_mod;
                    File f = files[i];
                    String name = f.getName();
                    if (!name.startsWith("hs_err_pid") || (last_mod = f.lastModified()) <= most_recent_time || last_mod <= one_week_ago) continue;
                    most_recent_dump = f;
                    most_recent_time = last_mod;
                }
                if (most_recent_dump != null && (last_done = COConfigurationManager.getLongParameter("diagnostics.dump.lasttime", 0L)) < most_recent_time) {
                    COConfigurationManager.setParameter("diagnostics.dump.lasttime", most_recent_time);
                    AEDiagnostics.analyseDump(most_recent_dump);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void analyseDump(File file) {
        System.out.println("Analysing " + file);
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(file));
            try {
                String line;
                boolean float_excep = false;
                String[] bad_dlls_uc = new String[bad_dlls.length];
                for (int i = 0; i < bad_dlls.length; ++i) {
                    String dll = bad_dlls[i][0];
                    bad_dlls_uc[i] = (dll + ".dll").toUpperCase();
                }
                String alcohol_dll = "AxShlex";
                ArrayList<String> matches = new ArrayList<String>();
                while ((line = lnr.readLine()) != null) {
                    if ((line = line.toUpperCase()).indexOf("EXCEPTION_FLT") != -1) {
                        float_excep = true;
                        continue;
                    }
                    for (int i = 0; i < bad_dlls_uc.length; ++i) {
                        String b_uc = bad_dlls_uc[i];
                        if (line.indexOf(b_uc) == -1) continue;
                        String dll = bad_dlls[i][0];
                        if (dll.equals(alcohol_dll)) {
                            if (!float_excep) continue;
                            matches.add(dll);
                            continue;
                        }
                        matches.add(dll);
                    }
                }
                for (int i = 0; i < matches.size(); ++i) {
                    String dll = (String)matches.get(i);
                    String detail = MessageText.getString("platform.win32.baddll." + dll);
                    Logger.logTextResource(new LogAlert(true, 1, "platform.win32.baddll.info"), new String[]{dll + ".dll", detail});
                }
            }
            finally {
                lnr.close();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEvidenceGenerator(AEDiagnosticsEvidenceGenerator gen) {
        List list = evidence_generators;
        synchronized (list) {
            evidence_generators.add(gen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateEvidence(PrintWriter _writer) {
        IndentWriter writer = new IndentWriter(_writer);
        List list = evidence_generators;
        synchronized (list) {
            for (int i = 0; i < evidence_generators.size(); ++i) {
                try {
                    ((AEDiagnosticsEvidenceGenerator)evidence_generators.get(i)).generate(writer);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace(_writer);
                }
            }
        }
        writer.println("Memory");
        try {
            writer.indent();
            Runtime rt = Runtime.getRuntime();
            writer.println("max=" + rt.maxMemory() + ",total=" + rt.totalMemory() + ",free=" + rt.freeMemory());
        }
        finally {
            writer.exdent();
        }
    }

    static {
        int maxFileSize = 262144;
        try {
            String logSize = System.getProperty("diag.logsize", null);
            if (logSize != null) {
                maxFileSize = logSize.toLowerCase().endsWith("m") ? Integer.parseInt(logSize.substring(0, logSize.length() - 1)) * 1024 * 1024 : Integer.parseInt(logSize);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MAX_FILE_SIZE = maxFileSize;
        loggers = new HashMap<String, AEDiagnosticsLogger>();
        evidence_generators = new ArrayList();
        bad_dlls = new String[][]{{"niphk", "y"}, {"nvappfilter", "y"}, {"netdog", "y"}, {"vlsp", "y"}, {"imon", "y"}, {"sarah", "y"}, {"MxAVLsp", "y"}, {"mclsp", "y"}, {"radhslib", "y"}, {"winsflt", "y"}, {"nl_lsp", "y"}, {"AxShlex", "y"}, {"iFW_Xfilter", "y"}, {"gapsp", "y"}, {"WSOCKHK", "n"}};
    }
}

