/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.BEncodingException;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.StringInterner;

public class BDecoder {
    private static final int MAX_BYTE_ARRAY_SIZE = 0x800000;
    private static final int MAX_MAP_KEY_SIZE = 65536;
    private static final boolean TRACE = false;
    private boolean recovery_mode;
    private final char[] numberChars = new char[32];

    public static Map decode(byte[] data) throws IOException {
        return new BDecoder().decodeByteArray(data);
    }

    public static Map decode(byte[] data, int offset, int length) throws IOException {
        return new BDecoder().decodeByteArray(data, offset, length);
    }

    public static Map decode(BufferedInputStream is) throws IOException {
        return new BDecoder().decodeStream(is);
    }

    public Map decodeByteArray(byte[] data) throws IOException {
        return this.decode(new BDecoderInputStreamArray(data));
    }

    public Map decodeByteArray(byte[] data, int offset, int length) throws IOException {
        return this.decode(new BDecoderInputStreamArray(data, offset, length));
    }

    public Map decodeStream(BufferedInputStream data) throws IOException {
        return this.decodeStream(data, true);
    }

    public Map decodeStream(BufferedInputStream data, boolean internKeys) throws IOException {
        Object res = this.decodeInputStream(data, 0, internKeys);
        if (res == null) {
            throw new BEncodingException("BDecoder: zero length file");
        }
        if (!(res instanceof Map)) {
            throw new BEncodingException("BDecoder: top level isn't a Map");
        }
        return (Map)res;
    }

    private Map decode(InputStream data) throws IOException {
        Object res = this.decodeInputStream(data, 0, true);
        if (res == null) {
            throw new BEncodingException("BDecoder: zero length file");
        }
        if (!(res instanceof Map)) {
            throw new BEncodingException("BDecoder: top level isn't a Map");
        }
        return (Map)res;
    }

    /*
     * Unable to fully structure code
     */
    private Object decodeInputStream(InputStream dbis, int nesting, boolean internKeys) throws IOException {
        if (nesting == 0 && !dbis.markSupported()) {
            throw new IOException("InputStream must support the mark() method");
        }
        dbis.mark(0x7FFFFFFF);
        tempByte = dbis.read();
        switch (tempByte) {
            case 100: {
                tempMap = new LightHashMap<S, T>();
                try {
                    tempByteArray = null;
                    while ((tempByteArray = (byte[])this.decodeInputStream(dbis, nesting + 1, internKeys)) != null) {
                        if (tempByteArray.length > 65536) {
                            msg = "dictionary key is too large, max=65536: value=" + new String(tempByteArray, 0, 128);
                            System.err.println(msg);
                            throw new IOException(msg);
                        }
                        value = this.decodeInputStream(dbis, nesting + 1, internKeys);
                        key = null;
                        if (key == null) {
                            cb = Constants.BYTE_CHARSET.decode(ByteBuffer.wrap(tempByteArray));
                            key = new String(cb.array(), 0, cb.limit());
                            if (internKeys) {
                                key = StringInterner.intern(key);
                            }
                        }
                        if (value == null) {
                            System.err.println("Invalid encoding - value not serialsied for '" + key + "' - ignoring");
                            break;
                        }
                        if (tempMap.put(key, value) == null) continue;
                        Debug.out("BDecoder: key '" + key + "' already exists!");
                    }
                    dbis.mark(0x7FFFFFFF);
                    tempByte = dbis.read();
                    dbis.reset();
                    if (nesting > 0 && tempByte == -1) {
                        throw new BEncodingException("BDecoder: invalid input data, 'e' missing from end of dictionary");
                    }
                }
                catch (Throwable e) {
                    if (this.recovery_mode) ** GOTO lbl39
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException(Debug.getNestedExceptionMessage(e));
                }
lbl39:
                // 2 sources

                if (tempMap instanceof LightHashMap) {
                    tempMap.compactify(-0.9f);
                }
                return tempMap;
            }
            case 108: {
                tempList = new ArrayList<Object>();
                try {
                    tempElement = null;
                    while ((tempElement = this.decodeInputStream(dbis, nesting + 1, internKeys)) != null) {
                        tempList.add(tempElement);
                    }
                    tempList.trimToSize();
                    dbis.mark(0x7FFFFFFF);
                    tempByte = dbis.read();
                    dbis.reset();
                    if (nesting > 0 && tempByte == -1) {
                        throw new BEncodingException("BDecoder: invalid input data, 'e' missing from end of list");
                    }
                }
                catch (Throwable e) {
                    if (this.recovery_mode) ** GOTO lbl62
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException(Debug.getNestedExceptionMessage(e));
                }
lbl62:
                // 2 sources

                return tempList;
            }
            case -1: 
            case 101: {
                return null;
            }
            case 105: {
                return new Long(this.getNumberFromStream(dbis, 'e'));
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                dbis.reset();
                return this.getByteArrayFromStream(dbis);
            }
        }
        rem_len = dbis.available();
        if (rem_len > 256) {
            rem_len = 256;
        }
        rem_data = new byte[rem_len];
        dbis.read(rem_data);
        throw new BEncodingException("BDecoder: unknown command '" + tempByte + ", remainder = " + new String(rem_data));
    }

    private long getNumberFromStream(InputStream dbis, char parseChar) throws IOException {
        int tempByte = dbis.read();
        int pos = 0;
        while (tempByte != parseChar && tempByte >= 0) {
            this.numberChars[pos++] = (char)tempByte;
            if (pos == this.numberChars.length) {
                throw new NumberFormatException("Number too large: " + new String(this.numberChars, 0, pos) + "...");
            }
            tempByte = dbis.read();
        }
        if (tempByte < 0) {
            return -1L;
        }
        if (pos == 0) {
            return 0L;
        }
        return BDecoder.parseLong(this.numberChars, 0, pos);
    }

    public static long parseLong(char[] chars, int start, int length) {
        if (length > 0) {
            long limit;
            if (chars[start] == '0') {
                return 0L;
            }
            long result = 0L;
            boolean negative = false;
            int i = start;
            if (chars[i] == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                if (length == 1) {
                    int digit = chars[i] - 48;
                    if (digit < 0 || digit > 9) {
                        throw new NumberFormatException(new String(chars, start, length));
                    }
                    return digit;
                }
                limit = -9223372036854775807L;
            }
            int max = start + length;
            if (i < max) {
                int digit;
                if ((digit = chars[i++] - 48) < 0 || digit > 9) {
                    throw new NumberFormatException(new String(chars, start, length));
                }
                result = -digit;
            }
            long multmin = limit / 10L;
            while (i < max) {
                int digit;
                if ((digit = chars[i++] - 48) < 0 || digit > 9) {
                    throw new NumberFormatException(new String(chars, start, length));
                }
                if (result < multmin) {
                    throw new NumberFormatException(new String(chars, start, length));
                }
                if ((result *= 10L) < limit + (long)digit) {
                    throw new NumberFormatException(new String(chars, start, length));
                }
                result -= (long)digit;
            }
            if (negative) {
                if (i > start + 1) {
                    return result;
                }
                throw new NumberFormatException(new String(chars, start, length));
            }
            return -result;
        }
        throw new NumberFormatException(new String(chars, start, length));
    }

    private byte[] getByteArrayFromStream(InputStream dbis) throws IOException {
        int count;
        int length = (int)this.getNumberFromStream(dbis, ':');
        if (length < 0) {
            return null;
        }
        if (length > 0x800000) {
            throw new IOException("Byte array length too large (" + length + ")");
        }
        byte[] tempArray = new byte[length];
        int len = 0;
        for (count = 0; count != length && (len = dbis.read(tempArray, count, length - count)) > 0; count += len) {
        }
        if (count != tempArray.length) {
            throw new IOException("BDecoder::getByteArrayFromStream: truncated");
        }
        return tempArray;
    }

    public void setRecoveryMode(boolean r) {
        this.recovery_mode = r;
    }

    public static void print(Object obj) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        BDecoder.print(pw, obj);
        pw.flush();
        System.out.println(sw.toString());
    }

    public static void print(PrintWriter writer, Object obj) {
        BDecoder.print(writer, obj, "", false);
    }

    private static void print(PrintWriter writer, Object obj, String indent, boolean skip_indent) {
        String use_indent;
        String string = use_indent = skip_indent ? "" : indent;
        if (obj instanceof Long) {
            writer.println(use_indent + obj);
        } else if (obj instanceof byte[]) {
            byte[] b = (byte[])obj;
            if (b.length == 20) {
                writer.println(use_indent + " { " + ByteFormatter.nicePrint(b) + " }");
            } else if (b.length < 64) {
                writer.println(new String(b) + " [" + ByteFormatter.encodeString(b) + "]");
            } else {
                writer.println("[byte array length " + b.length);
            }
        } else if (obj instanceof String) {
            writer.println(use_indent + obj);
        } else if (obj instanceof List) {
            List l = (List)obj;
            writer.println(use_indent + "[");
            for (int i = 0; i < l.size(); ++i) {
                writer.print(indent + "  (" + i + ") ");
                BDecoder.print(writer, l.get(i), indent + "    ", true);
            }
            writer.println(indent + "]");
        } else {
            Map m = (Map)obj;
            for (String key : m.keySet()) {
                if (key.length() > 256) {
                    writer.print(indent + key.substring(0, 256) + "... = ");
                } else {
                    writer.print(indent + key + " = ");
                }
                BDecoder.print(writer, m.get(key), indent + "  ", true);
            }
        }
    }

    public static Map decodeStrings(Map map) {
        if (map == null) {
            return null;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof byte[]) {
                try {
                    entry.setValue(new String((byte[])value, "UTF-8"));
                }
                catch (Throwable e) {
                    System.err.println(e);
                }
                continue;
            }
            if (value instanceof Map) {
                BDecoder.decodeStrings((Map)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            BDecoder.decodeStrings((List)value);
        }
        return map;
    }

    public static List decodeStrings(List list) {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object value = list.get(i);
            if (value instanceof byte[]) {
                try {
                    String str = new String((byte[])value, "UTF-8");
                    list.set(i, str);
                }
                catch (Throwable e) {
                    System.err.println(e);
                }
                continue;
            }
            if (value instanceof Map) {
                BDecoder.decodeStrings((Map)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            BDecoder.decodeStrings((List)value);
        }
        return list;
    }

    private static void print(File f, File output) {
        try {
            BDecoder decoder = new BDecoder();
            decoder.setRecoveryMode(false);
            PrintWriter pw = new PrintWriter(new FileWriter(output));
            BDecoder.print(pw, decoder.decodeStream(new BufferedInputStream(new FileInputStream(f))));
            pw.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        BDecoder.print(new File("C:\\Temp\\tables.config"), new File("C:\\Temp\\tables.txt"));
    }

    private class BDecoderInputStreamArray
    extends InputStream {
        private final byte[] buffer;
        private final int count;
        private int pos;
        private int mark;

        private BDecoderInputStreamArray(byte[] _buffer) {
            this.buffer = _buffer;
            this.count = this.buffer.length;
        }

        private BDecoderInputStreamArray(byte[] _buffer, int _offset, int _length) {
            this.buffer = _buffer;
            this.pos = _offset;
            this.count = Math.min(_offset + _length, _buffer.length);
            this.mark = _offset;
        }

        public int read() throws IOException {
            return this.pos < this.count ? this.buffer[this.pos++] & 0xFF : -1;
        }

        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        public int read(byte[] b, int offset, int length) throws IOException {
            if (this.pos >= this.count) {
                return -1;
            }
            if (this.pos + length > this.count) {
                length = this.count - this.pos;
            }
            if (length <= 0) {
                return 0;
            }
            System.arraycopy(this.buffer, this.pos, b, offset, length);
            this.pos += length;
            return length;
        }

        public int available() throws IOException {
            return this.count - this.pos;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int limit) {
            this.mark = this.pos;
        }

        public void reset() throws IOException {
            this.pos = this.mark;
        }
    }
}

