/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.util.Debug;

public class Constants {
    public static final String EMPTY_STRING = "";
    public static final String SF_WEB_SITE = "http://azureus.sourceforge.net/";
    public static final String AELITIS_TORRENTS = "http://torrents.aelitis.com:88/torrents/";
    public static final String AELITIS_FILES = "http://torrents.aelitis.com:88/files/";
    public static final String AZUREUS_WIKI = "http://wiki.vuze.com/index.php/";
    public static final String VERSION_SERVER_V4 = "version.azureusplatform.com";
    public static final String VERSION_SERVER_V6 = "version6.azureusplatform.com";
    public static final String DHT_SEED_ADDRESS_V4 = "dht.aelitis.com";
    public static final String DHT_SEED_ADDRESS_V6 = "dht6.azureusplatform.com";
    public static final String NAT_TEST_SERVER = "nettest.azureusplatform.com";
    public static final String NAT_TEST_SERVER_HTTP = "http://nettest.azureusplatform.com/";
    public static final String SPEED_TEST_SERVER = "speed.azureusplatform.com";
    public static final String[] AZUREUS_DOMAINS = new String[]{"azureusplatform.com", "azureus.com", "aelitis.com", "vuze.com"};
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final String BYTE_ENCODING = "ISO-8859-1";
    public static Charset BYTE_CHARSET;
    public static Charset DEFAULT_CHARSET;
    public static final Locale LOCALE_ENGLISH;
    public static final String INFINITY_STRING = "\u221e";
    public static final int CRAPPY_INFINITY_AS_INT = 31536000;
    public static final long CRAPPY_INFINITE_AS_LONG = 1827387392L;
    public static String APP_NAME;
    public static final String AZUREUS_NAME = "Azureus";
    public static final String AZUREUS_VERSION = "4.2.0.8";
    public static final byte[] VERSION_ID;
    public static final String OSName;
    public static final boolean isOSX;
    public static final boolean isLinux;
    public static final boolean isSolaris;
    public static final boolean isFreeBSD;
    public static final boolean isWindowsXP;
    public static final boolean isWindowsVista;
    public static final boolean isWindows95;
    public static final boolean isWindows98;
    public static final boolean isWindows2000;
    public static final boolean isWindowsME;
    public static final boolean isWindows9598ME;
    public static boolean isSafeMode;
    public static final boolean isWindows;
    public static final boolean isUnix;
    public static final boolean isWindowsVistaOrHigher;
    public static final String JAVA_VERSION;
    public static final String FILE_WILDCARD;

    public static String getBaseVersion() {
        return Constants.getBaseVersion(AZUREUS_VERSION);
    }

    public static String getBaseVersion(String version) {
        int p1 = version.indexOf("_");
        if (p1 == -1) {
            return version;
        }
        return version.substring(0, p1);
    }

    public static boolean isCVSVersion() {
        return Constants.isCVSVersion(AZUREUS_VERSION);
    }

    public static boolean isCVSVersion(String version) {
        return version.indexOf("_") != -1;
    }

    public static int getIncrementalBuild() {
        return Constants.getIncrementalBuild(AZUREUS_VERSION);
    }

    public static int getIncrementalBuild(String version) {
        if (!Constants.isCVSVersion(version)) {
            return 0;
        }
        int p1 = version.indexOf("_B");
        if (p1 == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(version.substring(p1 + 2));
        }
        catch (Throwable e) {
            System.out.println("can't parse version");
            return -1;
        }
    }

    public static int compareVersions(String version_1, String version_2) {
        try {
            block7: {
                if (version_1.startsWith(".")) {
                    version_1 = "0" + version_1;
                }
                if (version_2.startsWith(".")) {
                    version_2 = "0" + version_2;
                }
                version_1 = version_1.replaceAll("[^0-9.]", ".");
                version_2 = version_2.replaceAll("[^0-9.]", ".");
                StringTokenizer tok1 = new StringTokenizer(version_1, ".");
                StringTokenizer tok2 = new StringTokenizer(version_2, ".");
                while (true) {
                    int i1;
                    if (tok1.hasMoreTokens() && tok2.hasMoreTokens()) {
                        int i2;
                        i1 = Integer.parseInt(tok1.nextToken());
                        if (i1 == (i2 = Integer.parseInt(tok2.nextToken()))) continue;
                        return i1 - i2;
                    }
                    if (tok1.hasMoreTokens()) {
                        i1 = Integer.parseInt(tok1.nextToken());
                        if (i1 == 0) continue;
                        return 1;
                    }
                    if (!tok2.hasMoreTokens()) break block7;
                    int i2 = Integer.parseInt(tok2.nextToken());
                    if (i2 != 0) break;
                }
                return -1;
            }
            return 0;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return 0;
        }
    }

    public static boolean isValidVersionFormat(String version) {
        if (version == null || version.length() == 0) {
            return false;
        }
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return !version.startsWith(".") && !version.endsWith(".") && version.indexOf("..") == -1;
    }

    public static boolean isAzureusDomain(String host) {
        host = host.toLowerCase();
        for (int i = 0; i < AZUREUS_DOMAINS.length; ++i) {
            String domain = AZUREUS_DOMAINS[i];
            if (domain.equals(host)) {
                return true;
            }
            if (!host.endsWith("." + domain)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(Constants.compareVersions("3.0.0.1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0", "3.0.0.0_B1"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0_B4"));
        System.out.println(Constants.compareVersions("3.0.0.0..B1", "3.0.0.0_B4"));
    }

    static {
        try {
            BYTE_CHARSET = Charset.forName(BYTE_ENCODING);
            DEFAULT_CHARSET = Charset.forName(DEFAULT_ENCODING);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        LOCALE_ENGLISH = new Locale("en", EMPTY_STRING);
        APP_NAME = "Vuze";
        VERSION_ID = "-AZ4208-".getBytes();
        OSName = System.getProperty("os.name");
        isOSX = OSName.toLowerCase().startsWith("mac os");
        isLinux = OSName.equalsIgnoreCase("Linux");
        isSolaris = OSName.equalsIgnoreCase("SunOS");
        isFreeBSD = OSName.equalsIgnoreCase("FreeBSD");
        isWindowsXP = OSName.equalsIgnoreCase("Windows XP");
        isWindowsVista = OSName.equalsIgnoreCase("Windows Vista");
        isWindows95 = OSName.equalsIgnoreCase("Windows 95");
        isWindows98 = OSName.equalsIgnoreCase("Windows 98");
        isWindows2000 = OSName.equalsIgnoreCase("Windows 2000");
        isWindowsME = OSName.equalsIgnoreCase("Windows ME");
        isWindows9598ME = isWindows95 || isWindows98 || isWindowsME;
        isSafeMode = false;
        isWindows = OSName.toLowerCase().startsWith("windows");
        boolean bl = isUnix = !isWindows && !isOSX;
        if (isWindows) {
            Float ver = null;
            try {
                ver = new Float(System.getProperty("os.version"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            isWindowsVistaOrHigher = ver != null && ver.floatValue() >= 6.0f;
        } else {
            isWindowsVistaOrHigher = false;
        }
        JAVA_VERSION = System.getProperty("java.version");
        FILE_WILDCARD = isWindows ? "*.*" : "*";
    }
}

