/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class FileUtil {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String DIR_SEP = System.getProperty("file.separator");
    private static final int RESERVED_FILE_HANDLE_COUNT = 4;
    private static List reserved_file_handles = new ArrayList();
    private static AEMonitor class_mon = new AEMonitor("FileUtil:class");
    private static Method reflectOnUsableSpace;

    public static boolean isAncestorOf(File parent, File child) {
        if ((parent = FileUtil.canonise(parent)).equals(child = FileUtil.canonise(child))) {
            return true;
        }
        String parent_s = parent.getPath();
        String child_s = child.getPath();
        if (parent_s.charAt(parent_s.length() - 1) != File.separatorChar) {
            parent_s = parent_s + File.separatorChar;
        }
        return child_s.startsWith(parent_s);
    }

    public static File canonise(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ioe) {
            return file;
        }
    }

    public static String getCanonicalFileName(String filename) {
        String canonicalFileName = filename;
        try {
            canonicalFileName = new File(filename).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return canonicalFileName;
    }

    public static File getUserFile(String filename) {
        return new File(SystemProperties.getUserPath(), filename);
    }

    public static File getApplicationFile(String filename) {
        String path = SystemProperties.getApplicationPath();
        if (Constants.isOSX) {
            path = path + "/" + SystemProperties.getApplicationName() + ".app/Contents/";
        }
        return new File(path, filename);
    }

    public static boolean recursiveDelete(File f) {
        String defSaveDir = COConfigurationManager.getStringParameter("Default save path");
        String moveToDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
        try {
            moveToDir = new File(moveToDir).getCanonicalPath();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            defSaveDir = new File(defSaveDir).getCanonicalPath();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (f.getCanonicalPath().equals(moveToDir)) {
                System.out.println("FileUtil::recursiveDelete:: not allowed to delete the MoveTo dir !");
                return false;
            }
            if (f.getCanonicalPath().equals(defSaveDir)) {
                System.out.println("FileUtil::recursiveDelete:: not allowed to delete the default data dir !");
                return false;
            }
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (FileUtil.recursiveDelete(files[i])) continue;
                    return false;
                }
                if (!f.delete()) {
                    return false;
                }
            } else if (!f.delete()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static long getFileOrDirectorySize(File file) {
        if (file.isFile()) {
            return file.length();
        }
        long res = 0L;
        File[] files = file.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                res += FileUtil.getFileOrDirectorySize(files[i]);
            }
        }
        return res;
    }

    protected static void recursiveEmptyDirDelete(File f, Set ignore_set, boolean log_warnings) {
        try {
            String defSaveDir = COConfigurationManager.getStringParameter("Default save path");
            String moveToDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
            if (defSaveDir.trim().length() > 0) {
                defSaveDir = new File(defSaveDir).getCanonicalPath();
            }
            if (moveToDir.trim().length() > 0) {
                moveToDir = new File(moveToDir).getCanonicalPath();
            }
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                if (files == null) {
                    if (log_warnings) {
                        Debug.out("Empty folder delete:  failed to list contents of directory " + f);
                    }
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    File x = files[i];
                    if (x.isDirectory()) {
                        FileUtil.recursiveEmptyDirDelete(files[i], ignore_set, log_warnings);
                        continue;
                    }
                    if (!ignore_set.contains(x.getName().toLowerCase()) || x.delete() || !log_warnings) continue;
                    Debug.out("Empty folder delete: failed to delete file " + x);
                }
                if (f.getCanonicalPath().equals(moveToDir)) {
                    if (log_warnings) {
                        Debug.out("Empty folder delete:  not allowed to delete the MoveTo dir !");
                    }
                    return;
                }
                if (f.getCanonicalPath().equals(defSaveDir)) {
                    if (log_warnings) {
                        Debug.out("Empty folder delete:  not allowed to delete the default data dir !");
                    }
                    return;
                }
                File[] files_inside = f.listFiles();
                if (files_inside.length == 0) {
                    if (!f.delete() && log_warnings) {
                        Debug.out("Empty folder delete:  failed to delete directory " + f);
                    }
                } else if (log_warnings) {
                    Debug.out("Empty folder delete:  " + files_inside.length + " file(s)/folder(s) still in \"" + f + "\" - first listed item is \"" + files_inside[0].getName() + "\". Not removing.");
                }
            }
        }
        catch (Exception e) {
            Debug.out(e.toString());
        }
    }

    public static String convertOSSpecificChars(String file_name_in, boolean is_folder) {
        int i;
        char[] chars = file_name_in.toCharArray();
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] != '\"') continue;
            chars[i] = 39;
        }
        if (!Constants.isOSX) {
            if (Constants.isWindows) {
                int i2;
                String not_allowed = "\\/:?*<>|";
                for (i2 = 0; i2 < chars.length; ++i2) {
                    if (not_allowed.indexOf(chars[i2]) == -1) continue;
                    chars[i2] = 95;
                }
                if (is_folder) {
                    for (i2 = chars.length - 1; i2 >= 0 && (chars[i2] == '.' || chars[i2] == ' '); --i2) {
                        chars[i2] = 95;
                    }
                }
            }
            for (i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c != '/' && c != '\r' && c != '\n') continue;
                chars[i] = 32;
            }
        }
        String file_name_out = new String(chars);
        try {
            if (Constants.isWindows) {
                while (file_name_out.endsWith(" ")) {
                    file_name_out = file_name_out.substring(0, file_name_out.length() - 1);
                }
            } else {
                String str = new File(file_name_out).getCanonicalFile().toString();
                int p = str.lastIndexOf(File.separator);
                file_name_out = str.substring(p + 1);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return file_name_out;
    }

    public static void writeResilientConfigFile(String file_name, Map data) {
        File parent_dir = new File(SystemProperties.getUserPath());
        boolean use_backups = COConfigurationManager.getBooleanParameter("Use Config File Backups");
        FileUtil.writeResilientFile(parent_dir, file_name, data, use_backups);
    }

    public static void writeResilientFile(File file, Map data) {
        FileUtil.writeResilientFile(file.getParentFile(), file.getName(), data, false);
    }

    public static void writeResilientFile(File parent_dir, String file_name, Map data, boolean use_backup) {
        FileUtil.writeResilientFile(parent_dir, file_name, data, use_backup, true);
    }

    public static void writeResilientFile(File parent_dir, String file_name, Map data, boolean use_backup, boolean copy_to_backup) {
        File originator;
        if (use_backup && (originator = new File(parent_dir, file_name)).exists()) {
            FileUtil.backupFile(originator, copy_to_backup);
        }
        FileUtil.writeResilientFile(parent_dir, file_name, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResilientFile(File parent_dir, String file_name, Map data) {
        try {
            class_mon.enter();
            try {
                FileUtil.getReservedFileHandles();
                File temp = new File(parent_dir, file_name + ".saving");
                FilterOutputStream baos = null;
                try {
                    byte[] encoded_data = BEncoder.encode(data);
                    FileOutputStream tempOS = new FileOutputStream(temp, false);
                    baos = new BufferedOutputStream(tempOS, 8192);
                    baos.write(encoded_data);
                    ((BufferedOutputStream)baos).flush();
                    tempOS.getFD().sync();
                    baos.close();
                    baos = null;
                    if (temp.length() > 1L) {
                        File file = new File(parent_dir, file_name);
                        if (file.exists()) {
                            file.delete();
                        }
                        temp.renameTo(file);
                    }
                }
                catch (Exception e) {
                    Logger.log(new LogAlert(false, "Save of '" + file_name + "' fails", e));
                }
                finally {
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                    }
                    catch (Exception e) {
                        Logger.log(new LogAlert(false, "Save of '" + file_name + "' fails", e));
                    }
                }
            }
            finally {
                FileUtil.releaseReservedFileHandles();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static boolean resilientConfigFileExists(String name) {
        File parent_dir = new File(SystemProperties.getUserPath());
        boolean use_backups = COConfigurationManager.getBooleanParameter("Use Config File Backups");
        return new File(parent_dir, name).exists() || use_backups && new File(parent_dir, name + ".bak").exists();
    }

    public static Map readResilientConfigFile(String file_name) {
        File parent_dir = new File(SystemProperties.getUserPath());
        boolean use_backups = COConfigurationManager.getBooleanParameter("Use Config File Backups");
        return FileUtil.readResilientFile(parent_dir, file_name, use_backups);
    }

    public static Map readResilientConfigFile(String file_name, boolean use_backups) {
        File parent_dir = new File(SystemProperties.getUserPath());
        if (!use_backups && new File(parent_dir, file_name + ".bak").exists()) {
            use_backups = true;
        }
        return FileUtil.readResilientFile(parent_dir, file_name, use_backups);
    }

    public static Map readResilientFile(File file) {
        return FileUtil.readResilientFile(file.getParentFile(), file.getName(), false, true);
    }

    public static Map readResilientFile(File parent_dir, String file_name, boolean use_backup) {
        return FileUtil.readResilientFile(parent_dir, file_name, use_backup, true);
    }

    public static Map readResilientFile(File parent_dir, String file_name, boolean use_backup, boolean intern_keys) {
        Map res;
        File backup_file = new File(parent_dir, file_name + ".bak");
        if (use_backup) {
            use_backup = backup_file.exists();
        }
        if ((res = FileUtil.readResilientFileSupport(parent_dir, file_name, !use_backup, intern_keys)) == null && use_backup) {
            res = FileUtil.readResilientFileSupport(parent_dir, file_name + ".bak", false, intern_keys);
            if (res != null) {
                Logger.log(new LogAlert(false, 1, "Backup file '" + backup_file + "' has been used for recovery purposes"));
                FileUtil.writeResilientFile(parent_dir, file_name, res, false);
            } else {
                res = FileUtil.readResilientFileSupport(parent_dir, file_name, true, true);
            }
        }
        if (res == null) {
            res = new HashMap();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map readResilientFileSupport(File parent_dir, String file_name, boolean attempt_recovery, boolean intern_keys) {
        try {
            Map map;
            class_mon.enter();
            try {
                FileUtil.getReservedFileHandles();
                Map res = null;
                try {
                    res = FileUtil.readResilientFile(file_name, parent_dir, file_name, 0, false, intern_keys);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (res == null && attempt_recovery && (res = FileUtil.readResilientFile(file_name, parent_dir, file_name, 0, true, intern_keys)) != null) {
                    Logger.log(new LogAlert(false, 1, "File '" + file_name + "' has been partially recovered, " + "information may have been lost!"));
                }
                map = res;
            }
            catch (Throwable e) {
                Map map2;
                try {
                    Debug.printStackTrace(e);
                    map2 = null;
                }
                catch (Throwable throwable) {
                    FileUtil.releaseReservedFileHandles();
                    throw throwable;
                }
                FileUtil.releaseReservedFileHandles();
                class_mon.exit();
                return map2;
            }
            FileUtil.releaseReservedFileHandles();
            return map;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map readResilientFile(String original_file_name, File parent_dir, String file_name, int fail_count, boolean recovery_mode, boolean skip_key_intern) {
        boolean using_backup = file_name.endsWith(".saving");
        File file = new File(parent_dir, file_name);
        if (!file.exists() || file.length() <= 1L) {
            if (using_backup) {
                if (!recovery_mode && fail_count == 1) {
                    Logger.log(new LogAlert(false, 3, "Load of '" + original_file_name + "' fails, no usable file or backup"));
                }
                return null;
            }
            if (!recovery_mode) {
                // empty if block
            }
            return FileUtil.readResilientFile(original_file_name, parent_dir, file_name + ".saving", 0, recovery_mode, true);
        }
        BufferedInputStream bin = null;
        try {
            int retry_limit = 5;
            while (true) {
                try {
                    bin = new BufferedInputStream(new FileInputStream(file), 16384);
                }
                catch (IOException e) {
                    if (--retry_limit == 0) {
                        throw e;
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Failed to open '" + file.toString() + "', retrying", e));
                    }
                    Thread.sleep(500L);
                    continue;
                }
                break;
            }
            BDecoder decoder = new BDecoder();
            if (recovery_mode) {
                decoder.setRecoveryMode(true);
            }
            Map res = decoder.decodeStream(bin, !skip_key_intern);
            if (using_backup && !recovery_mode) {
                Logger.log(new LogAlert(false, 1, "Load of '" + original_file_name + "' had to revert to backup file"));
            }
            Map map = res;
            return map;
        }
        catch (Throwable e) {
            Map map;
            Debug.printStackTrace(e);
            try {
                if (bin != null) {
                    bin.close();
                    bin = null;
                }
            }
            catch (Exception x) {
                Debug.printStackTrace(x);
            }
            if (!recovery_mode) {
                File test;
                int bad_id = 0;
                while (true) {
                    if (!(test = new File(parent_dir, file.getName() + ".bad" + (bad_id == 0 ? "" : "" + bad_id))).exists()) break;
                    ++bad_id;
                }
                File bad = test;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Read of '" + original_file_name + "' failed, decoding error. " + "Renaming to " + bad.getName()));
                }
                FileUtil.copyFile(file, bad);
            }
            if (using_backup) {
                if (!recovery_mode) {
                    Logger.log(new LogAlert(false, 3, "Load of '" + original_file_name + "' fails, no usable file or backup"));
                }
                map = null;
                return map;
            }
            map = FileUtil.readResilientFile(original_file_name, parent_dir, file_name + ".saving", 1, recovery_mode, true);
            return map;
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void deleteResilientFile(File file) {
        file.delete();
        new File(file.getParentFile(), file.getName() + ".bak").delete();
    }

    public static void deleteResilientConfigFile(String name) {
        File parent_dir = new File(SystemProperties.getUserPath());
        new File(parent_dir, name).delete();
        new File(parent_dir, name + ".bak").delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getReservedFileHandles() {
        try {
            class_mon.enter();
            while (reserved_file_handles.size() > 0) {
                InputStream is = (InputStream)reserved_file_handles.remove(0);
                try {
                    is.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseReservedFileHandles() {
        try {
            class_mon.enter();
            File lock_file = new File(SystemProperties.getUserPath() + ".lock");
            lock_file.createNewFile();
            while (reserved_file_handles.size() < 4) {
                FileInputStream is = new FileInputStream(lock_file);
                reserved_file_handles.add(is);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        finally {
            class_mon.exit();
        }
    }

    public static void backupFile(String _filename, boolean _make_copy) {
        FileUtil.backupFile(new File(_filename), _make_copy);
    }

    public static void backupFile(File _file, boolean _make_copy) {
        if (_file.length() > 0L) {
            File bakfile = new File(_file.getAbsolutePath() + ".bak");
            if (bakfile.exists()) {
                bakfile.delete();
            }
            if (_make_copy) {
                FileUtil.copyFile(_file, bakfile);
            } else {
                _file.renameTo(bakfile);
            }
        }
    }

    public static boolean copyFile(String _source_name, String _dest_name) {
        return FileUtil.copyFile(new File(_source_name), new File(_dest_name));
    }

    public static boolean copyFile(File _source, File _dest) {
        try {
            FileUtil.copyFile((InputStream)new FileInputStream(_source), new FileOutputStream(_dest));
            return true;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    public static void copyFileWithException(File _source, File _dest) throws IOException {
        FileUtil.copyFile((InputStream)new FileInputStream(_source), new FileOutputStream(_dest));
    }

    public static boolean copyFile(File _source, OutputStream _dest, boolean closeInputStream) {
        try {
            FileUtil.copyFile((InputStream)new FileInputStream(_source), _dest, closeInputStream);
            return true;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream _source, File _dest) throws IOException {
        FileOutputStream dest = null;
        boolean close_input = true;
        try {
            dest = new FileOutputStream(_dest);
            close_input = false;
            FileUtil.copyFile(_source, (OutputStream)dest, true);
        }
        finally {
            try {
                if (close_input) {
                    _source.close();
                }
            }
            catch (IOException e) {}
            if (dest != null) {
                dest.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream _source, File _dest, boolean _close_input_stream) throws IOException {
        FileOutputStream dest = null;
        boolean close_input = _close_input_stream;
        try {
            dest = new FileOutputStream(_dest);
            close_input = false;
            FileUtil.copyFile(_source, (OutputStream)dest, close_input);
        }
        finally {
            try {
                if (close_input) {
                    _source.close();
                }
            }
            catch (IOException e) {}
            if (dest != null) {
                dest.close();
            }
        }
    }

    public static void copyFile(InputStream is, OutputStream os) throws IOException {
        FileUtil.copyFile(is, os, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream is, OutputStream os, boolean closeInputStream) throws IOException {
        try {
            int len;
            if (!(is instanceof BufferedInputStream)) {
                is = new BufferedInputStream(is);
            }
            byte[] buffer = new byte[131072];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        finally {
            try {
                if (closeInputStream) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            os.close();
        }
    }

    public static void copyFileOrDirectory(File from_file_or_dir, File to_parent_dir) throws IOException {
        if (!from_file_or_dir.exists()) {
            throw new IOException("File '" + from_file_or_dir.toString() + "' doesn't exist");
        }
        if (!to_parent_dir.exists()) {
            throw new IOException("File '" + to_parent_dir.toString() + "' doesn't exist");
        }
        if (!to_parent_dir.isDirectory()) {
            throw new IOException("File '" + to_parent_dir.toString() + "' is not a directory");
        }
        if (from_file_or_dir.isDirectory()) {
            File[] files = from_file_or_dir.listFiles();
            File new_parent = new File(to_parent_dir, from_file_or_dir.getName());
            FileUtil.mkdirs(new_parent);
            for (int i = 0; i < files.length; ++i) {
                File from_file = files[i];
                FileUtil.copyFileOrDirectory(from_file, new_parent);
            }
        } else {
            File target = new File(to_parent_dir, from_file_or_dir.getName());
            if (!FileUtil.copyFile(from_file_or_dir, target)) {
                throw new IOException("File copy from " + from_file_or_dir + " to " + target + " failed");
            }
        }
    }

    public static File getFileOrBackup(String _filename) {
        try {
            File file = new File(_filename);
            if (file.length() <= 1L) {
                File bakfile = new File(_filename + ".bak");
                if (bakfile.length() <= 1L) {
                    return null;
                }
                return bakfile;
            }
            return file;
        }
        catch (Exception e) {
            Debug.out(e);
            return null;
        }
    }

    public static File getJarFileFromClass(Class cla) {
        try {
            File jar_file;
            String url_str;
            String str = cla.getName();
            str = str.replace('.', '/') + ".class";
            URL url = cla.getClassLoader().getResource(str);
            if (url != null && (url_str = url.toExternalForm()).startsWith("jar:file:") && (jar_file = FileUtil.getJarFileFromURL(url_str)).exists()) {
                return jar_file;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static File getJarFileFromURL(String url_str) {
        if (url_str.startsWith("jar:file:")) {
            if (!(url_str = url_str.replaceAll(" ", "%20")).startsWith("jar:file:/")) {
                url_str = "jar:file:/".concat(url_str.substring(9));
            }
            try {
                int posPling = url_str.lastIndexOf(33);
                String jarName = url_str.substring(4, posPling);
                URI uri = URI.create(jarName);
                File jar = new File(uri);
                return jar;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public static boolean renameFile(File from_file, File to_file) {
        return FileUtil.renameFile(from_file, to_file, true);
    }

    public static boolean renameFile(File from_file, File to_file, boolean fail_on_existing_directory) {
        return FileUtil.renameFile(from_file, to_file, fail_on_existing_directory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean renameFile(File from_file, File to_file, boolean fail_on_existing_directory, FileFilter file_filter) {
        if (!from_file.exists()) {
            Logger.log(new LogAlert(true, 3, "renameFile: source file '" + from_file + "' doesn't exist, failing"));
            return false;
        }
        if (to_file.exists() && (fail_on_existing_directory || from_file.isFile() || to_file.isFile())) {
            Logger.log(new LogAlert(true, 3, "renameFile: target file '" + to_file + "' already exists, failing"));
            return false;
        }
        File to_file_parent = to_file.getParentFile();
        if (!to_file_parent.exists()) {
            FileUtil.mkdirs(to_file_parent);
        }
        if (from_file.isDirectory()) {
            File tf;
            File ff;
            int i;
            File[] files = null;
            files = file_filter != null ? from_file.listFiles(file_filter) : from_file.listFiles();
            if (files == null) {
                return true;
            }
            int last_ok = 0;
            if (!to_file.exists()) {
                to_file.mkdir();
            }
            for (i = 0; i < files.length; ++i) {
                ff = files[i];
                tf = new File(to_file, ff.getName());
                try {
                    if (!FileUtil.renameFile(ff, tf, fail_on_existing_directory, file_filter)) break;
                    ++last_ok;
                    continue;
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(true, "renameFile: failed to rename file '" + ff.toString() + "' to '" + tf.toString() + "'", e));
                    break;
                }
            }
            if (last_ok == files.length) {
                File[] remaining = from_file.listFiles();
                if (remaining != null && remaining.length > 0) {
                    if (file_filter != null) return true;
                    Logger.log(new LogAlert(true, 3, "renameFile: files remain in '" + from_file.toString() + "', not deleting"));
                    return true;
                } else {
                    if (from_file.delete()) return true;
                    Logger.log(new LogAlert(true, 3, "renameFile: failed to delete '" + from_file.toString() + "'"));
                }
                return true;
            }
            for (i = 0; i < last_ok; ++i) {
                ff = files[i];
                tf = new File(to_file, ff.getName());
                try {
                    if (FileUtil.renameFile(tf, ff, false, null)) continue;
                    Logger.log(new LogAlert(true, 3, "renameFile: recovery - failed to move file '" + tf.toString() + "' to '" + ff.toString() + "'"));
                    continue;
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(true, "renameFile: recovery - failed to move file '" + tf.toString() + "' to '" + ff.toString() + "'", e));
                }
            }
            return false;
        }
        if (!COConfigurationManager.getBooleanParameter("Copy And Delete Data Rather Than Move") && from_file.renameTo(to_file)) {
            return true;
        }
        boolean success = false;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int len;
            fis = new FileInputStream(from_file);
            fos = new FileOutputStream(to_file);
            byte[] buffer = new byte[65536];
            while ((len = fis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            fos = null;
            fis.close();
            fis = null;
            if (!from_file.delete()) {
                Logger.log(new LogAlert(true, 3, "renameFile: failed to delete '" + from_file.toString() + "'"));
                throw new Exception("Failed to delete '" + from_file.toString() + "'");
            }
            success = true;
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            Logger.log(new LogAlert(true, "renameFile: failed to rename '" + from_file.toString() + "' to '" + to_file.toString() + "'", e));
            boolean bl = false;
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable e) {}
            }
            if (!success && to_file.exists()) {
                to_file.delete();
            }
        }
    }

    public static void writeBytesAsFile(String filename, byte[] file_data) {
        FileUtil.writeBytesAsFile2(filename, file_data);
    }

    public static boolean writeBytesAsFile2(String filename, byte[] file_data) {
        try {
            File file = new File(filename);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(file);
            out.write(file_data);
            out.close();
            return true;
        }
        catch (Throwable t) {
            Debug.out("writeBytesAsFile:: error: ", t);
            return false;
        }
    }

    public static boolean deleteWithRecycle(File file) {
        if (COConfigurationManager.getBooleanParameter("Move Deleted Data To Recycle Bin")) {
            try {
                PlatformManager platform = PlatformManagerFactory.getPlatformManager();
                if (platform.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                    platform.performRecoverableFileDelete(file.getAbsolutePath());
                    return true;
                }
                return file.delete();
            }
            catch (PlatformManagerException e) {
                return file.delete();
            }
        }
        return file.delete();
    }

    public static String translateMoveFilePath(String old_root, String new_root, String file_to_move) {
        if (!file_to_move.startsWith(old_root)) {
            return null;
        }
        String file_suffix = file_to_move.substring(old_root.length());
        if (new_root.endsWith(File.separator)) {
            new_root = new_root.substring(0, new_root.length() - 1);
        }
        if (file_suffix.startsWith(File.separator)) {
            file_suffix = file_suffix.substring(1);
        }
        return new_root + File.separator + file_suffix;
    }

    public static void runAsTask(AzureusCoreOperationTask task2) {
        AzureusCore core = AzureusCoreFactory.getSingleton();
        core.createOperation(2, task2);
    }

    public static boolean mkdirs(File f) {
        String sVolume;
        File fVolume;
        Pattern pat;
        Matcher matcher;
        if (Constants.isOSX && (matcher = (pat = Pattern.compile("^(/Volumes/[^/]+)")).matcher(f.getParent())).find() && !(fVolume = new File(sVolume = matcher.group())).isDirectory()) {
            Logger.log(new LogEvent(LOGID, 1, sVolume + " is not mounted or not available."));
            return false;
        }
        return f.mkdirs();
    }

    public static String getExtension(String fName) {
        int fileSepIndex = fName.lastIndexOf(File.separator);
        int fileDotIndex = fName.lastIndexOf(46);
        if (fileSepIndex == fName.length() - 1 || fileDotIndex == -1 || fileSepIndex > fileDotIndex) {
            return "";
        }
        return fName.substring(fileDotIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File file, int size_limit, String charset) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            String string = FileUtil.readInputStreamAsString(fis, size_limit, charset);
            return string;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File file, int size_limit) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            String string = FileUtil.readInputStreamAsString(fis, size_limit);
            return string;
        }
        finally {
            fis.close();
        }
    }

    public static String readInputStreamAsString(InputStream is, int size_limit) throws IOException {
        return FileUtil.readInputStreamAsString(is, size_limit, "ISO-8859-1");
    }

    public static String readInputStreamAsString(InputStream is, int size_limit, String charSet) throws IOException {
        int len;
        StringBuffer result = new StringBuffer(1024);
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) > 0) {
            result.append(new String(buffer, 0, len, charSet));
            if (size_limit < 0 || result.length() <= size_limit) continue;
            result.setLength(size_limit);
            break;
        }
        return result.toString();
    }

    public static String readInputStreamAsStringWithTruncation(InputStream is, int size_limit) throws IOException {
        StringBuffer result = new StringBuffer(1024);
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = is.read(buffer)) > 0) {
                result.append(new String(buffer, 0, len, "ISO-8859-1"));
                if (size_limit < 0 || result.length() <= size_limit) continue;
                result.setLength(size_limit);
                break;
            }
        }
        catch (SocketTimeoutException e) {
            // empty catch block
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileEndAsString(File file, int size_limit) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            int len;
            if (file.length() > (long)size_limit) {
                fis.skip(file.length() - (long)size_limit);
            }
            StringBuffer result = new StringBuffer(1024);
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer)) > 0) {
                result.append(new String(buffer, 0, len, "ISO-8859-1"));
                if (result.length() <= size_limit) continue;
                result.setLength(size_limit);
                break;
            }
            String string = result.toString();
            return string;
        }
        finally {
            fis.close();
        }
    }

    public static byte[] readInputStreamAsByteArray(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
        byte[] buffer = new byte[32768];
        while ((len = is.read(buffer)) > 0) {
            baos.write(buffer, 0, len);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileAsByteArray(File file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)file.length());
        byte[] buffer = new byte[32768];
        FileInputStream is = new FileInputStream(file);
        try {
            int len;
            while ((len = ((InputStream)is).read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static final boolean getUsableSpaceSupported() {
        return reflectOnUsableSpace != null;
    }

    public static final long getUsableSpace(File f) {
        try {
            return (Long)reflectOnUsableSpace.invoke((Object)f, null);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    static {
        try {
            reflectOnUsableSpace = File.class.getMethod("getUsableSpace", null);
        }
        catch (NoSuchMethodException e) {
            reflectOnUsableSpace = null;
        }
    }
}

