/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.util.Java15Utils;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DebugLight;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class ThreadPool {
    private static final boolean LOG_WARNINGS = false;
    private static final int WARN_TIME = 10000;
    private static List busy_pools = new ArrayList();
    private static boolean busy_pool_timer_set = false;
    private static boolean debug_thread_pool;
    private static boolean debug_thread_pool_log_on;
    private static ThreadLocal tls;
    private String name;
    private int max_size;
    private int thread_name_index = 1;
    private long execution_limit;
    private List busy;
    private boolean queue_when_full;
    private List task_queue = new ArrayList();
    AESemaphore thread_sem;
    private int thread_priority = 5;
    private boolean warn_when_full;
    private long task_total;
    private long task_total_last;
    private Average task_average = Average.getInstance(10000, 120);
    private boolean log_cpu = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkAllTimeouts() {
        ArrayList pools;
        List list = busy_pools;
        synchronized (list) {
            pools = new ArrayList(busy_pools);
        }
        for (int i = 0; i < pools.size(); ++i) {
            ((ThreadPool)pools.get(i)).checkTimeouts();
        }
    }

    public ThreadPool(String _name, int _max_size) {
        this(_name, _max_size, false);
    }

    public ThreadPool(String _name, int _max_size, boolean _queue_when_full) {
        this.name = _name;
        this.max_size = _max_size;
        this.queue_when_full = _queue_when_full;
        this.thread_sem = new AESemaphore("ThreadPool::" + this.name, _max_size);
        this.busy = new ArrayList(_max_size);
    }

    private void generateEvidence(IndentWriter writer) {
        writer.println(this.name + ": max=" + this.max_size + ",qwf=" + this.queue_when_full + ",queue=" + this.task_queue.size() + ",busy=" + this.busy.size() + ",total=" + this.task_total + ":" + DisplayFormatters.formatDecimal(this.task_average.getDoubleAverage(), 2) + "/sec");
    }

    public void setWarnWhenFull() {
        this.warn_when_full = true;
    }

    public void setLogCPU() {
        this.log_cpu = true;
    }

    public int getMaxThreads() {
        return this.max_size;
    }

    public void setThreadPriority(int _priority) {
        this.thread_priority = _priority;
    }

    public void setExecutionLimit(long millis) {
        this.execution_limit = millis;
    }

    public threadPoolWorker run(AERunnable runnable) {
        return this.run(runnable, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public threadPoolWorker run(AERunnable runnable, boolean high_priority, boolean manualRelease) {
        threadPoolWorker allocated_worker;
        if (manualRelease && !(runnable instanceof ThreadPoolTask)) {
            throw new IllegalArgumentException("manual release only allowed for ThreadPoolTasks");
        }
        if (manualRelease) {
            ((ThreadPoolTask)runnable).manualRelease = 1;
        }
        if (!this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
            threadPoolWorker recursive_worker = (threadPoolWorker)tls.get();
            if (recursive_worker == null || recursive_worker.getOwner() != this) {
                this.checkWarning();
                this.thread_sem.reserve();
            } else {
                if (runnable instanceof ThreadPoolTask) {
                    ThreadPoolTask task2 = (ThreadPoolTask)runnable;
                    task2.worker = recursive_worker;
                    try {
                        task2.taskStarted();
                        this.runIt(runnable);
                        task2.join();
                    }
                    finally {
                        task2.taskCompleted();
                    }
                } else {
                    this.runIt(runnable);
                }
                return recursive_worker;
            }
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (high_priority) {
                this.task_queue.add(0, runnable);
            } else {
                this.task_queue.add(runnable);
            }
            if (this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
                allocated_worker = null;
                this.checkWarning();
            } else {
                allocated_worker = new threadPoolWorker();
            }
        }
        return allocated_worker;
    }

    protected void runIt(AERunnable runnable) {
        if (this.log_cpu) {
            long start_cpu = this.log_cpu ? Java15Utils.getThreadCPUTime() : 0L;
            long start_time = SystemTime.getHighPrecisionCounter();
            runnable.run();
            if (start_cpu > 0L) {
                long end_cpu = this.log_cpu ? Java15Utils.getThreadCPUTime() : 0L;
                long diff_cpu = (end_cpu - start_cpu) / 1000000L;
                long end_time = SystemTime.getHighPrecisionCounter();
                long diff_millis = (end_time - start_time) / 1000000L;
                if (diff_cpu > 10L || diff_millis > 10L) {
                    System.out.println(TimeFormatter.milliStamp() + ": Thread: " + Thread.currentThread().getName() + ": " + runnable + " -> " + diff_cpu + "/" + diff_millis);
                }
            }
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkWarning() {
        if (this.warn_when_full) {
            String task_names = "";
            try {
                ThreadPool threadPool = this;
                synchronized (threadPool) {
                    for (int i = 0; i < this.busy.size(); ++i) {
                        threadPoolWorker x = (threadPoolWorker)this.busy.get(i);
                        AERunnable r = x.runnable;
                        if (x == null) continue;
                        String name = r instanceof ThreadPoolTask ? ((ThreadPoolTask)r).getName() : x.getClass().getName();
                        task_names = task_names + (task_names.length() == 0 ? "" : ",") + name;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Debug.out("Thread pool '" + this.getName() + "' is full (busy=" + task_names + ")");
            this.warn_when_full = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AERunnable[] getQueuedTasks() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            AERunnable[] res = new AERunnable[this.task_queue.size()];
            this.task_queue.toArray(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.task_queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueued(AERunnable task2) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.task_queue.contains(task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AERunnable[] getRunningTasks() {
        ArrayList<AERunnable> runnables = new ArrayList<AERunnable>();
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            for (threadPoolWorker worker : this.busy) {
                AERunnable runnable = worker.getRunnable();
                if (runnable == null) continue;
                runnables.add(runnable);
            }
        }
        AERunnable[] res = new AERunnable[runnables.size()];
        runnables.toArray(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningCount() {
        int res = 0;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            for (threadPoolWorker worker : this.busy) {
                AERunnable runnable = worker.getRunnable();
                if (runnable == null) continue;
                ++res;
            }
        }
        return res;
    }

    public boolean isFull() {
        return this.thread_sem.getValue() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            long diff = this.task_total - this.task_total_last;
            this.task_average.addValue(diff);
            this.task_total_last = this.task_total;
            if (debug_thread_pool_log_on) {
                System.out.println("ThreadPool '" + this.getName() + "'/" + this.thread_name_index + ": max=" + this.max_size + ",sem=[" + this.thread_sem.getString() + "],busy=" + this.busy.size() + ",queue=" + this.task_queue.size());
            }
            long now = SystemTime.getCurrentTime();
            for (int i = 0; i < this.busy.size(); ++i) {
                AERunnable r;
                threadPoolWorker x = (threadPoolWorker)this.busy.get(i);
                long elapsed = now - x.run_start_time;
                if (elapsed <= (long)(10000 * (x.warn_count + 1))) continue;
                x.warn_count++;
                if (this.execution_limit <= 0L || elapsed <= this.execution_limit || (r = x.runnable) == null) continue;
                try {
                    if (r instanceof ThreadPoolTask) {
                        ((ThreadPoolTask)r).interruptTask();
                        continue;
                    }
                    x.interrupt();
                    continue;
                }
                catch (Throwable e) {
                    DebugLight.printStackTrace(e);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseManual(ThreadPoolTask toRelease) {
        if (!this.busy.contains(toRelease.worker) || toRelease.manualRelease != 2) {
            throw new IllegalStateException("task already released or not manually releasable");
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            long elapsed = SystemTime.getCurrentTime() - toRelease.worker.run_start_time;
            if (elapsed > 10000L) {
                // empty if block
            }
            this.busy.remove(toRelease.worker);
            if (this.busy.size() == 0 && !debug_thread_pool) {
                List list = busy_pools;
                synchronized (list) {
                    busy_pools.remove(this);
                }
            }
            if (this.busy.size() == 0) {
                this.thread_sem.release();
            } else {
                new threadPoolWorker();
            }
        }
    }

    public void registerThreadAsChild(threadPoolWorker parent) {
        if (tls.get() != null && tls.get() != parent) {
            throw new IllegalStateException("another parent is already set for this thread");
        }
        tls.set(parent);
    }

    public void deregisterThreadAsChild(threadPoolWorker parent) {
        if (tls.get() != parent) {
            throw new IllegalStateException("tls is not set to parent");
        }
        tls.set(null);
    }

    static {
        if (System.getProperty("transitory.startup", "0").equals("0")) {
            AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void generate(IndentWriter writer) {
                    writer.println("Thread Pools");
                    try {
                        ArrayList pools;
                        writer.indent();
                        List list = busy_pools;
                        synchronized (list) {
                            pools = new ArrayList(busy_pools);
                        }
                        for (int i = 0; i < pools.size(); ++i) {
                            ((ThreadPool)pools.get(i)).generateEvidence(writer);
                        }
                    }
                    finally {
                        writer.exdent();
                    }
                }
            });
        }
        tls = new ThreadLocal(){

            public Object initialValue() {
                return null;
            }
        };
    }

    class threadPoolWorker
    extends AEThread2 {
        private final String worker_name;
        private volatile AERunnable runnable;
        private long run_start_time;
        private int warn_count;
        private String state;

        protected threadPoolWorker() {
            super(ThreadPool.this.name + "[" + ThreadPool.this.thread_name_index++ + "]", true);
            this.state = "<none>";
            this.setPriority(ThreadPool.this.thread_priority);
            this.worker_name = ThreadPool.this.name + "[" + ThreadPool.this.thread_name_index++ + "]";
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            tls.set(this);
            boolean autoRelease = true;
            try {
                do {
                    List list;
                    long elapsed;
                    ThreadPool threadPool;
                    Object var8_6;
                    try {
                        block49: {
                            try {
                                block51: {
                                    block52: {
                                        block50: {
                                            ThreadPool threadPool2 = ThreadPool.this;
                                            // MONITORENTER : threadPool2
                                            if (ThreadPool.this.task_queue.size() <= 0) break block50;
                                            this.runnable = (AERunnable)ThreadPool.this.task_queue.remove(0);
                                            // MONITOREXIT : threadPool2
                                            threadPool2 = ThreadPool.this;
                                            // MONITORENTER : threadPool2
                                            this.run_start_time = SystemTime.getCurrentTime();
                                            this.warn_count = 0;
                                            ThreadPool.this.busy.add(this);
                                            ThreadPool.this.task_total++;
                                            if (ThreadPool.this.busy.size() != 1) break block51;
                                            break block52;
                                        }
                                        // MONITOREXIT : threadPool2
                                        var8_6 = null;
                                        if (!autoRelease) return;
                                        threadPool = ThreadPool.this;
                                        // MONITORENTER : threadPool
                                        elapsed = SystemTime.getCurrentTime() - this.run_start_time;
                                        if (elapsed > 10000L) {
                                            // empty if block
                                        }
                                        ThreadPool.this.busy.remove(this);
                                        if (ThreadPool.this.busy.size() == 0 && !debug_thread_pool) {
                                            list = busy_pools;
                                            // MONITORENTER : list
                                            busy_pools.remove(ThreadPool.this);
                                            // MONITOREXIT : list
                                        }
                                        // MONITOREXIT : threadPool
                                        return;
                                    }
                                    List list2 = busy_pools;
                                    // MONITORENTER : list2
                                    if (!busy_pools.contains(ThreadPool.this)) {
                                        busy_pools.add(ThreadPool.this);
                                        if (!busy_pool_timer_set) {
                                            COConfigurationManager.addAndFireParameterListeners(new String[]{"debug.threadpool.log.enable", "debug.threadpool.debug.trace"}, new ParameterListener(){

                                                public void parameterChanged(String name) {
                                                    debug_thread_pool = COConfigurationManager.getBooleanParameter("debug.threadpool.log.enable", false);
                                                    debug_thread_pool_log_on = COConfigurationManager.getBooleanParameter("debug.threadpool.debug.trace", false);
                                                }
                                            });
                                            busy_pool_timer_set = true;
                                            SimpleTimer.addPeriodicEvent("ThreadPool:timeout", 10000L, new TimerEventPerformer(){

                                                public void perform(TimerEvent event2) {
                                                    ThreadPool.checkAllTimeouts();
                                                }
                                            });
                                        }
                                    }
                                    // MONITOREXIT : list2
                                }
                                // MONITOREXIT : threadPool2
                                if (this.runnable instanceof ThreadPoolTask) {
                                    ThreadPoolTask tpt = (ThreadPoolTask)this.runnable;
                                    tpt.worker = this;
                                    String task_name = tpt.getName();
                                    try {
                                        if (task_name != null) {
                                            this.setName(this.worker_name + "{" + task_name + "}");
                                        }
                                        tpt.taskStarted();
                                        ThreadPool.this.runIt(this.runnable);
                                        break block49;
                                    }
                                    finally {
                                        if (task_name != null) {
                                            this.setName(this.worker_name);
                                        }
                                        if (tpt.isAutoReleaseAndAllowManual()) {
                                            tpt.taskCompleted();
                                        }
                                        autoRelease = false;
                                    }
                                }
                                ThreadPool.this.runIt(this.runnable);
                            }
                            catch (Throwable e) {
                                DebugLight.printStackTrace(e);
                                var8_6 = null;
                                if (!autoRelease) continue;
                                threadPool = ThreadPool.this;
                                // MONITORENTER : threadPool
                                elapsed = SystemTime.getCurrentTime() - this.run_start_time;
                                if (elapsed > 10000L) {
                                    // empty if block
                                }
                                ThreadPool.this.busy.remove(this);
                                if (ThreadPool.this.busy.size() == 0 && !debug_thread_pool) {
                                    list = busy_pools;
                                    // MONITORENTER : list
                                    busy_pools.remove(ThreadPool.this);
                                    // MONITOREXIT : list
                                }
                                // MONITOREXIT : threadPool
                                continue;
                            }
                        }
                        var8_6 = null;
                        if (!autoRelease) continue;
                        threadPool = ThreadPool.this;
                        // MONITORENTER : threadPool
                        elapsed = SystemTime.getCurrentTime() - this.run_start_time;
                        if (elapsed > 10000L) {
                            // empty if block
                        }
                        ThreadPool.this.busy.remove(this);
                        if (ThreadPool.this.busy.size() == 0 && !debug_thread_pool) {
                            list = busy_pools;
                            // MONITORENTER : list
                            busy_pools.remove(ThreadPool.this);
                            // MONITOREXIT : list
                        }
                        // MONITOREXIT : threadPool
                    }
                    catch (Throwable throwable) {
                        var8_6 = null;
                        if (!autoRelease) throw throwable;
                        threadPool = ThreadPool.this;
                        // MONITORENTER : threadPool
                        elapsed = SystemTime.getCurrentTime() - this.run_start_time;
                        if (elapsed > 10000L) {
                            // empty if block
                        }
                        ThreadPool.this.busy.remove(this);
                        if (ThreadPool.this.busy.size() == 0 && !debug_thread_pool) {
                            list = busy_pools;
                            // MONITORENTER : list
                            busy_pools.remove(ThreadPool.this);
                            // MONITOREXIT : list
                        }
                        // MONITOREXIT : threadPool
                        throw throwable;
                    }
                } while (this.runnable != null);
                return;
            }
            catch (Throwable e) {
                DebugLight.printStackTrace(e);
                return;
            }
            finally {
                if (autoRelease) {
                    ThreadPool.this.thread_sem.release();
                }
                tls.set(null);
            }
        }

        public void setState(String _state) {
            this.state = _state;
        }

        public String getState() {
            return this.state;
        }

        protected String getWorkerName() {
            return this.worker_name;
        }

        protected ThreadPool getOwner() {
            return ThreadPool.this;
        }

        protected AERunnable getRunnable() {
            return this.runnable;
        }

        static /* synthetic */ String access$500(threadPoolWorker x0) {
            return x0.state;
        }
    }
}

