/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileIsADirectoryException;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorrentUtils {
    public static final int TORRENT_FLAG_LOW_NOISE = 1;
    private static final String TORRENT_AZ_PROP_DHT_BACKUP_ENABLE = "dht_backup_enable";
    private static final String TORRENT_AZ_PROP_DHT_BACKUP_REQUESTED = "dht_backup_requested";
    private static final String TORRENT_AZ_PROP_TORRENT_FLAGS = "torrent_flags";
    private static final String TORRENT_AZ_PROP_PLUGINS = "plugins";
    public static final String TORRENT_AZ_PROP_OBTAINED_FROM = "obtained_from";
    private static final String MEM_ONLY_TORRENT_PATH = "?/\\!:mem_only:!\\/?";
    private static final List created_torrents;
    private static final Set created_torrents_set;
    private static ThreadLocal tls;
    private static volatile Set ignore_set;
    private static boolean bSaveTorrentBackup;
    private static CopyOnWriteList torrent_attribute_listeners;
    private static final int PIECE_HASH_TIMEOUT = 180000;
    private static Map torrent_delegates;
    private static HashSet torrentFluffKeyset;
    private static Map fluffThombstone;

    public static TOTorrent readFromFile(File file, boolean create_delegate) throws TOTorrentException {
        return TorrentUtils.readFromFile(file, create_delegate, false);
    }

    public static ExtendedTorrent readDelegateFromFile(File file, boolean force_initial_discard) throws TOTorrentException {
        return (ExtendedTorrent)TorrentUtils.readFromFile(file, true, force_initial_discard);
    }

    public static TOTorrent readFromFile(File file, boolean create_delegate, boolean force_initial_discard) throws TOTorrentException {
        TOTorrent torrent;
        try {
            File torrent_file_bak;
            torrent = TOTorrentFactory.deserialiseFromBEncodedFile(file);
            if (bSaveTorrentBackup && !(torrent_file_bak = new File(file.getParent(), file.getName() + ".bak")).exists()) {
                try {
                    torrent.serialiseToBEncodedFile(torrent_file_bak);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        catch (TOTorrentException e) {
            Debug.outNoStack(e.getMessage());
            File torrentBackup = new File(file.getParent(), file.getName() + ".bak");
            if (torrentBackup.exists()) {
                torrent = TOTorrentFactory.deserialiseFromBEncodedFile(torrentBackup);
            }
            throw e;
        }
        torrent.setAdditionalStringProperty("torrent filename", file.toString());
        if (create_delegate) {
            torrentDelegate res = new torrentDelegate(torrent, file);
            if (force_initial_discard) {
                res.discardPieces(SystemTime.getCurrentTime(), true);
            }
            return res;
        }
        return torrent;
    }

    public static TOTorrent readFromBEncodedInputStream(InputStream is) throws TOTorrentException {
        TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(is);
        torrent.removeAdditionalProperties();
        return torrent;
    }

    public static void setMemoryOnly(TOTorrent torrent, boolean mem_only) {
        if (mem_only) {
            torrent.setAdditionalStringProperty("torrent filename", MEM_ONLY_TORRENT_PATH);
        } else {
            String s = torrent.getAdditionalStringProperty("torrent filename");
            if (s != null && s.equals(MEM_ONLY_TORRENT_PATH)) {
                torrent.removeAdditionalProperty("torrent filename");
            }
        }
    }

    public static void writeToFile(TOTorrent torrent) throws TOTorrentException {
        TorrentUtils.writeToFile(torrent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(TOTorrent torrent, boolean force_backup) throws TOTorrentException {
        try {
            torrent.getMonitor().enter();
            String str = torrent.getAdditionalStringProperty("torrent filename");
            if (str == null) {
                throw new TOTorrentException("TorrentUtils::writeToFile: no 'torrent filename' attribute defined", 1);
            }
            if (str.equals(MEM_ONLY_TORRENT_PATH)) {
                return;
            }
            File torrent_file_tmp = new File(str + "._az");
            torrent.serialiseToBEncodedFile(torrent_file_tmp);
            File torrent_file = new File(str);
            if ((force_backup || COConfigurationManager.getBooleanParameter("Save Torrent Backup")) && torrent_file.exists()) {
                File torrent_file_bak = new File(str + ".bak");
                try {
                    torrent_file_bak.delete();
                    torrent_file.renameTo(torrent_file_bak);
                }
                catch (SecurityException e) {
                    Debug.printStackTrace(e);
                }
            }
            if (torrent_file.exists()) {
                torrent_file.delete();
            }
            torrent_file_tmp.renameTo(torrent_file);
        }
        finally {
            torrent.getMonitor().exit();
        }
    }

    public static void writeToFile(TOTorrent torrent, File file) throws TOTorrentException {
        TorrentUtils.writeToFile(torrent, file, false);
    }

    public static void writeToFile(TOTorrent torrent, File file, boolean force_backup) throws TOTorrentException {
        torrent.setAdditionalStringProperty("torrent filename", file.toString());
        TorrentUtils.writeToFile(torrent, force_backup);
    }

    public static String getTorrentFileName(TOTorrent torrent) throws TOTorrentException {
        String str = torrent.getAdditionalStringProperty("torrent filename");
        if (str == null) {
            throw new TOTorrentException("TorrentUtils::getTorrentFileName: no 'torrent filename' attribute defined", 1);
        }
        if (str.equals(MEM_ONLY_TORRENT_PATH)) {
            return null;
        }
        return str;
    }

    public static void copyToFile(TOTorrent torrent, File file) throws TOTorrentException {
        torrent.serialiseToBEncodedFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(TOTorrent torrent) throws TOTorrentException {
        try {
            torrent.getMonitor().enter();
            String str = torrent.getAdditionalStringProperty("torrent filename");
            if (str == null) {
                throw new TOTorrentException("TorrentUtils::delete: no 'torrent filename' attribute defined", 1);
            }
            if (str.equals(MEM_ONLY_TORRENT_PATH)) {
                return;
            }
            if (!new File(str).delete()) {
                throw new TOTorrentException("TorrentUtils::delete: failed to delete '" + str + "'", 5);
            }
            new File(str + ".bak").delete();
        }
        finally {
            torrent.getMonitor().exit();
        }
    }

    public static void delete(File torrent_file) {
        if (!FileUtil.deleteWithRecycle(torrent_file)) {
            Debug.out("TorrentUtils::delete: failed to delete '" + torrent_file + "'");
        }
        new File(torrent_file.toString() + ".bak").delete();
    }

    public static boolean move(File from_torrent, File to_torrent) {
        if (!FileUtil.renameFile(from_torrent, to_torrent)) {
            return false;
        }
        if (new File(from_torrent.toString() + ".bak").exists()) {
            FileUtil.renameFile(new File(from_torrent.toString() + ".bak"), new File(to_torrent.toString() + ".bak"));
        }
        return true;
    }

    public static String exceptionToText(TOTorrentException e) {
        String msg;
        int reason = e.getReason();
        String errorDetail = reason == 1 ? MessageText.getString("DownloadManager.error.filenotfound") : (reason == 2 ? MessageText.getString("DownloadManager.error.fileempty") : (reason == 3 ? MessageText.getString("DownloadManager.error.filetoobig") : (reason == 6 ? MessageText.getString("DownloadManager.error.filewithouttorrentinfo") : (reason == 7 ? MessageText.getString("DownloadManager.error.unsupportedencoding") : (reason == 4 ? MessageText.getString("DownloadManager.error.ioerror") : (reason == 8 ? MessageText.getString("DownloadManager.error.sha1") : (reason == 9 ? MessageText.getString("DownloadManager.error.operationcancancelled") : Debug.getNestedExceptionMessage(e))))))));
        if (errorDetail.indexOf(msg = Debug.getNestedExceptionMessage(e)) == -1) {
            errorDetail = errorDetail + " (" + msg + ")";
        }
        return errorDetail;
    }

    public static List<List<String>> announceGroupsToList(TOTorrent torrent) {
        ArrayList<List<String>> groups = new ArrayList<List<String>>();
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        if (sets.length == 0) {
            ArrayList<String> s = new ArrayList<String>();
            s.add(torrent.getAnnounceURL().toString());
            groups.add(s);
        } else {
            for (int i = 0; i < sets.length; ++i) {
                ArrayList<String> s = new ArrayList<String>();
                TOTorrentAnnounceURLSet set = sets[i];
                URL[] urls = set.getAnnounceURLs();
                for (int j = 0; j < urls.length; ++j) {
                    s.add(urls[j].toString());
                }
                if (s.size() <= 0) continue;
                groups.add(s);
            }
        }
        return groups;
    }

    public static void listToAnnounceGroups(List<List<String>> groups, TOTorrent torrent) {
        try {
            List<String> set;
            TOTorrentAnnounceURLGroup tg = torrent.getAnnounceURLGroup();
            if (groups.size() == 1 && (set = groups.get(0)).size() == 1) {
                torrent.setAnnounceURL(new URL(set.get(0)));
                tg.setAnnounceURLSets(new TOTorrentAnnounceURLSet[0]);
                return;
            }
            Vector<TOTorrentAnnounceURLSet> g = new Vector<TOTorrentAnnounceURLSet>();
            for (int i = 0; i < groups.size(); ++i) {
                List<String> set2 = groups.get(i);
                URL[] urls = new URL[set2.size()];
                for (int j = 0; j < set2.size(); ++j) {
                    urls[j] = new URL(set2.get(j));
                }
                if (urls.length <= 0) continue;
                g.add(tg.createAnnounceURLSet(urls));
            }
            Object[] sets = new TOTorrentAnnounceURLSet[g.size()];
            g.copyInto(sets);
            tg.setAnnounceURLSets((TOTorrentAnnounceURLSet[])sets);
            if (sets.length == 0) {
                torrent.setAnnounceURL(new URL("http://no.valid.urls.defined/announce"));
            }
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
        }
    }

    public static void announceGroupsInsertFirst(TOTorrent torrent, String first_url) {
        try {
            TorrentUtils.announceGroupsInsertFirst(torrent, new URL(first_url));
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
        }
    }

    public static void announceGroupsInsertFirst(TOTorrent torrent, URL first_url) {
        TorrentUtils.announceGroupsInsertFirst(torrent, new URL[]{first_url});
    }

    public static void announceGroupsInsertFirst(TOTorrent torrent, URL[] first_urls) {
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        TOTorrentAnnounceURLSet set1 = group.createAnnounceURLSet(first_urls);
        if (sets.length > 0) {
            TOTorrentAnnounceURLSet[] new_sets = new TOTorrentAnnounceURLSet[sets.length + 1];
            new_sets[0] = set1;
            System.arraycopy(sets, 0, new_sets, 1, sets.length);
            group.setAnnounceURLSets(new_sets);
        } else {
            TOTorrentAnnounceURLSet set2 = group.createAnnounceURLSet(new URL[]{torrent.getAnnounceURL()});
            group.setAnnounceURLSets(new TOTorrentAnnounceURLSet[]{set1, set2});
        }
    }

    public static void announceGroupsInsertLast(TOTorrent torrent, URL[] first_urls) {
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        TOTorrentAnnounceURLSet set1 = group.createAnnounceURLSet(first_urls);
        if (sets.length > 0) {
            TOTorrentAnnounceURLSet[] new_sets = new TOTorrentAnnounceURLSet[sets.length + 1];
            new_sets[sets.length] = set1;
            System.arraycopy(sets, 0, new_sets, 0, sets.length);
            group.setAnnounceURLSets(new_sets);
        } else {
            TOTorrentAnnounceURLSet set2 = group.createAnnounceURLSet(new URL[]{torrent.getAnnounceURL()});
            group.setAnnounceURLSets(new TOTorrentAnnounceURLSet[]{set2, set1});
        }
    }

    public static void announceGroupsSetFirst(TOTorrent torrent, String first_url) {
        List<List<String>> groups = TorrentUtils.announceGroupsToList(torrent);
        boolean found = false;
        block0: for (int i = 0; i < groups.size(); ++i) {
            List<String> set = groups.get(i);
            for (int j = 0; j < set.size(); ++j) {
                if (!first_url.equals(set.get(j))) continue;
                set.remove(j);
                set.add(0, first_url);
                groups.remove(set);
                groups.add(0, set);
                found = true;
                break block0;
            }
        }
        if (!found) {
            System.out.println("TorrentUtils::announceGroupsSetFirst - failed to find '" + first_url + "'");
        }
        TorrentUtils.listToAnnounceGroups(groups, torrent);
    }

    public static boolean announceGroupsContainsURL(TOTorrent torrent, String url) {
        List<List<String>> groups = TorrentUtils.announceGroupsToList(torrent);
        for (int i = 0; i < groups.size(); ++i) {
            List<String> set = groups.get(i);
            for (int j = 0; j < set.size(); ++j) {
                if (!url.equals(set.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean mergeAnnounceURLs(TOTorrent new_torrent, TOTorrent dest_torrent) {
        int i;
        if (new_torrent == null || dest_torrent == null) {
            return false;
        }
        List<List<String>> new_groups = TorrentUtils.announceGroupsToList(new_torrent);
        List<List<String>> dest_groups = TorrentUtils.announceGroupsToList(dest_torrent);
        ArrayList<List<String>> groups_to_add = new ArrayList<List<String>>();
        for (i = 0; i < new_groups.size(); ++i) {
            List<String> new_set = new_groups.get(i);
            boolean match = false;
            for (int j = 0; j < dest_groups.size(); ++j) {
                boolean same;
                List<String> dest_set = dest_groups.get(j);
                boolean bl = same = new_set.size() == dest_set.size();
                if (same) {
                    for (int k = 0; k < new_set.size(); ++k) {
                        String new_url = new_set.get(k);
                        if (dest_set.contains(new_url)) continue;
                        same = false;
                        break;
                    }
                }
                if (!same) continue;
                match = true;
                break;
            }
            if (match) continue;
            groups_to_add.add(new_set);
        }
        if (groups_to_add.size() == 0) {
            return false;
        }
        for (i = 0; i < groups_to_add.size(); ++i) {
            dest_groups.add(i, (List<String>)groups_to_add.get(i));
        }
        TorrentUtils.listToAnnounceGroups(dest_groups, dest_torrent);
        return true;
    }

    public static boolean replaceAnnounceURL(TOTorrent torrent, URL old_url, URL new_url) {
        boolean found = false;
        String old_str = old_url.toString();
        String new_str = new_url.toString();
        List<List<String>> l = TorrentUtils.announceGroupsToList(torrent);
        for (int i = 0; i < l.size(); ++i) {
            List<String> set = l.get(i);
            for (int j = 0; j < set.size(); ++j) {
                if (!set.get(j).equals(old_str)) continue;
                found = true;
                set.set(j, new_str);
            }
        }
        if (found) {
            TorrentUtils.listToAnnounceGroups(l, torrent);
        }
        if (torrent.getAnnounceURL().toString().equals(old_str)) {
            torrent.setAnnounceURL(new_url);
            found = true;
        }
        if (found) {
            try {
                TorrentUtils.writeToFile(torrent);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return false;
            }
        }
        return found;
    }

    public static void setResumeDataCompletelyValid(DownloadManagerState download_manager_state) {
        DiskManagerFactory.setResumeDataCompletelyValid(download_manager_state);
    }

    public static String getLocalisedName(TOTorrent torrent) {
        try {
            LocaleUtilDecoder decoder = LocaleTorrentUtil.getTorrentEncodingIfAvailable(torrent);
            if (decoder == null) {
                return new String(torrent.getName(), "UTF8");
            }
            return decoder.decodeString(torrent.getName());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new String(torrent.getName());
        }
    }

    public static void setTLSTorrentHash(HashWrapper hash) {
        ((Map)tls.get()).put("hash", hash);
    }

    public static TOTorrent getTLSTorrent() {
        HashWrapper hash = (HashWrapper)((Map)tls.get()).get("hash");
        if (hash != null) {
            try {
                AzureusCore core = AzureusCoreFactory.getSingleton();
                DownloadManager dm = core.getGlobalManager().getDownloadManager(hash);
                if (dm != null) {
                    return dm.getTorrent();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public static void setTLSDescription(String desc) {
        ((Map)tls.get()).put("desc", desc);
    }

    public static String getTLSDescription() {
        return (String)((Map)tls.get()).get("desc");
    }

    public static Object getTLS() {
        return tls.get();
    }

    public static void setTLS(Object obj) {
        Map m = (Map)obj;
        ((Map)tls.get()).putAll(m);
    }

    public static URL getDecentralisedEmptyURL() {
        try {
            return new URL("dht://");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public static void setDecentralised(TOTorrent torrent) {
        try {
            byte[] hash = torrent.getHash();
            torrent.setAnnounceURL(new URL("dht://" + ByteFormatter.encodeString(hash) + ".dht/announce"));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static boolean isDecentralised(TOTorrent torrent) {
        if (torrent == null) {
            return false;
        }
        return TorrentUtils.isDecentralised(torrent.getAnnounceURL());
    }

    public static boolean isDecentralised(URL url) {
        if (url == null) {
            return false;
        }
        return url.getProtocol().equalsIgnoreCase("dht");
    }

    private static Map getAzureusProperties(TOTorrent torrent) {
        HashMap m = torrent.getAdditionalMapProperty("azureus_properties");
        if (m == null) {
            m = new HashMap();
            torrent.setAdditionalMapProperty("azureus_properties", m);
        }
        return m;
    }

    private static Map getAzureusPrivateProperties(TOTorrent torrent) {
        HashMap m = torrent.getAdditionalMapProperty("azureus_private_properties");
        if (m == null) {
            m = new HashMap();
            torrent.setAdditionalMapProperty("azureus_private_properties", m);
        }
        return m;
    }

    public static void setObtainedFrom(File file, String str) {
        try {
            TOTorrent torrent = TorrentUtils.readFromFile(file, false, false);
            TorrentUtils.setObtainedFrom(torrent, str);
            TorrentUtils.writeToFile(torrent);
        }
        catch (TOTorrentException e) {
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public static void setObtainedFrom(TOTorrent torrent, String str) {
        Map m = TorrentUtils.getAzureusPrivateProperties(torrent);
        try {
            m.put(TORRENT_AZ_PROP_OBTAINED_FROM, str.getBytes("UTF-8"));
            TorrentUtils.fireAttributeListener(torrent, TORRENT_AZ_PROP_OBTAINED_FROM, str);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static String getObtainedFrom(TOTorrent torrent) {
        Map m = TorrentUtils.getAzureusPrivateProperties(torrent);
        byte[] from = (byte[])m.get(TORRENT_AZ_PROP_OBTAINED_FROM);
        if (from != null) {
            try {
                return new String(from, "UTF-8");
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public static void setFlag(TOTorrent torrent, int flag, boolean value) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Long flags = (Long)m.get(TORRENT_AZ_PROP_TORRENT_FLAGS);
        if (flags == null) {
            flags = new Long(0L);
        }
        m.put(TORRENT_AZ_PROP_TORRENT_FLAGS, new Long(flags.intValue() | flag));
    }

    public static boolean getFlag(TOTorrent torrent, int flag) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Long flags = (Long)m.get(TORRENT_AZ_PROP_TORRENT_FLAGS);
        if (flags == null) {
            return false;
        }
        return (flags.intValue() & flag) != 0;
    }

    public static void setPluginStringProperty(TOTorrent torrent, String name, String value) {
        HashMap<String, byte[]> p;
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object obj = m.get(TORRENT_AZ_PROP_PLUGINS);
        if (obj instanceof Map) {
            p = (HashMap<String, byte[]>)obj;
        } else {
            p = new HashMap<String, byte[]>();
            m.put(TORRENT_AZ_PROP_PLUGINS, p);
        }
        if (value == null) {
            p.remove(name);
        } else {
            p.put(name, value.getBytes());
        }
    }

    public static String getPluginStringProperty(TOTorrent torrent, String name) {
        Map p;
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object obj = m.get(TORRENT_AZ_PROP_PLUGINS);
        if (obj instanceof Map && (obj = (p = (Map)obj).get(name)) instanceof byte[]) {
            return new String((byte[])obj);
        }
        return null;
    }

    public static void setPluginMapProperty(TOTorrent torrent, String name, Map value) {
        HashMap<String, Map> p;
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object obj = m.get(TORRENT_AZ_PROP_PLUGINS);
        if (obj instanceof Map) {
            p = (HashMap<String, Map>)obj;
        } else {
            p = new HashMap<String, Map>();
            m.put(TORRENT_AZ_PROP_PLUGINS, p);
        }
        if (value == null) {
            p.remove(name);
        } else {
            p.put(name, value);
        }
    }

    public static Map getPluginMapProperty(TOTorrent torrent, String name) {
        Map p;
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object obj = m.get(TORRENT_AZ_PROP_PLUGINS);
        if (obj instanceof Map && (obj = (p = (Map)obj).get(name)) instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    public static void setDHTBackupEnabled(TOTorrent torrent, boolean enabled) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        m.put(TORRENT_AZ_PROP_DHT_BACKUP_ENABLE, new Long(enabled ? 1L : 0L));
    }

    public static boolean getDHTBackupEnabled(TOTorrent torrent) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object obj = m.get(TORRENT_AZ_PROP_DHT_BACKUP_ENABLE);
        if (obj instanceof Long) {
            return (Long)obj == 1L;
        }
        return true;
    }

    public static boolean isDHTBackupRequested(TOTorrent torrent) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        Object obj = m.get(TORRENT_AZ_PROP_DHT_BACKUP_REQUESTED);
        if (obj instanceof Long) {
            return (Long)obj == 1L;
        }
        return false;
    }

    public static void setDHTBackupRequested(TOTorrent torrent, boolean requested) {
        Map m = TorrentUtils.getAzureusProperties(torrent);
        m.put(TORRENT_AZ_PROP_DHT_BACKUP_REQUESTED, new Long(requested ? 1L : 0L));
    }

    public static boolean isReallyPrivate(TOTorrent torrent) {
        if (torrent == null) {
            return false;
        }
        if (UrlUtils.containsPasskey(torrent.getAnnounceURL())) {
            return torrent.getPrivate();
        }
        return false;
    }

    public static boolean getPrivate(TOTorrent torrent) {
        if (torrent == null) {
            return false;
        }
        return torrent.getPrivate();
    }

    public static void setPrivate(TOTorrent torrent, boolean _private) {
        if (torrent == null) {
            return;
        }
        try {
            torrent.setPrivate(_private);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static Set getIgnoreSet() {
        return TorrentUtils.getIgnoreSetSupport(false);
    }

    public static synchronized Set getIgnoreSetSupport(boolean force) {
        if (ignore_set == null || force) {
            int p1;
            HashSet<String> new_ignore_set = new HashSet<String>();
            String ignore_list = COConfigurationManager.getStringParameter("File.Torrent.IgnoreFiles", ".DS_Store;Thumbs.db;desktop.ini");
            if (ignore_set == null) {
                COConfigurationManager.addParameterListener("File.Torrent.IgnoreFiles", new ParameterListener(){

                    public void parameterChanged(String parameterName) {
                        TorrentUtils.getIgnoreSetSupport(true);
                    }
                });
            }
            int pos = 0;
            do {
                String bit;
                if ((p1 = ignore_list.indexOf(";", pos)) == -1) {
                    bit = ignore_list.substring(pos);
                } else {
                    bit = ignore_list.substring(pos, p1);
                    pos = p1 + 1;
                }
                new_ignore_set.add(bit.trim().toLowerCase());
            } while (p1 != -1);
            ignore_set = new_ignore_set;
        }
        return ignore_set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMapFluff(String[] fluff) {
        Class<TorrentUtils> clazz = TorrentUtils.class;
        synchronized (TorrentUtils.class) {
            for (int i = 0; i < fluff.length; ++i) {
                torrentFluffKeyset.add(fluff[i]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static File copyTorrentFileToSaveDir(File f, boolean persistent) throws IOException {
        File cFile;
        boolean saveTorrents = persistent && COConfigurationManager.getBooleanParameter("Save Torrent Files");
        File torrentDir = saveTorrents ? new File(COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory")) : new File(f.getParent());
        boolean moveWhenDone = COConfigurationManager.getBooleanParameter("Move Completed When Done");
        String completedDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
        if (moveWhenDone && completedDir.length() > 0 && (cFile = new File(completedDir, f.getName())).exists()) {
            torrentDir = new File(completedDir);
        }
        FileUtil.mkdirs(torrentDir);
        File fDest = new File(torrentDir, f.getName().replaceAll("%20", "."));
        if (fDest.equals(f)) {
            return f;
        }
        while (fDest.exists()) {
            fDest = new File(torrentDir, "_" + fDest.getName());
        }
        fDest.createNewFile();
        if (!FileUtil.copyFile(f, fDest)) {
            throw new IOException("File copy failed");
        }
        return fDest;
    }

    public static DownloadManager getDownloadManager(HashWrapper hash) {
        try {
            return AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManager(hash);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void recursiveEmptyDirDelete(File f) {
        TorrentUtils.recursiveEmptyDirDelete(f, true);
    }

    public static void recursiveEmptyDirDelete(File f, boolean log_warnings) {
        Set ignore_map = TorrentUtils.getIgnoreSet();
        FileUtil.recursiveEmptyDirDelete(f, ignore_map, log_warnings);
    }

    public static String nicePrintTorrentHash(TOTorrent torrent) {
        return TorrentUtils.nicePrintTorrentHash(torrent, false);
    }

    public static String nicePrintTorrentHash(TOTorrent torrent, boolean tight) {
        byte[] hash;
        if (torrent == null) {
            hash = new byte[20];
        } else {
            try {
                hash = torrent.getHash();
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
                hash = new byte[20];
            }
        }
        return ByteFormatter.nicePrint(hash, tight);
    }

    public static boolean isTorrentFile(String filename) throws FileNotFoundException, IOException {
        File check = new File(filename);
        if (!check.exists()) {
            throw new FileNotFoundException("File " + filename + " not found.");
        }
        if (!check.canRead()) {
            throw new IOException("File " + filename + " cannot be read.");
        }
        if (check.isDirectory()) {
            throw new FileIsADirectoryException("File " + filename + " is a directory.");
        }
        try {
            TOTorrentFactory.deserialiseFromBEncodedFile(check);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCreatedTorrent(TOTorrent torrent) {
        List list = created_torrents;
        synchronized (list) {
            try {
                HashWrapper hw;
                byte[] hash = torrent.getHash();
                if (created_torrents.size() == 0) {
                    COConfigurationManager.setParameter("my.created.torrents", created_torrents);
                }
                if (!created_torrents_set.contains(hw = new HashWrapper(hash))) {
                    created_torrents.add(hash);
                    created_torrents_set.add(hw);
                    COConfigurationManager.setDirty();
                }
            }
            catch (TOTorrentException tOTorrentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCreatedTorrent(TOTorrent torrent) {
        List list = created_torrents;
        synchronized (list) {
            try {
                HashWrapper hw = torrent.getHashWrapper();
                byte[] hash = hw.getBytes();
                Iterator it = created_torrents.iterator();
                while (it.hasNext()) {
                    byte[] h = (byte[])it.next();
                    if (!Arrays.equals(hash, h)) continue;
                    it.remove();
                }
                COConfigurationManager.setDirty();
                created_torrents_set.remove(hw);
            }
            catch (TOTorrentException tOTorrentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCreatedTorrent(TOTorrent torrent) {
        List list = created_torrents;
        synchronized (list) {
            try {
                HashWrapper hw = torrent.getHashWrapper();
                boolean res = created_torrents_set.contains(hw);
                if (!res) {
                    res = torrent.isCreated();
                }
                return res;
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
                return false;
            }
        }
    }

    public static String getMagnetURI(byte[] hash) {
        return "magnet:?xt=urn:btih:" + Base32.encode(hash);
    }

    private static void fireAttributeListener(TOTorrent torrent, String attribute, Object value) {
        Iterator it = torrent_attribute_listeners.iterator();
        while (it.hasNext()) {
            try {
                ((torrentAttributeListener)it.next()).attributeSet(torrent, attribute, value);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void addTorrentAttributeListener(torrentAttributeListener listener) {
        torrent_attribute_listeners.add(listener);
    }

    public static void removeTorrentAttributeListener(torrentAttributeListener listener) {
        torrent_attribute_listeners.remove(listener);
    }

    static {
        tls = new ThreadLocal(){

            public Object initialValue() {
                return new HashMap();
            }
        };
        torrent_attribute_listeners = new CopyOnWriteList();
        COConfigurationManager.addAndFireParameterListener("Save Torrent Backup", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                bSaveTorrentBackup = COConfigurationManager.getBooleanParameter(parameterName);
            }
        });
        created_torrents = COConfigurationManager.getListParameter("my.created.torrents", new ArrayList());
        created_torrents_set = new HashSet();
        Iterator it = created_torrents.iterator();
        while (it.hasNext()) {
            created_torrents_set.add(new HashWrapper((byte[])it.next()));
        }
        torrent_delegates = new WeakHashMap();
        SimpleTimer.addPeriodicEvent("TorrentUtils:pieceDiscard", 90000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent event2) {
                long now = SystemTime.getCurrentTime();
                Map map = torrent_delegates;
                synchronized (map) {
                    Iterator it = torrent_delegates.keySet().iterator();
                    while (it.hasNext()) {
                        ((torrentDelegate)it.next()).discardPieces(now, false);
                    }
                }
            }
        });
        torrentFluffKeyset = new HashSet(2);
        fluffThombstone = new HashMap(1);
    }

    public static interface ExtendedTorrent
    extends TOTorrent {
        public byte[][] peekPieces() throws TOTorrentException;

        public void setDiscardFluff(boolean var1);
    }

    public static interface torrentAttributeListener {
        public void attributeSet(TOTorrent var1, String var2, Object var3);
    }

    private static class torrentDelegate
    extends LogRelation
    implements ExtendedTorrent {
        private TOTorrent delegate;
        private File file;
        private boolean fluff_dirty;
        private long last_pieces_read_time = SystemTime.getCurrentTime();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected torrentDelegate(TOTorrent _delegate, File _file) {
            this.delegate = _delegate;
            this.file = _file;
            Map map = torrent_delegates;
            synchronized (map) {
                torrent_delegates.put(this, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDiscardFluff(boolean discard) {
            if (discard && !torrentFluffKeyset.isEmpty()) {
                try {
                    this.getMonitor().enter();
                    try {
                        if (this.fluff_dirty) {
                            boolean[] restored = this.restoreState(true, true);
                            this.delegate.serialiseToBEncodedFile(this.file);
                            this.fluff_dirty = false;
                            if (restored[0]) {
                                this.discardPieces(SystemTime.getCurrentTime(), true);
                            }
                        }
                        Iterator it = torrentFluffKeyset.iterator();
                        while (it.hasNext()) {
                            this.delegate.setAdditionalMapProperty((String)it.next(), fluffThombstone);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                finally {
                    this.getMonitor().exit();
                }
            }
        }

        public byte[] getName() {
            return this.delegate.getName();
        }

        public boolean isSimpleTorrent() {
            return this.delegate.isSimpleTorrent();
        }

        public byte[] getComment() {
            return this.delegate.getComment();
        }

        public void setComment(String comment) {
            this.delegate.setComment(comment);
        }

        public long getCreationDate() {
            return this.delegate.getCreationDate();
        }

        public void setCreationDate(long date) {
            this.delegate.setCreationDate(date);
        }

        public byte[] getCreatedBy() {
            return this.delegate.getCreatedBy();
        }

        public boolean isCreated() {
            return this.delegate.isCreated();
        }

        public URL getAnnounceURL() {
            return this.delegate.getAnnounceURL();
        }

        public boolean setAnnounceURL(URL url) {
            return this.delegate.setAnnounceURL(url);
        }

        public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
            return this.delegate.getAnnounceURLGroup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void discardPieces(long now, boolean force) {
            block7: {
                if (now < this.last_pieces_read_time && !force) {
                    this.last_pieces_read_time = now;
                } else {
                    try {
                        if (now - this.last_pieces_read_time <= 180000L && !force || this.delegate.getPieces() == null) break block7;
                        try {
                            this.getMonitor().enter();
                            this.delegate.setPieces(null);
                        }
                        finally {
                            this.getMonitor().exit();
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[][] getPieces() throws TOTorrentException {
            byte[][] res = this.delegate.getPieces();
            this.last_pieces_read_time = SystemTime.getCurrentTime();
            if (res == null) {
                try {
                    this.getMonitor().enter();
                    this.restoreState(true, false);
                    res = this.delegate.getPieces();
                }
                finally {
                    this.getMonitor().exit();
                }
            }
            return res;
        }

        protected boolean[] restoreState(boolean do_pieces, boolean do_fluff) throws TOTorrentException {
            boolean had_pieces = this.delegate.getPieces() != null;
            boolean had_fluff = true;
            Iterator it = torrentFluffKeyset.iterator();
            while (it.hasNext()) {
                had_fluff &= this.delegate.getAdditionalMapProperty((String)it.next()) != fluffThombstone;
            }
            if (had_pieces) {
                do_pieces = false;
            }
            if (had_fluff) {
                do_fluff = false;
            }
            if (do_pieces || do_fluff) {
                TOTorrent temp = TorrentUtils.readFromFile(this.file, false);
                if (do_pieces) {
                    byte[][] res = temp.getPieces();
                    this.delegate.setPieces(res);
                }
                if (do_fluff) {
                    for (String fluffKey : torrentFluffKeyset) {
                        if (this.delegate.getAdditionalMapProperty(fluffKey) != fluffThombstone) continue;
                        this.delegate.setAdditionalMapProperty(fluffKey, temp.getAdditionalMapProperty(fluffKey));
                    }
                }
            }
            return new boolean[]{do_pieces, do_fluff};
        }

        public byte[][] peekPieces() throws TOTorrentException {
            return this.delegate.getPieces();
        }

        public void setPieces(byte[][] pieces) throws TOTorrentException {
            throw new TOTorrentException("Unsupported Operation", 5);
        }

        public long getPieceLength() {
            return this.delegate.getPieceLength();
        }

        public int getNumberOfPieces() {
            return this.delegate.getNumberOfPieces();
        }

        public long getSize() {
            return this.delegate.getSize();
        }

        public TOTorrentFile[] getFiles() {
            return this.delegate.getFiles();
        }

        public byte[] getHash() throws TOTorrentException {
            return this.delegate.getHash();
        }

        public HashWrapper getHashWrapper() throws TOTorrentException {
            return this.delegate.getHashWrapper();
        }

        public void setHashOverride(byte[] hash) throws TOTorrentException {
            throw new TOTorrentException("Not supported", 8);
        }

        public boolean getPrivate() {
            return this.delegate.getPrivate();
        }

        public void setPrivate(boolean _private) throws TOTorrentException {
            throw new TOTorrentException("Can't amend private attribute", 5);
        }

        public boolean hasSameHashAs(TOTorrent other) {
            return this.delegate.hasSameHashAs(other);
        }

        public void setAdditionalStringProperty(String name, String value) {
            this.delegate.setAdditionalStringProperty(name, value);
        }

        public String getAdditionalStringProperty(String name) {
            return this.delegate.getAdditionalStringProperty(name);
        }

        public void setAdditionalByteArrayProperty(String name, byte[] value) {
            this.delegate.setAdditionalByteArrayProperty(name, value);
        }

        public byte[] getAdditionalByteArrayProperty(String name) {
            return this.delegate.getAdditionalByteArrayProperty(name);
        }

        public void setAdditionalLongProperty(String name, Long value) {
            this.delegate.setAdditionalLongProperty(name, value);
        }

        public Long getAdditionalLongProperty(String name) {
            return this.delegate.getAdditionalLongProperty(name);
        }

        public void setAdditionalListProperty(String name, List value) {
            this.delegate.setAdditionalListProperty(name, value);
        }

        public List getAdditionalListProperty(String name) {
            return this.delegate.getAdditionalListProperty(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAdditionalMapProperty(String name, Map value) {
            if (torrentFluffKeyset.contains(name)) {
                try {
                    this.getMonitor().enter();
                    this.delegate.setAdditionalMapProperty(name, value);
                    this.fluff_dirty = true;
                }
                finally {
                    this.getMonitor().exit();
                }
            } else {
                this.delegate.setAdditionalMapProperty(name, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map getAdditionalMapProperty(String name) {
            block7: {
                if (torrentFluffKeyset.contains(name)) {
                    try {
                        this.getMonitor().enter();
                        Map result = this.delegate.getAdditionalMapProperty(name);
                        if (result != fluffThombstone) break block7;
                        try {
                            Map res;
                            this.restoreState(false, true);
                            Map map = res = this.delegate.getAdditionalMapProperty(name);
                            return map;
                        }
                        catch (Throwable e) {
                            Debug.out("Property '" + name + " lost due to torrent read error", e);
                        }
                    }
                    finally {
                        this.getMonitor().exit();
                    }
                }
            }
            return this.delegate.getAdditionalMapProperty(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getAdditionalProperty(String name) {
            block7: {
                if (torrentFluffKeyset.contains(name)) {
                    try {
                        this.getMonitor().enter();
                        Object result = this.delegate.getAdditionalProperty(name);
                        if (result != fluffThombstone) break block7;
                        try {
                            Object res;
                            this.restoreState(false, true);
                            Object object = res = this.delegate.getAdditionalProperty(name);
                            return object;
                        }
                        catch (Throwable e) {
                            Debug.out("Property '" + name + " lost due to torrent read error", e);
                        }
                    }
                    finally {
                        this.getMonitor().exit();
                    }
                }
            }
            return this.delegate.getAdditionalProperty(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAdditionalProperty(String name, Object value) {
            if (torrentFluffKeyset.contains(name)) {
                try {
                    this.getMonitor().enter();
                    this.delegate.setAdditionalProperty(name, value);
                    this.fluff_dirty = true;
                }
                finally {
                    this.getMonitor().exit();
                }
            } else {
                this.delegate.setAdditionalProperty(name, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAdditionalProperty(String name) {
            if (this.delegate.getAdditionalProperty(name) == null) {
                return;
            }
            if (torrentFluffKeyset.contains(name)) {
                try {
                    this.getMonitor().enter();
                    this.delegate.removeAdditionalProperty(name);
                    this.fluff_dirty = true;
                }
                finally {
                    this.getMonitor().exit();
                }
            } else {
                this.delegate.removeAdditionalProperty(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAdditionalProperties() {
            try {
                this.getMonitor().enter();
                this.delegate.removeAdditionalProperties();
                this.fluff_dirty = true;
            }
            finally {
                this.getMonitor().exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialiseToBEncodedFile(File target_file) throws TOTorrentException {
            try {
                this.getMonitor().enter();
                boolean[] restored = this.restoreState(true, true);
                this.delegate.serialiseToBEncodedFile(target_file);
                if (target_file.equals(this.file)) {
                    this.fluff_dirty = false;
                }
                if (restored[0]) {
                    this.discardPieces(SystemTime.getCurrentTime(), true);
                }
                if (restored[1]) {
                    Iterator it = torrentFluffKeyset.iterator();
                    while (it.hasNext()) {
                        this.delegate.setAdditionalMapProperty((String)it.next(), fluffThombstone);
                    }
                }
            }
            finally {
                this.getMonitor().exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map serialiseToMap() throws TOTorrentException {
            try {
                this.getMonitor().enter();
                boolean[] restored = this.restoreState(true, true);
                Map result = this.delegate.serialiseToMap();
                if (restored[0]) {
                    this.discardPieces(SystemTime.getCurrentTime(), true);
                }
                if (restored[1]) {
                    Iterator it = torrentFluffKeyset.iterator();
                    while (it.hasNext()) {
                        this.delegate.setAdditionalMapProperty((String)it.next(), fluffThombstone);
                    }
                }
                Map map = result;
                return map;
            }
            finally {
                this.getMonitor().exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialiseToXMLFile(File target_file) throws TOTorrentException {
            try {
                this.getMonitor().enter();
                boolean[] restored = this.restoreState(true, true);
                this.delegate.serialiseToXMLFile(target_file);
                if (restored[0]) {
                    this.discardPieces(SystemTime.getCurrentTime(), true);
                }
                if (restored[1]) {
                    Iterator it = torrentFluffKeyset.iterator();
                    while (it.hasNext()) {
                        this.delegate.setAdditionalMapProperty((String)it.next(), fluffThombstone);
                    }
                }
            }
            finally {
                this.getMonitor().exit();
            }
        }

        public AEMonitor getMonitor() {
            return this.delegate.getMonitor();
        }

        public void print() {
            this.delegate.print();
        }

        public String getRelationText() {
            if (this.delegate instanceof LogRelation) {
                return ((LogRelation)((Object)this.delegate)).getRelationText();
            }
            return this.delegate.toString();
        }

        public Object[] getQueryableInterfaces() {
            if (this.delegate instanceof LogRelation) {
                return ((LogRelation)((Object)this.delegate)).getQueryableInterfaces();
            }
            return super.getQueryableInterfaces();
        }
    }
}

