/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform;

import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.win32.PlatformManagerImpl;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class PlatformManagerFactory {
    protected static PlatformManager platform_manager;
    protected static AEMonitor class_mon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlatformManager getPlatformManager() {
        try {
            boolean force_dummy = System.getProperty("azureus.platform.manager.disable", "false").equals("true");
            class_mon.enter();
            if (platform_manager == null && !force_dummy) {
                try {
                    if (PlatformManagerFactory.getPlatformType() == 1) {
                        platform_manager = PlatformManagerImpl.getSingleton();
                    } else if (PlatformManagerFactory.getPlatformType() == 3) {
                        platform_manager = org.gudy.azureus2.platform.macosx.PlatformManagerImpl.getSingleton();
                    } else if (PlatformManagerFactory.getPlatformType() == 4) {
                        platform_manager = org.gudy.azureus2.platform.unix.PlatformManagerImpl.getSingleton();
                    }
                }
                catch (PlatformManagerException e) {
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            if (platform_manager == null) {
                platform_manager = org.gudy.azureus2.platform.dummy.PlatformManagerImpl.getSingleton();
            }
            PlatformManager platformManager = platform_manager;
            return platformManager;
        }
        finally {
            class_mon.exit();
        }
    }

    public static int getPlatformType() {
        if (Constants.isWindows) {
            return 1;
        }
        if (Constants.isOSX) {
            return 3;
        }
        if (Constants.isUnix) {
            return 4;
        }
        return 2;
    }

    static {
        class_mon = new AEMonitor("PlatformManagerFactory");
    }
}

