/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.macosx.access.jnilib;

import com.aelitis.azureus.core.drivedetector.DriveDetectorFactory;
import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.util.Map;
import org.eclipse.swt.internal.carbon.AEDesc;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.macosx.access.jnilib.OSXDriveDetectListener;

public class OSXAccess {
    private static boolean bLoaded = false;
    private static boolean DEBUG = Constants.isCVSVersion();

    private static void initDriveDetection() {
        try {
            OSXAccess.initializeDriveDetection(new OSXDriveDetectListener(){

                public void driveRemoved(File mount, Map driveInfo) {
                    if (DEBUG) {
                        System.out.println("UNMounted " + mount);
                        for (Object key : driveInfo.keySet()) {
                            Object val = driveInfo.get(key);
                            System.out.println("\t" + key + "\t:\t" + val);
                        }
                    }
                    DriveDetectorFactory.getDeviceDetector().driveRemoved(mount);
                }

                public void driveDetected(File mount, Map driveInfo) {
                    boolean isWritable;
                    if (DEBUG) {
                        System.out.println("Mounted " + mount);
                        for (Object key : driveInfo.keySet()) {
                            Object val = driveInfo.get(key);
                            System.out.println("\t" + key + "\t:\t" + val);
                        }
                    }
                    boolean isOptical = MapUtils.getMapLong(driveInfo, "isOptical", 0L) != 0L;
                    boolean isRemovable = MapUtils.getMapLong(driveInfo, "Removable", 0L) != 0L;
                    boolean bl = isWritable = MapUtils.getMapLong(driveInfo, "Writable", 0L) != 0L;
                    if (isRemovable && isWritable && !isOptical) {
                        DriveDetectorFactory.getDeviceDetector().driveDetected(mount);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final native int AEGetParamDesc(int var0, int var1, int var2, AEDesc var3);

    public static final native String getVersion();

    public static final native String getDocDir();

    public static final native void memmove(byte[] var0, int var1, int var2);

    public static final native void initializeDriveDetection(OSXDriveDetectListener var0);

    public static boolean isLoaded() {
        return bLoaded;
    }

    static {
        try {
            System.loadLibrary("OSXAccess");
            System.out.println("OSXAccess v" + OSXAccess.getVersion() + " Load complete!");
            bLoaded = true;
            OSXAccess.initDriveDetection();
        }
        catch (UnsatisfiedLinkError e1) {
            Debug.out("Could not find libOSXAccess.jnilib");
        }
    }
}

