/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.unix;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;

public class ScriptAfterShutdown {
    private static PrintStream sysout;

    public static void main(String[] args) {
        System.setProperty("transitory.startup", "1");
        sysout = System.out;
        try {
            System.setOut(new PrintStream(new FileOutputStream("/dev/stderr")));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        String extraCmds = COConfigurationManager.getStringParameter("scriptaftershutdown", null);
        if (extraCmds != null) {
            boolean exit = COConfigurationManager.getBooleanParameter("scriptaftershutdown.exit", false);
            if (exit) {
                COConfigurationManager.removeParameter("scriptaftershutdown.exit");
            }
            COConfigurationManager.removeParameter("scriptaftershutdown");
            COConfigurationManager.save();
            sysout.println(extraCmds);
            if (exit) {
                sysout.println("exit");
            }
        } else {
            ScriptAfterShutdown.log("No shutdown tasks to do");
        }
    }

    public static void addExtraCommand(String s) {
        String extraCmds = COConfigurationManager.getStringParameter("scriptaftershutdown", null);
        extraCmds = extraCmds == null ? s + "\n" : extraCmds + s + "\n";
        COConfigurationManager.setParameter("scriptaftershutdown", extraCmds);
    }

    public static void setRequiresExit(boolean requiresExit) {
        if (requiresExit) {
            COConfigurationManager.setParameter("scriptaftershutdown.exit", true);
        }
    }

    private static void log(String string) {
        sysout.println("echo \"" + string.replaceAll("\"", "\\\"") + "\"");
    }
}

