/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerFileInfoImpl;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;

public class PluginCoreUtils {
    public static Torrent wrap(TOTorrent t) {
        return new TorrentImpl(t);
    }

    public static TOTorrent unwrap(Torrent t) {
        return ((TorrentImpl)t).getTorrent();
    }

    public static DiskManager wrap(org.gudy.azureus2.core3.disk.DiskManager dm) {
        return new DiskManagerImpl(dm);
    }

    public static org.gudy.azureus2.core3.disk.DiskManager unwrap(DiskManager dm) {
        return ((DiskManagerImpl)dm).getDiskmanager();
    }

    public static Download wrap(DownloadManager dm) {
        try {
            return DownloadManagerImpl.getDownloadStatic(dm);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Object convert(Object datasource, boolean toCore) {
        try {
            if (toCore) {
                if (datasource instanceof DownloadManager) {
                    return datasource;
                }
                if (datasource instanceof DownloadImpl) {
                    return ((DownloadImpl)datasource).getDownload();
                }
                if (datasource instanceof org.gudy.azureus2.core3.disk.DiskManager) {
                    return datasource;
                }
                if (datasource instanceof DiskManagerImpl) {
                    return ((DiskManagerImpl)datasource).getDiskmanager();
                }
                if (datasource instanceof PEPeerManager) {
                    return datasource;
                }
                if (datasource instanceof PeerManagerImpl) {
                    return ((PeerManagerImpl)datasource).getDelegate();
                }
                if (datasource instanceof PEPeer) {
                    return datasource;
                }
                if (datasource instanceof PeerImpl) {
                    return ((PeerImpl)datasource).getPEPeer();
                }
                if (datasource instanceof DiskManagerFileInfo) {
                    return datasource;
                }
                if (datasource instanceof DiskManagerFileInfoImpl) {
                    ((DiskManagerFileInfoImpl)datasource).getCore();
                }
                if (datasource instanceof TRHostTorrent) {
                    return datasource;
                }
                if (datasource instanceof TrackerTorrentImpl) {
                    ((TrackerTorrentImpl)datasource).getHostTorrent();
                }
            } else {
                DiskManagerFileInfo fileInfo2;
                if (datasource instanceof DownloadManager) {
                    return PluginCoreUtils.wrap((DownloadManager)datasource);
                }
                if (datasource instanceof DownloadImpl) {
                    return datasource;
                }
                if (datasource instanceof org.gudy.azureus2.core3.disk.DiskManager) {
                    return PluginCoreUtils.wrap((org.gudy.azureus2.core3.disk.DiskManager)datasource);
                }
                if (datasource instanceof DiskManagerImpl) {
                    return datasource;
                }
                if (datasource instanceof PEPeerManager) {
                    return PluginCoreUtils.wrap((PEPeerManager)datasource);
                }
                if (datasource instanceof PeerManagerImpl) {
                    return datasource;
                }
                if (datasource instanceof PEPeer) {
                    return PeerManagerImpl.getPeerForPEPeer((PEPeer)datasource);
                }
                if (datasource instanceof Peer) {
                    return datasource;
                }
                if (datasource instanceof DiskManagerFileInfo && (fileInfo2 = (DiskManagerFileInfo)datasource) != null) {
                    try {
                        return new DiskManagerFileInfoImpl(DownloadManagerImpl.getDownloadStatic(fileInfo2.getDownloadManager()), fileInfo2);
                    }
                    catch (DownloadException downloadException) {
                        // empty catch block
                    }
                }
                if (datasource instanceof DiskManagerFileInfoImpl) {
                    return datasource;
                }
                if (datasource instanceof TRHostTorrent) {
                    TRHostTorrent item = (TRHostTorrent)datasource;
                    return new TrackerTorrentImpl(item);
                }
                if (datasource instanceof TrackerTorrentImpl) {
                    return datasource;
                }
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        return datasource;
    }

    public static DownloadManager unwrap(Download dm) {
        if (dm instanceof DownloadImpl) {
            return ((DownloadImpl)dm).getDownload();
        }
        Debug.out("Can't unwrap " + dm);
        return null;
    }

    public static PeerManager wrap(PEPeerManager pm) {
        return PeerManagerImpl.getPeerManager(pm);
    }

    public static PEPeerManager unwrap(PeerManager pm) {
        return ((PeerManagerImpl)pm).getDelegate();
    }

    public static TRTrackerServerTorrent unwrap(TrackerTorrent torrent) {
        return ((TrackerTorrentImpl)torrent).getHostTorrent().getTrackerTorrent();
    }
}

