/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.disk;

import java.io.File;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerChannelImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;

public class DiskManagerFileInfoImpl
implements DiskManagerFileInfo {
    protected DownloadImpl download;
    protected org.gudy.azureus2.core3.disk.DiskManagerFileInfo core;

    public DiskManagerFileInfoImpl(DownloadImpl _download, org.gudy.azureus2.core3.disk.DiskManagerFileInfo coreFileInfo) {
        this.core = coreFileInfo;
        this.download = _download;
    }

    public void setPriority(boolean b) {
        this.core.setPriority(b);
    }

    public void setSkipped(boolean b) {
        this.core.setSkipped(b);
    }

    public void setDeleted(boolean b) {
        if (b) {
            this.core.setStorageType(2);
        } else {
            this.core.setStorageType(1);
        }
    }

    public boolean isDeleted() {
        return this.core.getStorageType() == 2;
    }

    public void setLink(File link_destination) {
        this.core.setLink(link_destination);
    }

    public File getLink() {
        return this.core.getLink();
    }

    public int getAccessMode() {
        return this.core.getAccessMode();
    }

    public long getDownloaded() {
        return this.core.getDownloaded();
    }

    public long getLength() {
        return this.core.getLength();
    }

    public File getFile() {
        return this.core.getFile(false);
    }

    public int getFirstPieceNumber() {
        return this.core.getFirstPieceNumber();
    }

    public long getPieceSize() {
        try {
            return this.getDownload().getTorrent().getPieceSize();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return 0L;
        }
    }

    public int getNumPieces() {
        return this.core.getNbPieces();
    }

    public boolean isPriority() {
        return this.core.isPriority();
    }

    public boolean isSkipped() {
        return this.core.isSkipped();
    }

    public int getIndex() {
        return this.core.getIndex();
    }

    public byte[] getDownloadHash() throws DownloadException {
        return this.getDownload().getTorrent().getHash();
    }

    public Download getDownload() throws DownloadException {
        if (this.download != null) {
            return this.download;
        }
        return DownloadManagerImpl.getDownloadStatic(this.core.getDownloadManager());
    }

    public DiskManagerChannel createChannel() throws DownloadException {
        if (this.core.getDownloadManager().getTorrent() == null) {
            throw new DownloadException("Torrent invalid");
        }
        return new DiskManagerChannelImpl(this.download, this);
    }

    public org.gudy.azureus2.core3.disk.DiskManagerFileInfo getCore() {
        return this.core;
    }
}

