/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.DownloadStats;

public class DownloadStatsImpl
implements DownloadStats {
    protected DownloadManager dm;
    protected DownloadManagerStats dm_stats;

    protected DownloadStatsImpl(DownloadManager _dm) {
        this.dm = _dm;
        this.dm_stats = this.dm.getStats();
    }

    public String getStatus() {
        return DisplayFormatters.formatDownloadStatusDefaultLocale(this.dm);
    }

    public String getStatus(boolean localised) {
        return localised ? DisplayFormatters.formatDownloadStatus(this.dm) : this.getStatus();
    }

    public String getDownloadDirectory() {
        return this.dm.getSaveLocation().getParent();
    }

    public String getTargetFileOrDir() {
        return this.dm.getSaveLocation().toString();
    }

    public String getTrackerStatus() {
        return this.dm.getTrackerStatus();
    }

    public int getCompleted() {
        return this.dm_stats.getCompleted();
    }

    public int getDownloadCompleted(boolean bLive) {
        return this.dm_stats.getDownloadCompleted(bLive);
    }

    public int getCheckingDoneInThousandNotation() {
        DiskManager disk = this.dm.getDiskManager();
        if (disk != null) {
            return disk.getCompleteRecheckStatus();
        }
        return -1;
    }

    public long getDownloaded() {
        return this.dm_stats.getTotalDataBytesReceived();
    }

    public long getRemaining() {
        return this.dm_stats.getRemaining();
    }

    public long getUploaded() {
        return this.dm_stats.getTotalDataBytesSent();
    }

    public long getDiscarded() {
        return this.dm_stats.getDiscarded();
    }

    public long getDownloadAverage() {
        return this.dm_stats.getDataReceiveRate();
    }

    public long getUploadAverage() {
        return this.dm_stats.getDataSendRate();
    }

    public long getTotalAverage() {
        return this.dm_stats.getTotalAverage();
    }

    public String getElapsedTime() {
        return this.dm_stats.getElapsedTime();
    }

    public String getETA() {
        return DisplayFormatters.formatETA(this.dm_stats.getETA());
    }

    public long getETASecs() {
        return this.dm_stats.getETA();
    }

    public long getHashFails() {
        return this.dm_stats.getHashFailCount();
    }

    public int getShareRatio() {
        return this.dm_stats.getShareRatio();
    }

    public long getTimeStarted() {
        return this.dm_stats.getTimeStarted();
    }

    public float getAvailability() {
        return this.dm_stats.getAvailability();
    }

    public long getSecondsOnlySeeding() {
        return this.dm_stats.getSecondsOnlySeeding();
    }

    public long getSecondsDownloading() {
        return this.dm_stats.getSecondsDownloading();
    }

    public long getTimeStartedSeeding() {
        return this.dm_stats.getTimeStartedSeeding();
    }

    public long getSecondsSinceLastDownload() {
        return this.dm_stats.getTimeSinceLastDataReceivedInSeconds();
    }

    public long getSecondsSinceLastUpload() {
        return this.dm_stats.getTimeSinceLastDataSentInSeconds();
    }

    public int getHealth() {
        switch (this.dm.getHealthStatus()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        Debug.out("Invalid health status");
        return this.dm.getHealthStatus();
    }
}

