/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.installer;

import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.FilePluginInstaller;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.PluginInstallerListener;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateListener;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.FailedPlugin;
import org.gudy.azureus2.pluginsimpl.local.installer.FilePluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.InstallablePluginImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.StandardPluginImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;
import org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsException;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInstallerImpl
implements PluginInstaller {
    protected static PluginInstallerImpl singleton;
    private PluginManager manager;
    private List listeners = new ArrayList();
    private AsyncDispatcher add_file_install_dispatcher;

    public static PluginInstallerImpl getSingleton(PluginManager _manager) {
        if (singleton == null) {
            singleton = new PluginInstallerImpl(_manager);
        }
        return singleton;
    }

    protected PluginInstallerImpl(PluginManager _manager) {
        this.manager = _manager;
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            public void process(VuzeFile[] files, int expected_types) {
                for (int i = 0; i < files.length; ++i) {
                    VuzeFile vf = files[i];
                    VuzeFileComponent[] comps = vf.getComponents();
                    for (int j = 0; j < comps.length; ++j) {
                        VuzeFileComponent comp2 = comps[j];
                        if (comp2.getType() != 8) continue;
                        try {
                            Map content = comp2.getContent();
                            String id = new String((byte[])content.get("id"), "UTF-8");
                            String version = new String((byte[])content.get("version"), "UTF-8");
                            String suffix = (Long)content.get("is_jar") == 1L ? "jar" : "zip";
                            byte[] plugin_file = (byte[])content.get("file");
                            File temp_dir = AETemporaryFileHandler.createTempDir();
                            File temp_file = new File(temp_dir, id + "_" + version + "." + suffix);
                            FileUtil.copyFile((InputStream)new ByteArrayInputStream(plugin_file), temp_file);
                            FilePluginInstaller installer = PluginInstallerImpl.this.installFromFile(temp_file);
                            PluginInstallerImpl.this.addFileInstallOperation(installer);
                            comp2.setProcessed();
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileInstallOperation(final FilePluginInstaller installer) {
        PluginInstallerImpl pluginInstallerImpl = this;
        synchronized (pluginInstallerImpl) {
            if (this.add_file_install_dispatcher == null) {
                this.add_file_install_dispatcher = new AsyncDispatcher();
            }
            this.add_file_install_dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    try {
                        final AESemaphore done_sem = new AESemaphore("PluginInstall:fio");
                        final UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                        new AEThread2("PluginInstall:fio", true){

                            public void run() {
                                if (installer.isAlreadyInstalled()) {
                                    String details = MessageText.getString("fileplugininstall.duplicate.desc", new String[]{installer.getName(), installer.getVersion()});
                                    ui_manager.showMessageBox("fileplugininstall.duplicate.title", "!" + details + "!", 1L);
                                    done_sem.release();
                                } else {
                                    String details = MessageText.getString("fileplugininstall.install.desc", new String[]{installer.getName(), installer.getVersion()});
                                    long res = ui_manager.showMessageBox("fileplugininstall.install.title", "!" + details + "!", 12L);
                                    if (res == 4L) {
                                        try {
                                            PluginInstallerImpl.this.install(new InstallablePlugin[]{installer}, false, true, null, new PluginInstallationListener(){

                                                public void completed() {
                                                    done_sem.release();
                                                }

                                                public void cancelled() {
                                                    done_sem.release();
                                                }

                                                public void failed(PluginException e) {
                                                    done_sem.release();
                                                    Debug.out("Installation failed", e);
                                                }
                                            });
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                            done_sem.release();
                                        }
                                    } else if (res == 8L) {
                                        done_sem.release();
                                    } else {
                                        Debug.out("Message box not handled");
                                        done_sem.release();
                                    }
                                }
                            }
                        }.start();
                        while (!done_sem.reserve(60000L)) {
                            if (PluginInstallerImpl.this.add_file_install_dispatcher.getQueueSize() <= 0) continue;
                            Debug.out("File plugin install operation queued pending completion of previous");
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            });
        }
    }

    protected PluginManager getPluginManager() {
        return this.manager;
    }

    @Override
    public StandardPlugin[] getStandardPlugins() throws PluginException {
        try {
            SFPluginDetailsLoader loader = SFPluginDetailsLoaderFactory.getSingleton();
            SFPluginDetails[] details = loader.getPluginDetails();
            ArrayList<StandardPluginImpl> res = new ArrayList<StandardPluginImpl>();
            for (int i = 0; i < details.length; ++i) {
                SFPluginDetails detail = details[i];
                String name = detail.getId();
                String version = "";
                if (Constants.isCVSVersion()) {
                    version = detail.getCVSVersion();
                }
                if (version == null || version.length() == 0 || !Character.isDigit(version.charAt(0))) {
                    version = detail.getVersion();
                } else {
                    String non_cvs_version = detail.getVersion();
                    if (version.equals(non_cvs_version + "_CVS")) {
                        version = non_cvs_version;
                    }
                }
                if (name.startsWith("azplatform") || name.equals("azupdater") || version == null || version.length() == 0 || !Character.isDigit(version.charAt(0)) || detail.getCategory().equalsIgnoreCase("hidden")) continue;
                res.add(new StandardPluginImpl(this, details[i], version));
            }
            StandardPlugin[] res_a = new StandardPlugin[res.size()];
            res.toArray(res_a);
            return res_a;
        }
        catch (SFPluginDetailsException e) {
            throw new PluginException("Failed to load standard plugin details", e);
        }
    }

    @Override
    public StandardPlugin getStandardPlugin(String id) throws PluginException {
        try {
            SFPluginDetailsLoader loader = SFPluginDetailsLoaderFactory.getSingleton();
            SFPluginDetails[] details = loader.getPluginDetails();
            for (int i = 0; i < details.length; ++i) {
                SFPluginDetails detail = details[i];
                String name = detail.getId();
                if (!name.equals(id)) continue;
                String version = "";
                if (Constants.isCVSVersion()) {
                    version = detail.getCVSVersion();
                }
                if (version == null || version.length() == 0 || !Character.isDigit(version.charAt(0))) {
                    version = detail.getVersion();
                } else {
                    String non_cvs_version = detail.getVersion();
                    if (version.equals(non_cvs_version + "_CVS")) {
                        version = non_cvs_version;
                    }
                }
                if (name.startsWith("azplatform") || name.equals("azupdater") || version == null || version.length() == 0 || !Character.isDigit(version.charAt(0))) continue;
                return new StandardPluginImpl(this, details[i], version);
            }
            return null;
        }
        catch (SFPluginDetailsException e) {
            throw new PluginException("Failed to load standard plugin details", e);
        }
    }

    @Override
    public FilePluginInstaller installFromFile(File file) throws PluginException {
        return new FilePluginInstallerImpl(this, file);
    }

    public void install(InstallablePlugin installable_plugin, boolean shared) throws PluginException {
        this.install(new InstallablePlugin[]{installable_plugin}, shared);
    }

    @Override
    public void install(InstallablePlugin[] plugins, boolean shared) throws PluginException {
        this.install(plugins, shared, false, null, null);
    }

    @Override
    public void install(InstallablePlugin[] plugins, boolean shared, Map<Integer, Object> properties, PluginInstallationListener listener) throws PluginException {
        this.install(plugins, shared, false, properties, listener);
    }

    protected void install(InstallablePlugin[] plugins, boolean shared, boolean low_noise, Map<Integer, Object> properties, final PluginInstallationListener listener) throws PluginException {
        PluginUpdatePlugin pup = (PluginUpdatePlugin)this.manager.getPluginInterfaceByClass(PluginUpdatePlugin.class).getPlugin();
        UpdateManagerImpl uman = (UpdateManagerImpl)this.manager.getDefaultPluginInterface().getUpdateManager();
        UpdateCheckInstanceImpl inst = uman.createEmptyUpdateCheckInstance(1, "update.instance.install", low_noise);
        if (properties != null) {
            for (Map.Entry<Integer, Object> entry : properties.entrySet()) {
                inst.setProperty(entry.getKey(), entry.getValue());
            }
        }
        if (listener != null) {
            inst.addListener(new UpdateCheckInstanceListener(){

                public void cancelled(UpdateCheckInstance instance) {
                    listener.cancelled();
                }

                public void complete(UpdateCheckInstance instance) {
                    final Update[] updates = instance.getUpdates();
                    if (updates.length == 0) {
                        listener.failed(new PluginException("No updates were added during check process"));
                    } else {
                        for (int i = 0; i < updates.length; ++i) {
                            updates[i].addListener(new UpdateListener(){
                                private boolean cancelled;

                                public void cancelled(Update update) {
                                    this.cancelled = true;
                                    this.check();
                                }

                                public void complete(Update update) {
                                    this.check();
                                }

                                protected void check() {
                                    for (int i = 0; i < updates.length; ++i) {
                                        if (updates[i].isCancelled() || updates[i].isComplete()) continue;
                                        return;
                                    }
                                    if (this.cancelled) {
                                        listener.cancelled();
                                    } else {
                                        listener.completed();
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
        try {
            for (int i = 0; i < plugins.length; ++i) {
                InstallablePlugin plugin = plugins[i];
                final String plugin_id = plugin.getId();
                PluginInterface existing_plugin_interface = this.manager.getPluginInterfaceByID(plugin_id, false);
                Plugin existing_plugin = null;
                if (existing_plugin_interface != null) {
                    existing_plugin = existing_plugin_interface.getPlugin();
                    String old_version = existing_plugin_interface.getPluginVersion();
                    if (old_version != null) {
                        int res = Constants.compareVersions(plugin.getVersion(), old_version);
                        if (res < 0) {
                            throw new PluginException("A higher version (" + old_version + ") of Plugin '" + plugin_id + "' is already installed");
                        }
                        if (res == 0) {
                            throw new PluginException("Version (" + old_version + ") of Plugin '" + plugin_id + "' is already installed");
                        }
                    }
                }
                String target_dir = shared ? FileUtil.getApplicationFile("plugins").toString() : FileUtil.getUserFile("plugins").toString();
                target_dir = target_dir + File.separator + plugin_id;
                new File(target_dir).mkdir();
                if (existing_plugin == null) {
                    FailedPlugin dummy_plugin = new FailedPlugin(plugin_id, target_dir);
                    PluginManager.registerPlugin(dummy_plugin, plugin_id);
                    final PluginInterface dummy_plugin_interface = this.manager.getPluginInterfaceByID(plugin_id, false);
                    ((InstallablePluginImpl)plugin).addUpdate(inst, pup, dummy_plugin, dummy_plugin_interface);
                    inst.addListener(new UpdateCheckInstanceListener(){

                        public void cancelled(UpdateCheckInstance instance) {
                            try {
                                dummy_plugin_interface.getPluginState().unload();
                            }
                            catch (Throwable e) {
                                Debug.out("Failed to unload plugin", e);
                            }
                        }

                        public void complete(UpdateCheckInstance instance) {
                            PluginInterface pi = PluginInstallerImpl.this.manager.getPluginInterfaceByID(plugin_id, false);
                            if (pi != null && pi.getPlugin() instanceof FailedPlugin) {
                                try {
                                    pi.getPluginState().unload();
                                }
                                catch (Throwable e) {
                                    Debug.out("Failed to unload plugin", e);
                                }
                            }
                        }
                    });
                    continue;
                }
                ((InstallablePluginImpl)plugin).addUpdate(inst, pup, existing_plugin, existing_plugin_interface);
            }
            inst.start();
        }
        catch (Throwable e) {
            inst.cancel();
            if (e instanceof PluginException) {
                throw (PluginException)e;
            }
            throw new PluginException("Failed to create installer", e);
        }
    }

    public void uninstall(InstallablePlugin standard_plugin) throws PluginException {
        PluginInterface pi = standard_plugin.getAlreadyInstalledPlugin();
        if (pi == null) {
            throw new PluginException(" Plugin '" + standard_plugin.getId() + "' is not installed");
        }
        pi.getPluginState().uninstall();
    }

    @Override
    public void uninstall(PluginInterface pi) throws PluginException {
        this.uninstall(new PluginInterface[]{pi});
    }

    @Override
    public void uninstall(PluginInterface[] pis) throws PluginException {
        for (int i = 0; i < pis.length; ++i) {
            PluginInterface pi = pis[i];
            if (pi.getPluginState().isMandatory()) {
                throw new PluginException("Plugin '" + pi.getPluginID() + "' is mandatory, can't uninstall");
            }
            if (pi.getPluginState().isBuiltIn()) {
                throw new PluginException("Plugin '" + pi.getPluginID() + "' is built-in, can't uninstall");
            }
            String plugin_dir = pi.getPluginDirectoryName();
            if (plugin_dir != null && new File(plugin_dir).exists()) continue;
            throw new PluginException("Plugin '" + pi.getPluginID() + "' is not loaded from the file system, can't uninstall");
        }
        try {
            UpdateManager uman = this.manager.getDefaultPluginInterface().getUpdateManager();
            UpdateCheckInstance inst = uman.createEmptyUpdateCheckInstance(3, "update.instance.uninstall");
            for (int i = 0; i < pis.length; ++i) {
                final PluginInterface pi = pis[i];
                final String plugin_dir = pi.getPluginDirectoryName();
                inst.addUpdatableComponent(new UpdatableComponent(){

                    public String getName() {
                        return pi.getPluginName();
                    }

                    public int getMaximumCheckTime() {
                        return 0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void checkForUpdate(final UpdateChecker checker) {
                        try {
                            ResourceDownloader rd = PluginInstallerImpl.this.manager.getDefaultPluginInterface().getUtilities().getResourceDownloaderFactory().create(new File(plugin_dir));
                            rd.addListener(new ResourceDownloaderAdapter(){

                                public boolean completed(ResourceDownloader downloader, InputStream data) {
                                    try {
                                        if (pi.getPluginState().isUnloadable()) {
                                            pi.getPluginState().unload();
                                            FileUtil.recursiveDelete(new File(plugin_dir));
                                        }
                                        UpdateInstaller installer = checker.createInstaller();
                                        installer.addRemoveAction(new File(plugin_dir).getCanonicalPath());
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                        Logger.log(new LogAlert(true, "Plugin uninstall failed", e));
                                    }
                                    return true;
                                }

                                public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                                    if (!downloader.isCancelled()) {
                                        Logger.log(new LogAlert(true, "Plugin uninstall failed", e));
                                    }
                                }
                            });
                            String update_name = "";
                            PluginInterface[] ifs = PluginInstallerImpl.this.manager.getPluginInterfaces();
                            Arrays.sort(ifs, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    return ((PluginInterface)o1).getPluginName().compareTo(((PluginInterface)o2).getPluginName());
                                }
                            });
                            for (int i = 0; i < ifs.length; ++i) {
                                if (!ifs[i].getPluginID().equals(pi.getPluginID())) continue;
                                update_name = update_name + (update_name.length() == 0 ? "" : ",") + ifs[i].getPluginName();
                            }
                            checker.addUpdate(update_name, new String[]{"Uninstall: " + plugin_dir}, pi.getPluginVersion(), rd, pi.getPluginState().isUnloadable() ? 1 : 2);
                        }
                        finally {
                            checker.completed();
                        }
                    }
                }, false);
            }
            inst.start();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected PluginInterface getAlreadyInstalledPlugin(String id) {
        return this.getPluginManager().getPluginInterfaceByID(id, false);
    }

    @Override
    public void requestInstall(String reason, InstallablePlugin plugin) throws PluginException {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!((PluginInstallerListener)this.listeners.get(i)).installRequest(reason, plugin)) continue;
            return;
        }
        throw new PluginException("No listeners registered to perform installation of '" + plugin.getName() + " (" + reason + ")");
    }

    @Override
    public void addListener(PluginInstallerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(PluginInstallerListener l) {
        this.listeners.remove(l);
    }
}

