/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.logging;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;

public class LoggerChannelImpl
implements LoggerChannel {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    private Logger logger;
    private String name;
    private boolean timestamp;
    private boolean no_output;
    private List listeners = new ArrayList();
    private AEDiagnosticsLogger diagnostic_logger;

    protected LoggerChannelImpl(Logger _logger, String _name, boolean _timestamp, boolean _no_output) {
        this.logger = _logger;
        this.name = _name;
        this.timestamp = _timestamp;
        this.no_output = _no_output;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return org.gudy.azureus2.core3.logging.Logger.isEnabled();
    }

    public void setDiagnostic() {
        this.setDiagnostic(0L, true);
    }

    public void setDiagnostic(long max_file_size, boolean timestamp) {
        if (this.diagnostic_logger == null) {
            this.diagnostic_logger = AEDiagnostics.getLogger(FileUtil.convertOSSpecificChars(this.name, false));
            if (max_file_size > 0L) {
                this.diagnostic_logger.setMaxFileSize((int)max_file_size);
            }
            this.diagnostic_logger.enableTimeStamp(timestamp);
            this.addListener(new LoggerChannelListener(){

                public void messageLogged(int type, String content) {
                    LoggerChannelImpl.this.diagnostic_logger.log(content);
                }

                public void messageLogged(String str, Throwable error) {
                    LoggerChannelImpl.this.diagnostic_logger.log(str);
                    LoggerChannelImpl.this.diagnostic_logger.log(error);
                }
            });
        }
    }

    private int LogTypePluginToCore(int pluginLogType) {
        switch (pluginLogType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private void notifyListeners(int log_type, String data) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                LoggerChannelListener l = (LoggerChannelListener)this.listeners.get(i);
                l.messageLogged(log_type, data);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void notifyListeners(String listenersText, Throwable error) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                LoggerChannelListener l = (LoggerChannelListener)this.listeners.get(i);
                l.messageLogged(listenersText, error);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void log(int log_type, String data) {
        this.notifyListeners(log_type, this.addTimeStamp(data));
        if (this.isEnabled() && !this.no_output) {
            data = "[" + this.name + "] " + data;
            org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(LOGID, this.LogTypePluginToCore(log_type), data));
        }
    }

    public void log(String data) {
        this.log(1, data);
    }

    public void log(Object[] relatedTo, int log_type, String data) {
        String listenerData = data;
        if (relatedTo != null) {
            StringBuffer text = new StringBuffer();
            for (int i = 0; i < relatedTo.length; ++i) {
                Object obj = relatedTo[i];
                if (obj == null) continue;
                if (i > 0) {
                    text.append("; ");
                }
                if (obj instanceof LogRelation) {
                    text.append(((LogRelation)obj).getRelationText());
                    continue;
                }
                text.append("RelatedTo[").append(obj.toString()).append("]");
            }
            listenerData = listenerData + "\t" + text.toString() + "] " + data;
        }
        this.notifyListeners(log_type, this.addTimeStamp(listenerData));
        if (this.isEnabled() && !this.no_output) {
            data = "[" + this.name + "] " + data;
            org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(relatedTo, LOGID, this.LogTypePluginToCore(log_type), data));
        }
    }

    public void log(Object relatedTo, int log_type, String data) {
        this.log(new Object[]{relatedTo}, log_type, data);
    }

    public void log(Throwable error) {
        this.log("", error);
    }

    public void log(String str, Throwable error) {
        this.notifyListeners(str.equals("") ? "" : this.addTimeStamp(str), error);
        if (!this.no_output) {
            LogEvent event2 = new LogEvent(LOGID, "[" + this.name + "] " + str, error);
            org.gudy.azureus2.core3.logging.Logger.log(event2);
        }
    }

    public void log(Object[] relatedTo, String str, Throwable error) {
        this.notifyListeners(str.equals("") ? "" : this.addTimeStamp(str), error);
        if (this.isEnabled() && !this.no_output) {
            str = "[" + this.name + "] " + str;
            org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(relatedTo, LOGID, str, error));
        }
    }

    public void log(Object relatedTo, String str, Throwable error) {
        this.log(new Object[]{relatedTo}, str, error);
    }

    public void log(Object[] relatedTo, String data) {
        this.log(relatedTo, 1, data);
    }

    public void log(Object relatedTo, String data) {
        this.log(relatedTo, 1, data);
    }

    protected void logAlert(int alert_type, String message, boolean repeatable) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((LoggerChannelListener)this.listeners.get(i)).messageLogged(alert_type, this.addTimeStamp(message));
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (!this.no_output) {
            int at;
            switch (alert_type) {
                case 1: {
                    at = 0;
                    break;
                }
                case 2: {
                    at = 1;
                    break;
                }
                default: {
                    at = 3;
                }
            }
            org.gudy.azureus2.core3.logging.Logger.log(new LogAlert(repeatable, at, message));
        }
    }

    public void logAlert(int alert_type, String message) {
        this.logAlert(alert_type, message, false);
    }

    public void logAlertRepeatable(int alert_type, String message) {
        this.logAlert(alert_type, message, true);
    }

    public void logAlert(String message, Throwable e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((LoggerChannelListener)this.listeners.get(i)).messageLogged(this.addTimeStamp(message), e);
                continue;
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
        }
        if (!this.no_output) {
            org.gudy.azureus2.core3.logging.Logger.log(new LogAlert(false, message, e));
        }
    }

    public void logAlertRepeatable(String message, Throwable e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((LoggerChannelListener)this.listeners.get(i)).messageLogged(this.addTimeStamp(message), e);
                continue;
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
        }
        if (!this.no_output) {
            org.gudy.azureus2.core3.logging.Logger.log(new LogAlert(true, message, e));
        }
    }

    public void addListener(LoggerChannelListener l) {
        this.listeners.add(l);
    }

    public void removeListener(LoggerChannelListener l) {
        this.listeners.remove(l);
    }

    protected String addTimeStamp(String data) {
        if (this.timestamp) {
            return this.getTimeStamp() + data;
        }
        return data;
    }

    protected String getTimeStamp() {
        Calendar now = GregorianCalendar.getInstance();
        String timeStamp = "[" + now.get(11) + ":" + LoggerChannelImpl.format(now.get(12)) + ":" + LoggerChannelImpl.format(now.get(13)) + "] ";
        return timeStamp;
    }

    private static String format(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }
}

