/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerForeignNetworkConnection;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerStatsImpl;

public class PeerForeignDelegate
implements PEPeerTransport {
    protected volatile int _lastPiece = -1;
    private PeerManagerImpl manager;
    private Peer foreign;
    private NetworkConnectionBase network_connection;
    private long create_time = SystemTime.getCurrentTime();
    private long last_data_received_time = -1L;
    private long last_data_message_received_time = -1L;
    private int reserved_piece = -1;
    private int consecutive_no_requests;
    private BitFlags bit_flags;
    private boolean priority_connection;
    private Map data;
    private HashMap peer_listeners;
    protected AEMonitor this_mon = new AEMonitor("PeerForeignDelegate");

    protected PeerForeignDelegate(PeerManagerImpl _manager, Peer _foreign) {
        this.manager = _manager;
        this.foreign = _foreign;
        PEPeerManager pm = this.manager.getDelegate();
        this.network_connection = new PeerForeignNetworkConnection(this.foreign);
        this.network_connection.addRateLimiter(pm.getUploadLimitedRateGroup(), true);
        this.network_connection.addRateLimiter(pm.getDownloadLimitedRateGroup(), false);
    }

    public void start() {
        NetworkManager.getSingleton().startTransferProcessing(this.network_connection);
        NetworkManager.getSingleton().upgradeTransferProcessing(this.network_connection, this.manager.getPartitionID());
    }

    protected void stop() {
        NetworkManager.getSingleton().stopTransferProcessing(this.network_connection);
    }

    public void sendChoke() {
    }

    public void sendHave(int piece) {
    }

    public void sendUnChoke() {
    }

    public boolean transferAvailable() {
        return this.foreign.isTransferAvailable();
    }

    public boolean isDownloadPossible() {
        return this.foreign.isDownloadPossible();
    }

    public void sendCancel(DiskManagerReadRequest request2) {
        this.foreign.cancelRequest(request2);
    }

    public DiskManagerReadRequest request(int pieceNumber, int pieceOffset, int pieceLength) {
        DiskManagerReadRequest request2 = this.manager.getDelegate().getDiskManager().createReadRequest(pieceNumber, pieceOffset, pieceLength);
        if (this.foreign.addRequest(request2)) {
            return request2;
        }
        return null;
    }

    public int getRequestIndex(DiskManagerReadRequest request2) {
        return this.foreign.getRequests().indexOf(request2);
    }

    protected void dataReceived() {
        this.last_data_received_time = SystemTime.getCurrentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(String reason) {
        try {
            this.foreign.close(reason, false, false);
        }
        finally {
            this.stop();
        }
    }

    public List getExpiredRequests() {
        return this.foreign.getExpiredRequests();
    }

    public int getMaxNbRequests() {
        return this.foreign.getMaximumNumberOfRequests();
    }

    public int getNbRequests() {
        return this.foreign.getNumberOfRequests();
    }

    public int[] getPriorityOffsets() {
        return this.foreign.getPriorityOffsets();
    }

    public boolean requestAllocationStarts(int[] base_priorities) {
        return this.foreign.requestAllocationStarts(base_priorities);
    }

    public void requestAllocationComplete() {
        this.foreign.requestAllocationComplete();
    }

    public PEPeerControl getControl() {
        return (PEPeerControl)this.manager.getDelegate();
    }

    public void updatePeerExchange() {
    }

    public PeerItem getPeerItemIdentity() {
        return PeerItemFactory.createPeerItem(this.foreign.getIp(), this.foreign.getTCPListenPort(), (byte)3, (byte)0, this.foreign.getUDPListenPort(), (byte)1, 0);
    }

    public int getConnectionState() {
        int peer_state = this.getPeerState();
        if (peer_state == 10) {
            return 1;
        }
        if (peer_state == 20) {
            return 2;
        }
        if (peer_state == 30) {
            return 4;
        }
        return 4;
    }

    public void doKeepAliveCheck() {
    }

    public boolean doTimeoutChecks() {
        return false;
    }

    public void doPerformanceTuningCheck() {
    }

    public long getTimeSinceConnectionEstablished() {
        long now = SystemTime.getCurrentTime();
        if (now > this.create_time) {
            return now - this.create_time;
        }
        return 0L;
    }

    public long getTimeSinceLastDataMessageReceived() {
        if (this.last_data_message_received_time == -1L) {
            return -1L;
        }
        long now = SystemTime.getCurrentTime();
        if (this.last_data_message_received_time < now) {
            this.last_data_message_received_time = now;
        }
        return now - this.last_data_message_received_time;
    }

    public long getTimeSinceGoodDataReceived() {
        if (this.last_data_received_time == -1L) {
            return -1L;
        }
        long now = SystemTime.getCurrentTime();
        long time_since = now - this.last_data_received_time;
        if (time_since < 0L) {
            this.last_data_received_time = now;
            time_since = 0L;
        }
        return time_since;
    }

    public long getTimeSinceLastDataMessageSent() {
        return 0L;
    }

    public int getConsecutiveNoRequestCount() {
        return this.consecutive_no_requests;
    }

    public void setConsecutiveNoRequestCount(int num) {
        this.consecutive_no_requests = num;
    }

    public PEPeerManager getManager() {
        return this.manager.getDelegate();
    }

    public String getPeerSource() {
        return "Plugin";
    }

    public int getPeerState() {
        int peer_state = this.foreign.getState();
        return peer_state;
    }

    public byte[] getId() {
        return this.foreign.getId();
    }

    public String getIp() {
        return this.foreign.getIp();
    }

    public String getIPHostName() {
        return this.foreign.getIp();
    }

    public int getPort() {
        return this.foreign.getPort();
    }

    public int getTCPListenPort() {
        return this.foreign.getTCPListenPort();
    }

    public int getUDPListenPort() {
        return this.foreign.getUDPListenPort();
    }

    public int getUDPNonDataListenPort() {
        return this.foreign.getUDPNonDataListenPort();
    }

    public BitFlags getAvailable() {
        boolean[] flags = this.foreign.getAvailable();
        if (this.bit_flags == null || this.bit_flags.flags != flags) {
            this.bit_flags = new BitFlags(flags);
        }
        return this.bit_flags;
    }

    public boolean hasReceivedBitField() {
        return true;
    }

    public boolean isPieceAvailable(int pieceNumber) {
        return this.foreign.isPieceAvailable(pieceNumber);
    }

    public void setSnubbed(boolean b) {
        this.foreign.setSnubbed(b);
    }

    public boolean isChokingMe() {
        return this.foreign.isChoked();
    }

    public boolean isChokedByMe() {
        return this.foreign.isChoking();
    }

    public boolean isInteresting() {
        return this.foreign.isInteresting();
    }

    public boolean isInterested() {
        return this.foreign.isInterested();
    }

    public boolean isSeed() {
        return this.foreign.isSeed();
    }

    public boolean isRelativeSeed() {
        return false;
    }

    public boolean isSnubbed() {
        return this.foreign.isSnubbed();
    }

    public long getSnubbedTime() {
        return this.foreign.getSnubbedTime();
    }

    public boolean isLANLocal() {
        return AddressUtils.isLANLocalAddress(this.foreign.getIp()) == 1;
    }

    public boolean sendRequestHint(int piece_number, int offset, int length, int life) {
        return false;
    }

    public int[] getRequestHint() {
        return null;
    }

    public void clearRequestHint() {
    }

    public void sendBadPiece(int piece_number) {
    }

    public boolean isTCP() {
        return true;
    }

    public PEPeerStats getStats() {
        return ((PeerStatsImpl)this.foreign.getStats()).getDelegate();
    }

    public boolean isIncoming() {
        return this.foreign.isIncoming();
    }

    public int getPercentDoneInThousandNotation() {
        return this.foreign.getPercentDoneInThousandNotation();
    }

    public long getBytesRemaining() {
        int rem_pm = 1000 - this.getPercentDoneInThousandNotation();
        if (rem_pm == 0) {
            return 0L;
        }
        try {
            Torrent t = this.manager.getDownload().getTorrent();
            if (t == null) {
                return Long.MAX_VALUE;
            }
            return t.getSize() * (long)rem_pm / 1000L;
        }
        catch (Throwable e) {
            return Long.MAX_VALUE;
        }
    }

    public String getClient() {
        return this.foreign.getClient();
    }

    public byte[] getHandshakeReservedBytes() {
        return this.foreign.getHandshakeReservedBytes();
    }

    public boolean isOptimisticUnchoke() {
        return this.foreign.isOptimisticUnchoke();
    }

    public void setOptimisticUnchoke(boolean is_optimistic) {
        this.foreign.setOptimisticUnchoke(is_optimistic);
    }

    public int getUniqueAnnounce() {
        return -1;
    }

    public int getUploadHint() {
        return 0;
    }

    public void setUniqueAnnounce(int uniquePieceNumber) {
    }

    public void setUploadHint(int timeToSpread) {
    }

    public boolean isStalledPendingLoad() {
        return false;
    }

    public void addListener(final PEPeerListener l) {
        final PeerForeignDelegate self = this;
        PeerListener2 core_listener = new PeerListener2(){

            public void eventOccurred(PeerEvent event2) {
                Object data = event2.getData();
                switch (event2.getType()) {
                    case 1: {
                        l.stateChanged(self, (Integer)data);
                        break;
                    }
                    case 2: {
                        Integer[] d = (Integer[])data;
                        l.sentBadChunk(self, d[0], d[1]);
                        break;
                    }
                    case 3: {
                        l.addAvailability(self, new BitFlags((boolean[])data));
                        break;
                    }
                    case 4: {
                        l.removeAvailability(self, new BitFlags((boolean[])data));
                    }
                }
            }
        };
        this.foreign.addListener(core_listener);
        if (this.peer_listeners == null) {
            this.peer_listeners = new HashMap();
        }
        this.peer_listeners.put(l, core_listener);
    }

    public void removeListener(PEPeerListener l) {
        Object core_listener;
        if (this.peer_listeners != null && (core_listener = this.peer_listeners.remove(l)) != null) {
            if (core_listener instanceof PeerListener) {
                this.foreign.removeListener((PeerListener)core_listener);
            } else {
                this.foreign.removeListener((PeerListener2)core_listener);
            }
        }
    }

    public Connection getPluginConnection() {
        return this.foreign.getConnection();
    }

    public int getPercentDoneOfCurrentIncomingRequest() {
        return this.foreign.getPercentDoneOfCurrentIncomingRequest();
    }

    public int getPercentDoneOfCurrentOutgoingRequest() {
        return this.foreign.getPercentDoneOfCurrentOutgoingRequest();
    }

    public boolean supportsMessaging() {
        return this.foreign.supportsMessaging();
    }

    public int getMessagingMode() {
        return 4;
    }

    public String getEncryption() {
        return "";
    }

    public com.aelitis.azureus.core.peermanager.messaging.Message[] getSupportedMessages() {
        Message[] plug_msgs = this.foreign.getSupportedMessages();
        com.aelitis.azureus.core.peermanager.messaging.Message[] core_msgs = new com.aelitis.azureus.core.peermanager.messaging.Message[plug_msgs.length];
        for (int i = 0; i < plug_msgs.length; ++i) {
            core_msgs[i] = new MessageAdapter(plug_msgs[i]);
        }
        return core_msgs;
    }

    public Object getData(String key) {
        return this.getUserData(key);
    }

    public void setData(String key, Object value) {
        this.setUserData(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUserData(Object key) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                Object var2_2 = null;
                return var2_2;
            }
            Object v = this.data.get(key);
            return v;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserData(Object key, Object value) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                this.data = new LightHashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                    if (this.data.size() == 0) {
                        this.data = null;
                    }
                }
            } else {
                this.data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean equals(Object other) {
        if (other instanceof PeerForeignDelegate) {
            return this.foreign.equals(((PeerForeignDelegate)other).foreign);
        }
        return false;
    }

    public int hashCode() {
        return this.foreign.hashCode();
    }

    public int getReservedPieceNumber() {
        return this.reserved_piece;
    }

    public void setReservedPieceNumber(int pieceNumber) {
        this.reserved_piece = pieceNumber;
    }

    public int[] getIncomingRequestedPieceNumbers() {
        return new int[0];
    }

    public int getIncomingRequestCount() {
        return 0;
    }

    public int getOutgoingRequestCount() {
        return this.foreign.getRequests().size();
    }

    public int[] getOutgoingRequestedPieceNumbers() {
        List l = this.foreign.getRequests();
        int[] res = new int[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            res[i] = ((PeerReadRequest)l.get(i)).getPieceNumber();
        }
        return res;
    }

    public int getOutboundDataQueueSize() {
        return this.getOutgoingRequestCount() * 16384;
    }

    public int getLastPiece() {
        return this._lastPiece;
    }

    public void setLastPiece(int pieceNumber) {
        this._lastPiece = pieceNumber;
    }

    public void checkInterested() {
    }

    public boolean isAvailabilityAdded() {
        return false;
    }

    public void clearAvailabilityAdded() {
    }

    public PEPeerTransport reconnect(boolean tryUDP) {
        return null;
    }

    public boolean isSafeForReconnect() {
        return false;
    }

    public void setUploadRateLimitBytesPerSecond(int bytes) {
        this.network_connection.setUploadLimit(bytes);
    }

    public void setDownloadRateLimitBytesPerSecond(int bytes) {
        this.network_connection.setDownloadLimit(bytes);
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.network_connection.getUploadLimit();
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return this.network_connection.getDownloadLimit();
    }

    public void addRateLimiter(LimitedRateGroup limiter, boolean upload) {
        this.network_connection.addRateLimiter(limiter, upload);
    }

    public void removeRateLimiter(LimitedRateGroup limiter, boolean upload) {
        this.network_connection.removeRateLimiter(limiter, upload);
    }

    public void setHaveAggregationEnabled(boolean enabled) {
    }

    public void setPriorityConnection(boolean is_priority) {
        this.priority_connection = is_priority;
    }

    public boolean isPriorityConnection() {
        return this.priority_connection;
    }

    public void generateEvidence(IndentWriter writer) {
        writer.println("delegate: ip=" + this.getIp() + ",tcp=" + this.getTCPListenPort() + ",udp=" + this.getUDPListenPort() + ",state=" + this.foreign.getState() + ",foreign=" + this.foreign);
    }

    public String getClientNameFromExtensionHandshake() {
        return null;
    }

    public String getClientNameFromPeerID() {
        return null;
    }
}

