/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerForeignDelegate;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerStatsImpl;

public class PeerImpl
extends LogRelation
implements Peer {
    protected PeerManagerImpl manager;
    protected PEPeer delegate;
    protected AEMonitor this_mon = new AEMonitor("Peer");
    private HashMap peer_listeners;

    protected PeerImpl(PEPeer _delegate) {
        this.delegate = _delegate;
        this.manager = PeerManagerImpl.getPeerManager(this.delegate.getManager());
    }

    public PeerManager getManager() {
        return this.manager;
    }

    protected PEPeer getDelegate() {
        return this.delegate;
    }

    public Connection getConnection() {
        return this.delegate.getPluginConnection();
    }

    public boolean supportsMessaging() {
        return this.delegate.supportsMessaging();
    }

    public Message[] getSupportedMessages() {
        com.aelitis.azureus.core.peermanager.messaging.Message[] core_msgs = this.delegate.getSupportedMessages();
        Message[] plug_msgs = new Message[core_msgs.length];
        for (int i = 0; i < core_msgs.length; ++i) {
            plug_msgs[i] = new MessageAdapter(core_msgs[i]);
        }
        return plug_msgs;
    }

    public int getState() {
        int state = this.delegate.getPeerState();
        switch (state) {
            case 10: {
                return 10;
            }
            case 50: {
                return 50;
            }
            case 20: {
                return 20;
            }
            case 30: {
                return 30;
            }
        }
        return -1;
    }

    public byte[] getId() {
        byte[] id = this.delegate.getId();
        if (id == null) {
            return null;
        }
        byte[] copy = new byte[id.length];
        System.arraycopy(id, 0, copy, 0, copy.length);
        return copy;
    }

    public String getIp() {
        return this.delegate.getIp();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public int getTCPListenPort() {
        return this.delegate.getTCPListenPort();
    }

    public int getUDPListenPort() {
        return this.delegate.getUDPListenPort();
    }

    public int getUDPNonDataListenPort() {
        return this.delegate.getUDPNonDataListenPort();
    }

    public final boolean[] getAvailable() {
        return this.delegate.getAvailable().flags;
    }

    public boolean isPieceAvailable(int pieceNumber) {
        return this.delegate.isPieceAvailable(pieceNumber);
    }

    public boolean isTransferAvailable() {
        return this.delegate.transferAvailable();
    }

    public boolean isDownloadPossible() {
        return this.delegate.isDownloadPossible();
    }

    public boolean isChoked() {
        return this.delegate.isChokingMe();
    }

    public boolean isChoking() {
        return this.delegate.isChokedByMe();
    }

    public boolean isInterested() {
        return this.delegate.isInteresting();
    }

    public boolean isInteresting() {
        return this.delegate.isInterested();
    }

    public boolean isSeed() {
        return this.delegate.isSeed();
    }

    public boolean isSnubbed() {
        return this.delegate.isSnubbed();
    }

    public long getSnubbedTime() {
        return this.delegate.getSnubbedTime();
    }

    public void setSnubbed(boolean b) {
        this.delegate.setSnubbed(b);
    }

    public PeerStats getStats() {
        return new PeerStatsImpl(this.manager, this, this.delegate.getStats());
    }

    public boolean isIncoming() {
        return this.delegate.isIncoming();
    }

    public int getPercentDone() {
        return this.delegate.getPercentDoneInThousandNotation();
    }

    public int getPercentDoneInThousandNotation() {
        return this.delegate.getPercentDoneInThousandNotation();
    }

    public String getClient() {
        return this.delegate.getClient();
    }

    public boolean isOptimisticUnchoke() {
        return this.delegate.isOptimisticUnchoke();
    }

    public void setOptimisticUnchoke(boolean is_optimistic) {
        this.delegate.setOptimisticUnchoke(is_optimistic);
    }

    public void initialize() {
        throw new RuntimeException("not supported");
    }

    public List getExpiredRequests() {
        throw new RuntimeException("not supported");
    }

    public List getRequests() {
        throw new RuntimeException("not supported");
    }

    public int getNumberOfRequests() {
        throw new RuntimeException("not supported");
    }

    public int getMaximumNumberOfRequests() {
        throw new RuntimeException("not supported");
    }

    public int[] getPriorityOffsets() {
        throw new RuntimeException("not supported");
    }

    public boolean requestAllocationStarts(int[] base_priorities) {
        throw new RuntimeException("not supported");
    }

    public void requestAllocationComplete() {
        throw new RuntimeException("not supported");
    }

    public void cancelRequest(PeerReadRequest request2) {
        throw new RuntimeException("not supported");
    }

    public boolean addRequest(PeerReadRequest request2) {
        throw new RuntimeException("not supported");
    }

    public void close(String reason, boolean closedOnError, boolean attemptReconnect) {
        this.manager.removePeer(this, reason);
    }

    public int readBytes(int max) {
        throw new RuntimeException("not supported");
    }

    public int writeBytes(int max) {
        throw new RuntimeException("not supported");
    }

    protected void closed() {
        if (this.delegate instanceof PeerForeignDelegate) {
            ((PeerForeignDelegate)this.delegate).stop();
        }
    }

    public int getPercentDoneOfCurrentIncomingRequest() {
        return this.delegate.getPercentDoneOfCurrentIncomingRequest();
    }

    public int getPercentDoneOfCurrentOutgoingRequest() {
        return this.delegate.getPercentDoneOfCurrentOutgoingRequest();
    }

    public void addListener(final PeerListener l) {
        PEPeerListener core_listener = new PEPeerListener(){

            public void stateChanged(PEPeer peer, int new_state) {
                try {
                    l.stateChanged(new_state);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }

            public void sentBadChunk(PEPeer peer, int piece_num, int total_bad_chunks) {
                try {
                    l.sentBadChunk(piece_num, total_bad_chunks);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }

            public void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
            }

            public void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
            }
        };
        this.delegate.addListener(core_listener);
        if (this.peer_listeners == null) {
            this.peer_listeners = new HashMap();
        }
        this.peer_listeners.put(l, core_listener);
    }

    public void removeListener(PeerListener l) {
        PEPeerListener core_listener;
        if (this.peer_listeners != null && (core_listener = (PEPeerListener)this.peer_listeners.remove(l)) != null) {
            this.delegate.removeListener(core_listener);
        }
    }

    public void addListener(final PeerListener2 l) {
        PEPeerListener core_listener = new PEPeerListener(){

            public void stateChanged(PEPeer peer, int new_state) {
                this.fireEvent(1, new Integer(new_state));
            }

            public void sentBadChunk(PEPeer peer, int piece_num, int total_bad_chunks) {
                this.fireEvent(2, new Integer[]{new Integer(piece_num), new Integer(total_bad_chunks)});
            }

            public void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
                this.fireEvent(3, peerHavePieces.flags);
            }

            public void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
                this.fireEvent(4, peerHavePieces.flags);
            }

            protected void fireEvent(final int type, final Object data) {
                try {
                    l.eventOccurred(new PeerEvent(){

                        public int getType() {
                            return type;
                        }

                        public Object getData() {
                            return data;
                        }
                    });
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        };
        this.delegate.addListener(core_listener);
        if (this.peer_listeners == null) {
            this.peer_listeners = new HashMap();
        }
        this.peer_listeners.put(l, core_listener);
    }

    public void removeListener(PeerListener2 l) {
        PEPeerListener core_listener;
        if (this.peer_listeners != null && (core_listener = (PEPeerListener)this.peer_listeners.remove(l)) != null) {
            this.delegate.removeListener(core_listener);
        }
    }

    public boolean isPriorityConnection() {
        return this.delegate.isPriorityConnection();
    }

    public void setPriorityConnection(boolean is_priority) {
        this.delegate.setPriorityConnection(is_priority);
    }

    public void setUserData(Object key, Object value) {
        this.delegate.setUserData(key, value);
    }

    public Object getUserData(Object key) {
        return this.delegate.getUserData(key);
    }

    public boolean equals(Object other) {
        if (other instanceof PeerImpl) {
            return this.delegate == ((PeerImpl)other).delegate;
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public PEPeer getPEPeer() {
        return this.delegate;
    }

    public String getRelationText() {
        return this.propogatedRelationText(this.delegate);
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.delegate};
    }

    public byte[] getHandshakeReservedBytes() {
        return this.delegate.getHandshakeReservedBytes();
    }
}

