/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceListener;
import org.gudy.azureus2.plugins.sharing.ShareResourceWillBeDeletedListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceImpl;

public class ShareResourceDirContentsImpl
extends ShareResourceImpl
implements ShareResourceDirContents {
    protected File root;
    protected boolean recursive;
    protected ShareResource[] children = new ShareResource[0];

    protected ShareResourceDirContentsImpl(ShareManagerImpl _manager, File _dir, boolean _recursive, boolean _async_check) throws ShareException {
        super(_manager, 3);
        this.root = _dir;
        this.recursive = _recursive;
        if (!this.root.exists()) {
            throw new ShareException("Dir '".concat(this.root.getName()).concat("' not found"));
        }
        if (this.root.isFile()) {
            throw new ShareException("Not a directory");
        }
        if (_async_check) {
            new AEThread2("SM:asyncCheck", true){

                public void run() {
                    try {
                        ShareResourceDirContentsImpl.this.checkConsistency();
                    }
                    catch (Throwable e) {
                        Debug.out("Failed to update consistency", e);
                    }
                }
            }.start();
        } else {
            this.checkConsistency();
        }
    }

    protected ShareResourceDirContentsImpl(ShareManagerImpl _manager, File _dir, boolean _recursive, Map _map) throws ShareException {
        super(_manager, 3, _map);
        this.root = _dir;
        this.recursive = _recursive;
        if (!this.root.exists()) {
            Debug.out("Dir '" + this.root.getName() + "' not found");
        } else if (this.root.isFile()) {
            throw new ShareException("Not a directory");
        }
    }

    public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].canBeDeleted()) continue;
            return false;
        }
        return true;
    }

    protected void checkConsistency() throws ShareException {
        List kids = this.checkConsistency(this.root);
        if (kids != null) {
            this.children = new ShareResource[kids.size()];
            kids.toArray(this.children);
        } else {
            this.children = new ShareResource[0];
        }
    }

    protected List checkConsistency(File dir) throws ShareException {
        ArrayList<ShareResource> kids = new ArrayList<ShareResource>();
        File[] files = dir.listFiles();
        if (files == null || !dir.exists()) {
            if (dir == this.root) {
                return null;
            }
            this.manager.delete(this);
        } else {
            int i;
            for (i = 0; i < files.length; ++i) {
                ShareResource res;
                File file = files[i];
                String file_name = file.getName();
                if (file_name.equals(".") || file_name.equals("..")) continue;
                if (file.isDirectory()) {
                    if (this.recursive) {
                        List child = this.checkConsistency(file);
                        kids.add(new shareNode(this, file, child));
                        continue;
                    }
                    try {
                        res = this.manager.getDir(file);
                        if (res == null) {
                            res = this.manager.addDir(this, file);
                        }
                        kids.add(res);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    continue;
                }
                try {
                    res = this.manager.getFile(file);
                    if (res == null) {
                        res = this.manager.addFile(this, file);
                    }
                    kids.add(res);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            for (i = 0; i < kids.size(); ++i) {
                Object o = kids.get(i);
                if (o instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)o).setParent(this);
                    continue;
                }
                ((shareNode)o).setParent(this);
            }
        }
        return kids;
    }

    protected void deleteInternal() {
        for (int i = 0; i < this.children.length; ++i) {
            try {
                if (this.children[i] instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)this.children[i]).delete(true);
                    continue;
                }
                ((shareNode)this.children[i]).delete(true);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void serialiseResource(Map map) {
        super.serialiseResource(map);
        map.put("type", new Long(this.getType()));
        map.put("recursive", new Long(this.recursive ? 1L : 0L));
        try {
            map.put("file", this.root.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
        }
    }

    protected static ShareResourceImpl deserialiseResource(ShareManagerImpl manager, Map map) throws ShareException {
        try {
            File root = new File(new String((byte[])map.get("file"), "UTF8"));
            boolean recursive = (Long)map.get("recursive") == 1L;
            ShareResourceDirContentsImpl res = new ShareResourceDirContentsImpl(manager, root, recursive, map);
            return res;
        }
        catch (UnsupportedEncodingException e) {
            throw new ShareException("internal error", e);
        }
    }

    public String getName() {
        return this.root.toString();
    }

    public File getRoot() {
        return this.root;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public ShareResource[] getChildren() {
        return this.children;
    }

    protected class shareNode
    implements ShareResourceDirContents {
        protected ShareResourceDirContents node_parent;
        protected File node;
        protected ShareResource[] node_children;

        protected shareNode(ShareResourceDirContents _parent, File _node, List kids) {
            this.node_parent = _parent;
            this.node = _node;
            this.node_children = new ShareResource[kids.size()];
            kids.toArray(this.node_children);
            for (int i = 0; i < this.node_children.length; ++i) {
                ShareResource o = this.node_children[i];
                if (o instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)o).setParent(this);
                    continue;
                }
                ((shareNode)o).setParent(this);
            }
        }

        public ShareResourceDirContents getParent() {
            return this.node_parent;
        }

        protected void setParent(ShareResourceDirContents _parent) {
            this.node_parent = _parent;
        }

        public int getType() {
            return 3;
        }

        public String getName() {
            return this.node.toString();
        }

        public void setAttribute(TorrentAttribute attribute, String value) {
            for (int i = 0; i < this.node_children.length; ++i) {
                this.node_children[i].setAttribute(attribute, value);
            }
        }

        public String getAttribute(TorrentAttribute attribute) {
            return null;
        }

        public TorrentAttribute[] getAttributes() {
            return new TorrentAttribute[0];
        }

        public void delete() throws ShareResourceDeletionVetoException {
            throw new ShareResourceDeletionVetoException(MessageText.getString("plugin.sharing.remove.veto"));
        }

        public void delete(boolean force) throws ShareException, ShareResourceDeletionVetoException {
            for (int i = 0; i < this.node_children.length; ++i) {
                ShareResource o = this.node_children[i];
                if (o instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)o).delete(force);
                    continue;
                }
                ((shareNode)o).delete(force);
            }
        }

        public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
            for (int i = 0; i < this.node_children.length; ++i) {
                this.node_children[i].canBeDeleted();
            }
            return true;
        }

        public File getRoot() {
            return this.node;
        }

        public boolean isRecursive() {
            return ShareResourceDirContentsImpl.this.recursive;
        }

        public ShareResource[] getChildren() {
            return this.node_children;
        }

        public void addChangeListener(ShareResourceListener l) {
        }

        public void removeChangeListener(ShareResourceListener l) {
        }

        public void addDeletionListener(ShareResourceWillBeDeletedListener l) {
        }

        public void removeDeletionListener(ShareResourceWillBeDeletedListener l) {
        }
    }
}

