/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.test;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.security.CryptoManagerPasswordHandler;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnectionListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageHandler;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageRegistration;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentAttributeEvent;
import org.gudy.azureus2.plugins.torrent.TorrentAttributeListener;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.search.Search;
import org.gudy.azureus2.plugins.utils.search.SearchInitiator;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.search.SearchProviderResults;
import org.gudy.azureus2.plugins.utils.search.SearchResult;
import org.gudy.azureus2.plugins.utils.security.SEPublicKey;
import org.gudy.azureus2.plugins.utils.security.SEPublicKeyLocator;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;
import org.gudy.azureus2.ui.swt.Main;

public class Test
implements Plugin {
    protected PluginInterface plugin_interface;

    public void initialize(PluginInterface _pi) {
        this.plugin_interface = _pi;
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                AEThread t = new AEThread("test"){

                    public void runSupport() {
                        while (true) {
                            try {
                                SearchInitiator si;
                                SearchProvider[] providers;
                                do {
                                    Thread.sleep(1000L);
                                    si = Test.this.plugin_interface.getUtilities().getSearchInitiator();
                                    providers = si.getProviders();
                                    System.out.println("search providers=" + providers.length);
                                } while (providers.length <= 0);
                                HashMap<String, String> properties = new HashMap<String, String>();
                                properties.put("search_term", "monkey");
                                properties.put("mature", "true");
                                Search s = si.createSearch(providers, properties, null);
                                while (!s.isComplete()) {
                                    Thread.sleep(1000L);
                                    SearchProviderResults[] results = s.getResults();
                                    if (results.length <= 0) continue;
                                    System.out.println("Got results: " + results.length);
                                    for (SearchProviderResults result : results) {
                                        SearchResult[] srs;
                                        System.out.println("    " + result.getProvider().getProperty(1) + ": comp=" + result.isComplete() + ", error=" + result.getError());
                                        for (SearchResult sr : srs = result.getResults()) {
                                            System.out.println("        " + sr.getProperty(1));
                                        }
                                    }
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
    }

    protected void testMessaging() {
        try {
            AzureusCoreFactory.getSingleton().getCryptoManager().addPasswordHandler(new CryptoManagerPasswordHandler(){

                public int getHandlerType() {
                    return 1;
                }

                public CryptoManagerPasswordHandler.passwordDetails getPassword(int handler_type, int action_type, boolean last_pw_incorrect, String reason) {
                    System.out.println("CryptoPassword (" + reason + ")");
                    return new CryptoManagerPasswordHandler.passwordDetails(){

                        public char[] getPassword() {
                            return "changeit".toCharArray();
                        }

                        public int getPersistForSeconds() {
                            return 0;
                        }
                    };
                }

                public void passwordOK(int handler_type, CryptoManagerPasswordHandler.passwordDetails details) {
                }
            });
            final SESecurityManager sec_man = this.plugin_interface.getUtilities().getSecurityManager();
            final SEPublicKey my_key = sec_man.getPublicKey(1, "test");
            int stream_crypto = 3;
            boolean use_sts = true;
            int block_crypto = 2;
            GenericMessageRegistration reg = this.plugin_interface.getMessageManager().registerGenericMessageType("GENTEST", "Gen test desc", 3, new GenericMessageHandler(){

                public boolean accept(GenericMessageConnection connection) throws MessageException {
                    System.out.println("accept");
                    try {
                        connection = sec_man.getSTSConnection(connection, my_key, new SEPublicKeyLocator(){

                            public boolean accept(Object context2, SEPublicKey other_key) {
                                System.out.println("acceptKey");
                                return true;
                            }
                        }, "test", 2);
                        connection.addListener(new GenericMessageConnectionListener(){

                            public void connected(GenericMessageConnection connection) {
                            }

                            public void receive(GenericMessageConnection connection, PooledByteBuffer message) throws MessageException {
                                System.out.println("receive: " + message.toByteArray().length);
                                PooledByteBuffer reply = Test.this.plugin_interface.getUtilities().allocatePooledByteBuffer(new byte[connection.getMaximumMessageSize()]);
                                connection.send(reply);
                            }

                            public void failed(GenericMessageConnection connection, Throwable error) throws MessageException {
                                System.out.println("Responder connection error:");
                                error.printStackTrace();
                            }
                        });
                    }
                    catch (Throwable e) {
                        connection.close();
                        e.printStackTrace();
                    }
                    return true;
                }
            });
            InetSocketAddress tcp_target = new InetSocketAddress("127.0.0.1", 6889);
            InetSocketAddress udp_target = new InetSocketAddress("212.159.18.92", 6881);
            GenericMessageEndpoint endpoint = reg.createEndpoint(tcp_target);
            endpoint.addTCP(tcp_target);
            endpoint.addUDP(udp_target);
            while (true) {
                try {
                    block7: while (true) {
                        int i = 0;
                        while (true) {
                            if (i >= 1000) continue block7;
                            System.out.println("Test: initiating connection");
                            final AESemaphore sem = new AESemaphore("wait!");
                            GenericMessageConnection con = reg.createConnection(endpoint);
                            con = sec_man.getSTSConnection(con, my_key, new SEPublicKeyLocator(){

                                public boolean accept(Object context2, SEPublicKey other_key) {
                                    System.out.println("acceptKey");
                                    return true;
                                }
                            }, "test", 2);
                            con.addListener(new GenericMessageConnectionListener(){

                                public void connected(GenericMessageConnection connection) {
                                    System.out.println("connected");
                                    PooledByteBuffer data = Test.this.plugin_interface.getUtilities().allocatePooledByteBuffer("1234".getBytes());
                                    try {
                                        connection.send(data);
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                }

                                public void receive(GenericMessageConnection connection, PooledByteBuffer message) throws MessageException {
                                    System.out.println("receive: " + message.toByteArray().length);
                                    try {
                                        Thread.sleep(30000L);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    System.out.println("closing connection");
                                    connection.close();
                                    sem.release();
                                }

                                public void failed(GenericMessageConnection connection, Throwable error) throws MessageException {
                                    System.out.println("Initiator connection error:");
                                    error.printStackTrace();
                                    sem.release();
                                }
                            });
                            con.connect();
                            sem.reserve();
                            Thread.sleep(1000L);
                            ++i;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    try {
                        System.out.println("Sleeping before retrying");
                        Thread.sleep(30000L);
                    }
                    catch (Throwable f) {}
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    protected void testLinks() {
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                DiskManagerFileInfo[] info = download.getDiskManagerFileInfo();
                for (int i = 0; i < info.length; ++i) {
                    info[i].setLink(new File("C:\\temp"));
                }
            }

            public void downloadRemoved(Download download) {
            }
        });
    }

    protected void testDDB() {
        try {
            DistributedDatabase db = this.plugin_interface.getDistributedDatabase();
            DistributedDatabaseKey key = db.createKey(new byte[]{4, 7, 1, 2, 5, 8});
            boolean do_write = false;
            if (do_write) {
                DistributedDatabaseValue[] values = new DistributedDatabaseValue[500];
                for (int i = 0; i < values.length; ++i) {
                    byte[] val = new byte[20];
                    Arrays.fill(val, (byte)i);
                    values[i] = db.createValue(val);
                }
                db.write(new DistributedDatabaseListener(){

                    public void event(DistributedDatabaseEvent event2) {
                        System.out.println("Event:" + event2.getType());
                        if (event2.getType() == 1) {
                            try {
                                System.out.println("    write - key = " + ByteFormatter.encodeString((byte[])event2.getKey().getKey()) + ", val = " + ByteFormatter.encodeString((byte[])event2.getValue().getValue(byte[].class)));
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }, key, values);
            } else {
                db.read(new DistributedDatabaseListener(){

                    public void event(DistributedDatabaseEvent event2) {
                        System.out.println("Event:" + event2.getType());
                        if (event2.getType() == 2) {
                            try {
                                System.out.println("    read - key = " + ByteFormatter.encodeString((byte[])event2.getKey().getKey()) + ", val = " + ByteFormatter.encodeString((byte[])event2.getValue().getValue(byte[].class)));
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }, key, 60000L);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void taTest() {
        try {
            final TorrentAttribute ta = this.plugin_interface.getTorrentManager().getAttribute("Category");
            ta.addTorrentAttributeListener(new TorrentAttributeListener(){

                public void event(TorrentAttributeEvent ev) {
                    System.out.println("ev: " + ev.getType() + ", " + ev.getData());
                    if (ev.getType() == 1 && "plop".equals(ev.getData())) {
                        ta.removeDefinedValue("plop");
                    }
                }
            });
            ta.addDefinedValue("wibble");
            this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

                public void downloadAdded(Download download) {
                    try {
                        download.setAttribute(ta, "wibble");
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }

                public void downloadRemoved(Download download) {
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.setProperty("azureus.dynamic.plugins", "org.gudy.azureus2.pluginsimpl.local.test.Test");
        Main.main(args);
    }
}

