/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import java.net.URL;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLList;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLListSet;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAnnounceURLListSetImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class TorrentAnnounceURLListImpl
implements TorrentAnnounceURLList {
    protected TorrentImpl torrent;

    protected TorrentAnnounceURLListImpl(TorrentImpl _torrent) {
        this.torrent = _torrent;
    }

    public TorrentAnnounceURLListSet[] getSets() {
        TOTorrentAnnounceURLGroup group = this.torrent.getTorrent().getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        TorrentAnnounceURLListSet[] res = new TorrentAnnounceURLListSet[sets.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new TorrentAnnounceURLListSetImpl(this, sets[i]);
        }
        return res;
    }

    public void setSets(TorrentAnnounceURLListSet[] sets) {
        TOTorrentAnnounceURLGroup group = this.torrent.getTorrent().getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] res = new TOTorrentAnnounceURLSet[sets.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = ((TorrentAnnounceURLListSetImpl)sets[i]).getSet();
        }
        group.setAnnounceURLSets(res);
        this.updated();
    }

    public TorrentAnnounceURLListSet create(URL[] urls) {
        return new TorrentAnnounceURLListSetImpl(this, this.torrent.getTorrent().getAnnounceURLGroup().createAnnounceURLSet(urls));
    }

    public void addSet(URL[] urls) {
        if (this.setAlreadyExists(urls)) {
            return;
        }
        TorrentUtils.announceGroupsInsertLast(this.torrent.getTorrent(), urls);
        this.updated();
    }

    public void insertSetAtFront(URL[] urls) {
        if (this.setAlreadyExists(urls)) {
            return;
        }
        TorrentUtils.announceGroupsInsertFirst(this.torrent.getTorrent(), urls);
        this.updated();
    }

    protected boolean setAlreadyExists(URL[] urls) {
        TOTorrentAnnounceURLGroup group = this.torrent.getTorrent().getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        for (int i = 0; i < sets.length; ++i) {
            URL[] u = sets[i].getAnnounceURLs();
            if (u.length != urls.length) continue;
            boolean all_found = true;
            for (int j = 0; j < urls.length; ++j) {
                URL u1 = urls[j];
                boolean this_found = false;
                for (int k = 0; k < u.length; ++k) {
                    URL u2 = u[k];
                    if (!u1.toString().equals(u2.toString())) continue;
                    this_found = true;
                    break;
                }
                if (this_found) continue;
                all_found = false;
                break;
            }
            if (!all_found) continue;
            return true;
        }
        return false;
    }

    protected void updated() {
        this.torrent.updated();
    }
}

