/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;

public class TrackerWebPageRequestImpl
implements TrackerWebPageRequest {
    private Tracker tracker;
    private TrackerWebContext context;
    private TRTrackerServerListener2.ExternalRequest request;

    protected TrackerWebPageRequestImpl(Tracker _tracker, TrackerWebContext _context, TRTrackerServerListener2.ExternalRequest _request) {
        this.tracker = _tracker;
        this.context = _context;
        this.request = _request;
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    public TrackerWebContext getContext() {
        return this.context;
    }

    public String getURL() {
        return this.request.getURL();
    }

    public URL getAbsoluteURL() {
        return this.request.getAbsoluteURL();
    }

    public String getClientAddress() {
        return this.request.getClientAddress().getAddress().getHostAddress();
    }

    public InetSocketAddress getClientAddress2() {
        return this.request.getClientAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.request.getLocalAddress();
    }

    public String getUser() {
        return this.request.getUser();
    }

    public InputStream getInputStream() {
        return this.request.getInputStream();
    }

    protected OutputStream getOutputStream() {
        return this.request.getOutputStream();
    }

    protected AsyncController getAsyncController() {
        return this.request.getAsyncController();
    }

    public boolean canKeepAlive() {
        return this.request.canKeepAlive();
    }

    public void setKeepAlive(boolean ka) {
        this.request.setKeepAlive(ka);
    }

    public String getHeader() {
        return this.request.getHeader();
    }

    public Map getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String[] header_parts = this.request.getHeader().split("\r\n");
        headers.put("status", header_parts[0].trim());
        for (int i = 1; i < header_parts.length; ++i) {
            String[] key_value = header_parts[i].split(":", 2);
            headers.put(key_value[0].trim().toLowerCase(MessageText.LOCALE_ENGLISH), key_value[1].trim());
        }
        return headers;
    }
}

