/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.model;

import java.util.ArrayList;
import java.util.Properties;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.ColorParameter;
import org.gudy.azureus2.plugins.ui.config.DirectoryParameter;
import org.gudy.azureus2.plugins.ui.config.FileParameter;
import org.gudy.azureus2.plugins.ui.config.HyperlinkParameter;
import org.gudy.azureus2.plugins.ui.config.InfoParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterGroup;
import org.gudy.azureus2.plugins.ui.config.PasswordParameter;
import org.gudy.azureus2.plugins.ui.config.StringListParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.config.UIParameter;
import org.gudy.azureus2.plugins.ui.config.UIParameterContext;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ActionParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.BooleanParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ColorParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.DirectoryParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.HyperlinkParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.InfoParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.IntParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.LabelParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterGroupImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.PasswordParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringListParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.UIParameterImpl;

public class BasicPluginConfigModelImpl
implements BasicPluginConfigModel {
    private UIManagerImpl ui_manager;
    private String parent_section;
    private String section;
    private PluginInterface pi;
    private ArrayList<Parameter> parameters = new ArrayList();
    private String key_prefix;
    private PluginConfigImpl configobj;

    public BasicPluginConfigModelImpl(UIManagerImpl _ui_manager, String _parent_section, String _section) {
        this.ui_manager = _ui_manager;
        this.parent_section = _parent_section;
        this.section = _section;
        this.pi = this.ui_manager.getPluginInterface();
        this.key_prefix = this.pi.getPluginconfig().getPluginConfigKeyPrefix();
        this.configobj = (PluginConfigImpl)this.pi.getPluginconfig();
    }

    public String getParentSection() {
        return this.parent_section;
    }

    public String getSection() {
        return this.section;
    }

    public PluginInterface getPluginInterface() {
        return this.pi;
    }

    public Parameter[] getParameters() {
        Parameter[] res = new Parameter[this.parameters.size()];
        this.parameters.toArray(res);
        return res;
    }

    public void addBooleanParameter(String key, String resource_name, boolean defaultValue) {
        this.addBooleanParameter2(key, resource_name, defaultValue);
    }

    public BooleanParameter addBooleanParameter2(String key, String resource_name, boolean defaultValue) {
        BooleanParameterImpl res = new BooleanParameterImpl(this.configobj, this.resolveKey(key), resource_name, defaultValue);
        this.parameters.add(res);
        return res;
    }

    public void addStringParameter(String key, String resource_name, String defaultValue) {
        this.addStringParameter2(key, resource_name, defaultValue);
    }

    public StringParameter addStringParameter2(String key, String resource_name, String defaultValue) {
        StringParameterImpl res = new StringParameterImpl(this.configobj, this.resolveKey(key), resource_name, defaultValue);
        this.parameters.add(res);
        return res;
    }

    public StringListParameter addStringListParameter2(String key, String resource_name, String[] values, String defaultValue) {
        StringListParameterImpl res = new StringListParameterImpl(this.configobj, this.resolveKey(key), resource_name, defaultValue, values, values);
        this.parameters.add(res);
        return res;
    }

    public StringListParameter addStringListParameter2(String key, String resource_name, String[] values, String[] labels, String defaultValue) {
        StringListParameterImpl res = new StringListParameterImpl(this.configobj, this.resolveKey(key), resource_name, defaultValue, values, labels);
        this.parameters.add(res);
        return res;
    }

    public PasswordParameter addPasswordParameter2(String key, String resource_name, int encoding_type, byte[] defaultValue) {
        PasswordParameterImpl res = new PasswordParameterImpl(this.configobj, this.resolveKey(key), resource_name, encoding_type, defaultValue);
        this.parameters.add(res);
        return res;
    }

    public IntParameter addIntParameter2(String key, String resource_name, int defaultValue) {
        IntParameterImpl res = new IntParameterImpl(this.configobj, this.resolveKey(key), resource_name, defaultValue);
        this.parameters.add(res);
        return res;
    }

    public IntParameter addIntParameter2(String key, String resource_name, int defaultValue, int min_value, int max_value) {
        IntParameterImpl res = new IntParameterImpl(this.configobj, this.resolveKey(key), resource_name, defaultValue, min_value, max_value);
        this.parameters.add(res);
        return res;
    }

    public DirectoryParameter addDirectoryParameter2(String key, String resource_name, String defaultValue) {
        DirectoryParameterImpl res = new DirectoryParameterImpl(this.configobj, this.resolveKey(key), resource_name, defaultValue);
        this.parameters.add(res);
        return res;
    }

    public FileParameter addFileParameter2(String key, String resource_name, String defaultValue) {
        return this.addFileParameter2(key, resource_name, defaultValue, null);
    }

    public FileParameter addFileParameter2(String key, String resource_name, String defaultValue, String[] file_extensions) {
        org.gudy.azureus2.pluginsimpl.local.ui.config.FileParameter res = new org.gudy.azureus2.pluginsimpl.local.ui.config.FileParameter(this.configobj, this.resolveKey(key), resource_name, defaultValue, file_extensions);
        this.parameters.add(res);
        return res;
    }

    public LabelParameter addLabelParameter2(String resource_name) {
        LabelParameterImpl res = new LabelParameterImpl(this.configobj, this.key_prefix, resource_name);
        this.parameters.add(res);
        return res;
    }

    public InfoParameter addInfoParameter2(String resource_name, String value) {
        InfoParameterImpl res = new InfoParameterImpl(this.configobj, this.key_prefix, resource_name, value);
        this.parameters.add(res);
        return res;
    }

    public HyperlinkParameter addHyperlinkParameter2(String resource_name, String url_location) {
        HyperlinkParameterImpl res = new HyperlinkParameterImpl(this.configobj, this.key_prefix, resource_name, url_location);
        this.parameters.add(res);
        return res;
    }

    public ColorParameter addColorParameter2(String key, String resource_name, int r, int g, int b) {
        ColorParameterImpl res = new ColorParameterImpl(this.configobj, this.resolveKey(key), resource_name, r, g, b);
        this.parameters.add(res);
        return res;
    }

    public UIParameter addUIParameter2(UIParameterContext context2, String resource_name) {
        UIParameterImpl res = new UIParameterImpl(this.configobj, context2, this.key_prefix, resource_name);
        this.parameters.add(res);
        return res;
    }

    public ActionParameter addActionParameter2(String label_resource_name, String action_resource_name) {
        ActionParameterImpl res = new ActionParameterImpl(this.configobj, label_resource_name, action_resource_name);
        this.parameters.add(res);
        return res;
    }

    public ParameterGroup createGroup(String _resource_name, Parameter[] _parameters) {
        ParameterGroupImpl pg = new ParameterGroupImpl(_resource_name);
        for (int i = 0; i < _parameters.length; ++i) {
            ((ParameterImpl)_parameters[i]).setGroup(pg);
        }
        return pg;
    }

    public void destroy() {
        this.ui_manager.destroy(this);
        for (int i = 0; i < this.parameters.size(); ++i) {
            ((ParameterImpl)this.parameters.get(i)).destroy();
        }
    }

    public void setLocalizedName(String name) {
        Properties props = new Properties();
        props.put("ConfigView.section." + this.section, name);
        this.pi.getUtilities().getLocaleUtilities().integrateLocalisedMessageBundle(props);
    }

    protected String resolveKey(String key) {
        if (key.startsWith("!") && key.endsWith("!")) {
            return key.substring(1, key.length() - 1);
        }
        return this.key_prefix + key;
    }
}

